/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.leaderboard.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.leaderboard.Leaderboard;

public class LeaderboardImpl
extends Leaderboard {
    private String name;
    private CommonDataContainer container;
    private Logger logger = LogManager.getLogger((String)"Leaderboards");
    private Object refreshAllTimeLock = new Object();
    private Object refreshDailyLock = new Object();
    private Object refreshWeeklyLock = new Object();
    private Object refreshMonthlyLock = new Object();

    public LeaderboardImpl(String name) {
        this.name = name;
        this.container = CommonDataManager.getInstance().getContainer("LEADERBOARD" + name.toUpperCase());
        this.refreshLeaderboard();
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    Thread.sleep(43200000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                this.refreshLeaderboard();
            }
        });
    }

    private void refreshLeaderboard() {
        this.logger.info("Refreshing " + this.name + " leaderboard...");
        this.logger.info("Gathering user scores...");
        HashMap<String, Integer> userScores = new HashMap<String, Integer>();
        AccountManager.getInstance().runForAllAccounts(account -> {
            long lastLogin = account.getLastLoginTime();
            if (lastLogin == -1L || System.currentTimeMillis() / 1000L - lastLogin > 2764800L) {
                return true;
            }
            for (String save : account.getSaveIDs()) {
                userScores.put(save, AchievementManager.getInstance().getRank(account.getSave(save), save, RankTypeID.UDT).getTotalScore());
            }
            return true;
        });
        this.refreshAllTimeScores(userScores);
        this.refreshDailyScoresIfNeeded(userScores);
        this.refreshWeeklyScoresIfNeeded(userScores);
        this.refreshMonthlyScoresIfNeeded(userScores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllTimeScores(HashMap<String, Integer> scores) {
        try {
            CommonDataContainer scoresAllTime = this.container.getChildContainer("alltime");
            int addedScores = 0;
            long lastRefresh = -1L;
            if (scoresAllTime.entryExists("last_refresh")) {
                lastRefresh = scoresAllTime.getEntry("last_refresh").getAsLong();
            }
            if (lastRefresh != -1L && System.currentTimeMillis() - lastRefresh < 43200000L) {
                return;
            }
            scoresAllTime.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            this.logger.info("Refreshing " + this.name + " scores of all time...");
            Object object = this.refreshAllTimeLock;
            synchronized (object) {
                scoresAllTime = scoresAllTime.getChildContainer("scores");
                scoresAllTime.deleteContainer();
                for (String id : (String[])scores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)scores.get(t1), (Integer)scores.get(t2))).toArray(String[]::new)) {
                    if (scores.get(id) <= 0) continue;
                    if (addedScores >= 1000) break;
                    ++addedScores;
                    scoresAllTime.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)scores.get(id)));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDailyScoresIfNeeded(HashMap<String, Integer> scores) {
        block10: {
            try {
                int lastDay;
                Calendar cal = Calendar.getInstance();
                CommonDataContainer scoresDaily = this.container.getChildContainer("daily");
                JsonElement ent = scoresDaily.getEntry("last_day");
                int n = lastDay = ent == null ? -1 : ent.getAsInt();
                if (lastDay == cal.get(6)) break block10;
                long lastRefresh = -1L;
                if (scoresDaily.entryExists("last_refresh")) {
                    lastRefresh = scoresDaily.getEntry("last_refresh").getAsLong();
                }
                if (lastRefresh != -1L && System.currentTimeMillis() - lastRefresh > 43200000L) {
                    return;
                }
                scoresDaily.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                scoresDaily.setEntry("last_day", (JsonElement)new JsonPrimitive((Number)cal.get(6)));
                this.logger.info("Refreshing daily " + this.name + " score...");
                Object object = this.refreshDailyLock;
                synchronized (object) {
                    CommonDataContainer current = scoresDaily.getChildContainer("scores_current");
                    CommonDataContainer last = scoresDaily.getChildContainer("scores_last");
                    HashMap lastScores = new HashMap();
                    last.runForEntries((key, value) -> {
                        if (key.startsWith("s-")) {
                            String id = key.substring(2);
                            lastScores.put(id, value.getAsInt());
                        }
                        return true;
                    });
                    HashMap<String, Integer> newScores = new HashMap<String, Integer>();
                    for (String id : scores.keySet()) {
                        int scoreChange;
                        if (!lastScores.containsKey(id) || (scoreChange = scores.get(id) - (Integer)lastScores.get(id)) <= 0) continue;
                        newScores.put(id, scoreChange);
                    }
                    int addedScores = 0;
                    current.deleteContainer();
                    current.setEntry("dataholder", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    current.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    current.setEntry("last_refresh_prev", (JsonElement)(last.entryExists("last_refresh") ? last.getEntry("last_refresh") : new JsonPrimitive((Number)System.currentTimeMillis())));
                    for (String id : (String[])newScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)newScores.get(t1), (Integer)newScores.get(t2))).toArray(String[]::new)) {
                        if (addedScores >= 1000) break;
                        ++addedScores;
                        current.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)newScores.get(id)));
                    }
                    last.deleteContainer();
                    last.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    for (String id : scores.keySet()) {
                        last.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)scores.get(id)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshWeeklyScoresIfNeeded(HashMap<String, Integer> scores) {
        block10: {
            try {
                int lastWeek;
                Calendar cal = Calendar.getInstance();
                CommonDataContainer scoresWeekly = this.container.getChildContainer("weekly");
                JsonElement ent = scoresWeekly.getEntry("last_week");
                int n = lastWeek = ent == null ? -1 : ent.getAsInt();
                if (lastWeek == cal.get(3)) break block10;
                long lastRefresh = -1L;
                if (scoresWeekly.entryExists("last_refresh")) {
                    lastRefresh = scoresWeekly.getEntry("last_refresh").getAsLong();
                }
                if (lastRefresh != -1L && System.currentTimeMillis() - lastRefresh > 43200000L) {
                    return;
                }
                scoresWeekly.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                scoresWeekly.setEntry("last_week", (JsonElement)new JsonPrimitive((Number)cal.get(3)));
                this.logger.info("Refreshing weekly " + this.name + " score...");
                Object object = this.refreshWeeklyLock;
                synchronized (object) {
                    CommonDataContainer current = scoresWeekly.getChildContainer("scores_current");
                    CommonDataContainer last = scoresWeekly.getChildContainer("scores_last");
                    HashMap lastScores = new HashMap();
                    last.runForEntries((key, value) -> {
                        if (key.startsWith("s-")) {
                            String id = key.substring(2);
                            lastScores.put(id, value.getAsInt());
                        }
                        return true;
                    });
                    HashMap<String, Integer> newScores = new HashMap<String, Integer>();
                    for (String id : scores.keySet()) {
                        int scoreChange;
                        if (!lastScores.containsKey(id) || (scoreChange = scores.get(id) - (Integer)lastScores.get(id)) <= 0) continue;
                        newScores.put(id, scoreChange);
                    }
                    int addedScores = 0;
                    current.deleteContainer();
                    current.setEntry("dataholder", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    current.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    current.setEntry("last_refresh_prev", (JsonElement)(last.entryExists("last_refresh") ? last.getEntry("last_refresh") : new JsonPrimitive((Number)System.currentTimeMillis())));
                    for (String id : (String[])newScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)newScores.get(t1), (Integer)newScores.get(t2))).toArray(String[]::new)) {
                        if (addedScores >= 1000) break;
                        ++addedScores;
                        current.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)newScores.get(id)));
                    }
                    last.deleteContainer();
                    last.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    for (String id : scores.keySet()) {
                        last.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)scores.get(id)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMonthlyScoresIfNeeded(HashMap<String, Integer> scores) {
        block10: {
            try {
                int lastMonth;
                Calendar cal = Calendar.getInstance();
                CommonDataContainer scoresMonthly = this.container.getChildContainer("monthly");
                JsonElement ent = scoresMonthly.getEntry("last_month");
                int n = lastMonth = ent == null ? -1 : ent.getAsInt();
                if (lastMonth == cal.get(2)) break block10;
                long lastRefresh = -1L;
                if (scoresMonthly.entryExists("last_refresh")) {
                    lastRefresh = scoresMonthly.getEntry("last_refresh").getAsLong();
                }
                if (lastRefresh != -1L && System.currentTimeMillis() - lastRefresh > 43200000L) {
                    return;
                }
                scoresMonthly.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                scoresMonthly.setEntry("last_month", (JsonElement)new JsonPrimitive((Number)cal.get(2)));
                this.logger.info("Refreshing monthly " + this.name + " score...");
                Object object = this.refreshMonthlyLock;
                synchronized (object) {
                    CommonDataContainer current = scoresMonthly.getChildContainer("scores_current");
                    CommonDataContainer last = scoresMonthly.getChildContainer("scores_last");
                    HashMap lastScores = new HashMap();
                    last.runForEntries((key, value) -> {
                        if (key.startsWith("s-")) {
                            String id = key.substring(2);
                            lastScores.put(id, value.getAsInt());
                        }
                        return true;
                    });
                    HashMap<String, Integer> newScores = new HashMap<String, Integer>();
                    for (String id : scores.keySet()) {
                        int scoreChange;
                        if (!lastScores.containsKey(id) || (scoreChange = scores.get(id) - (Integer)lastScores.get(id)) <= 0) continue;
                        newScores.put(id, scoreChange);
                    }
                    int addedScores = 0;
                    current.deleteContainer();
                    current.setEntry("dataholder", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    current.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    current.setEntry("last_refresh_prev", (JsonElement)(last.entryExists("last_refresh") ? last.getEntry("last_refresh") : new JsonPrimitive((Number)System.currentTimeMillis())));
                    for (String id : (String[])newScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)newScores.get(t1), (Integer)newScores.get(t2))).toArray(String[]::new)) {
                        if (addedScores >= 1000) break;
                        ++addedScores;
                        current.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)newScores.get(id)));
                    }
                    last.deleteContainer();
                    last.setEntry("last_refresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    for (String id : scores.keySet()) {
                        last.setEntry("s-" + id, (JsonElement)new JsonPrimitive((Number)scores.get(id)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getWeeklyScores() {
        try {
            Object object = this.refreshWeeklyLock;
            synchronized (object) {
                HashMap userScores = new HashMap();
                CommonDataContainer scores = this.container.getChildContainer("weekly");
                scores = scores.getChildContainer("scores_current");
                scores.runForEntries((key, value) -> {
                    if (key.startsWith("s-")) {
                        String id = key.substring(2);
                        userScores.put(id, value.getAsInt());
                    }
                    return true;
                });
                LinkedHashMap<String, Integer> userScoresSorted = new LinkedHashMap<String, Integer>();
                for (String id : (String[])userScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)userScores.get(t1), (Integer)userScores.get(t2))).toArray(String[]::new)) {
                    userScoresSorted.put(id, (Integer)userScores.get(id));
                }
                return userScoresSorted;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getMonthlyScores() {
        try {
            Object object = this.refreshMonthlyLock;
            synchronized (object) {
                HashMap userScores = new HashMap();
                CommonDataContainer scores = this.container.getChildContainer("monthly");
                scores = scores.getChildContainer("scores_current");
                scores.runForEntries((key, value) -> {
                    if (key.startsWith("s-")) {
                        String id = key.substring(2);
                        userScores.put(id, value.getAsInt());
                    }
                    return true;
                });
                LinkedHashMap<String, Integer> userScoresSorted = new LinkedHashMap<String, Integer>();
                for (String id : (String[])userScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)userScores.get(t1), (Integer)userScores.get(t2))).toArray(String[]::new)) {
                    userScoresSorted.put(id, (Integer)userScores.get(id));
                }
                return userScoresSorted;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getDailyScores() {
        try {
            Object object = this.refreshDailyLock;
            synchronized (object) {
                HashMap userScores = new HashMap();
                CommonDataContainer scores = this.container.getChildContainer("daily");
                scores = scores.getChildContainer("scores_current");
                scores.runForEntries((key, value) -> {
                    if (key.startsWith("s-")) {
                        String id = key.substring(2);
                        userScores.put(id, value.getAsInt());
                    }
                    return true;
                });
                LinkedHashMap<String, Integer> userScoresSorted = new LinkedHashMap<String, Integer>();
                for (String id : (String[])userScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)userScores.get(t1), (Integer)userScores.get(t2))).toArray(String[]::new)) {
                    userScoresSorted.put(id, (Integer)userScores.get(id));
                }
                return userScoresSorted;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getScoresAllTime() {
        try {
            Object object = this.refreshAllTimeLock;
            synchronized (object) {
                HashMap userScores = new HashMap();
                CommonDataContainer scoresAllTime = this.container.getChildContainer("alltime");
                scoresAllTime = scoresAllTime.getChildContainer("scores");
                scoresAllTime.runForEntries((key, value) -> {
                    if (key.startsWith("s-")) {
                        String id = key.substring(2);
                        userScores.put(id, value.getAsInt());
                    }
                    return true;
                });
                LinkedHashMap<String, Integer> userScoresSorted = new LinkedHashMap<String, Integer>();
                for (String id : (String[])userScores.keySet().stream().sorted((t1, t2) -> -Integer.compare((Integer)userScores.get(t1), (Integer)userScores.get(t2))).toArray(String[]::new)) {
                    userScoresSorted.put(id, (Integer)userScores.get(id));
                }
                return userScoresSorted;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Leaderboard.DateRange getDateRangeOfDailyScores() {
        try {
            Object object = this.refreshDailyLock;
            synchronized (object) {
                CommonDataContainer scores = this.container.getChildContainer("daily");
                scores = scores.getChildContainer("scores_current");
                Leaderboard.DateRange range = new Leaderboard.DateRange();
                range.dateEnd = scores.getEntry("last_refresh").getAsLong();
                range.dateStart = scores.getEntry("last_refresh_prev").getAsLong();
                return range;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Leaderboard.DateRange getDateRangeOfWeeklyScores() {
        try {
            Object object = this.refreshWeeklyLock;
            synchronized (object) {
                CommonDataContainer scores = this.container.getChildContainer("weekly");
                scores = scores.getChildContainer("scores_current");
                Leaderboard.DateRange range = new Leaderboard.DateRange();
                range.dateEnd = scores.getEntry("last_refresh").getAsLong();
                range.dateStart = scores.getEntry("last_refresh_prev").getAsLong();
                return range;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Leaderboard.DateRange getDateRangeOfMonthlyScores() {
        try {
            Object object = this.refreshMonthlyLock;
            synchronized (object) {
                CommonDataContainer scores = this.container.getChildContainer("monthly");
                scores = scores.getChildContainer("scores_current");
                Leaderboard.DateRange range = new Leaderboard.DateRange();
                range.dateEnd = scores.getEntry("last_refresh").getAsLong();
                range.dateStart = scores.getEntry("last_refresh_prev").getAsLong();
                return range;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

