/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.impl.BasicAccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.DatabaseAccountManager;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseAccountObject;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseRequest;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseSaveDataContainer;

public class DatabaseSaveContainer
extends BasicAccountSaveContainer {
    private DatabaseAccountManager manager;

    public DatabaseSaveContainer(String saveID, long time, String username, String id, DatabaseAccountManager manager, DatabaseAccountObject acc) {
        super(saveID, time, username, id, manager, acc);
        this.manager = manager;
        AccountDataContainer sv = this.getSaveData();
        try {
            if (!sv.entryExists("accountid")) {
                sv.setEntry("accountid", (JsonElement)new JsonPrimitive(acc.getAccountID()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean performUpdateUsername(String name) {
        try (DatabaseRequest conn = this.manager.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT SAVES FROM SAVEMAP_V2 WHERE ACCID = ?");
            statement.setString(1, this.getAccountID());
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                boolean bl = false;
                return bl;
            }
            JsonArray saves = JsonParser.parseString((String)res.getString("SAVES")).getAsJsonArray();
            res.close();
            statement.close();
            for (JsonElement ele : saves) {
                JsonObject saveObj = ele.getAsJsonObject();
                if (!saveObj.get("id").getAsString().equals(this.getSaveID())) continue;
                saveObj.remove("username");
                saveObj.addProperty("username", name);
                statement = conn.prepareStatement("UPDATE SAVEMAP_V2 SET SAVES = ? WHERE ACCID = ?");
                conn.setDataObject(1, saves.toString(), statement);
                statement.setString(2, this.getAccountID());
                statement.execute();
                statement.close();
                break;
            }
            statement = conn.prepareStatement("UPDATE SAVEUSERNAMEMAP_V2 SET USERNAME = ? WHERE ID = ?");
            statement.setString(1, name);
            statement.setString(2, this.getSaveID());
            statement.execute();
            statement.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to update username of save '" + this.getSaveID() + "' for ID '" + this.getAccountID() + "'", (Throwable)e);
            return false;
        }
    }

    @Override
    protected AccountDataContainer retrieveSaveData() {
        return new DatabaseSaveDataContainer(this.getAccount(), this, this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteSave() {
        try (DatabaseRequest conn = this.manager.createRequest();){
            PreparedStatement statement = conn.prepareStatement("DELETE FROM SAVEUSERNAMEMAP_V2 WHERE ID = ?");
            statement.setString(1, this.getSaveID());
            statement.execute();
            statement.close();
            this.getSaveData().deleteContainer();
            statement = conn.prepareStatement("SELECT SAVES FROM SAVEMAP_V2 WHERE ACCID = ?");
            statement.setString(1, this.getAccountID());
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                statement.close();
                res.close();
                return;
            }
            JsonArray saves = JsonParser.parseString((String)res.getString("SAVES")).getAsJsonArray();
            statement.close();
            res.close();
            for (JsonElement ele : saves) {
                JsonObject saveObj = ele.getAsJsonObject();
                if (!saveObj.get("id").getAsString().equals(this.getSaveID())) continue;
                saves.remove((JsonElement)saveObj);
                statement = conn.prepareStatement("UPDATE SAVEMAP_V2 SET SAVES = ? WHERE ACCID = ?");
                conn.setDataObject(1, saves.toString(), statement);
                statement.setString(2, this.getAccountID());
                statement.execute();
                statement.close();
                break;
            }
        }
        catch (IOException | SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to delete save '" + this.getSaveID() + "' of ID '" + this.getAccountID() + "'", (Throwable)e);
        }
    }
}

