/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.implementation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.Transformer;
import org.asf.cyan.fluid.bytecode.BytecodeExporter;
import org.asf.cyan.fluid.bytecode.UnrecognizedEnumInfo;
import org.asf.cyan.fluid.bytecode.enums.OpcodeUseCase;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FluidBytecodeExporter
extends BytecodeExporter {
    private HashMap<OpcodeUseCase, HashMap<Object, String>> opcodes = new HashMap();

    public FluidBytecodeExporter() {
        for (Field field : Opcodes.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(null);
                OpcodeUseCase useCase = OpcodeUseCase.valueOf(field.getName().toUpperCase(), field.getType().getTypeName());
                HashMap<Object, String> mp = this.opcodes.getOrDefault((Object)useCase, new HashMap());
                mp.put(value, field.getName().toUpperCase());
                this.opcodes.put(useCase, mp);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected String getImplementationName() {
        return "Fluid";
    }

    @Override
    protected String getOpcodeName(Object opcode, OpcodeUseCase useCase) {
        return (String)this.opcodes.getOrDefault((Object)useCase, new HashMap()).get(opcode);
    }

    @Override
    protected String insnNodeToString(AbstractInsnNode insn, int index) {
        String opcode;
        Object output = "";
        Object type = "";
        Object value = "";
        switch (insn.getClass().getSimpleName()) {
            case "LabelNode": {
                output = (String)output + "Label label" + (index + 1) + " = {";
                break;
            }
            case "LineNumberNode": {
                type = "LineNode";
                value = "line: " + ((LineNumberNode)insn).line;
                break;
            }
            case "VarInsnNode": {
                type = "VariableNode";
                value = "var: var" + ((VarInsnNode)insn).var;
                String opcode2 = this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE);
                value = (String)value + ", method: " + opcode2;
                break;
            }
            case "LdcInsnNode": {
                type = "LdcNode";
                Object ldcValue = ((LdcInsnNode)insn).cst;
                Object valueStr = "";
                String typeStr = "";
                if (ldcValue instanceof String) {
                    valueStr = "\"" + ldcValue.toString() + "\"";
                    typeStr = "string";
                } else if (ldcValue instanceof Type) {
                    Type ldcType = (Type)ldcValue;
                    typeStr = "classref";
                    valueStr = "(classof: \"" + ldcType.getClassName() + "\")";
                } else {
                    valueStr = ldcValue.toString();
                    typeStr = ldcValue.getClass().getSimpleName().toLowerCase();
                }
                value = "value: " + (String)valueStr + ", type: " + typeStr;
                break;
            }
            case "TypeInsnNode": {
                type = "TypeNode";
                value = "type: \"" + ((TypeInsnNode)insn).desc + "\", opcode: " + this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE).toLowerCase();
                break;
            }
            case "MethodInsnNode": {
                type = "MethodNode";
                value = "owner: \"" + ((MethodInsnNode)insn).owner + "\", name: \"" + ((MethodInsnNode)insn).name + "\", desc: \"" + ((MethodInsnNode)insn).desc + "\", opcode: " + this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE).toLowerCase();
                break;
            }
            case "FieldInsnNode": {
                type = "FieldNode";
                value = "owner: \"" + ((FieldInsnNode)insn).owner + "\", name: \"" + ((FieldInsnNode)insn).name + "\", type: \"" + Fluid.parseDescriptor(((FieldInsnNode)insn).desc) + "\"";
                value = (String)value + ", method: " + this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE).toLowerCase();
                break;
            }
            case "JumpInsnNode": {
                type = "JumpNode";
                int labelIndex = 1;
                for (AbstractInsnNode tmpNode = ((JumpInsnNode)insn).label.getPrevious(); tmpNode != null; tmpNode = tmpNode.getPrevious()) {
                    if (!(tmpNode instanceof LabelNode)) continue;
                    ++labelIndex;
                }
                value = "target: label" + labelIndex + ", code: " + this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE);
                break;
            }
            case "IincInsnNode": {
                type = "IincNode";
                value = "var: var" + ((IincInsnNode)insn).var + ", value: " + ((IincInsnNode)insn).incr;
                break;
            }
            case "IntInsnNode": {
                IntInsnNode inode = (IntInsnNode)insn;
                value = "operand: " + inode.operand;
                break;
            }
            case "InvokeDynamicInsnNode": {
                InvokeDynamicInsnNode dnode = (InvokeDynamicInsnNode)insn;
                Object bsmArgs = "";
                for (Object bsmArg : dnode.bsmArgs) {
                    if (!((String)bsmArgs).isEmpty()) {
                        bsmArgs = (String)bsmArgs + ", ";
                    }
                    if (bsmArg instanceof Handle) {
                        bsmArgs = (String)bsmArgs + "[ desc: \"" + ((Handle)bsmArg).getDesc() + "\", tag: " + ((Handle)bsmArg).getTag() + ", owner: \"" + ((Handle)bsmArg).getOwner() + "\", name: \"" + ((Handle)bsmArg).getName() + "\" ]";
                        continue;
                    }
                    if (!(bsmArg instanceof Type)) continue;
                    Type bArgType = (Type)bsmArg;
                    bsmArgs = (String)bsmArgs + "\"" + bArgType.getDescriptor() + "\"";
                }
                value = "call: \"" + dnode.name + "\", desc: \"" + dnode.desc + "\", bsm: [ desc: \"" + dnode.bsm.getDesc() + "\", tag: " + dnode.bsm.getTag() + ", owner: \"" + dnode.bsm.getOwner() + "\", name: \"" + dnode.bsm.getName() + "\" ], bsmArgs: [ " + (String)bsmArgs + "]";
                break;
            }
            case "FrameNode": {
                boolean first;
                type = "FrameNode";
                Object stack = "";
                Object local = "";
                FrameNode fnode = (FrameNode)insn;
                if (fnode.stack != null) {
                    stack = (String)stack + " ";
                    first = true;
                    for (Object item : fnode.stack) {
                        if (!first) {
                            stack = (String)stack + ", ";
                        }
                        first = false;
                        if (item instanceof String) {
                            stack = (String)stack + "\"" + item + "\"";
                            continue;
                        }
                        if (item instanceof LabelNode) {
                            LabelNode label = (LabelNode)item;
                            String label_value = "";
                            if (label.getNext() instanceof TypeInsnNode) {
                                label_value = ((TypeInsnNode)label.getNext()).desc.replace("/", ".");
                            }
                            stack = (String)stack + "\"" + this.getOpcodeName(label.getOpcode(), OpcodeUseCase.ASM_STACKMAP) + " " + label_value + "\"";
                            continue;
                        }
                        stack = (String)stack + "\"" + this.getOpcodeName((Integer)item, OpcodeUseCase.STACK_FRAME) + "\"";
                    }
                    stack = (String)stack + " ";
                }
                if (fnode.local != null) {
                    local = (String)local + " ";
                    first = true;
                    for (Object item : fnode.local) {
                        if (!first) {
                            local = (String)local + ", ";
                        }
                        first = false;
                        if (item instanceof String) {
                            local = (String)local + "\"" + item + "\"";
                            continue;
                        }
                        local = (String)local + "\"" + this.getOpcodeName((Integer)item, OpcodeUseCase.STACK_FRAME) + "\"";
                    }
                    local = (String)local + " ";
                }
                value = "stack: [" + (String)stack + "], local: [" + (String)local + "], type: " + this.getOpcodeName(fnode.type, OpcodeUseCase.ASM_STACKMAP);
            }
        }
        if (((String)output).equals("") && (opcode = this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE)) != null && opcode.contains("RETURN")) {
            value = opcode;
        }
        if (((String)output).equals("")) {
            String methName = "";
            Object objName = "";
            if (((String)type).equals("")) {
                type = this.getOpcodeName(insn.getOpcode(), OpcodeUseCase.JVM_OPCODE).toLowerCase();
                methName = type;
                objName = ((String)(type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1) + "Node")).replaceAll("[^A-Z]", "").toLowerCase();
                if (((String)objName).equals("")) {
                    objName = type;
                }
            } else {
                objName = ((String)type).replaceAll("[^A-Z]", "").toLowerCase();
                if (((String)objName).equals("")) {
                    objName = type;
                }
                methName = ((String)type).toLowerCase().replaceAll("node", "");
            }
            output = (String)output + (String)type + " " + (String)objName + (index + 1) + " = " + methName + "(" + (String)value + ");";
        }
        return output;
    }

    @Override
    protected String mthHeadToString(MethodNode method) {
        Transformer.FluidMethodInfo meth = Transformer.FluidMethodInfo.create(method.name, method.desc);
        StringBuilder result = new StringBuilder();
        StringBuilder annotationHead = new StringBuilder();
        if (method.localVariables != null) {
            for (LocalVariableNode var : method.localVariables) {
                AbstractInsnNode tmpNode;
                if (!annotationHead.toString().isEmpty()) {
                    annotationHead.append("\n");
                }
                Transformer.AnnotationInfo anno = new Transformer.AnnotationInfo();
                anno.name = "LocalVariable";
                anno.values.put("%pseudoannotation", true);
                int labelIndex = 1;
                for (tmpNode = var.end.getPrevious(); tmpNode != null; tmpNode = tmpNode.getPrevious()) {
                    if (!(tmpNode instanceof LabelNode)) continue;
                    ++labelIndex;
                }
                anno.values.put("_end", "label" + labelIndex);
                labelIndex = 1;
                for (tmpNode = var.start.getPrevious(); tmpNode != null; tmpNode = tmpNode.getPrevious()) {
                    if (!(tmpNode instanceof LabelNode)) continue;
                    ++labelIndex;
                }
                anno.values.put("_start", "label" + labelIndex);
                anno.values.put("type", Fluid.parseDescriptor(var.desc));
                anno.values.put("index", var.index);
                anno.values.put("name", var.name);
                annotationHead.append(this.annotationToString(anno));
            }
        }
        String annotations = this.mthAnnotationHeadToString(method);
        if (!annotationHead.toString().isEmpty() && !annotations.isEmpty()) {
            annotationHead.append("\n");
        }
        annotationHead.append(annotations);
        if (!annotationHead.toString().isEmpty()) {
            result.append((CharSequence)annotationHead).append("\n");
        }
        String mod = Modifier.toString(method.access);
        String[] lines = annotationHead.toString().split("\n");
        Arrays.sort(lines, (one, two) -> one.compareTo((String)two));
        annotationHead = new StringBuilder();
        for (String line : lines) {
            if (!annotationHead.toString().isEmpty()) {
                annotationHead.append("\n");
            }
            annotationHead.append(line);
        }
        result.append(mod);
        if (!mod.isEmpty()) {
            result.append(" ");
        }
        result.append(meth.returnType);
        result.append(" ");
        result.append(meth.name);
        result.append("(");
        int var = 0;
        if (!Modifier.isStatic(method.access)) {
            var = 1;
        }
        boolean hasAnnotations = false;
        boolean first = true;
        for (String type : meth.types) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            List<Transformer.AnnotationInfo> paramAnnotations = Transformer.FluidMethodInfo.getParameterAnnotations(method, var);
            for (Transformer.AnnotationInfo paramAnno : paramAnnotations) {
                result.append("\n\t");
                result.append(this.annotationToString(paramAnno));
                result.append(" ");
                hasAnnotations = true;
            }
            result.append(type);
            result.append(" var").append(var++);
        }
        if (hasAnnotations) {
            result.append("\n");
        }
        result.append(")");
        first = true;
        if (method.exceptions != null && method.exceptions.size() != 0) {
            result.append(" throws ");
            for (String exception : method.exceptions) {
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(exception.replaceAll("/", "."));
            }
        }
        if (!Modifier.isAbstract(method.access)) {
            result.append(" {");
            result.append("\n\t");
            result.append("// Method descriptor: " + meth.name + meth.toDescriptor());
        } else {
            result.append(";");
        }
        return result.toString();
    }

    @Override
    protected String mthAnnotationHeadToString(MethodNode method) {
        Transformer.AnnotationInfo i;
        Object result = "";
        if (method.visibleAnnotations != null) {
            for (AnnotationNode anode : method.visibleAnnotations) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + "\n";
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", false);
                result = (String)result + this.annotationToString(i);
            }
        }
        if (method.invisibleAnnotations != null) {
            for (AnnotationNode anode : method.invisibleAnnotations) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + "\n";
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", true);
                result = (String)result + this.annotationToString(i);
            }
        }
        if (method.visibleLocalVariableAnnotations != null) {
            for (AnnotationNode anode : method.visibleLocalVariableAnnotations) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + "\n";
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", false);
                i.values.put("%localVarAnnotation", true);
                i.values.put("%varIndex", anode.index);
                result = (String)result + this.annotationToString(i);
            }
        }
        if (method.invisibleLocalVariableAnnotations != null) {
            for (AnnotationNode anode : method.invisibleLocalVariableAnnotations) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + "\n";
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", true);
                i.values.put("%localVarAnnotation", true);
                i.values.put("%varIndex", anode.index);
                result = (String)result + this.annotationToString(i);
            }
        }
        return result;
    }

    private String annotationToString(Transformer.AnnotationInfo anno) {
        Object result = "";
        result = (String)result + "@" + anno.name;
        if (anno.values.size() != 0) {
            result = (String)result + "(";
        }
        for (int i = anno.values.keySet().size() - 1; i >= 0; --i) {
            String param = ((String[])anno.values.keySet().toArray(String[]::new))[i];
            Object value = anno.values.get(param);
            if (!((String)result).endsWith("(")) {
                result = (String)result + ", ";
            }
            result = (String)result + this.parseParam(param, value);
        }
        if (anno.values.size() != 0) {
            result = (String)result + ")";
        }
        return result;
    }

    private String parseParam(String param, Object value) {
        if (value instanceof String) {
            return param + ": \"" + value + "\"";
        }
        if (value instanceof Enum) {
            return param + ": " + value.getClass().getTypeName() + "." + ((Enum)value).name();
        }
        if (value instanceof UnrecognizedEnumInfo) {
            return ((UnrecognizedEnumInfo)value).getType() + "." + ((UnrecognizedEnumInfo)value).getName();
        }
        if (value instanceof Integer || value instanceof Boolean) {
            return param + ": " + value.toString();
        }
        if (value instanceof List) {
            Object strs = "";
            for (Object obj : (List)value) {
                if (!((String)strs).isEmpty()) {
                    strs = (String)strs + ", ";
                }
                strs = (String)strs + this.parseParam("dummy", obj).substring("dummy: ".length());
            }
            return param + ": [ " + (String)strs + " ]";
        }
        return param + ": " + value.toString() + value.getClass().getSimpleName().substring(0, 1).toLowerCase();
    }

    @Override
    protected String classHeadToString(ClassNode cls) {
        Transformer.AnnotationInfo i;
        StringBuilder result = new StringBuilder();
        if (cls.visibleAnnotations != null) {
            for (AnnotationNode anode : cls.visibleAnnotations) {
                if (!result.toString().isEmpty()) {
                    result.append("\n");
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", false);
                result.append(this.annotationToString(i));
            }
        }
        if (cls.invisibleAnnotations != null) {
            for (AnnotationNode anode : cls.invisibleAnnotations) {
                if (!result.toString().isEmpty()) {
                    result.append("\n");
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", true);
                result.append(this.annotationToString(i));
            }
        }
        if (!result.toString().isEmpty()) {
            result.append("\n");
        }
        boolean added = false;
        if (Modifier.isPublic(cls.access)) {
            result.append("public");
            added = true;
        }
        if (Modifier.isPrivate(cls.access)) {
            if (added) {
                result.append(" ");
            }
            result.append("private");
            added = true;
        }
        if (Modifier.isStatic(cls.access)) {
            if (added) {
                result.append(" ");
            }
            result.append("static");
            added = true;
        }
        if (Modifier.isProtected(cls.access)) {
            if (added) {
                result.append(" ");
            }
            result.append("protected");
            added = true;
        }
        if (Modifier.isInterface(cls.access) && cls.interfaces != null && cls.interfaces.stream().anyMatch(t -> t.equals("java/lang/annotation/Annotation"))) {
            if (added) {
                result.append(" ");
            }
            result.append("@interface");
            added = true;
        } else if (Modifier.isInterface(cls.access)) {
            if (added) {
                result.append(" ");
            }
            result.append("interface");
            added = true;
        }
        if (added) {
            result.append(" ");
        }
        result.append("class");
        result.append(" ");
        result.append(cls.name.replaceAll("/", "."));
        if (cls.superName != null && !cls.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) {
            result.append(" extends ");
            result.append(cls.superName.replaceAll("/", "."));
        }
        if (!Modifier.isInterface(cls.access) && cls.interfaces != null && cls.interfaces.size() != 0) {
            result.append(" implements");
            boolean first = true;
            for (String inter : cls.interfaces) {
                if (!first) {
                    result.append(",");
                }
                result.append(" ").append(inter.replaceAll("/", "."));
                first = false;
            }
        }
        result.append(" {");
        return result.toString();
    }

    @Override
    protected String fieldToStringInternal(FieldNode field) {
        Transformer.AnnotationInfo i;
        StringBuilder result = new StringBuilder();
        if (field.visibleAnnotations != null) {
            for (AnnotationNode anode : field.visibleAnnotations) {
                if (!result.toString().isEmpty()) {
                    result.append("\n");
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", false);
                result.append(this.annotationToString(i));
            }
        }
        if (field.invisibleAnnotations != null) {
            for (AnnotationNode anode : field.invisibleAnnotations) {
                if (!result.toString().isEmpty()) {
                    result.append("\n");
                }
                i = Transformer.AnnotationInfo.create(anode);
                i.values.put("%invis", true);
                result.append(this.annotationToString(i));
            }
        }
        if (!result.toString().isEmpty()) {
            result.append("\n");
        }
        String mod = Modifier.toString(field.access);
        result.append(mod);
        if (!mod.isEmpty()) {
            result.append(" ");
        }
        result.append(Fluid.parseDescriptor(field.desc));
        result.append(" ");
        result.append(field.name);
        if (field.value != null) {
            result.append(" = ");
            Object value = field.value;
            if (value instanceof String) {
                result.append("\"" + value + "\"");
            } else if (value instanceof Integer || value instanceof Boolean) {
                result.append(value.toString());
            } else {
                result.append(value.toString() + value.getClass().getSimpleName().substring(0, 1).toLowerCase());
            }
        }
        result.append(";");
        return result.toString();
    }
}

