/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.api.transforming.information.metadata;

import org.asf.cyan.fluid.api.transforming.enums.MemberType;
import org.asf.cyan.fluid.api.transforming.information.metadata.TransformerMetadata;

public class MemberMetadata {
    private MemberType memType;
    private String transformerMemberName;
    private String name;
    private String type;
    private String[] types;
    private String desc;
    private String obfusName;
    private String obfusType;
    private String[] obfusTypes;
    private boolean appended = false;
    private int oldMod = -1;
    private int newMod = -1;

    MemberMetadata() {
    }

    void assign(MemberType meberType, String transformerMemberName, String ownerDeobf, String name, String desc, String type, String[] types, int oldMod, int newMod, boolean appended) {
        this.name = name;
        this.type = type;
        this.types = types;
        this.memType = meberType;
        this.transformerMemberName = transformerMemberName;
        this.oldMod = oldMod;
        this.newMod = newMod;
        this.appended = appended;
        this.desc = desc;
        if (this.memType == MemberType.METHOD) {
            this.obfusName = TransformerMetadata.getImplementationInstance().mapMethod(ownerDeobf, name, types);
            this.obfusTypes = new String[types.length];
            int index = 0;
            for (String mType : types) {
                this.obfusTypes[index++] = TransformerMetadata.getImplementationInstance().mapClass(mType);
            }
        } else {
            this.obfusName = TransformerMetadata.getImplementationInstance().mapField(ownerDeobf, name, type);
        }
        this.obfusType = TransformerMetadata.getImplementationInstance().mapClass(type);
    }

    public MemberType getMemberType() {
        return this.memType;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String[] getTypes() {
        return this.types;
    }

    public String getTransformerMemberName() {
        return this.transformerMemberName;
    }

    public int getOldModifier() {
        return this.oldMod;
    }

    public int getNewModifier() {
        return this.newMod;
    }

    public String toDescriptor() {
        if (this.memType == MemberType.METHOD) {
            return TransformerMetadata.toDescriptor(this.type, this.types);
        }
        return TransformerMetadata.toDescriptor(this.type, null);
    }

    public String getMappedName() {
        return this.obfusName;
    }

    public String getMappedType() {
        return this.obfusType;
    }

    public String[] getMappedTypes() {
        return this.obfusTypes;
    }

    public boolean isNew() {
        return this.appended;
    }

    public String toMappedDescriptor() {
        if (this.memType == MemberType.METHOD) {
            return TransformerMetadata.toDescriptor(this.obfusType, this.obfusTypes);
        }
        return TransformerMetadata.toDescriptor(this.obfusType, null);
    }

    public String toTransformerDescriptor() {
        return this.desc;
    }
}

