/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.items.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.events.items.InventoryItemCreateEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.items.impl.PlayerInventoryItemImpl;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class PlayerInventoryContainerImpl
extends PlayerInventoryContainer {
    private static Random rnd = new Random();
    private AccountDataContainer data;
    private PlayerInventory inv;
    private AccountObject account;
    private int id;

    public PlayerInventoryContainerImpl(AccountDataContainer data, PlayerInventory inv, AccountObject account, int id) {
        this.id = id;
        this.account = account;
        this.inv = inv;
        try {
            this.data = data.getChildContainer("c-" + Integer.toString(id));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int[] getItemUniqueIDs() {
        try {
            ArrayList ids = new ArrayList();
            this.data.runForChildContainers(ent -> {
                if (ent.startsWith("d-")) {
                    int defID = Integer.parseInt(ent.substring(2));
                    try {
                        AccountDataContainer cont = this.data.getChildContainer("d-" + defID);
                        cont.runForEntries((ent2, value) -> {
                            if (ent2.startsWith("u-")) {
                                int uniqueID = Integer.parseInt(ent2.substring(2));
                                try {
                                    if (!this.data.entryExists("u-" + uniqueID)) {
                                        this.data.setEntry("u-" + uniqueID, (JsonElement)new JsonPrimitive((Number)defID));
                                    }
                                    if (cont.getEntry("u-" + uniqueID) == null) {
                                        JsonObject newI = new JsonObject();
                                        newI.addProperty("quantity", (Number)1);
                                        newI.addProperty("uses", (Number)-1);
                                        cont.setEntry("u-" + uniqueID, (JsonElement)newI);
                                    }
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                ids.add(uniqueID);
                            }
                            return true;
                        });
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            });
            int[] i = new int[ids.size()];
            for (int i2 = 0; i2 < i.length; ++i2) {
                i[i2] = (Integer)ids.get(i2);
            }
            return i;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PlayerInventoryItem[] getItems() {
        try {
            ArrayList itms = new ArrayList();
            for (String ent : this.data.getChildContainers()) {
                if (!ent.startsWith("d-")) continue;
                int defID = Integer.parseInt(ent.substring(2));
                AccountDataContainer cont = this.data.getChildContainer("d-" + defID);
                cont.runForEntries((ent2, value) -> {
                    try {
                        if (ent2.startsWith("u-")) {
                            JsonObject itmO;
                            int uniqueID = Integer.parseInt(ent2.substring(2));
                            if (!this.data.entryExists("u-" + uniqueID)) {
                                this.data.setEntry("u-" + uniqueID, (JsonElement)new JsonPrimitive((Number)defID));
                            }
                            if (cont.getEntry("u-" + uniqueID) == null) {
                                JsonObject newI = new JsonObject();
                                newI.addProperty("quantity", (Number)1);
                                newI.addProperty("uses", (Number)-1);
                                cont.setEntry("u-" + uniqueID, (JsonElement)newI);
                            }
                            if ((itmO = value.getAsJsonObject()).get("quantity") == null) {
                                itmO.addProperty("quantity", (Number)1);
                                cont.setEntry("u-" + uniqueID, (JsonElement)itmO);
                            }
                            int quantity = itmO.get("quantity").getAsInt();
                            int uses = itmO.get("uses").getAsInt();
                            itms.add(new PlayerInventoryItemImpl(this.data, uniqueID, defID, quantity, uses, this.account, this.inv, this));
                        }
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return (PlayerInventoryItem[])itms.toArray(PlayerInventoryItem[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PlayerInventoryItem getItem(int uniqueID) {
        try {
            JsonElement ele = this.data.getEntry("u-" + uniqueID);
            if (ele == null) {
                return null;
            }
            int defID = ele.getAsInt();
            if ((ele = this.data.getChildContainer("d-" + defID).getEntry("u-" + uniqueID)) == null) {
                return null;
            }
            JsonObject itm = ele.getAsJsonObject();
            if (itm.get("quantity") == null) {
                itm.addProperty("quantity", (Number)1);
                this.data.getChildContainer("d-" + defID).setEntry("u-" + uniqueID, (JsonElement)itm);
            }
            int quantity = itm.get("quantity").getAsInt();
            int uses = itm.get("uses").getAsInt();
            return new PlayerInventoryItemImpl(this.data, uniqueID, defID, quantity, uses, this.account, this.inv, this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PlayerInventoryItem createItem(int defID, int quantity, int uses) {
        try {
            AccountDataContainer item = this.data.getChildContainer("d-" + defID);
            if (item.getEntryKeys().length >= 0x7FFFFFFE) {
                throw new IOException("Too many items in inventory");
            }
            int uniqueID = rnd.nextInt(0, 1000000000);
            while (this.data.entryExists("u-" + uniqueID)) {
                uniqueID = rnd.nextInt(0, 1000000000);
            }
            JsonObject itm = new JsonObject();
            itm.addProperty("quantity", (Number)quantity);
            itm.addProperty("uses", (Number)uses);
            item.setEntry("u-" + uniqueID, (JsonElement)itm);
            this.data.setEntry("u-" + uniqueID, (JsonElement)new JsonPrimitive((Number)defID));
            PlayerInventoryItemImpl i = new PlayerInventoryItemImpl(this.data, uniqueID, defID, quantity, uses, this.account, this.inv, this);
            EventBus.getInstance().dispatchEvent((EventObject)new InventoryItemCreateEvent(i, this.account, this.data, this.inv, this));
            return i;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getContainerId() {
        return this.id;
    }

    @Override
    public PlayerInventoryItem[] find(int defID) {
        try {
            ArrayList items = new ArrayList();
            AccountDataContainer item = this.data.getChildContainer("d-" + defID);
            item.runForEntries((itm, value) -> {
                if (itm.startsWith("u-")) {
                    try {
                        int uniqueID = Integer.parseInt(itm.substring(2));
                        JsonObject itmO = value.getAsJsonObject();
                        if (itmO.get("quantity") == null) {
                            itmO.addProperty("quantity", (Number)1);
                            this.data.getChildContainer("d-" + defID).setEntry("u-" + uniqueID, (JsonElement)itmO);
                        }
                        int quantity = itmO.get("quantity").getAsInt();
                        int uses = itmO.get("uses").getAsInt();
                        items.add(new PlayerInventoryItemImpl(this.data, uniqueID, defID, quantity, uses, this.account, this.inv, this));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            });
            return (PlayerInventoryItem[])items.toArray(PlayerInventoryItem[]::new);
        }
        catch (IOException e) {
            return new PlayerInventoryItem[0];
        }
    }

    @Override
    public PlayerInventoryItem findFirst(int defID) {
        try {
            ItmRes r = new ItmRes();
            AccountDataContainer item = this.data.getChildContainer("d-" + defID);
            JsonElement ele = item.findEntry((itm, value) -> {
                if (itm.startsWith("u-")) {
                    r.uniqueID = Integer.parseInt(itm.substring(2));
                    return true;
                }
                return false;
            });
            if (ele != null) {
                JsonObject itmO = ele.getAsJsonObject();
                if (itmO.get("quantity") == null) {
                    itmO.addProperty("quantity", (Number)1);
                    this.data.getChildContainer("d-" + defID).setEntry("u-" + r.uniqueID, (JsonElement)itmO);
                }
                int quantity = itmO.get("quantity").getAsInt();
                int uses = itmO.get("uses").getAsInt();
                return new PlayerInventoryItemImpl(this.data, r.uniqueID, defID, quantity, uses, this.account, this.inv, this);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private class ItmRes {
        public int uniqueID;

        private ItmRes() {
        }
    }
}

