/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.impl.BasicAccountObject;
import org.asf.edge.common.services.accounts.impl.BasicAccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.DatabaseAccountManager;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseAccountDataContainer;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseRequest;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseSaveContainer;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseSaveDataContainer;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;

public class DatabaseAccountObject
extends BasicAccountObject {
    private DatabaseAccountManager manager;

    public DatabaseAccountObject(String id, String username, DatabaseAccountManager manager) {
        super(id, username, manager);
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAccountEmail() {
        try (DatabaseRequest conn = this.manager.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT EMAIL FROM EMAILMAP_V2 WHERE ID = ?");
            statement.setString(1, this.getAccountID());
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                String string = null;
                return string;
            }
            String r = res.getString("EMAIL");
            res.close();
            statement.close();
            String string = r;
            return string;
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to pull account email of ID '" + this.getAccountID() + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performUpdateUsername(String name) {
        boolean bl;
        DatabaseRequest conn = this.manager.createRequest();
        try {
            PreparedStatement statement = conn.prepareStatement("UPDATE USERMAP_V2 SET USERNAME = ? WHERE ID = ?");
            statement.setString(1, name);
            statement.setString(2, this.getAccountID());
            statement.execute();
            statement.close();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException e) {
                this.getLogger().error("Failed to execute database query request while trying to update username of ID '" + this.getAccountID() + "'", (Throwable)e);
                return false;
            }
        }
        conn.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performUpdatePassword(byte[] cred) {
        boolean bl;
        DatabaseRequest conn = this.manager.createRequest();
        try {
            PreparedStatement statement = conn.prepareStatement("UPDATE USERMAP_V2 SET CREDS = ? WHERE ID = ?");
            statement.setBytes(1, cred);
            statement.setString(2, this.getAccountID());
            statement.execute();
            statement.close();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException e) {
                this.getLogger().error("Failed to execute database query request while trying to update password of ID '" + this.getAccountID() + "'", (Throwable)e);
                return false;
            }
        }
        conn.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateEmail(String email) {
        try {
            if (this.getAccountEmail() == null) {
                try (DatabaseRequest conn = this.manager.createRequest();){
                    PreparedStatement statement = conn.prepareStatement("INSERT INTO EMAILMAP_V2 VALUES (?, ?)");
                    statement.setString(1, email);
                    statement.setString(2, this.getAccountID());
                    statement.execute();
                    statement.close();
                    boolean bl = true;
                    return bl;
                }
            }
            try (DatabaseRequest conn = this.manager.createRequest();){
                PreparedStatement statement = conn.prepareStatement("UPDATE EMAILMAP_V2 SET EMAIL = ? WHERE ID = ?");
                statement.setString(1, email);
                statement.setString(2, this.getAccountID());
                statement.execute();
                statement.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to update email of ID '" + this.getAccountID() + "'", (Throwable)e);
            return false;
        }
    }

    @Override
    public AccountDataContainer retrieveAccountData() {
        return new DatabaseAccountDataContainer(this, this.getAccountID(), this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String[] retrieveSaveIDs() {
        try (DatabaseRequest conn = this.manager.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT SAVES FROM SAVEMAP_V2 WHERE ACCID = ?");
            statement.setString(1, this.getAccountID());
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                statement.close();
                res.close();
                String[] stringArray = new String[]{};
                return stringArray;
            }
            JsonArray saves = JsonParser.parseString((String)res.getString("SAVES")).getAsJsonArray();
            statement.close();
            res.close();
            String[] ids = new String[saves.size()];
            int i = 0;
            for (JsonElement ele : saves) {
                JsonObject saveObj = ele.getAsJsonObject();
                ids[i++] = saveObj.get("id").getAsString();
            }
            String[] stringArray = ids;
            return stringArray;
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to pull save list of ID '" + this.getAccountID() + "'", (Throwable)e);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BasicAccountSaveContainer performCreateSave(String saveID, String username) {
        try {
            JsonObject saveObj = new JsonObject();
            saveObj.addProperty("id", saveID);
            saveObj.addProperty("username", username);
            saveObj.addProperty("creationTime", (Number)System.currentTimeMillis());
            try (DatabaseRequest conn = this.manager.createRequest();){
                PreparedStatement statement = conn.prepareStatement("SELECT SAVES FROM SAVEMAP_V2 WHERE ACCID = ?");
                statement.setString(1, this.getAccountID());
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    res.close();
                    statement.close();
                    BasicAccountSaveContainer basicAccountSaveContainer = null;
                    return basicAccountSaveContainer;
                }
                JsonArray saves = JsonParser.parseString((String)res.getString("SAVES")).getAsJsonArray();
                res.close();
                statement.close();
                for (JsonElement ele : saves) {
                    JsonObject saveObj2 = ele.getAsJsonObject();
                    if (!saveObj2.get("username").getAsString().equals(username)) continue;
                    BasicAccountSaveContainer basicAccountSaveContainer = null;
                    return basicAccountSaveContainer;
                }
                saves.add((JsonElement)saveObj);
                statement = conn.prepareStatement("UPDATE SAVEMAP_V2 SET SAVES = ? WHERE ACCID = ?");
                conn.setDataObject(1, saves.toString(), statement);
                statement.setString(2, this.getAccountID());
                statement.execute();
                statement.close();
                statement = conn.prepareStatement("INSERT INTO SAVEUSERNAMEMAP_V2 VALUES (?, ?)");
                statement.setString(1, username);
                statement.setString(2, saveID);
                statement.execute();
                statement.close();
                return new DatabaseSaveContainer(saveID, saveObj.get("creationTime").getAsLong(), username, this.getAccountID(), this.manager, this);
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to create save '" + saveID + "' for ID '" + this.getAccountID() + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BasicAccountSaveContainer findSave(String saveID) {
        try {
            JsonElement ele;
            JsonObject saveObj;
            JsonArray saves;
            try (DatabaseRequest conn = this.manager.createRequest();){
                PreparedStatement statement = conn.prepareStatement("SELECT SAVES FROM SAVEMAP_V2 WHERE ACCID = ?");
                statement.setString(1, this.getAccountID());
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    res.close();
                    statement.close();
                    BasicAccountSaveContainer basicAccountSaveContainer = null;
                    return basicAccountSaveContainer;
                }
                saves = JsonParser.parseString((String)res.getString("SAVES")).getAsJsonArray();
                res.close();
                statement.close();
            }
            Iterator iterator = saves.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!(saveObj = (ele = (JsonElement)iterator.next()).getAsJsonObject()).get("id").getAsString().equals(saveID));
            String username = saveObj.get("username").getAsString();
            return new DatabaseSaveContainer(saveID, saveObj.get("creationTime").getAsLong(), username, this.getAccountID(), this.manager, this);
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to pull save '" + saveID + "' of ID '" + this.getAccountID() + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAccount() throws IOException {
        this.getAccountData().deleteContainer();
        try {
            JsonArray saves = null;
            try (DatabaseRequest conn = this.manager.createRequest();){
                ResultSet res;
                PreparedStatement statement;
                block15: {
                    try {
                        statement = conn.prepareStatement("DELETE FROM USERMAP_V2 WHERE ID = ?");
                        statement.setString(1, this.getAccountID());
                        statement.execute();
                        statement.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().error("Failed to execute database query request while trying to delete account '" + this.getAccountID() + "'", (Throwable)e);
                        throw new IOException("SQL error", e);
                    }
                    try {
                        statement = conn.prepareStatement("DELETE FROM EMAILMAP_V2 WHERE ID = ?");
                        statement.setString(1, this.getAccountID());
                        statement.execute();
                        statement.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().error("Failed to execute database query request while trying to delete account '" + this.getAccountID() + "'", (Throwable)e);
                        throw new IOException("SQL error", e);
                    }
                    statement = conn.prepareStatement("SELECT SAVES FROM SAVEMAP_V2 WHERE ACCID = ?");
                    statement.setString(1, this.getAccountID());
                    res = statement.executeQuery();
                    if (res.next()) break block15;
                    statement.close();
                    res.close();
                    return;
                }
                try {
                    saves = JsonParser.parseString((String)res.getString("SAVES")).getAsJsonArray();
                    statement.close();
                    res.close();
                    for (JsonElement saveEle : saves) {
                        JsonObject saveObj = saveEle.getAsJsonObject();
                        statement = conn.prepareStatement("DELETE FROM SAVEUSERNAMEMAP_V2 WHERE ID = ?");
                        statement.setString(1, saveObj.get("id").getAsString());
                        statement.execute();
                        statement.close();
                    }
                    statement = conn.prepareStatement("DELETE FROM SAVEMAP_V2 WHERE ACCID = ?");
                    statement.setString(1, this.getAccountID());
                    statement.execute();
                    statement.close();
                }
                catch (SQLException e) {
                    this.getLogger().error("Failed to execute database query request while trying to delete account '" + this.getAccountID() + "'", (Throwable)e);
                    throw new IOException("SQL error", e);
                }
            }
            for (JsonElement saveEle : saves) {
                JsonObject saveObj = saveEle.getAsJsonObject();
                new DatabaseSaveDataContainer(this, this.getSave(saveObj.get("id").getAsString()), this.manager).deleteContainer();
                MinigameDataManager.getInstance().deleteDataFor(saveObj.get("id").getAsString());
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to execute database query request while trying to delete account '" + this.getAccountID() + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }
}

