/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class CompositePublicKey
implements PublicKey {
    private final List keys;

    public CompositePublicKey(PublicKey[] publicKeyArray) {
        if (publicKeyArray == null || publicKeyArray.length == 0) {
            throw new IllegalArgumentException("at least one public key must be provided");
        }
        ArrayList<PublicKey> arrayList = new ArrayList<PublicKey>(publicKeyArray.length);
        for (int i = 0; i != publicKeyArray.length; ++i) {
            arrayList.add(publicKeyArray[i]);
        }
        this.keys = Collections.unmodifiableList(arrayList);
    }

    public List getPublicKeys() {
        return this.keys;
    }

    public String getAlgorithm() {
        return "Composite";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i != this.keys.size(); ++i) {
            aSN1EncodableVector.add(SubjectPublicKeyInfo.getInstance(((PublicKey)this.keys.get(i)).getEncoded()));
        }
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(MiscObjectIdentifiers.id_alg_composite), new DERSequence(aSN1EncodableVector)).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode composite key: " + iOException.getMessage());
        }
    }

    public int hashCode() {
        return ((Object)this.keys).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositePublicKey) {
            return ((Object)this.keys).equals(((CompositePublicKey)object).keys);
        }
        return false;
    }
}

