/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.contentserver.http.postprocessors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.asf.connective.RemoteClient;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.edge.common.util.TripleDesUtil;
import org.asf.edge.contentserver.http.ContentServerRequestHandler;

public class ApplicationManifestPreProcessor
implements ContentServerRequestHandler.IPreProcessor {
    @Override
    public boolean match(String path, String method, RemoteClient client, String contentType, HttpRequest request, HttpResponse response, File sourceDir) {
        return path.toLowerCase().endsWith("/dwadragonsmain.xml") && !new File(sourceDir, path + ".edgeunencrypted").exists();
    }

    @Override
    public InputStream preProcess(String path, String method, RemoteClient client, String contentType, HttpRequest request, HttpResponse response, InputStream source, File sourceDir) throws IOException {
        String secret = "C92EC1AA-54CD-4D0C-A8D5-403FCCF1C0BD";
        File reqFile = new File(sourceDir, path);
        if (reqFile.exists()) {
            byte[] key;
            File verSpecificSecret = new File(sourceDir, path.split("/")[1] + "/" + path.split("/")[2] + "/" + path.split("/")[3] + "/versionxmlsecret.conf");
            if (verSpecificSecret.exists()) {
                for (String line : Files.readAllLines(verSpecificSecret.toPath())) {
                    if (line.isBlank() || line.startsWith("#") || !line.contains("=")) continue;
                    String key2 = line.substring(0, line.indexOf("="));
                    String val = line.substring(line.indexOf("=") + 1);
                    if (!key2.equals("xmlsecret")) continue;
                    secret = val;
                }
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                key = digest.digest(secret.getBytes("ASCII"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] manifest = source.readAllBytes();
            source.close();
            manifest = TripleDesUtil.encrypt((byte[])manifest, (byte[])key);
            String base64Manifest = Base64.getEncoder().encodeToString(manifest);
            return new ByteArrayInputStream(base64Manifest.getBytes("ASCII"));
        }
        return source;
    }
}

