/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.commondata.impl.db;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.impl.db.DatabaseCommonDataManager;
import org.asf.edge.common.services.commondata.impl.db.DatabaseRequest;

public class DatabaseCommonDataContainer
extends CommonDataContainer {
    private String table;
    private DatabaseCommonDataManager mgr;
    private Logger logger = LogManager.getLogger((String)"CommonDataManager");

    public DatabaseCommonDataContainer(DatabaseCommonDataManager mgr, String table) {
        this.mgr = mgr;
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JsonElement get(String key) throws IOException {
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                String parent = "";
                String parentContainer = "";
                if (key.contains("/")) {
                    parent = key.substring(0, key.lastIndexOf("/"));
                    key = key.substring(key.lastIndexOf("/") + 1);
                    if (parent.contains("/")) {
                        parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                        parent = parent.substring(parent.lastIndexOf("/") + 1);
                    }
                }
                PreparedStatement statement = req.createPreparedStatement("SELECT DATA FROM " + this.table + " WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ?");
                statement.setString(1, key);
                statement.setString(2, parent);
                statement.setString(3, parentContainer);
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    res.close();
                    statement.close();
                    JsonElement jsonElement = null;
                    return jsonElement;
                }
                String data = res.getString("DATA");
                if (data == null) {
                    res.close();
                    statement.close();
                    JsonElement jsonElement = null;
                    return jsonElement;
                }
                res.close();
                statement.close();
                JsonElement jsonElement = JsonParser.parseString((String)data);
                return jsonElement;
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve common data entry '" + key + "' of table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void set(String key, JsonElement value) throws IOException {
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                String parent = "";
                String parentContainer = "";
                if (key.contains("/")) {
                    parent = key.substring(0, key.lastIndexOf("/"));
                    key = key.substring(key.lastIndexOf("/") + 1);
                    if (parent.contains("/")) {
                        parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                        parent = parent.substring(parent.lastIndexOf("/") + 1);
                    }
                }
                PreparedStatement statement = req.createPreparedStatement("UPDATE " + this.table + " SET DATA = ? WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ?");
                req.setDataObject(1, value.toString(), statement);
                statement.setString(2, key);
                statement.setString(3, parent);
                statement.setString(4, parentContainer);
                statement.execute();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to update common data entry '" + key + "' of table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void create(String key, String root, JsonElement value) throws IOException {
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                String parent = "";
                String parentContainer = "";
                if (key.contains("/")) {
                    parent = key.substring(0, key.lastIndexOf("/"));
                    key = key.substring(key.lastIndexOf("/") + 1);
                    if (parent.contains("/")) {
                        parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                        parent = parent.substring(parent.lastIndexOf("/") + 1);
                    }
                }
                PreparedStatement statement = req.createPreparedStatement("INSERT INTO " + this.table + " VALUES(?, ?, ?, ?)");
                statement.setString(1, key);
                statement.setString(2, parent);
                statement.setString(3, parentContainer);
                req.setDataObject(4, value.toString(), statement);
                statement.execute();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to create common data entry '" + key + "' in table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean exists(String key) throws IOException {
        boolean bl;
        DatabaseRequest req = this.mgr.createRequest();
        try {
            String parent = "";
            String parentContainer = "";
            if (key.contains("/")) {
                parent = key.substring(0, key.lastIndexOf("/"));
                key = key.substring(key.lastIndexOf("/") + 1);
                if (parent.contains("/")) {
                    parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                    parent = parent.substring(parent.lastIndexOf("/") + 1);
                }
            }
            PreparedStatement statement = req.createPreparedStatement("SELECT DATA FROM " + this.table + " WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ?");
            statement.setString(1, key);
            statement.setString(2, parent);
            statement.setString(3, parentContainer);
            ResultSet res = statement.executeQuery();
            boolean r = res.next();
            res.close();
            statement.close();
            bl = r;
        }
        catch (Throwable throwable) {
            try {
                req.finish();
                throw throwable;
            }
            catch (SQLException e) {
                this.logger.error("Failed to execute database query request while trying to check common data entry '" + key + "' in table '" + this.table + "'", (Throwable)e);
                throw new IOException("SQL error", e);
            }
        }
        req.finish();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(String key) throws IOException {
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                String parent = "";
                String parentContainer = "";
                if (key.contains("/")) {
                    parent = key.substring(0, key.lastIndexOf("/"));
                    key = key.substring(key.lastIndexOf("/") + 1);
                    if (parent.contains("/")) {
                        parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                        parent = parent.substring(parent.lastIndexOf("/") + 1);
                    }
                }
                PreparedStatement statement = req.createPreparedStatement("DELETE FROM " + this.table + " WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ?");
                statement.setString(1, key);
                statement.setString(2, parent);
                statement.setString(3, parentContainer);
                statement.execute();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to delete common data entry '" + key + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] getEntryKeys(String key) throws IOException {
        String parent = key;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                PreparedStatement statement = req.createPreparedStatement("SELECT DATAKEY FROM " + this.table + " WHERE PARENT = ? AND PARENTCONTAINER = ?");
                statement.setString(1, parent);
                statement.setString(2, parentContainer);
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String cont = res.getString("DATAKEY");
                    if (cont.isEmpty() || keys.contains(cont)) continue;
                    keys.add(cont);
                }
                res.close();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of common data container '" + key + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
        return (String[])keys.toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] getChildContainers(String key) throws IOException {
        ArrayList<String> containers = new ArrayList<String>();
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                PreparedStatement statement = req.createPreparedStatement("SELECT PARENT FROM " + this.table + " WHERE PARENTCONTAINER = ?");
                statement.setString(1, key);
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String cont = res.getString("PARENT");
                    if (cont.isEmpty() || containers.contains(cont)) continue;
                    containers.add(cont);
                }
                res.close();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of common data container '" + key + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
        return (String[])containers.toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteContainer(String root) throws IOException {
        String parent = root;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        try {
            for (String ch : this.getChildContainers(root)) {
                this.deleteContainer((String)(root.isEmpty() ? "" : root + "/") + ch);
            }
            DatabaseRequest req = this.mgr.createRequest();
            try {
                PreparedStatement statement = req.createPreparedStatement("DELETE FROM " + this.table + " WHERE PARENT = ? AND PARENTCONTAINER = ?");
                statement.setString(1, parent);
                statement.setString(2, parentContainer);
                statement.execute();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to delete common data container '" + (root.isEmpty() ? "<root>" : root) + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JsonElement find(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
        JsonElement resO = null;
        String parent = root;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                PreparedStatement statement = req.createPreparedStatement("SELECT * FROM " + this.table + " WHERE PARENT = ? AND PARENTCONTAINER = ?");
                statement.setString(1, parent);
                statement.setString(2, parentContainer);
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String cont = res.getString("DATAKEY");
                    String data = res.getString("DATA");
                    if (cont.isEmpty() || keys.contains(cont)) continue;
                    keys.add(cont);
                    JsonElement d = JsonParser.parseString((String)data);
                    if (!function.apply(cont, d).booleanValue()) continue;
                    resO = d;
                    break;
                }
                res.close();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of common data container '" + root + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
        return resO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runFor(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
        String parent = root;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                PreparedStatement statement = req.createPreparedStatement("SELECT * FROM " + this.table + " WHERE PARENT = ? AND PARENTCONTAINER = ?");
                statement.setString(1, parent);
                statement.setString(2, parentContainer);
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String cont = res.getString("DATAKEY");
                    String data = res.getString("DATA");
                    if (cont.isEmpty() || keys.contains(cont)) continue;
                    keys.add(cont);
                    JsonElement d = JsonParser.parseString((String)data);
                    if (function.apply(cont, d).booleanValue()) continue;
                    break;
                }
                res.close();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of common data container '" + root + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runForChildren(Function<String, Boolean> function, String root) throws IOException {
        ArrayList<String> containers = new ArrayList<String>();
        try {
            DatabaseRequest req = this.mgr.createRequest();
            try {
                PreparedStatement statement = req.createPreparedStatement("SELECT PARENT FROM " + this.table + " WHERE PARENTCONTAINER = ?");
                statement.setString(1, root);
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String cont = res.getString("PARENT");
                    if (cont.isEmpty() || containers.contains(cont)) continue;
                    containers.add(cont);
                    if (function.apply(cont).booleanValue()) continue;
                    break;
                }
                res.close();
                statement.close();
            }
            finally {
                req.finish();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of common data container '" + root + "' from table '" + this.table + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }
}

