/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.events.items;

import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.modules.eventbus.EventObject;
import org.asf.edge.modules.eventbus.EventPath;

@EventPath(value="items.update.uses")
public class InventoryItemUsesUpdateEvent
extends EventObject {
    private PlayerInventoryItem item;
    private AccountObject playerAccount;
    private AccountDataContainer data;
    private PlayerInventory inventory;
    private PlayerInventoryContainer inventoryContainer;
    private int oldUses;
    private int newUses;

    public InventoryItemUsesUpdateEvent(PlayerInventoryItem item, AccountObject playerAccount, AccountDataContainer data, PlayerInventory inventory, PlayerInventoryContainer inventoryContainer, int oldUses, int newUses) {
        this.item = item;
        this.playerAccount = playerAccount;
        this.data = data;
        while (data.getParent() != null) {
            data = data.getParent();
        }
        this.inventory = inventory;
        this.inventoryContainer = inventoryContainer;
        this.oldUses = oldUses;
        this.newUses = newUses;
    }

    public String eventPath() {
        return "items.update.uses";
    }

    public int getOldUseCount() {
        return this.oldUses;
    }

    public int getNewUseCount() {
        return this.newUses;
    }

    public PlayerInventoryItem getItem() {
        return this.item;
    }

    public AccountObject getAccount() {
        return this.playerAccount;
    }

    public AccountDataContainer getSaveData() {
        return this.data;
    }

    public PlayerInventory getPlayerInventory() {
        return this.inventory;
    }

    public PlayerInventoryContainer getInventoryContainer() {
        return this.inventoryContainer;
    }
}

