/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.bytecode.sources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.enums.ComparisonMethod;
import org.asf.cyan.fluid.bytecode.sources.IClassSourceProvider;

public class URLClassSourceProvider
implements IClassSourceProvider<URL> {
    private URL url;

    public URLClassSourceProvider(URL url) {
        this.url = url;
    }

    public boolean isZipLike() {
        return this.url.toString().endsWith(".jar") || this.url.toString().endsWith(".zip");
    }

    @Override
    public ComparisonMethod getComparisonMethod() {
        return ComparisonMethod.OBJECT_EQUALS;
    }

    @Override
    public URL providerObject() {
        return this.url;
    }

    @Override
    public InputStream getStream(String classType) {
        BufferedInputStream strm;
        URL url = this.url;
        if (this.isZipLike()) {
            try {
                url = new URL("jar:" + url.toString() + "!/" + classType + ".class");
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        try {
            url = new URL(url + "/" + classType + ".class");
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            strm = new BufferedInputStream(url.openStream());
        }
        catch (IOException e) {
            return null;
        }
        return strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importAll(FluidClassPool pool) {
        if (this.isZipLike()) {
            InputStream strm;
            URL url = this.url;
            try {
                strm = url.openStream();
            }
            catch (IOException e1) {
                return;
            }
            try (ZipInputStream zip = new ZipInputStream(strm);){
                pool.importArchive(zip);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    strm.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

