/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.bytecode;

import java.lang.reflect.Modifier;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.sources.LoaderClassSourceProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class FluidClassWriter
extends ClassWriter {
    private FluidClassPool pool;
    private ClassLoader classLoader;

    public FluidClassWriter(FluidClassPool pool, ClassLoader classLoader) {
        this(pool, 2, classLoader);
    }

    public FluidClassWriter(FluidClassPool pool, int flags, ClassLoader classLoader) {
        super(flags);
        this.pool = pool;
        this.classLoader = classLoader;
    }

    public FluidClassWriter(FluidClassPool pool, ClassReader classReader, int flags, ClassLoader classLoader) {
        super(classReader, flags);
        this.pool = pool;
        this.classLoader = classLoader;
    }

    public String getCommonSuperClass(String type1, String type2) {
        ClassNode class2;
        ClassNode class1 = this.getClass(type1);
        if (this.isAssignableFrom(class1, class2 = this.getClass(type2))) {
            return type1;
        }
        if (this.isAssignableFrom(class2, class1)) {
            return type2;
        }
        if (Modifier.isInterface(class1.access) || Modifier.isInterface(class2.access)) {
            return "java/lang/Object";
        }
        do {
            if ((class1 = this.getSuperclass(class1)) != null) continue;
            return "java/lang/Object";
        } while (!this.isAssignableFrom(class1, class2));
        return class1.name;
    }

    private ClassNode getClass(String type) {
        if (this.classLoader != null) {
            this.pool.addSource(new LoaderClassSourceProvider(this.classLoader));
        }
        this.pool.addSource(new LoaderClassSourceProvider(this.getClassLoader()));
        ClassNode cls = null;
        try {
            cls = this.pool.getClassNode(type);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(type, e);
        }
        return cls;
    }

    private ClassNode getSuperclass(ClassNode cls) {
        try {
            if (cls.superName == null) {
                return this.getClass("java/lang/Object");
            }
            return this.getClass(cls.superName);
        }
        catch (TypeNotPresentException e) {
            return null;
        }
    }

    private boolean isAssignableFrom(ClassNode cls1, ClassNode cls2) {
        boolean isAssingable;
        boolean bl = cls1.name.equals(cls2.name) ? true : (isAssingable = cls2.superName == null ? cls1.name.equals("java/lang/Object") : cls2.superName.equals(cls1.name));
        if (isAssingable) {
            return true;
        }
        ClassNode newCls = this.getSuperclass(cls2);
        if (newCls == null || !cls1.name.equals("java/lang/Object") && (cls2.superName == null || cls2.superName.equals("java/lang/Object"))) {
            return false;
        }
        return this.isAssignableFrom(cls1, newCls);
    }
}

