/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassLoadHook {
    private String target = "";
    private static Logger log;
    private HashMap<String, String> mappedProperties = new HashMap();
    private HashMap<String[], String> mappedMethods = new HashMap();
    private ArrayList<String> mapProps = new ArrayList();
    private ArrayList<String[]> mapMeths = new ArrayList();

    public ClassLoadHook() {
        log = LogManager.getLogger((String)this.getClass().getName());
    }

    public boolean isSilent() {
        return false;
    }

    public void addPropertyMapping(String name) {
        this.mapProps.add(name);
    }

    public void addMethodMapping(String name, String ... arguments) {
        this.mapMeths.add(this.arrayFromMap(name, this.getTarget(), arguments));
    }

    protected String mapProperty(String name) {
        return this.mappedProperties.get(name);
    }

    protected String mapMethod(String name, String ... arguments) {
        Object[] target = this.arrayFromMap(name, "", arguments);
        for (Object[] objectArray : this.mappedMethods.keySet()) {
            if (!Arrays.equals(objectArray, target)) continue;
            return this.mappedMethods.get(objectArray);
        }
        return null;
    }

    private String[] arrayFromMap(String name, String cls, String[] arguments) {
        ArrayList<String> map = new ArrayList<String>();
        map.add(name);
        map.add(cls);
        map.addAll(Arrays.asList(arguments));
        return (String[])map.toArray(String[]::new);
    }

    public void intialize(String target) {
        if (this.target != "") {
            throw new IllegalStateException("This hook is already initialized");
        }
        this.target = target;
        log.debug("Initializing class hook " + this.getClass().getSimpleName() + "... target: " + this.targetPath() + ", mapped target: " + target);
        for (String prop : this.mapProps) {
            String pOut = Fluid.mapProperty(this.targetPath(), prop);
            log.debug("Mapped property: " + prop + ", output: " + pOut);
            this.mappedProperties.put(prop, pOut);
        }
        for (String[] method : this.mapMeths) {
            String name = method[0];
            String[] arguments = Arrays.copyOfRange(method, 2, method.length);
            String mOut = Fluid.mapMethod(this.targetPath(), name, arguments);
            log.debug("Mapped method: " + name + ", output: " + mOut);
            this.mappedMethods.put(method, mOut);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public abstract String targetPath();

    public abstract void build();

    public abstract void apply(ClassNode var1, FluidClassPool var2, ClassLoader var3, byte[] var4) throws ClassNotFoundException;
}

