/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.headers;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.asf.connective.headers.HttpHeader;

public class HeaderCollection {
    private HashMap<String, HttpHeader> headers = new LinkedHashMap<String, HttpHeader>();

    public static HeaderCollection create() {
        return new HeaderCollection();
    }

    public HttpHeader addHeader(String name, String value) {
        return this.addHeader(name, value, false);
    }

    public HttpHeader addHeader(String name, String value, boolean append) {
        if (!this.hasHeader(name)) {
            HttpHeader header = HttpHeader.create(name, value);
            this.headers.put(name.toLowerCase(), header);
            return header;
        }
        HttpHeader old = this.getHeader(name);
        if (!append) {
            old.clearValues();
        }
        old.addValue(value);
        return old;
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public boolean hasHeader(String header) {
        return this.headers.containsKey(header.toLowerCase());
    }

    public HttpHeader getHeader(String header) {
        return this.headers.get(header.toLowerCase());
    }

    public String getHeaderValue(String header) {
        HttpHeader head = this.getHeader(header);
        if (head == null) {
            return null;
        }
        return head.getValue();
    }

    public String[] getHeaderValues(String header) {
        HttpHeader head = this.getHeader(header);
        if (head == null) {
            return new String[0];
        }
        return head.getValues();
    }

    public HttpHeader removeHeader(String header) {
        return this.headers.remove(header.toLowerCase());
    }

    public String[] getHeaderNames() {
        return (String[])this.headers.values().stream().map(t -> t.getName()).toArray(String[]::new);
    }

    public HttpHeader[] getHeaders() {
        return (HttpHeader[])this.headers.values().toArray(HttpHeader[]::new);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String toString() {
        Object res = "";
        for (HttpHeader header : this.getHeaders()) {
            for (String value : header.getValues()) {
                if (!((String)res).isEmpty()) {
                    res = (String)res + "\n";
                }
                res = (String)res + header.getName() + ": " + value.replace("\\r", "\\\\r").replace("\\n", "\\\\n").replace("\r", "\\r").replace("\n", "\\n");
            }
        }
        return res;
    }
}

