/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.RemoteHttpAccountManager;
import org.asf.edge.common.util.SimpleBinaryMessageClient;

public class RemoteHttpSaveDataContainer
extends AccountDataContainer {
    private String acc;
    private AccountSaveContainer save;
    private RemoteHttpAccountManager mgr;
    private Logger logger = LogManager.getLogger((String)"AccountManager");
    private AccountObject account;

    public RemoteHttpSaveDataContainer(AccountObject account, AccountSaveContainer save, String acc, RemoteHttpAccountManager mgr) {
        this.account = account;
        this.save = save;
        this.acc = acc;
        this.mgr = mgr;
    }

    @Override
    protected JsonElement get(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getSaveDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return response.get("entryValue");
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getSaveDataEntry!", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void set(String key, JsonElement value) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            payload.add("value", value);
            JsonObject response = this.mgr.accountManagerRequest("accounts/setSaveDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in setSaveDataEntry!", (Throwable)e);
        }
    }

    @Override
    protected void create(String key, String root, JsonElement value) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            payload.addProperty("root", root);
            payload.add("value", value);
            JsonObject response = this.mgr.accountManagerRequest("accounts/createSaveDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in createSaveDataEntry!", (Throwable)e);
        }
    }

    @Override
    protected boolean exists(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/saveDataEntryExists", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in saveDataEntryExists!", (Throwable)e);
            return false;
        }
    }

    @Override
    protected void delete(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/deleteSaveDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in deleteSaveDataEntry!", (Throwable)e);
        }
    }

    @Override
    protected String[] getEntryKeys(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getSaveEntryKeys", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
            JsonArray arr = response.get("result").getAsJsonArray();
            String[] res = new String[arr.size()];
            int i = 0;
            for (JsonElement ele : arr) {
                res[i++] = ele.getAsString();
            }
            return res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getEntryKeys!", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    protected String[] getChildContainers(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getChildSaveContainers", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
            JsonArray arr = response.get("result").getAsJsonArray();
            String[] res = new String[arr.size()];
            int i = 0;
            for (JsonElement ele : arr) {
                res[i++] = ele.getAsString();
            }
            return res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getChildContainers!", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    protected void deleteContainer(String root) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("root", root);
            JsonObject response = this.mgr.accountManagerRequest("accounts/deleteSaveContainer", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in deleteContainer!", (Throwable)e);
        }
    }

    @Override
    protected JsonElement find(BiFunction<String, JsonElement, Boolean> function, String root) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("root", root);
            Socket conn = this.mgr.accountManagerUpgradeRequest("runForSaveDataEntries", payload, "EDGEBINPROT/ACCMANAGER/RUNFOR", "EDGEBINPROT/ACCMANAGER/RUNFOR");
            ResultContainer cont = new ResultContainer();
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    ByteArrayInputStream bIn = new ByteArrayInputStream(packet.data);
                    byte[] nameB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String name = new String(nameB, "UTF-8");
                    byte[] dataB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String data = new String(dataB, "UTF-8");
                    JsonElement d = JsonParser.parseString((String)data);
                    boolean res = (Boolean)function.apply(name, d);
                    if (res) {
                        cont.res = d;
                    }
                    client.send(new byte[]{!res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running findSaveDataEntry!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
            return (JsonElement)cont.res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in findSaveDataEntry!", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void runFor(BiFunction<String, JsonElement, Boolean> function, String root) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("root", root);
            Socket conn = this.mgr.accountManagerUpgradeRequest("runForSaveDataEntries", payload, "EDGEBINPROT/ACCMANAGER/RUNFOR", "EDGEBINPROT/ACCMANAGER/RUNFOR");
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    ByteArrayInputStream bIn = new ByteArrayInputStream(packet.data);
                    byte[] nameB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String name = new String(nameB, "UTF-8");
                    byte[] dataB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String data = new String(dataB, "UTF-8");
                    boolean res = (Boolean)function.apply(name, JsonParser.parseString((String)data));
                    client.send(new byte[]{res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running runForSaveDataEntries!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in runForSaveDataEntries!", (Throwable)e);
        }
    }

    @Override
    protected void runForChildren(Function<String, Boolean> function, String root) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.save.getSaveID());
            payload.addProperty("root", root);
            Socket conn = this.mgr.accountManagerUpgradeRequest("runForSaveDataChildren", payload, "EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN", "EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN");
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    String name = new String(packet.data, "UTF-8");
                    boolean res = (Boolean)function.apply(name);
                    client.send(new byte[]{res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running runForSaveDataChildren!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in runForSaveDataChildren!", (Throwable)e);
        }
    }

    @Override
    public AccountObject getAccount() {
        return this.account;
    }

    @Override
    public AccountSaveContainer getSave() {
        return this.save;
    }

    private class ResultContainer {
        public Object res;

        private ResultContainer() {
        }
    }
}

