/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.DefaultDatabaseAccountManager;
import org.asf.edge.common.services.accounts.impl.PostgresDatabaseAccountManager;
import org.asf.edge.common.services.accounts.impl.RemoteHttpAccountManager;
import org.asf.edge.common.tokens.TokenParseResult;

public abstract class AccountManager
extends AbstractService {
    private static boolean initedServices;

    public static AccountManager getInstance() {
        return ServiceManager.getService(AccountManager.class);
    }

    public static void initAccountManagerServices(int priorityRemote, int priorityDatabase, int priorityPostgres) {
        if (initedServices) {
            return;
        }
        initedServices = true;
        Logger logger = LogManager.getLogger((String)"AccountManager");
        File configFile = new File("accountmanager.json");
        JsonObject accountManagerConfig = new JsonObject();
        if (configFile.exists()) {
            try {
                accountManagerConfig = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException e) {
                logger.error("Failed to load account manager configuration!", e);
                return;
            }
        }
        boolean changed = false;
        JsonObject remoteManagerConfig = new JsonObject();
        if (!accountManagerConfig.has("remoteHttpManager")) {
            remoteManagerConfig.addProperty("priority", (Number)priorityRemote);
            remoteManagerConfig.addProperty("url", "http://127.0.0.1:5324/accountmanager/");
            accountManagerConfig.add("remoteHttpManager", (JsonElement)remoteManagerConfig);
            changed = true;
        } else {
            remoteManagerConfig = accountManagerConfig.get("remoteHttpManager").getAsJsonObject();
        }
        JsonObject databaseManagerConfig = new JsonObject();
        if (!accountManagerConfig.has("databaseManager")) {
            databaseManagerConfig.addProperty("priority", (Number)priorityDatabase);
            databaseManagerConfig.addProperty("url", "jdbc:sqlite:account-data.db");
            JsonObject props = new JsonObject();
            databaseManagerConfig.add("properties", (JsonElement)props);
            accountManagerConfig.add("databaseManager", (JsonElement)databaseManagerConfig);
            changed = true;
        } else {
            databaseManagerConfig = accountManagerConfig.get("databaseManager").getAsJsonObject();
        }
        JsonObject postgresManagerConfig = new JsonObject();
        if (!accountManagerConfig.has("postgreSQL")) {
            postgresManagerConfig.addProperty("priority", (Number)priorityPostgres);
            postgresManagerConfig.addProperty("url", "jdbc:postgresql://localhost/edge");
            JsonObject props = new JsonObject();
            postgresManagerConfig.add("properties", (JsonElement)props);
            accountManagerConfig.add("postgreSQL", (JsonElement)postgresManagerConfig);
            changed = true;
        } else {
            postgresManagerConfig = accountManagerConfig.get("postgreSQL").getAsJsonObject();
        }
        if (changed) {
            try {
                Files.writeString(configFile.toPath(), (CharSequence)new Gson().newBuilder().setPrettyPrinting().create().toJson((JsonElement)accountManagerConfig), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Failed to write the account manager configuration!", (Throwable)e);
                return;
            }
        }
        ServiceManager.registerServiceImplementation(AccountManager.class, new RemoteHttpAccountManager(), remoteManagerConfig.get("priority").getAsInt());
        ServiceManager.registerServiceImplementation(AccountManager.class, new DefaultDatabaseAccountManager(), databaseManagerConfig.get("priority").getAsInt());
        ServiceManager.registerServiceImplementation(AccountManager.class, new PostgresDatabaseAccountManager(), postgresManagerConfig.get("priority").getAsInt());
    }

    public abstract boolean isValidUsername(String var1);

    public abstract boolean isValidPassword(String var1);

    public abstract boolean isUsernameTaken(String var1);

    public abstract String getAccountIDByEmail(String var1);

    public abstract String getAccountID(String var1);

    public abstract String getAccountIdBySaveUsername(String var1);

    public abstract boolean accountExists(String var1);

    public abstract boolean verifyPassword(String var1, String var2);

    public abstract AccountObject getAccount(String var1);

    public abstract AccountObject getGuestAccount(String var1);

    public abstract TokenParseResult verifyToken(String var1);

    public abstract byte[] signToken(String var1);

    public abstract AccountObject registerGuestAccount(String var1);

    public abstract AccountObject registerAccount(String var1, String var2, char[] var3);

    public abstract AccountSaveContainer getSaveByID(String var1);

    public abstract String[] getOnlinePlayerIDs();

    public AccountObject[] getOnlinePlayers() {
        return (AccountObject[])Stream.of(this.getOnlinePlayerIDs()).map(t -> this.getAccount((String)t)).toArray(AccountObject[]::new);
    }

    public abstract void runForAllAccounts(Function<AccountObject, Boolean> var1);

    public abstract void loadManager();
}

