/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.http.cookies;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Cookie {
    protected String value;
    protected String name;
    protected boolean secure = false;
    protected boolean httpOnly = false;
    protected SameSiteFlag sameSite = null;
    protected Date expires = null;
    protected String path = null;
    protected String domain = null;

    public Cookie setFlag(CookieFlag flag, boolean value) {
        if (flag == CookieFlag.SECURE) {
            this.secure = value;
        } else if (flag == CookieFlag.HTTP_ONLY) {
            this.httpOnly = value;
        }
        return this;
    }

    public Cookie setOption(CookieOption option, String value) {
        if (option == CookieOption.PATH) {
            this.path = value;
        } else if (option == CookieOption.DOMAIN) {
            this.domain = value;
        }
        return this;
    }

    public Cookie setExpires(Date expiryDate) {
        this.expires = expiryDate;
        return this;
    }

    public Cookie setSameSite(SameSiteFlag value) {
        this.sameSite = value;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public static Cookie create(String name) {
        Cookie cookie = new Cookie();
        cookie.name = name;
        return cookie;
    }

    protected void setValue(Cookie input) {
        this.value = input.getValue();
        if (input.secure) {
            this.secure = input.secure;
        }
        if (input.httpOnly) {
            this.httpOnly = input.httpOnly;
        }
        if (input.expires != null) {
            this.expires = input.expires;
        }
        if (input.sameSite != null) {
            this.sameSite = input.sameSite;
        }
        if (input.domain != null) {
            this.domain = input.domain;
        }
        if (input.path != null) {
            this.path = input.path;
        }
    }

    public String getCookieString() {
        String name = this.getName();
        String value = this.getValue();
        name = name.replace("%", "%25");
        name = name.replace(";", "%3B");
        name = name.replace("=", "%3D");
        value = value.replace("%", "%25");
        value = value.replace(";", "%3B");
        value = value.replace("=", "%3D");
        String str = name + "=" + value;
        if (this.secure) {
            str = str + "; Secure";
        }
        if (this.httpOnly) {
            str = str + "; HttpOnly";
        }
        if (this.sameSite != null) {
            str = str + "; SameSite=" + this.sameSite.value;
        }
        if (this.expires != null) {
            str = str + "; Expires=" + this.getHttpDate(this.expires);
        }
        if (this.path != null) {
            str = str + "; Path=" + this.path;
        }
        if (this.domain != null) {
            str = str + "; Domain=" + this.path;
        }
        return str;
    }

    public synchronized String getHttpDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public static enum SameSiteFlag {
        STRICT("Strict"),
        LAX("Lax"),
        NONE("None");

        String value = "";

        private SameSiteFlag(String value) {
            this.value = value;
        }
    }

    public static enum CookieFlag {
        SECURE,
        HTTP_ONLY;

    }

    public static enum CookieOption {
        PATH,
        DOMAIN;

    }
}

