/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.bytecode.sources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.enums.ComparisonMethod;
import org.asf.cyan.fluid.bytecode.sources.IClassSourceProvider;

public class FileClassSourceProvider
implements IClassSourceProvider<String> {
    private File file;

    public FileClassSourceProvider(File file) {
        this.file = file;
    }

    public boolean isZipLike() {
        return this.file.getName().endsWith(".jar") || this.file.getName().endsWith(".zip");
    }

    @Override
    public ComparisonMethod getComparisonMethod() {
        return ComparisonMethod.OBJECT_EQUALS;
    }

    @Override
    public String providerObject() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream getStream(String classType) {
        InputStream strm;
        URL url;
        try {
            url = this.file.toURI().toURL();
        }
        catch (MalformedURLException e1) {
            return null;
        }
        if (this.isZipLike()) {
            try {
                url = new URL("jar:" + url.toString() + "!/" + classType + ".class");
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        try {
            url = new URL(url + "/" + classType + ".class");
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            strm = url.openStream();
        }
        catch (IOException e) {
            return null;
        }
        return strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importAll(FluidClassPool pool) {
        if (this.isZipLike()) {
            FileInputStream strm;
            try {
                strm = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e1) {
                return;
            }
            try (ZipInputStream zip = new ZipInputStream(strm);){
                pool.importArchive(zip);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    ((InputStream)strm).close();
                }
                catch (IOException iOException) {}
            }
        } else if (this.file.isDirectory()) {
            this.importFromFolder(this.file, pool, "");
        }
    }

    private void importFromFolder(File dir, FluidClassPool pool, String pref) {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.importFromFolder(f, pool, pref + f.getName() + ".");
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            try {
                FileInputStream strm = new FileInputStream(f);
                pool.readClass(pref + f.getName().substring(0, f.getName().lastIndexOf(".class")), strm);
                ((InputStream)strm).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

