/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.contentserver.http;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.stream.Stream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.apache.logging.log4j.LogManager;
import org.asf.connective.RemoteClient;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.CommonIndexPage;
import org.asf.edge.common.util.TripleDesUtil;
import org.asf.edge.contentserver.EdgeContentServer;

public class ContentServerRequestHandler
extends HttpPushProcessor {
    private String path;
    private File sourceDir;
    private IPreProcessor[] preProcessors;
    private EdgeContentServer server;

    private String sanitizePath(String path) {
        while (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        while (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        while (((String)path).contains("//")) {
            path = ((String)path).replace("//", "/");
        }
        if (((String)path).contains("\\")) {
            path = ((String)path).replace("\\", "/");
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public ContentServerRequestHandler(File sourceDir, String path, IPreProcessor[] preProcessors, EdgeContentServer server) {
        this.sourceDir = sourceDir;
        this.path = this.sanitizePath(path);
        this.server = server;
        this.preProcessors = preProcessors;
    }

    public HttpPushProcessor createNewInstance() {
        return new ContentServerRequestHandler(this.sourceDir, this.path, this.preProcessors, this.server);
    }

    public String path() {
        return this.path;
    }

    public boolean supportsNonPush() {
        return true;
    }

    public boolean supportsChildPaths() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(String path, String method, RemoteClient client, String contentType) throws IOException {
        void var7_12;
        if (((String)(path = this.sanitizePath(((String)path).substring(this.path.length())))).startsWith("..") || ((String)path).endsWith("..") || ((String)path).contains("/..") || ((String)path).contains("../")) {
            this.setResponseStatus(403, "Forbidden");
            return;
        }
        File requestedFile = new File(this.sourceDir, (String)path);
        if (!requestedFile.exists()) {
            if (this.server.getConfiguration().fallbackAssetServerEndpoint != null) {
                Object url = this.server.getConfiguration().fallbackAssetServerEndpoint;
                while (((String)url).endsWith("/")) {
                    url = ((String)url).substring(0, ((String)url).lastIndexOf("/"));
                }
                url = (String)url + (String)path;
                try {
                    URL uRL = new URL((String)url);
                    InputStream fileStream = uRL.openStream();
                    String type = MainFileMap.getInstance().getContentType(new File((String)path).getName());
                    boolean encrypted = false;
                    byte[] key = null;
                    if (((String)path).toLowerCase().endsWith("/dwadragonsmain.xml")) {
                        void var12_26;
                        JsonObject replace;
                        byte[] byArray = fileStream.readAllBytes();
                        fileStream.close();
                        String data = new String(byArray, "UTF-8");
                        encrypted = data.matches("^([A-Za-z0-9+\\/]{4})*([A-Za-z0-9+\\/]{3}=|[A-Za-z0-9+\\/]{2}==)?$");
                        String secret = "C92EC1AA-54CD-4D0C-A8D5-403FCCF1C0BD";
                        if (encrypted) {
                            File verSpecificSecret = new File(this.sourceDir, ((String)path).split("/")[1] + "/" + ((String)path).split("/")[2] + "/" + ((String)path).split("/")[3] + "/versionxmlsecret.conf");
                            if (verSpecificSecret.exists()) {
                                for (String line : Files.readAllLines(verSpecificSecret.toPath())) {
                                    if (line.isBlank() || line.startsWith("#") || !line.contains("=")) continue;
                                    String k = line.substring(0, line.indexOf("="));
                                    String val = line.substring(line.indexOf("=") + 1);
                                    if (!k.equals("xmlsecret")) continue;
                                    secret = val;
                                }
                            }
                            try {
                                MessageDigest digest = MessageDigest.getInstance("MD5");
                                key = digest.digest(secret.getBytes("ASCII"));
                            }
                            catch (NoSuchAlgorithmException e) {
                                throw new RuntimeException(e);
                            }
                            byte[] b = Base64.getDecoder().decode(data);
                            byte[] byArray2 = TripleDesUtil.decrypt((byte[])b, (byte[])key);
                            data = new String(byArray2, "UTF-8");
                        }
                        if ((replace = this.server.getConfiguration().fallbackAssetServerManifestModifications) != null) {
                            for (String replaceKey : replace.keySet()) {
                                data = data.replace(replaceKey, replace.get(replaceKey).getAsString().replace("%local%", "[" + this.server.getConfiguration().listenAddress + "]:" + this.server.getConfiguration().listenPort));
                            }
                            byte[] byArray3 = data.getBytes("UTF-8");
                        }
                        fileStream = new ByteArrayInputStream((byte[])var12_26);
                    }
                    for (IPreProcessor processor : this.preProcessors) {
                        if (!processor.match((String)path, method, client, contentType, this.getRequest(), this.getResponse(), this.sourceDir)) continue;
                        fileStream = processor.preProcess((String)path, method, client, contentType, this.getRequest(), this.getResponse(), fileStream, this.sourceDir);
                    }
                    if (this.server.getConfiguration().storeFallbackAssetDownloads) {
                        try {
                            requestedFile.getParentFile().mkdirs();
                            FileOutputStream fileOutputStream = new FileOutputStream(requestedFile);
                            fileStream.transferTo(fileOutputStream);
                            fileStream.close();
                            fileOutputStream.close();
                            fileStream = new FileInputStream(requestedFile);
                        }
                        catch (IOException iOException) {
                            LogManager.getLogger((String)"CONTENTSERVER").error("Failed to download asset to disk: " + (String)path, (Throwable)iOException);
                        }
                    }
                    if (encrypted) {
                        byte[] byArray = fileStream.readAllBytes();
                        fileStream.close();
                        byte[] byArray4 = TripleDesUtil.encrypt((byte[])byArray, key);
                        fileStream = new ByteArrayInputStream(Base64.getEncoder().encodeToString(byArray4).getBytes("UTF-8"));
                    }
                    if (this.getResponse().hasHeader("Content-Type")) {
                        type = this.getResponse().getHeaderValue("Content-Type");
                    }
                    this.setResponseContent(type, fileStream);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setResponseStatus(404, "Not found");
            return;
        }
        if (requestedFile.isDirectory()) {
            File[] fileArray;
            if (!this.server.getConfiguration().allowIndexingAssets) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            File indexPage = null;
            if (indexPage == null && (fileArray = requestedFile.listFiles(t -> !t.isDirectory() && t.getName().startsWith("index.") && !t.getName().substring("index.".length()).contains("."))).length != 0) {
                indexPage = Stream.of(fileArray).anyMatch(t -> t.getName().equals("index.html")) ? new File(requestedFile, "index.html") : (Stream.of(fileArray).anyMatch(t -> t.getName().equals("index.htm")) ? new File(requestedFile, "index.htm") : fileArray[0]);
            }
            if (indexPage == null) {
                CommonIndexPage.index((File)requestedFile, (HttpRequest)this.getRequest(), (HttpResponse)this.getResponse());
                return;
            }
            requestedFile = indexPage;
            path = (String)path + "/" + indexPage.getName();
        }
        String type = MainFileMap.getInstance().getContentType(requestedFile);
        FileInputStream fileInputStream = new FileInputStream(requestedFile);
        boolean processed = false;
        for (IPreProcessor iPreProcessor : this.preProcessors) {
            if (!iPreProcessor.match((String)path, method, client, contentType, this.getRequest(), this.getResponse(), this.sourceDir)) continue;
            InputStream inputStream = iPreProcessor.preProcess((String)path, method, client, contentType, this.getRequest(), this.getResponse(), (InputStream)var7_12, this.sourceDir);
            processed = true;
        }
        if (this.getResponse().hasHeader("Content-Type")) {
            type = this.getResponse().getHeaderValue("Content-Type");
        }
        if (!processed) {
            this.setResponseContent(type, (InputStream)var7_12, requestedFile.length());
            return;
        }
        this.setResponseContent(type, (InputStream)var7_12);
    }

    public static interface IPreProcessor {
        public boolean match(String var1, String var2, RemoteClient var3, String var4, HttpRequest var5, HttpResponse var6, File var7);

        public InputStream preProcess(String var1, String var2, RemoteClient var3, String var4, HttpRequest var5, HttpResponse var6, InputStream var7, File var8) throws IOException;
    }

    private static class MainFileMap
    extends MimetypesFileTypeMap {
        private static MainFileMap instance;
        private FileTypeMap parent;

        public static MainFileMap getInstance() {
            if (instance == null) {
                instance = new MainFileMap(MimetypesFileTypeMap.getDefaultFileTypeMap());
            }
            return instance;
        }

        public MainFileMap(FileTypeMap parent) {
            this.parent = parent;
            this.addMimeTypes("application/xml\txml");
            this.addMimeTypes("application/json\tjson");
            this.addMimeTypes("text/ini\tini\tini");
            this.addMimeTypes("text/css\tcss");
            this.addMimeTypes("text/javascript\tjs");
            if (new File(".mime.types").exists()) {
                try {
                    this.addMimeTypes(Files.readString(Path.of(".mime.types", new String[0])));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (new File("mime.types").exists()) {
                try {
                    this.addMimeTypes(Files.readString(Path.of("mime.types", new String[0])));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public String getContentType(String filename) {
            String type = super.getContentType(filename);
            if (type.equals("application/octet-stream")) {
                type = this.parent.getContentType(filename);
            }
            return type;
        }
    }
}

