/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.messages;

import java.util.HashMap;
import java.util.Map;
import org.asf.edge.common.entities.messages.WsMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsGenericMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsPluginMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsRankMessage;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.messages.PlayerMessenger;
import org.asf.edge.common.xmls.messages.MessageInfoData;

public abstract class WsMessageService
extends AbstractService {
    private HashMap<Integer, WsMessage> messages = new HashMap<Integer, WsPluginMessage>(Map.of(4, new WsRankMessage(), 36, new WsPluginMessage()));

    public static WsMessageService getInstance() {
        return ServiceManager.getService(WsMessageService.class);
    }

    public void registerMessageType(int typeID, WsMessage message) {
        if (!this.messages.containsKey(typeID)) {
            this.messages.put(typeID, message);
        }
    }

    public WsMessage deserializeMessage(MessageInfoData message) {
        if (this.messages.containsKey(message.typeID)) {
            WsMessage msg = this.messages.get(message.typeID);
            msg.deserialize(message);
            return msg;
        }
        WsGenericMessage msg = new WsGenericMessage();
        ((WsMessage)msg).deserialize(message);
        return msg;
    }

    public abstract PlayerMessenger getMessengerFor(AccountObject var1, AccountSaveContainer var2);

    public abstract PlayerMessenger getMessengerFor(AccountObject var1);
}

