/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.config.impl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.asf.edge.common.services.config.ConfigProviderService;

public class ConfigProviderServiceImpl
extends ConfigProviderService {
    private HashMap<String, JsonObject> configs = new HashMap();

    @Override
    public void initService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean configExists(String namespace, String config) {
        if (!namespace.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config namespace may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        if (!config.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config names may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        HashMap<String, JsonObject> hashMap = this.configs;
        synchronized (hashMap) {
            if (this.configs.containsKey(namespace + "/" + config)) {
                return true;
            }
        }
        File root = namespace.equals("server") ? new File(".") : new File(namespace);
        File configFile = new File(root, config + ".json");
        return configFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveConfig(String namespace, String config, JsonObject configData) throws IOException {
        if (!namespace.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config namespace may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        if (!config.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config names may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        File root = namespace.equals("server") ? new File(".") : new File(namespace);
        File configFile = new File(root, config + ".json");
        HashMap<String, JsonObject> hashMap = this.configs;
        synchronized (hashMap) {
            root.mkdirs();
            Files.writeString(configFile.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)configData), new OpenOption[0]);
            this.configs.put(namespace + "/" + config, configData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject loadConfig(String namespace, String config, JsonObject defaultConfig) throws IOException {
        if (!namespace.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config namespace may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        if (!config.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config names may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        HashMap<String, JsonObject> hashMap = this.configs;
        synchronized (hashMap) {
            File root = namespace.equals("server") ? new File(".") : new File(namespace);
            File configFile = new File(root, config + ".json");
            if (configFile.exists()) {
                this.configs.put(namespace + "/" + config, JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject());
                return this.configs.get(namespace + "/" + config);
            }
        }
        this.saveConfig(namespace, config, defaultConfig);
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject loadConfig(String namespace, String config) throws IOException {
        if (!namespace.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config namespace may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        if (!config.matches("^[0-9a-z\\-_]+$")) {
            throw new IllegalArgumentException("Config names may only contain lowercase alphanumeric characters, hyphens and underscores");
        }
        HashMap<String, JsonObject> hashMap = this.configs;
        synchronized (hashMap) {
            File root = namespace.equals("server") ? new File(".") : new File(namespace);
            File configFile = new File(root, config + ".json");
            if (configFile.exists()) {
                this.configs.put(namespace + "/" + config, JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject());
                return this.configs.get(namespace + "/" + config);
            }
        }
        return null;
    }
}

