/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.commondata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.impl.DefaultDatabaseCommonDataManager;
import org.asf.edge.common.services.commondata.impl.PostgresDatabaseCommonDataManager;
import org.asf.edge.common.services.commondata.impl.http.RemoteHttpCommonDataManager;
import org.asf.edge.common.services.config.ConfigProviderService;

public abstract class CommonDataManager
extends AbstractService {
    private HashMap<String, CommonDataContainer> loadedContainers = new HashMap();
    private static boolean initedServices;

    public static CommonDataManager getInstance() {
        return ServiceManager.getService(CommonDataManager.class);
    }

    public static void initCommonDataManagerServices(int priorityRemote, int priorityDatabase, int priorityPostgres) {
        JsonObject commonDataManagerConfig;
        if (initedServices) {
            return;
        }
        initedServices = true;
        Logger logger = LogManager.getLogger((String)"CommonDataManager");
        try {
            commonDataManagerConfig = ConfigProviderService.getInstance().loadConfig("server", "commondata");
        }
        catch (IOException e) {
            logger.error("Failed to load common data manager configuration!", (Throwable)e);
            return;
        }
        if (commonDataManagerConfig == null) {
            commonDataManagerConfig = new JsonObject();
        }
        boolean changed = false;
        JsonObject remoteManagerConfig = new JsonObject();
        if (!commonDataManagerConfig.has("remoteHttpManager")) {
            remoteManagerConfig.addProperty("priority", (Number)priorityRemote);
            remoteManagerConfig.addProperty("url", "http://127.0.0.1:5324/commondatamanager/");
            commonDataManagerConfig.add("remoteHttpManager", (JsonElement)remoteManagerConfig);
            changed = true;
        } else {
            remoteManagerConfig = commonDataManagerConfig.get("remoteHttpManager").getAsJsonObject();
        }
        JsonObject databaseManagerConfig = new JsonObject();
        if (!commonDataManagerConfig.has("databaseManager")) {
            databaseManagerConfig.addProperty("priority", (Number)priorityDatabase);
            databaseManagerConfig.addProperty("url", "jdbc:sqlite:common-data.db");
            JsonObject props = new JsonObject();
            databaseManagerConfig.add("properties", (JsonElement)props);
            commonDataManagerConfig.add("databaseManager", (JsonElement)databaseManagerConfig);
            changed = true;
        } else {
            databaseManagerConfig = commonDataManagerConfig.get("databaseManager").getAsJsonObject();
        }
        JsonObject postgresManagerConfig = new JsonObject();
        if (!commonDataManagerConfig.has("postgreSQL")) {
            postgresManagerConfig.addProperty("priority", (Number)priorityPostgres);
            postgresManagerConfig.addProperty("url", "jdbc:postgresql://localhost/edge");
            JsonObject props = new JsonObject();
            postgresManagerConfig.add("properties", (JsonElement)props);
            commonDataManagerConfig.add("postgreSQL", (JsonElement)postgresManagerConfig);
            changed = true;
        } else {
            postgresManagerConfig = commonDataManagerConfig.get("postgreSQL").getAsJsonObject();
        }
        if (changed) {
            try {
                ConfigProviderService.getInstance().saveConfig("server", "commondata", commonDataManagerConfig);
            }
            catch (IOException e) {
                logger.error("Failed to write the common data manager configuration!", (Throwable)e);
                return;
            }
        }
        ServiceManager.registerServiceImplementation(CommonDataManager.class, new RemoteHttpCommonDataManager(), remoteManagerConfig.get("priority").getAsInt());
        ServiceManager.registerServiceImplementation(CommonDataManager.class, new DefaultDatabaseCommonDataManager(), databaseManagerConfig.get("priority").getAsInt());
        ServiceManager.registerServiceImplementation(CommonDataManager.class, new PostgresDatabaseCommonDataManager(), postgresManagerConfig.get("priority").getAsInt());
    }

    protected abstract CommonDataContainer getContainerInternal(String var1);

    protected abstract void setupContainer(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonDataContainer getContainer(String rootNodeName) {
        if (!rootNodeName.matches("^[A-Za-z0-9]+$")) {
            throw new IllegalArgumentException("Root node name can only contain alphanumeric characters");
        }
        rootNodeName = rootNodeName.toUpperCase();
        while (true) {
            try {
                if (this.loadedContainers.containsKey(rootNodeName)) {
                    return this.loadedContainers.get(rootNodeName);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        HashMap<String, CommonDataContainer> hashMap = this.loadedContainers;
        synchronized (hashMap) {
            if (this.loadedContainers.containsKey(rootNodeName)) {
                return this.loadedContainers.get(rootNodeName);
            }
            CommonDataContainer cont = this.getContainerInternal(rootNodeName);
            this.setupContainer(rootNodeName);
            this.loadedContainers.put(rootNodeName, cont);
            return cont;
        }
    }

    public abstract void loadManager();
}

