/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.implementation;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.Transformer;
import org.asf.cyan.fluid.api.transforming.Constructor;
import org.asf.cyan.fluid.api.transforming.LocalVariable;
import org.asf.cyan.fluid.api.transforming.TargetClass;
import org.asf.cyan.fluid.api.transforming.TargetName;
import org.asf.cyan.fluid.api.transforming.TargetOwner;
import org.asf.cyan.fluid.api.transforming.TargetType;
import org.asf.cyan.fluid.api.transforming.enums.InjectLocation;
import org.asf.cyan.fluid.api.transforming.util.CodeControl;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.UnrecognizedEnumInfo;
import org.asf.cyan.fluid.bytecode.enums.OpcodeUseCase;
import org.asf.cyan.fluid.remapping.MAPTYPE;
import org.asf.cyan.fluid.remapping.Mapping;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FluidTransformer
extends Transformer {
    private static HashMap<OpcodeUseCase, HashMap<String, Integer>> opcodes = new HashMap();

    protected static String getMarker() {
        return "FLUID";
    }

    @Override
    protected String getImplementationName() {
        return "Fluid";
    }

    @Override
    protected String getDeobfNameInternal(String clName) {
        for (Mapping<?> map : Fluid.getMappings()) {
            for (Mapping<?> mp : map.mappings) {
                if (!mp.obfuscated.equals(clName)) continue;
                return mp.name;
            }
        }
        return clName;
    }

    @Override
    protected void applyClassModifiers(Transformer.TransformContext context, int oldModifiers, int newModifiers) {
        context.targetClass.access = newModifiers;
    }

    @Override
    protected boolean applyMethodInterfaceTransformer(Transformer.TransformContext context, MethodNode target, MethodNode transformer, int oldMod, int newMod, Transformer.FluidMethodInfo methodInfo) {
        if (target.name.equals(transformer.name) || Transformer.AnnotationInfo.isAnnotationPresent(Constructor.class, transformer)) {
            oldMod = target.access = newMod;
            return true;
        }
        MethodNode newmethod = new MethodNode();
        InsnList instructions = new InsnList();
        int i = 0;
        if (!Modifier.isStatic(newMod)) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, i++));
        }
        for (int i2 = 0; i2 <= methodInfo.types.length; ++i2) {
            if (methodInfo.types[i2].equals("int")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(21, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("float")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(23, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("double")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(24, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("long")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(22, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("int[]")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(46, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("float[]")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(48, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("double[]")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(49, i++));
                continue;
            }
            if (methodInfo.types[i2].equals("long[]")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(47, i++));
                continue;
            }
            if (methodInfo.types[i2].endsWith("[]")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(50, i++));
                continue;
            }
            instructions.add((AbstractInsnNode)new VarInsnNode(25, i++));
        }
        instructions.add((AbstractInsnNode)new MethodInsnNode(Modifier.isStatic(newMod) ? 184 : 182, context.targetClass.name, target.name, target.desc));
        if (!methodInfo.returnType.equals("void")) {
            if (methodInfo.returnType.equals("int") || methodInfo.returnType.equals("boolean") || methodInfo.returnType.equals("short")) {
                instructions.add((AbstractInsnNode)new InsnNode(172));
            } else if (methodInfo.returnType.equals("double")) {
                instructions.add((AbstractInsnNode)new InsnNode(175));
            } else if (methodInfo.returnType.equals("float")) {
                instructions.add((AbstractInsnNode)new InsnNode(174));
            } else if (methodInfo.returnType.equals("long")) {
                instructions.add((AbstractInsnNode)new InsnNode(173));
            } else {
                instructions.add((AbstractInsnNode)new InsnNode(176));
            }
        } else {
            instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        newmethod.name = transformer.name;
        newmethod.maxLocals = methodInfo.getVarOffset() + (Modifier.isStatic(newMod) ? 0 : 1);
        newmethod.instructions = instructions;
        newmethod.maxStack = target.maxStack;
        newmethod.access = newMod;
        newmethod.desc = target.desc;
        newmethod.exceptions = target.exceptions;
        context.targetClass.methods.add(newmethod);
        return true;
    }

    @Override
    public void applyMethodRewriteTransformer(Transformer.TransformContext context, MethodNode target, MethodNode transformer, int newModifiers, Transformer.FluidMethodInfo targetInfo) {
        LineNumberNode lnNode;
        int methodStart = -1;
        for (AbstractInsnNode node : target.instructions) {
            if (!(node instanceof LineNumberNode) || methodStart != -1) continue;
            lnNode = (LineNumberNode)node;
            methodStart = lnNode.line;
        }
        target.maxStack = transformer.maxStack;
        target.maxLocals = transformer.maxLocals + (!Modifier.isStatic(target.access) ? (Modifier.isStatic(transformer.access) ? 0 : 1) : 0);
        target.localVariables = transformer.localVariables;
        target.instructions = transformer.instructions;
        target.access = newModifiers;
        for (String except : transformer.exceptions) {
            if (target.exceptions == null) {
                target.exceptions = new ArrayList();
            }
            target.exceptions.add(except);
        }
        for (AbstractInsnNode node : target.instructions) {
            if (!(node instanceof LineNumberNode)) continue;
            lnNode = (LineNumberNode)node;
            lnNode.line = methodStart++;
        }
        Transformer.FluidMethodInfo mth = Transformer.FluidMethodInfo.create(transformer);
        mth.remap(context.mappedName, context.transformer, mth, context.programPool);
        mth.transform(target.instructions, context.transformer, context.mappedName, context.targetClass, context.programPool);
        mth.apply(transformer);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected void applyInjectAt(Transformer.TransformContext context, Transformer.TargetInfo targetInfo, MethodNode target, MethodNode transformer, int oldModifiers, int newModifiers, Transformer.FluidMethodInfo methodInfo) {
        void var26_72;
        void var17_37;
        JumpInsnNode jump;
        void var17_35;
        int injectNodeIndex;
        boolean lineless;
        LabelNode methodEndLabel;
        block114: {
            void var17_29;
            int index;
            int offset;
            AbstractInsnNode tnode;
            int methodEndIndex;
            block115: {
                int methodStart = -1;
                methodEndIndex = -1;
                LabelNode methodStartLabel = null;
                methodEndLabel = null;
                for (AbstractInsnNode node : target.instructions) {
                    if (node instanceof LineNumberNode && methodStart == -1) {
                        LineNumberNode lnNode = (LineNumberNode)node;
                        methodStart = lnNode.line;
                        continue;
                    }
                    if (!(node instanceof LabelNode) || methodStartLabel != null) continue;
                    methodStartLabel = (LabelNode)node;
                }
                boolean returned = false;
                int indexTmp = target.instructions.size();
                block10: for (tnode = target.instructions.getLast(); tnode != null; --indexTmp, tnode = tnode.getPrevious()) {
                    if (tnode instanceof LabelNode && returned && methodEndLabel == null) {
                        methodEndLabel = (LabelNode)tnode;
                        methodEndIndex = indexTmp;
                        continue;
                    }
                    if (returned) continue;
                    switch (tnode.getOpcode()) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            returned = true;
                            continue block10;
                        }
                    }
                }
                if (methodEndLabel == null) {
                    indexTmp = target.instructions.size();
                    for (tnode = target.instructions.getLast(); tnode != null; --indexTmp, tnode = tnode.getPrevious()) {
                        if (!(tnode instanceof LabelNode) || methodEndLabel != null) continue;
                        methodEndLabel = (LabelNode)tnode;
                        methodEndIndex = indexTmp;
                        break;
                    }
                }
                lineless = false;
                if (methodStart == -1) {
                    lineless = true;
                }
                injectNodeIndex = -1;
                Object var17_19 = null;
                if (targetInfo.targetMethodName != null) {
                    offset = targetInfo.offset;
                    if (targetInfo.location == InjectLocation.HEAD) {
                        index = 0;
                        for (AbstractInsnNode node : target.instructions) {
                            if (node instanceof MethodInsnNode) {
                                MethodInsnNode methNode = (MethodInsnNode)node;
                                if (methNode.owner.equals(targetInfo.targetMethodClass)) {
                                    String methDesc = methNode.desc;
                                    Object[] methTypes = Fluid.parseMultipleDescriptors(methDesc.substring(1, methDesc.lastIndexOf(")")));
                                    if (methNode.name.equals(targetInfo.targetMethodName) && Arrays.equals(methTypes, targetInfo.targetMethodTypes)) {
                                        if (offset > 0) {
                                            --offset;
                                        } else {
                                            void var17_20;
                                            if (lineless) {
                                                injectNodeIndex = index;
                                                MethodInsnNode methodInsnNode = methNode;
                                                break;
                                            }
                                            for (AbstractInsnNode pr = methNode.getPrevious(); pr != null && var17_20 == null; pr = pr.getPrevious()) {
                                                if (pr instanceof LineNumberNode) {
                                                    AbstractInsnNode abstractInsnNode = pr.getPrevious();
                                                    injectNodeIndex = index;
                                                    break;
                                                }
                                                if (!(pr instanceof LabelNode)) continue;
                                                AbstractInsnNode abstractInsnNode = pr;
                                                injectNodeIndex = index;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            ++index;
                        }
                    } else {
                        for (AbstractInsnNode node = target.instructions.getLast(); node != null; node = node.getPrevious()) {
                            int index2 = 0;
                            if (!(node instanceof MethodInsnNode)) continue;
                            MethodInsnNode methNode = (MethodInsnNode)node;
                            if (methNode.owner.equals(targetInfo.targetMethodClass)) {
                                String methDesc = methNode.desc;
                                Object[] methTypes = Fluid.parseMultipleDescriptors(methDesc.substring(1, methDesc.lastIndexOf(")")));
                                if (methNode.name.equals(targetInfo.targetMethodName) && Arrays.equals(methTypes, targetInfo.targetMethodTypes)) {
                                    if (offset > 0) {
                                        --offset;
                                    } else {
                                        void var17_25;
                                        if (lineless) {
                                            MethodInsnNode methodInsnNode = methNode;
                                            injectNodeIndex = index2;
                                            break;
                                        }
                                        for (Object pr = methNode.getPrevious(); pr != null && var17_25 == null; pr = pr.getPrevious()) {
                                            if (pr instanceof LineNumberNode) {
                                                AbstractInsnNode abstractInsnNode = pr.getPrevious();
                                                injectNodeIndex = index2;
                                                break;
                                            }
                                            if (!(pr instanceof LabelNode)) continue;
                                            Object object = pr;
                                            injectNodeIndex = index2;
                                            break;
                                        }
                                    }
                                }
                            }
                            ++index2;
                        }
                    }
                }
                if (var17_29 != null || targetInfo.targetMethodName != null) break block114;
                if (targetInfo.location != InjectLocation.HEAD) break block115;
                offset = targetInfo.offset;
                index = 0;
                for (tnode = methodStartLabel; var17_29 == null && tnode != null; ++index, tnode = tnode.getNext()) {
                    if (tnode instanceof LineNumberNode) {
                        if (offset > 0) {
                            --offset;
                            continue;
                        }
                        AbstractInsnNode abstractInsnNode = tnode.getPrevious();
                        injectNodeIndex = index;
                        break block114;
                    } else {
                        if (!(tnode instanceof LabelNode) || tnode.getNext() == null || tnode.getNext() instanceof LineNumberNode) continue;
                        if (offset > 0) {
                            --offset;
                            continue;
                        }
                        AbstractInsnNode abstractInsnNode = tnode;
                        injectNodeIndex = index;
                    }
                    break block114;
                }
                break block114;
            }
            offset = targetInfo.offset;
            tnode = methodEndLabel;
            index = methodEndIndex;
            if (tnode.getNext() != null && tnode.getNext() instanceof LineNumberNode) {
                ++index;
                tnode = tnode.getNext();
            }
            while (var17_29 == null && tnode != null) {
                block117: {
                    block116: {
                        if (!(tnode instanceof LineNumberNode)) break block116;
                        if (offset > 0) {
                            --offset;
                            break block117;
                        } else {
                            AbstractInsnNode abstractInsnNode = tnode.getPrevious();
                            injectNodeIndex = index;
                            break;
                        }
                    }
                    if (tnode instanceof LabelNode && tnode.getNext() != null && !(tnode.getNext() instanceof LineNumberNode)) {
                        if (offset <= 0) {
                            AbstractInsnNode abstractInsnNode = tnode;
                            injectNodeIndex = index;
                            break;
                        }
                        --offset;
                    }
                }
                --index;
                tnode = tnode.getPrevious();
            }
        }
        String[] actualParams = Fluid.parseMultipleDescriptors(transformer.desc.substring(1, transformer.desc.lastIndexOf(")")));
        int min = 0;
        for (String type : actualParams) {
            if (type.equals("double")) {
                min += 2;
                continue;
            }
            ++min;
        }
        if (!Modifier.isStatic(transformer.access) && Modifier.isStatic(target.access)) {
            --min;
        } else if (Modifier.isStatic(transformer.access) && !Modifier.isStatic(target.access)) {
            ++min;
        }
        int appendVarLength = transformer.maxLocals - (actualParams.length + (Modifier.isStatic(transformer.access) ? 0 : 1));
        int injectCodeStart = -1;
        int addVarStart = 0;
        if (var17_35 != null) {
            int index = 0;
            for (AbstractInsnNode node : target.instructions) {
                if (index == injectNodeIndex) break;
                if (node instanceof VarInsnNode) {
                    addVarStart = ((VarInsnNode)node).var;
                } else if (node instanceof IincInsnNode) {
                    addVarStart = ((IincInsnNode)node).var;
                }
                ++index;
            }
        }
        if (addVarStart == 0) {
            addVarStart = methodInfo.getVarOffset() + (Modifier.isStatic(target.access) ? 0 : 1);
        }
        target.maxLocals += appendVarLength;
        InsnList newNodes = new InsnList();
        for (AbstractInsnNode node : transformer.instructions) {
            int varIndex;
            if (node instanceof VarInsnNode) {
                VarInsnNode varInsnNode = (VarInsnNode)node;
                if (varInsnNode.var > min) {
                    varIndex = varInsnNode.var - min;
                    varInsnNode.var = addVarStart + varIndex;
                }
            } else if (node instanceof IincInsnNode) {
                IincInsnNode iincInsnNode = (IincInsnNode)node;
                if (iincInsnNode.var > min) {
                    varIndex = iincInsnNode.var - min;
                    iincInsnNode.var = addVarStart + varIndex;
                }
            }
            if (node instanceof FrameNode) continue;
            newNodes.add(node);
        }
        boolean keepReturn = false;
        InsnList instrs = target.instructions;
        if (newNodes.size() >= 2 && var17_35 == methodEndLabel) {
            void var26_59;
            void var26_58 = var17_35;
            boolean found = false;
            while (var26_59 != null) {
                if (var26_59 instanceof InsnNode) {
                    switch (var26_59.getOpcode()) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            found = true;
                            break;
                        }
                    }
                    if (found) break;
                }
                AbstractInsnNode abstractInsnNode = var26_59.getNext();
            }
            if (found && var26_59.getOpcode() == 177) {
                void var26_61;
                keepReturn = true;
                InsnNode last = (InsnNode)var26_59;
                LabelNode lastLabel = null;
                while (var26_61 != null) {
                    if (var26_61 instanceof LabelNode) {
                        lastLabel = (LabelNode)var26_61;
                        break;
                    }
                    AbstractInsnNode abstractInsnNode = var26_61.getNext();
                }
                if (lastLabel != null) {
                    for (LocalVariableNode var : transformer.localVariables) {
                        if (newNodes.indexOf((AbstractInsnNode)var.end) != newNodes.indexOf((AbstractInsnNode)lastLabel)) continue;
                        var.end = methodEndLabel;
                    }
                    for (AbstractInsnNode nnd : newNodes) {
                        if (!(nnd instanceof JumpInsnNode)) continue;
                        jump = (JumpInsnNode)nnd;
                        if (newNodes.indexOf((AbstractInsnNode)jump.label) != newNodes.indexOf((AbstractInsnNode)lastLabel)) continue;
                        jump.label = methodEndLabel;
                    }
                }
                InsnNode insnNode = last;
            }
        }
        if (!keepReturn) {
            void var26_65;
            void var26_64 = var17_37;
            while (var26_65 != null && !(var26_65 instanceof LabelNode)) {
                AbstractInsnNode abstractInsnNode = var26_65.getPrevious();
            }
            for (AbstractInsnNode nd = newNodes.getLast(); nd != null; nd = nd.getPrevious()) {
                boolean stop = false;
                switch (nd.getOpcode()) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        stop = true;
                        if (nd.getNext() != null && nd.getNext() instanceof LabelNode) {
                            LabelNode label = (LabelNode)nd.getNext();
                            if (var17_37 != null && transformer.localVariables != null && var26_65 != null) {
                                for (LocalVariableNode var : transformer.localVariables) {
                                    if (transformer.instructions.indexOf((AbstractInsnNode)label) != transformer.instructions.indexOf((AbstractInsnNode)var.end)) continue;
                                    var.end = (LabelNode)var26_65;
                                }
                                for (ListIterator node : newNodes) {
                                    if (!(node instanceof JumpInsnNode)) continue;
                                    jump = (JumpInsnNode)node;
                                    if (transformer.instructions.indexOf((AbstractInsnNode)label) != transformer.instructions.indexOf((AbstractInsnNode)jump.label)) continue;
                                    jump.label = (LabelNode)var26_65;
                                }
                            }
                            newNodes.remove((AbstractInsnNode)label);
                        }
                        if (nd.getPrevious() != null && nd.getPrevious() instanceof LineNumberNode) {
                            LineNumberNode line = (LineNumberNode)nd.getPrevious();
                            LabelNode label = line.start;
                            if (var17_37 != null && transformer.localVariables != null && var26_65 != null) {
                                ListIterator node;
                                for (LocalVariableNode var : transformer.localVariables) {
                                    if (transformer.instructions.indexOf((AbstractInsnNode)label) != transformer.instructions.indexOf((AbstractInsnNode)var.end)) continue;
                                    var.end = (LabelNode)var26_65;
                                }
                                node = newNodes.iterator();
                                while (node.hasNext()) {
                                    AbstractInsnNode node2 = (AbstractInsnNode)node.next();
                                    if (!(node2 instanceof JumpInsnNode)) continue;
                                    JumpInsnNode jump2 = (JumpInsnNode)node2;
                                    if (transformer.instructions.indexOf((AbstractInsnNode)label) != transformer.instructions.indexOf((AbstractInsnNode)jump2.label)) continue;
                                    jump2.label = (LabelNode)var26_65;
                                }
                            }
                            newNodes.remove((AbstractInsnNode)label);
                            newNodes.remove((AbstractInsnNode)line);
                        }
                        newNodes.remove(nd);
                        break;
                    }
                }
                if (stop) break;
            }
        }
        if (target.localVariables != null && transformer.localVariables != null && transformer.localVariables.size() > actualParams.length + (Modifier.isStatic(target.access) ? 0 : 1)) {
            int i;
            LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[transformer.localVariables.size() - (actualParams.length + (Modifier.isStatic(transformer.access) ? 0 : 1))];
            int index = 0;
            for (i = actualParams.length + (Modifier.isStatic(transformer.access) ? 0 : 1); i < transformer.localVariables.size(); ++i) {
                LocalVariableNode lvn = (LocalVariableNode)transformer.localVariables.get(i);
                if (Fluid.parseDescriptor(lvn.desc).equals(context.transformer.name.replaceAll("/", "."))) {
                    lvn.desc = Fluid.getDescriptor(context.targetClass.name);
                }
                localVariableNodeArray[index++] = lvn;
            }
            if (localVariableNodeArray.length != 0) {
                if (target.localVariables.size() == 0) {
                    block32: for (i = 0; i < localVariableNodeArray.length; ++i) {
                        localVariableNodeArray[i].index = i;
                        LabelNode start = localVariableNodeArray[i].start;
                        while (start != null) {
                            if (!((start = start.getPrevious()) instanceof LabelNode)) continue;
                            localVariableNodeArray[i].start = start;
                            continue block32;
                        }
                    }
                    target.localVariables = Arrays.asList(localVariableNodeArray);
                } else {
                    index = 0;
                    LocalVariableNode[] vars = new LocalVariableNode[target.localVariables.size() + localVariableNodeArray.length];
                    for (LocalVariableNode var : target.localVariables) {
                        if (var.index > addVarStart) {
                            var.index += appendVarLength;
                        }
                        vars[index++] = var;
                    }
                    block35: for (int i2 = 0; i2 < localVariableNodeArray.length; ++i2) {
                        localVariableNodeArray[i2].index = addVarStart + (localVariableNodeArray[i2].index - actualParams.length);
                        LabelNode start = localVariableNodeArray[i2].start;
                        while (start != null) {
                            if (!((start = start.getPrevious()) instanceof LabelNode)) continue;
                            vars[i2 + index].start = start;
                            continue block35;
                        }
                    }
                    target.localVariables = Arrays.asList(vars);
                }
            }
        }
        for (AbstractInsnNode node : newNodes) {
            if (!(node instanceof LineNumberNode) || injectCodeStart != -1) continue;
            LineNumberNode lnNode = (LineNumberNode)node;
            injectCodeStart = lnNode.line;
        }
        Object var26_71 = null;
        for (AbstractInsnNode node : newNodes) {
            if (!(node instanceof LabelNode) || var26_72 != null) continue;
            LabelNode labelNode = (LabelNode)node;
        }
        methodInfo.transform(newNodes, context.transformer, context.mappedName, context.targetClass, context.programPool);
        int offset = targetInfo.offset;
        if (!lineless && var17_37 == null && targetInfo.targetMethodName == null) {
            throw new RuntimeException("Unable to find LabelNode offset " + offset + " for class " + context.mappedName + ", transformer cannot be applied, method: " + transformer.name + ", transformer: " + context.transformerType);
        }
        if (!lineless && var17_37 == null) {
            Object object;
            String string = targetInfo.targetMethodName;
            if (offset == 0) {
                object = "";
                throw new RuntimeException("Unable to find target method '" + string + "'" + (String)object + " in class " + context.mappedName + ", transformer cannot be applied, method: " + transformer.name + ", transformer: " + context.transformerType);
            }
            object = " with offset " + offset;
            throw new RuntimeException("Unable to find target method '" + string + "'" + (String)object + " in class " + context.mappedName + ", transformer cannot be applied, method: " + transformer.name + ", transformer: " + context.transformerType);
        }
        if (var26_72 != null) {
            for (AbstractInsnNode node : instrs) {
                if (node instanceof JumpInsnNode) {
                    AbstractInsnNode nodeTmp;
                    JumpInsnNode jump3 = (JumpInsnNode)node;
                    int jTarget = 0;
                    for (nodeTmp = jump3.label.getPrevious(); nodeTmp != null; ++jTarget, nodeTmp = nodeTmp.getPrevious()) {
                    }
                    int mTarget = 0;
                    for (nodeTmp = var17_37.getPrevious(); nodeTmp != null; ++mTarget, nodeTmp = nodeTmp.getPrevious()) {
                    }
                    if (jTarget != mTarget) continue;
                    jump3.label = var26_72;
                    continue;
                }
                if (!(node instanceof FrameNode)) continue;
                instrs.remove(node);
            }
        }
        for (AbstractInsnNode node : instrs) {
            VarInsnNode vnode;
            if (node instanceof VarInsnNode) {
                vnode = (VarInsnNode)node;
                if (vnode.var <= addVarStart) continue;
                vnode.var += appendVarLength;
                continue;
            }
            if (!(node instanceof IincInsnNode)) continue;
            vnode = (IincInsnNode)node;
            if (vnode.var <= addVarStart) continue;
            vnode.var += appendVarLength;
        }
        if (var17_37 != null) {
            instrs.insertBefore((AbstractInsnNode)var17_37, newNodes);
        } else {
            if (targetInfo.location != InjectLocation.HEAD || targetInfo.offset > 0) {
                log.warn("Could not apply transformer " + context.transformerType + " to method " + transformer.name + " at its preferred offset, adding the instructions at the top of the method, class: " + context.mappedName);
            }
            instrs.insert(newNodes);
        }
        target.instructions = instrs;
        target.access = newModifiers;
        if (transformer.maxStack > target.maxStack) {
            target.maxStack += transformer.maxStack - target.maxStack;
        }
        if (transformer.tryCatchBlocks == null) return;
        if (target.tryCatchBlocks == null) {
            target.tryCatchBlocks = new ArrayList();
        }
        target.tryCatchBlocks.addAll(transformer.tryCatchBlocks);
    }

    @Override
    protected Transformer.FluidMethodInfo createMethod(Transformer.TransformContext context, MethodNode transformer, String methodName, int oldModifiers, int newModifiers) {
        Transformer.FluidMethodInfo mth = Transformer.FluidMethodInfo.create(transformer);
        mth.name = methodName;
        mth.remap(context.mappedName, context.transformer, mth, context.programPool);
        mth.transform(transformer.instructions, context.transformer, context.mappedName, context.targetClass, context.programPool);
        mth.apply(transformer);
        transformer.access = newModifiers;
        Transformer.FluidMethodInfo ninfo = Transformer.FluidMethodInfo.create(transformer);
        ninfo.remap(context.mappedName, context.transformer, ninfo, false, context.programPool);
        InsnList instrs = new InsnList();
        for (AbstractInsnNode nd : transformer.instructions) {
            if (nd instanceof FrameNode) continue;
            instrs.add(nd);
        }
        transformer.instructions = instrs;
        context.targetClass.methods.add(transformer);
        return ninfo;
    }

    @Override
    protected boolean checkField(String fname, FluidClassPool pool, ClassNode cls) {
        if (cls.fields.stream().anyMatch(t -> t.name.equals(fname))) {
            return true;
        }
        if (cls.superName != null && !cls.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) {
            try {
                if (this.checkField(fname, pool, pool.getClassNode(cls.superName))) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected FieldNode getField(String fname, FluidClassPool pool, ClassNode cls) {
        if (cls.fields.stream().anyMatch(t -> t.name.equals(fname))) {
            return cls.fields.stream().filter(t -> t.name.equals(fname)).findFirst().get();
        }
        if (cls.superName != null && !cls.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) {
            try {
                if (this.checkField(fname, pool, pool.getClassNode(cls.superName))) {
                    return this.getField(fname, pool, pool.getClassNode(cls.superName));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected List<Transformer.AnnotationInfo> getParameterAnnotations(MethodNode method, int param) {
        ArrayList<Transformer.AnnotationInfo> annotations = new ArrayList<Transformer.AnnotationInfo>();
        if (method.visibleParameterAnnotations != null && method.visibleParameterAnnotations.length > param && method.visibleParameterAnnotations[param] != null) {
            for (AnnotationNode anno : method.visibleParameterAnnotations[param]) {
                annotations.add(Transformer.AnnotationInfo.create(anno));
            }
        }
        if (method.invisibleParameterAnnotations != null && method.invisibleParameterAnnotations.length > param && method.invisibleParameterAnnotations[param] != null) {
            for (AnnotationNode anno : method.invisibleParameterAnnotations[param]) {
                annotations.add(Transformer.AnnotationInfo.create(anno));
            }
        }
        return annotations;
    }

    @Override
    protected Transformer.AnnotationInfo[] createAnnoInfo(AbstractInsnNode node) {
        ArrayList<Transformer.AnnotationInfo> infos = new ArrayList<Transformer.AnnotationInfo>();
        if (node.visibleTypeAnnotations != null) {
            for (AnnotationNode anno : node.visibleTypeAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        if (node.invisibleTypeAnnotations != null) {
            for (AnnotationNode anno : node.invisibleTypeAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        return (Transformer.AnnotationInfo[])infos.toArray(Transformer.AnnotationInfo[]::new);
    }

    @Override
    protected Transformer.AnnotationInfo[] createAnnoInfo(FieldNode node) {
        ArrayList<Transformer.AnnotationInfo> infos = new ArrayList<Transformer.AnnotationInfo>();
        if (node.visibleAnnotations != null) {
            for (AnnotationNode anno : node.visibleAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        if (node.invisibleAnnotations != null) {
            for (AnnotationNode anno : node.invisibleAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        return (Transformer.AnnotationInfo[])infos.toArray(Transformer.AnnotationInfo[]::new);
    }

    @Override
    protected Transformer.AnnotationInfo[] createAnnoInfo(MethodNode node) {
        ArrayList<Transformer.AnnotationInfo> infos = new ArrayList<Transformer.AnnotationInfo>();
        if (node.visibleAnnotations != null) {
            for (AnnotationNode anno : node.visibleAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        if (node.invisibleAnnotations != null) {
            for (AnnotationNode anno : node.invisibleAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        return (Transformer.AnnotationInfo[])infos.toArray(Transformer.AnnotationInfo[]::new);
    }

    @Override
    protected Transformer.AnnotationInfo[] createAnnoInfo(ClassNode node) {
        ArrayList<Transformer.AnnotationInfo> infos = new ArrayList<Transformer.AnnotationInfo>();
        if (node.visibleAnnotations != null) {
            for (AnnotationNode anno : node.visibleAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        if (node.invisibleAnnotations != null) {
            for (AnnotationNode anno : node.invisibleAnnotations) {
                infos.add(this.createAnnoInfo(anno));
            }
        }
        return (Transformer.AnnotationInfo[])infos.toArray(Transformer.AnnotationInfo[]::new);
    }

    @Override
    protected Transformer.AnnotationInfo createAnnoInfo(AnnotationNode node) {
        Transformer.AnnotationInfo info = new Transformer.AnnotationInfo();
        info.name = Fluid.parseDescriptor(node.desc);
        boolean key = true;
        String keyValue = "";
        if (node.values != null) {
            for (Object obj : node.values) {
                if (key) {
                    keyValue = obj.toString();
                } else {
                    obj = this.parseObj(obj);
                    info.values.put(keyValue, obj);
                    keyValue = "";
                }
                key = !key;
            }
        }
        return info;
    }

    private Object parseObj(Object obj) {
        if (obj instanceof String[]) {
            String[] data = (String[])obj;
            String type = Fluid.parseDescriptor(data[0]);
            Class<?> enumCls = null;
            try {
                enumCls = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                UnrecognizedEnumInfo uenum = new UnrecognizedEnumInfo(type, data[1]);
                return uenum;
            }
            try {
                obj = enumCls.getField(data[1]).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof List) {
            List lst = (List)obj;
            for (int i = 0; i < lst.size(); ++i) {
                lst.set(i, this.parseObj(lst.get(i)));
            }
        }
        return obj;
    }

    @Override
    protected Transformer.FluidMethodInfo createFMI(MethodNode method) {
        Transformer.FluidMethodInfo info = new Transformer.FluidMethodInfo();
        String desc = method.desc;
        info.name = method.name;
        String returnT = Fluid.parseDescriptor(desc.substring(desc.lastIndexOf(")") + 1));
        String typeStr = desc.substring(1, desc.lastIndexOf(")"));
        ArrayList<String> mTypes = new ArrayList<String>(Arrays.asList(Fluid.parseMultipleDescriptors(typeStr)));
        int paramIndex = 0;
        int size = mTypes.size();
        for (int i = 0; i < size; ++i) {
            boolean remove = false;
            for (Transformer.AnnotationInfo anno : Transformer.FluidMethodInfo.getParameterAnnotations(method, i)) {
                if (!anno.is(LocalVariable.class)) continue;
                mTypes.remove(paramIndex);
                remove = true;
            }
            if (remove) continue;
            ++paramIndex;
        }
        info.types = (String[])mTypes.toArray(String[]::new);
        info.returnType = returnT;
        return info;
    }

    @Override
    protected Transformer.FluidMethodInfo createFMI(MethodInsnNode method) {
        Transformer.FluidMethodInfo info = new Transformer.FluidMethodInfo();
        String desc = method.desc;
        info.name = method.name;
        String returnT = Fluid.parseDescriptor(desc.substring(desc.lastIndexOf(")") + 1));
        String typeStr = desc.substring(1, desc.lastIndexOf(")"));
        String[] mTypes = Fluid.parseMultipleDescriptors(typeStr);
        info.types = mTypes;
        info.returnType = returnT;
        return info;
    }

    @Override
    protected Transformer.FluidMethodInfo createFMI(String methodName, String methodDesc) {
        Transformer.FluidMethodInfo info = new Transformer.FluidMethodInfo();
        info.name = methodName;
        String returnT = Fluid.parseDescriptor(methodDesc.substring(methodDesc.lastIndexOf(")") + 1));
        String typeStr = methodDesc.substring(1, methodDesc.lastIndexOf(")"));
        String[] mTypes = Fluid.parseMultipleDescriptors(typeStr);
        info.types = mTypes;
        info.returnType = returnT;
        return info;
    }

    @Override
    protected Transformer.FluidMethodInfo createFMI(String name, String[] types, String returnType, String owner) {
        Transformer.FluidMethodInfo info = new Transformer.FluidMethodInfo();
        int i = 0;
        for (String type : types) {
            types[i++] = Fluid.mapClass(type);
        }
        returnType = Fluid.mapClass(returnType);
        info.name = name = Fluid.mapMethod(owner.replaceAll("/", "."), info.name, types);
        info.types = types;
        info.returnType = returnType;
        return null;
    }

    @Override
    protected Transformer.FluidMethodInfo createFMI(String methodIdentifier) {
        String name = methodIdentifier;
        Object desc = "";
        if (name.contains("(")) {
            desc = name.substring(name.indexOf("("));
            name = name.substring(0, name.indexOf("("));
            if (((String)desc).endsWith(")")) {
                String typesStr = ((String)desc).substring(1, ((String)desc).lastIndexOf(")"));
                desc = "(";
                if (typesStr.contains(" ")) {
                    typesStr = typesStr.replaceAll(" ", "");
                }
                if (!typesStr.isEmpty()) {
                    for (String type : typesStr.split(",")) {
                        desc = (String)desc + Fluid.getDescriptor(type);
                    }
                }
                desc = (String)desc + ")V";
            }
        }
        return this.createFMI(name, (String)desc);
    }

    @Override
    protected MethodNode remapFMI(Transformer.FluidMethodInfo self, String clName, ClassNode transformerNode, Transformer.FluidMethodInfo method, boolean fullRemap, FluidClassPool pool) {
        Optional<MethodNode> nodeOpt = transformerNode.methods.stream().filter(t -> t.name.equals(method.name) && Transformer.FluidMethodInfo.create(t).equals(method)).findFirst();
        if (!nodeOpt.isEmpty()) {
            MethodNode call = nodeOpt.get();
            if (Transformer.AnnotationInfo.isAnnotationPresent(TargetName.class, call)) {
                self.name = (String)Transformer.AnnotationInfo.getAnnotation(TargetName.class, call).get("target");
            }
            if (Transformer.AnnotationInfo.isAnnotationPresent(TargetOwner.class, call)) {
                self.owner = (String)Transformer.AnnotationInfo.getAnnotation(TargetOwner.class, call).get("owner");
            }
            if (Transformer.AnnotationInfo.isAnnotationPresent(Constructor.class, call)) {
                String string = self.name = Transformer.AnnotationInfo.getAnnotation(Constructor.class, call).get("clinit", false) != false ? "<clinit>" : "<init>";
            }
            if (Transformer.AnnotationInfo.isAnnotationPresent(TargetType.class, call)) {
                self.returnType = (String)Transformer.AnnotationInfo.getAnnotation(TargetType.class, call).get("target");
            }
            int index = 0;
            String[] stringArray = method.types;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String type;
                String typePath = type = stringArray[i];
                for (Transformer.AnnotationInfo anno : Transformer.FluidMethodInfo.getParameterAnnotations(call, index)) {
                    if (!anno.is(TargetType.class)) continue;
                    typePath = (String)anno.get("target");
                }
                self.types[index++] = typePath;
            }
        }
        if (fullRemap) {
            self.returnType = Fluid.mapClass(self.returnType);
        }
        if (fullRemap) {
            self.name = this.mapMethodName(clName, self.name, self.types, true, null, pool);
            int index = 0;
            for (int i = 0; i < method.types.length; ++i) {
                self.types[index] = Fluid.mapClass(self.types[index++]);
            }
        }
        return nodeOpt.isEmpty() ? null : nodeOpt.get();
    }

    private String mapMethodName(String clsName, String methName, String[] types, boolean toplevel, ClassNode clsT, FluidClassPool pool) {
        boolean found = false;
        String mName = methName;
        if (methName.equals("<init>") || methName.equals("<clinit>") || clsName == null) {
            return methName;
        }
        for (Mapping<?> root : Fluid.getMappings()) {
            Mapping<?> map = root.mapClassToMapping(clsName, t -> Stream.of(t.mappings).anyMatch(t2 -> t2.mappingType == MAPTYPE.METHOD && (t2.name.equals(mName) || t2.obfuscated.equals(mName)) && Arrays.equals(t2.argumentTypes, types)), false);
            if (map != null) {
                methName = Stream.of(map.mappings).filter((Predicate<Mapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$mapMethodName$11(java.lang.String java.lang.String[] org.asf.cyan.fluid.remapping.Mapping ), (Lorg/asf/cyan/fluid/remapping/Mapping;)Z)((String)mName, (String[])types)).findFirst().get().obfuscated;
                found = true;
                break;
            }
            if (clsT == null) {
                try {
                    clsT = pool.getClassNode(Fluid.mapClass(clsName));
                }
                catch (ClassNotFoundException ex) {
                    break;
                }
            }
            String outP = "";
            for (String inter : clsT.interfaces) {
                ClassNode iClsT;
                clsName = FluidTransformer.getDeobfName(inter.replaceAll("/", "."));
                try {
                    iClsT = pool.getClassNode(inter);
                }
                catch (ClassNotFoundException e) {
                    break;
                }
                outP = this.mapMethodName(clsName, methName, types, false, iClsT, pool);
                if (outP != null) {
                    found = true;
                    methName = outP;
                    break;
                }
                if (found || iClsT.superName == null || iClsT.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) continue;
                clsName = FluidTransformer.getDeobfName(iClsT.superName.replaceAll("/", "."));
                try {
                    iClsT = pool.getClassNode(iClsT.superName);
                }
                catch (ClassNotFoundException e) {
                    break;
                }
                outP = this.mapMethodName(clsName, methName, types, false, iClsT, pool);
                if (outP == null) continue;
                found = true;
                methName = outP;
            }
            if (found || clsT.superName == null || clsT.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) break;
            if (found) continue;
            clsName = FluidTransformer.getDeobfName(clsT.superName.replaceAll("/", "."));
            try {
                clsT = pool.getClassNode(clsT.superName);
            }
            catch (ClassNotFoundException e) {
                break;
            }
            outP = this.mapMethodName(clsName, methName, types, false, clsT, pool);
            if (outP == null) continue;
            found = true;
            methName = outP;
        }
        if (!found && !toplevel) {
            return null;
        }
        return methName;
    }

    @Override
    protected Transformer.FluidMethodInfo createFMI(String name, String[] types, String returnType) {
        Transformer.FluidMethodInfo info = new Transformer.FluidMethodInfo();
        info.name = name;
        info.types = types;
        info.returnType = returnType;
        return info;
    }

    @Override
    protected Transformer.FluidMethodInfo applyFMI(Transformer.FluidMethodInfo self, MethodNode method) {
        method.name = self.name;
        method.desc = "(" + Fluid.getDescriptors(self.types) + ")" + Fluid.getDescriptor(self.returnType);
        return self;
    }

    @Override
    protected Transformer.FluidMethodInfo applyFMI(Transformer.FluidMethodInfo self, String owner, MethodInsnNode method) {
        method.name = self.name;
        method.desc = "(" + Fluid.getDescriptors(self.types) + ")" + Fluid.getDescriptor(self.returnType);
        method.owner = owner.replaceAll("\\.", "/");
        return self;
    }

    private static int getOpcode(String name) {
        return opcodes.get((Object)OpcodeUseCase.JVM_OPCODE).get(name);
    }

    @Override
    protected Transformer.FluidMethodInfo transformFMI(Transformer.FluidMethodInfo self, InsnList instructions, ClassNode transformerNode, String clName, ClassNode cls, FluidClassPool pool) {
        InsnList lst = new InsnList();
        for (AbstractInsnNode nd : instructions) {
            lst.add(nd);
        }
        int nodeInd = 0;
        int skip = 0;
        int skipForced = 0;
        for (AbstractInsnNode nd : lst) {
            TypeInsnNode tnode;
            String newClName;
            if (skipForced != 0) {
                --skipForced;
                continue;
            }
            if (skip != 0) {
                instructions.remove(instructions.get(nodeInd));
                --skip;
                continue;
            }
            AbstractInsnNode node = instructions.get(nodeInd);
            if (node instanceof MethodInsnNode) {
                MethodInsnNode mnode = (MethodInsnNode)node;
                if (mnode.owner.equals(CodeControl.class.getTypeName().replace(".", "/"))) {
                    int var;
                    if (mnode.name.contains("STORE")) {
                        if (mnode.name.equals("ASTORE") && mnode.getNext() instanceof TypeInsnNode) {
                            ++skip;
                        }
                        instructions.remove((AbstractInsnNode)mnode);
                        continue;
                    }
                    if (!mnode.name.contains("LOAD")) continue;
                    if (mnode.getPrevious() instanceof InsnNode) {
                        var = mnode.getPrevious().getOpcode() - 3;
                    } else {
                        IntInsnNode value = (IntInsnNode)mnode.getPrevious();
                        var = value.operand;
                    }
                    instructions.remove(instructions.get(nodeInd - 1));
                    instructions.set((AbstractInsnNode)mnode, (AbstractInsnNode)new VarInsnNode(FluidTransformer.getOpcode(mnode.name), var));
                    continue;
                }
                if (mnode.owner.equals(transformerNode.name)) {
                    this.processMethod(mnode, clName, pool, transformerNode);
                } else {
                    ClassNode clsT = null;
                    try {
                        clsT = pool.getClassNode(mnode.owner);
                    }
                    catch (ClassNotFoundException value) {
                        // empty catch block
                    }
                    if (clsT != null && Transformer.AnnotationInfo.isAnnotationPresent(TargetClass.class, clsT)) {
                        newClName = (String)Transformer.AnnotationInfo.getAnnotation(TargetClass.class, clsT).get("target");
                        this.processMethod(mnode, newClName, pool, clsT);
                    }
                }
            } else if (node instanceof FieldInsnNode) {
                FieldInsnNode fnode = (FieldInsnNode)node;
                if (fnode.owner.equals(transformerNode.name)) {
                    FluidTransformer.processField(fnode, clName, pool, transformerNode);
                } else {
                    ClassNode clsT = null;
                    try {
                        clsT = pool.getClassNode(fnode.owner);
                    }
                    catch (ClassNotFoundException newClName2) {
                        // empty catch block
                    }
                    if (clsT != null && Transformer.AnnotationInfo.isAnnotationPresent(TargetClass.class, clsT)) {
                        newClName = (String)Transformer.AnnotationInfo.getAnnotation(TargetClass.class, clsT).get("target");
                        FluidTransformer.processField(fnode, newClName, pool, clsT);
                    }
                }
            } else if (node instanceof InvokeDynamicInsnNode) {
                InvokeDynamicInsnNode dnode = (InvokeDynamicInsnNode)node;
                String typesStr = dnode.desc;
                String type = typesStr.substring(typesStr.lastIndexOf(")") + 1);
                typesStr = typesStr.substring(1, typesStr.lastIndexOf(")"));
                String[] types = Fluid.parseMultipleDescriptors(typesStr);
                type = Fluid.parseDescriptor(type);
                int ind = 0;
                for (String param : types) {
                    if (param.equals(transformerNode.name.replaceAll("/", "."))) {
                        types[ind] = cls.name.replaceAll("/", ".");
                    }
                    ++ind;
                }
                if (type.equals(transformerNode.name.replaceAll("/", "."))) {
                    type = cls.name.replaceAll("/", ".");
                }
                dnode.desc = "(" + Fluid.getDescriptors(types) + ")" + Fluid.getDescriptor(type);
                ind = 0;
                for (Object arg : dnode.bsmArgs) {
                    Handle h;
                    if (arg instanceof Handle && (h = (Handle)arg).getOwner().equals(transformerNode.name)) {
                        dnode.bsmArgs[ind] = new Handle(h.getTag(), cls.name, h.getName(), h.getDesc(), h.isInterface());
                    }
                    ++ind;
                }
            } else if (node instanceof FrameNode) {
                if (((FrameNode)node).stack != null) {
                    int index = 0;
                    for (Object stackEntry : ((FrameNode)node).stack) {
                        if (stackEntry != null && stackEntry.equals(transformerNode.name)) {
                            ((FrameNode)node).stack.set(index, cls.name);
                        }
                        ++index;
                    }
                }
                if (((FrameNode)node).local != null) {
                    int index = 0;
                    for (Object localEntry : ((FrameNode)node).local) {
                        if (localEntry != null && localEntry.equals(transformerNode.name)) {
                            ((FrameNode)node).local.set(index, cls.name);
                        }
                        ++index;
                    }
                }
            } else if (node instanceof TypeInsnNode) {
                tnode = (TypeInsnNode)node;
                ClassNode clsT = null;
                try {
                    clsT = pool.getClassNode(tnode.desc);
                }
                catch (ClassNotFoundException localEntry) {
                    // empty catch block
                }
                if (clsT != null && Transformer.AnnotationInfo.isAnnotationPresent(TargetClass.class, clsT)) {
                    newClName = (String)Transformer.AnnotationInfo.getAnnotation(TargetClass.class, clsT).get("target");
                    tnode.desc = Fluid.mapClass(newClName).replace(".", "/");
                }
            } else if (node instanceof LdcInsnNode) {
                tnode = (LdcInsnNode)node;
                if (tnode.cst instanceof Type) {
                    Type type = (Type)tnode.cst;
                    ClassNode clsT = null;
                    try {
                        clsT = pool.getClassNode(Fluid.parseDescriptor(type.getDescriptor()));
                    }
                    catch (ClassNotFoundException types) {
                        // empty catch block
                    }
                    if (clsT != null && Transformer.AnnotationInfo.isAnnotationPresent(TargetClass.class, clsT)) {
                        String newClName3 = (String)Transformer.AnnotationInfo.getAnnotation(TargetClass.class, clsT).get("target");
                        tnode.cst = Type.getType((String)("L" + Fluid.mapClass(newClName3).replace(".", "/") + ";"));
                    }
                }
            }
            ++nodeInd;
        }
        return self;
    }

    private void processMethod(MethodInsnNode mnode, String clName, FluidClassPool pool, ClassNode targetClass) {
        Transformer.FluidMethodInfo info = Transformer.FluidMethodInfo.create(mnode);
        info.remap(clName, targetClass, info, false, pool);
        String superName = clName;
        if (info.owner != null) {
            superName = info.owner;
        }
        ClassNode clsT = null;
        try {
            clsT = pool.getClassNode(Fluid.mapClass(superName));
        }
        catch (ClassNotFoundException e1) {
            superName = null;
        }
        boolean found = false;
        if (Fluid.getMappings().length == 0) {
            found = true;
        }
        while (!found && superName != null) {
            for (Mapping<?> map : Fluid.getMappings()) {
                for (Mapping<?> mp : map.mappings) {
                    if (!mp.name.equals(superName) || !Stream.of(mp.mappings).anyMatch(t -> t.mappingType == MAPTYPE.METHOD && t.name.equals(info.name) && Arrays.equals(t.argumentTypes, info.types))) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            superName = null;
            if (clsT.superName == null || clsT.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) continue;
            superName = FluidTransformer.getDeobfName(clsT.superName.replaceAll("/", "."));
            try {
                clsT = pool.getClassNode(clsT.superName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
                break;
            }
        }
        if (superName == null) {
            superName = info.owner;
        }
        if (superName == null) {
            superName = clName;
        }
        info.name = Fluid.mapMethod(superName, mnode.name, info.types);
        int index = 0;
        for (int i = 0; i < info.types.length; ++i) {
            info.types[index] = Fluid.mapClass(info.types[index++]);
        }
        info.returnType = Fluid.mapClass(info.returnType);
        info.apply(Fluid.mapClass(superName), mnode);
    }

    private static void processField(FieldInsnNode fnode, String clName, FluidClassPool pool, ClassNode targetClass) {
        FieldNode targetNode;
        String superName = clName;
        ClassNode clsT = null;
        try {
            clsT = pool.getClassNode(Fluid.mapClass(superName));
        }
        catch (ClassNotFoundException e1) {
            superName = null;
        }
        boolean found = false;
        if (Fluid.getMappings().length == 0) {
            found = true;
        }
        while (!found && superName != null) {
            for (Mapping<?> map : Fluid.getMappings()) {
                for (Mapping<?> mp : map.mappings) {
                    if (!mp.name.equals(superName) || !Stream.of(mp.mappings).anyMatch(t -> t.mappingType == MAPTYPE.PROPERTY && t.name.equals(fnode.name))) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            superName = null;
            if (clsT.superName == null || clsT.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) continue;
            superName = FluidTransformer.getDeobfName(clsT.superName.replaceAll("/", "."));
            try {
                clsT = pool.getClassNode(clsT.superName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
                break;
            }
        }
        if (superName == null) {
            superName = clName;
        }
        if (Transformer.AnnotationInfo.isAnnotationPresent(TargetType.class, targetNode = targetClass.fields.stream().filter(t -> t.name.equals(fnode.name)).findFirst().get())) {
            fnode.desc = Fluid.getDescriptor(Fluid.mapClass((String)Transformer.AnnotationInfo.getAnnotation(TargetType.class, targetNode).get("target")));
        }
        fnode.name = Fluid.mapProperty(superName, fnode.name);
        fnode.owner = Fluid.mapClass(superName).replaceAll("\\.", "/");
    }

    private static /* synthetic */ boolean lambda$mapMethodName$11(String mName, String[] types, Mapping t2) {
        return t2.mappingType == MAPTYPE.METHOD && (t2.name.equals(mName) || t2.obfuscated.equals(mName)) && Arrays.equals(t2.argumentTypes, types);
    }

    static {
        for (Field field : Opcodes.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(null);
                OpcodeUseCase useCase = OpcodeUseCase.valueOf(field.getName().toUpperCase(), field.getType().getTypeName());
                HashMap<String, Integer> mp = opcodes.getOrDefault((Object)useCase, new HashMap());
                mp.put(field.getName().toUpperCase(), (Integer)value);
                opcodes.put(useCase, mp);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }
}

