/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.api.transforming.information.metadata;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.Transformer;
import org.asf.cyan.fluid.api.transforming.InjectAt;
import org.asf.cyan.fluid.api.transforming.Reflect;
import org.asf.cyan.fluid.api.transforming.TargetClass;
import org.asf.cyan.fluid.api.transforming.enums.MemberType;
import org.asf.cyan.fluid.api.transforming.information.metadata.MemberMetadata;
import org.asf.cyan.fluid.bytecode.BytecodeExporter;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.implementation.FluidTransformerMetadata;
import org.asf.cyan.fluid.reports.ReportBuilder;
import org.asf.cyan.fluid.reports.ReportCategory;
import org.asf.cyan.fluid.reports.ReportNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class TransformerMetadata {
    private static TransformerMetadata selectedImplementation = new FluidTransformerMetadata();
    private static Logger log = LogManager.getLogger((String)"Fluid");

    public static TransformerMetadata getImplementationInstance() {
        return selectedImplementation;
    }

    protected TransformerMetadata() {
    }

    public abstract String getTransfomerOwner();

    public abstract String getTransfomerClass();

    public abstract String getTargetClass();

    public abstract String getMappedTargetClass();

    public abstract MemberMetadata[] getTransformedFields();

    public abstract MemberMetadata[] getTransformedMethods();

    protected abstract String getImplementationName();

    protected abstract TransformerMetadata getNewInstance();

    protected abstract void storeInstance(TransformerMetadata var1);

    protected abstract boolean validateNewInstane(TransformerMetadata var1);

    protected abstract TransformerMetadata[] internalGetLoadedTransformers();

    protected abstract TransformerMetadata getMetadataByTransformer(String var1);

    protected abstract TransformerMetadata[] getMetadataByObfusTarget(String var1);

    protected abstract TransformerMetadata[] getMetadataByDeobfTarget(String var1);

    protected abstract String toDesc(String var1, String[] var2);

    protected abstract MemberMetadata parseMethod(String var1, String var2, String var3, String var4, String[] var5, String var6, int var7, int var8, boolean var9);

    protected abstract MemberMetadata parseField(String var1, String var2, String var3, String var4, int var5, int var6, boolean var7);

    protected abstract void storeMember(MemberMetadata var1);

    protected abstract String[] parseParams(String var1);

    protected abstract String parseType(String var1);

    protected abstract String mapClass(String var1);

    protected abstract String mapMethod(String var1, String var2, String[] var3);

    protected abstract String mapField(String var1, String var2, String var3);

    protected abstract FluidClassPool getClassPool();

    protected abstract void assignTransformer(TransformerMetadata var1, String var2, String var3, String var4, String var5, FluidClassPool var6);

    protected abstract String[] parseIdentifier(String var1, String var2);

    protected String getTransformerTarget(ClassNode transformer) {
        Transformer.AnnotationInfo anno = Transformer.AnnotationInfo.getAnnotation(TargetClass.class, transformer);
        if (anno != null) {
            return (String)anno.get("target");
        }
        return null;
    }

    public static TransformerMetadata[] getMetadataByTarget(String targetClass) {
        ArrayList<TransformerMetadata> items = new ArrayList<TransformerMetadata>();
        for (TransformerMetadata md : selectedImplementation.getMetadataByObfusTarget(targetClass.replaceAll("/", "."))) {
            if (items.stream().anyMatch(t -> t.getTransfomerClass().equals(md.getTransfomerClass()))) continue;
            items.add(md);
        }
        for (TransformerMetadata md : selectedImplementation.getMetadataByDeobfTarget(targetClass.replaceAll("/", "."))) {
            if (items.stream().anyMatch(t -> t.getTransfomerClass().equals(md.getTransfomerClass()))) continue;
            items.add(md);
        }
        return (TransformerMetadata[])items.toArray(TransformerMetadata[]::new);
    }

    public static TransformerMetadata getMetadataByTransformerClass(String transformer) {
        return selectedImplementation.getMetadataByTransformer(transformer.replaceAll("/", "."));
    }

    public static TransformerMetadata createMetadata(ClassNode transformerNode, String transformerOwner, ArrayList<String> transformedFields, ArrayList<String> transformedMethods, FluidClassPool pool) {
        String memNameInternal;
        String owner;
        String desc;
        String name;
        String[] info;
        TransformerMetadata data = selectedImplementation.getNewInstance();
        String target = selectedImplementation.getTransformerTarget(transformerNode);
        String mappedTarget = selectedImplementation.mapClass(target);
        for (String identifier : transformedMethods) {
            info = selectedImplementation.parseIdentifier(identifier, target);
            name = info[0];
            desc = info[1];
            owner = info[2];
            memNameInternal = info[3];
            String memDesc = "";
            if (memNameInternal.contains("&")) {
                memDesc = memNameInternal.substring(memNameInternal.indexOf("&") + 1);
                memNameInternal = memNameInternal.substring(0, memNameInternal.indexOf("&"));
            }
            int oldModifier = Integer.parseInt(info[4]);
            int newModifier = Integer.parseInt(info[5]);
            boolean isNew = Boolean.parseBoolean(info[6]);
            String[] types = selectedImplementation.parseParams(desc);
            String type = selectedImplementation.parseType(desc);
            MemberMetadata member = data.parseMethod(owner, memNameInternal, name, memDesc, types, type, oldModifier, newModifier, isNew);
            data.storeMember(member);
        }
        for (String identifier : transformedFields) {
            info = selectedImplementation.parseIdentifier(identifier, target);
            name = info[0];
            desc = info[1];
            owner = info[2];
            memNameInternal = info[3];
            int oldModifier = Integer.parseInt(info[4]);
            int newModifier = Integer.parseInt(info[5]);
            boolean isNew = Boolean.parseBoolean(info[6]);
            String type = selectedImplementation.parseType(desc);
            MemberMetadata member = data.parseField(owner, memNameInternal, name, type, oldModifier, newModifier, isNew);
            data.storeMember(member);
        }
        selectedImplementation.assignTransformer(data, transformerNode.name.replaceAll("/", "."), transformerOwner, target, mappedTarget, pool);
        if (!selectedImplementation.validateNewInstane(data)) {
            return null;
        }
        selectedImplementation.storeInstance(data);
        return data;
    }

    public static String toDescriptor(String type, String[] types) {
        return selectedImplementation.toDesc(type, types);
    }

    public static TransformerMetadata[] getLoadedTransformers() {
        return selectedImplementation.internalGetLoadedTransformers();
    }

    public static void createStackTrace(StackTraceElement[] elements, Consumer<String> append, Consumer<String> appendIndented) {
        selectedImplementation.createStackTraceInternal(elements, append, appendIndented);
    }

    /*
     * WARNING - void declaration
     */
    protected void createStackTraceInternal(StackTraceElement[] elements, Consumer<String> append, Consumer<String> appendIndented) {
        void var8_13;
        String tname2;
        Object targetName;
        String name;
        StackTraceElement element;
        void var8_11;
        ArrayList<CallSite> entries = new ArrayList<CallSite>();
        ArrayList<CallSite> entriesSecondary = new ArrayList<CallSite>();
        StackTraceElement[] stackTraceElementArray = elements;
        int n = stackTraceElementArray.length;
        boolean bl = false;
        while (var8_11 < n) {
            element = stackTraceElementArray[var8_11];
            name = element.getClassName();
            for (TransformerMetadata data : TransformerMetadata.getMetadataByTarget(name)) {
                targetName = data.getMappedTargetClass();
                tname2 = data.getTargetClass();
                if (tname2.contains(".")) {
                    tname2 = tname2.substring(tname2.lastIndexOf(".") + 1);
                }
                if (((String)targetName).contains(".")) {
                    targetName = ((String)targetName).substring(((String)targetName).lastIndexOf(".") + 1);
                }
                if (!data.getTargetClass().equals(data.getMappedTargetClass())) {
                    targetName = (String)targetName + " (aka " + tname2 + ")";
                }
                boolean match = false;
                for (MemberMetadata method : data.getTransformedMethods()) {
                    if (!method.getMappedName().equals(element.getMethodName()) && !method.getName().equals(element.getMethodName())) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                entries.add((CallSite)((Object)("[" + data.getTransfomerOwner() + "] " + data.getTransfomerClass() + " -> " + (String)targetName)));
            }
            ++var8_11;
        }
        stackTraceElementArray = elements;
        n = stackTraceElementArray.length;
        boolean bl2 = false;
        while (var8_13 < n) {
            element = stackTraceElementArray[var8_13];
            name = element.getClassName();
            for (TransformerMetadata data : TransformerMetadata.getMetadataByTarget(name)) {
                String entryStr;
                targetName = data.getMappedTargetClass();
                tname2 = data.getTargetClass();
                if (tname2.contains(".")) {
                    tname2 = tname2.substring(tname2.lastIndexOf(".") + 1);
                }
                if (((String)targetName).contains(".")) {
                    targetName = ((String)targetName).substring(((String)targetName).lastIndexOf(".") + 1);
                }
                if (!data.getTargetClass().equals(data.getMappedTargetClass())) {
                    targetName = (String)targetName + " (aka " + tname2 + ")";
                }
                if (entries.contains(entryStr = "[" + data.getTransfomerOwner() + "] " + data.getTransfomerClass() + " -> " + (String)targetName) || entriesSecondary.contains(entryStr)) continue;
                entriesSecondary.add((CallSite)((Object)entryStr));
            }
            ++var8_13;
        }
        if (entries.size() != 0 || entriesSecondary.size() != 0) {
            String trTarget;
            Object trInfo;
            int length = 0;
            for (String string : entries) {
                trInfo = string.substring(0, string.lastIndexOf(" -> "));
                if (((String)trInfo).length() <= length) continue;
                length = ((String)trInfo).length();
            }
            if (entries.size() != 0) {
                append.accept("The following transformers have most likely been called:");
            }
            for (String string : entries) {
                trInfo = string.substring(0, string.lastIndexOf(" -> "));
                trTarget = string.substring(string.lastIndexOf(" -> ") + 4);
                for (int i = ((String)trInfo).length(); i < length; ++i) {
                    trInfo = (String)trInfo + " ";
                }
                appendIndented.accept((String)trInfo + " -> " + trTarget);
            }
            if (entriesSecondary.size() != 0) {
                length = 0;
                for (String string : entriesSecondary) {
                    trInfo = string.substring(0, string.lastIndexOf(" -> "));
                    if (((String)trInfo).length() <= length) continue;
                    length = ((String)trInfo).length();
                }
                if (entries.size() != 0) {
                    append.accept("The following transformers were also present, but might not have been called at all:");
                } else {
                    append.accept("The following transformers were present, but might not have been called at all:");
                }
                for (String string : entriesSecondary) {
                    trInfo = string.substring(0, string.lastIndexOf(" -> "));
                    trTarget = string.substring(string.lastIndexOf(" -> ") + 4);
                    for (int i = ((String)trInfo).length(); i < length; ++i) {
                        trInfo = (String)trInfo + " ";
                    }
                    appendIndented.accept((String)trInfo + " -> " + trTarget);
                }
            }
        }
    }

    public static void dumpErrorBacktrace(String message, StackTraceElement[] elements, File output) throws IOException {
        selectedImplementation.dumpErrorBacktraceInternal(message, elements, output, selectedImplementation.getClassPool());
    }

    public static void dumpBacktraceOnly(File output, Consumer<String> logDebug, Consumer<String> logInfo, Consumer<String> logWarn, BiConsumer<String, Throwable> logError) throws IOException {
        selectedImplementation.dumpBacktraceNoStacktrace(output, selectedImplementation.getClassPool(), false, logDebug, logInfo, logWarn, logError);
    }

    protected synchronized void dumpErrorBacktraceInternal(String message, StackTraceElement[] elements, File output, FluidClassPool pool) throws IOException {
        File metadataDump;
        File classesDump;
        boolean classesNew;
        if (!output.exists()) {
            log.warn("Stack trace received... Dumping transformer backtrace... Message: " + message);
            output.mkdirs();
        }
        boolean bl = classesNew = !(classesDump = new File(output, "classes")).exists();
        if (!classesDump.exists()) {
            classesDump.mkdirs();
        }
        if (!(metadataDump = new File(output, "metadata")).exists()) {
            metadataDump.mkdirs();
        }
        StringBuilder errorReport = new StringBuilder();
        errorReport.append("Message:\n");
        errorReport.append("\t" + message + "\n");
        errorReport.append("Stacktrace:\n");
        for (StackTraceElement element : elements) {
            errorReport.append("\t").append("at ").append(element).append("\n");
        }
        errorReport.append("Transformers:").append("\n");
        TransformerMetadata.createStackTrace(elements, t -> errorReport.append("\t").append((String)t).append("\n"), t -> errorReport.append("\t- ").append((String)t).append("\n"));
        File errorReportFile = new File(output, "stacktrace.log");
        if (!errorReportFile.exists()) {
            Files.writeString(errorReportFile.toPath(), (CharSequence)errorReport.toString(), new OpenOption[0]);
        }
        this.dumpBacktraceNoStacktrace(output, pool, classesNew, str -> log.debug(str), str -> log.warn(str), str -> log.warn(str), (str, e) -> log.error(str, e));
    }

    /*
     * WARNING - void declaration
     */
    public void dumpBacktraceNoStacktrace(File output, FluidClassPool pool, boolean classesNew, Consumer<String> logDebug, Consumer<String> logInfo, Consumer<String> logWarn, BiConsumer<String, Throwable> logError) throws IOException {
        File classesDumpProgramBIN;
        File classesDumpTransformersBIN;
        File classesDumpProgramPC;
        File classesDumpTransformersPC;
        if (!output.exists()) {
            classesNew = true;
            output.mkdirs();
        }
        File classesDump = new File(output, "classes");
        File metadataDump = new File(output, "metadata");
        File loadedTransformers = new File(output, "loaded-transformers.txt");
        if (!loadedTransformers.exists()) {
            Object trInfo;
            void var15_19;
            logInfo.accept("Dumping transformer list...");
            StringBuilder transformerData = new StringBuilder();
            transformerData.append("All loaded transformers:").append("\n");
            ArrayList<CallSite> entries = new ArrayList<CallSite>();
            TransformerMetadata[] transformerMetadataArray = TransformerMetadata.getLoadedTransformers();
            int n = transformerMetadataArray.length;
            boolean bl = false;
            while (var15_19 < n) {
                TransformerMetadata data = transformerMetadataArray[var15_19];
                Object targetName = data.getMappedTargetClass();
                String tname2 = data.getTargetClass();
                if (tname2.contains(".")) {
                    tname2 = tname2.substring(tname2.lastIndexOf(".") + 1);
                }
                if (((String)targetName).contains(".")) {
                    targetName = ((String)targetName).substring(((String)targetName).lastIndexOf(".") + 1);
                }
                if (!data.getTargetClass().equals(data.getMappedTargetClass())) {
                    targetName = (String)targetName + " (aka " + tname2 + ")";
                }
                entries.add((CallSite)((Object)("[" + data.getTransfomerOwner() + "] " + data.getTransfomerClass() + " -> " + (String)targetName)));
                ++var15_19;
            }
            int length = 0;
            for (String string : entries) {
                trInfo = string.substring(0, string.lastIndexOf(" -> "));
                if (((String)trInfo).length() <= length) continue;
                length = ((String)trInfo).length();
            }
            for (String string : entries) {
                trInfo = string.substring(0, string.lastIndexOf(" -> "));
                String trTarget = string.substring(string.lastIndexOf(" -> ") + 4);
                for (int i = ((String)trInfo).length(); i < length; ++i) {
                    trInfo = (String)trInfo + " ";
                }
                transformerData.append("- " + (String)trInfo + " -> " + trTarget).append("\n");
            }
            Files.writeString(loadedTransformers.toPath(), (CharSequence)transformerData.toString(), new OpenOption[0]);
        }
        if (!(classesDumpTransformersPC = new File(classesDump, "transformers/pseudocode")).exists()) {
            classesDumpTransformersPC.mkdirs();
        }
        if (!(classesDumpProgramPC = new File(classesDump, "program/pseudocode")).exists()) {
            classesDumpProgramPC.mkdirs();
        }
        if (!(classesDumpTransformersBIN = new File(classesDump, "transformers/bytecode")).exists()) {
            classesDumpTransformersBIN.mkdirs();
        }
        if (!(classesDumpProgramBIN = new File(classesDump, "program/bytecode")).exists()) {
            classesDumpProgramBIN.mkdirs();
        }
        for (TransformerMetadata md : TransformerMetadata.getLoadedTransformers()) {
            try {
                this.dumpMetadata(md, metadataDump, logDebug);
            }
            catch (IOException | ClassNotFoundException e) {
                logError.accept("Transformer metadata dump failed, transformer: " + md.getTransfomerClass(), e);
            }
        }
        File file = new File(classesDump, "README, VERY IMPORTANT.txt");
        StringBuilder readmeTxt = new StringBuilder();
        readmeTxt.append("COPYTIGHT(c) AUTHORS OF PROGRAM AND AUTHORS OF TRANSFORMERS, DO NOT DISTRIBUTE!").append(System.lineSeparator());
        readmeTxt.append("-------------------------------------------------------------------------------").append(System.lineSeparator());
        readmeTxt.append("").append(System.lineSeparator());
        readmeTxt.append("The PSEUDOCODE and BYTECODE files in this directory and sub-directories are not").append(System.lineSeparator());
        readmeTxt.append("to be distributed, they have been exported directy from the FLUID class pools").append(System.lineSeparator());
        readmeTxt.append("and may ONLY be used for debugging purposes.").append(System.lineSeparator());
        readmeTxt.append("").append(System.lineSeparator());
        readmeTxt.append("You have the permission to transfer a copy of the files to the author of the").append(System.lineSeparator());
        readmeTxt.append("transformers so they can fix the crash, the files may not be used for anything").append(System.lineSeparator());
        readmeTxt.append("other than debugging purposes and must be destroyed afterwards.").append(System.lineSeparator());
        if (!file.exists()) {
            logDebug.accept("Creating readme file for backtrace...");
        }
        Files.writeString(file.toPath(), (CharSequence)readmeTxt.toString(), new OpenOption[0]);
        if (classesNew) {
            logInfo.accept("Dumping transformer classes...");
            for (TransformerMetadata md : TransformerMetadata.getLoadedTransformers()) {
                try {
                    File trPseudoCode = new File(classesDumpTransformersPC, md.getTransfomerOwner().replace(":", ".") + "/" + md.getTransfomerClass() + ".pc.java");
                    File trClassFile = new File(classesDumpTransformersBIN, md.getTransfomerOwner().replace(":", ".") + "/" + md.getTransfomerClass().replace(".", "/") + ".class");
                    if (trPseudoCode.exists()) continue;
                    trPseudoCode.getParentFile().mkdirs();
                    trClassFile.getParentFile().mkdirs();
                    logDebug.accept("Dumping transformer " + md.getTransfomerClass() + " PseudoCode...");
                    Files.write(trPseudoCode.toPath(), BytecodeExporter.classToString(pool.getClassNode(md.getTransfomerClass())).getBytes(), new OpenOption[0]);
                    logDebug.accept("Dumping transformer " + md.getTransfomerClass() + " bytecode class file...");
                    Files.write(trClassFile.toPath(), pool.getByteCode(md.getTransfomerClass()), new OpenOption[0]);
                }
                catch (IOException | ClassNotFoundException e) {
                    log.error("Transformer class dump failed, transformer: " + md.getTransfomerClass(), (Throwable)e);
                }
            }
            logInfo.accept("Dumping program class files...");
            for (TransformerMetadata md : TransformerMetadata.getLoadedTransformers()) {
                try {
                    File clPseudoCode = new File(classesDumpProgramPC, md.getTargetClass().replace(".", "/") + ".pc.java");
                    File clClassFile = new File(classesDumpProgramBIN, md.getTargetClass().replace(".", "/") + ".class");
                    if (clPseudoCode.exists()) continue;
                    clPseudoCode.getParentFile().mkdirs();
                    clClassFile.getParentFile().mkdirs();
                    logDebug.accept("Dumping class " + md.getTargetClass() + " PseudoCode...");
                    ClassNode targetClass = null;
                    try {
                        targetClass = pool.getClassNode(md.getMappedTargetClass());
                    }
                    catch (ClassNotFoundException e) {
                        targetClass = pool.getClassNode(md.getTargetClass());
                    }
                    Files.write(clPseudoCode.toPath(), BytecodeExporter.classToString(targetClass).getBytes(), new OpenOption[0]);
                    logDebug.accept("Dumping class " + md.getTargetClass() + " bytecode class file...");
                    Files.write(clClassFile.toPath(), pool.getByteCode(targetClass.name), new OpenOption[0]);
                }
                catch (IOException | ClassNotFoundException e) {
                    logError.accept("Transformer class dump failed, transformer: " + md.getTargetClass(), e);
                }
            }
        }
    }

    protected synchronized void dumpMetadata(TransformerMetadata metadata, File output, Consumer<String> logDebug) throws IOException, ClassNotFoundException {
        File summaryFile;
        File transformerDir = new File(output, metadata.getTransfomerOwner().replace(":", ".") + "/" + metadata.getTransfomerClass());
        if (!transformerDir.exists()) {
            transformerDir.mkdirs();
        }
        if (!(summaryFile = new File(output, metadata.getTransfomerClass() + ".tmd.txt")).exists()) {
            logDebug.accept("Dumping transformer summary metadata file... Transformer: " + metadata.getTransfomerClass());
            Files.writeString(summaryFile.toPath(), (CharSequence)selectedImplementation.buildSummary(metadata), new OpenOption[0]);
            logDebug.accept("Dumped transformer summary.");
        }
        ClassNode transformer = metadata.getClassPool().getClassNode(metadata.getTransfomerClass());
        ClassNode targetClass = null;
        try {
            targetClass = metadata.getClassPool().getClassNode(metadata.getMappedTargetClass());
        }
        catch (ClassNotFoundException e) {
            targetClass = metadata.getClassPool().getClassNode(metadata.getTargetClass());
        }
        this.dumpTransformerFieldInfo(metadata, new File(transformerDir, "fields"), transformer, targetClass);
        this.dumpTransformerMethodInfo(metadata, new File(transformerDir, "methods"), transformer, targetClass);
        File summaryFile2 = new File(transformerDir, metadata.getTransfomerClass() + ".tmd.txt");
        if (!summaryFile2.exists()) {
            logDebug.accept("Dumping transformer summary metadata file... Transformer: " + metadata.getTransfomerClass());
            Files.writeString(summaryFile2.toPath(), (CharSequence)selectedImplementation.buildSummary(metadata), new OpenOption[0]);
            logDebug.accept("Dumped transformer summary.");
        }
    }

    protected void dumpTransformerFieldInfo(TransformerMetadata metadata, File output, ClassNode transformer, ClassNode targetClass) throws IOException {
        if (output.exists()) {
            return;
        }
        log.debug("Dumping transformer field metadata... Transformer: " + metadata.getTransfomerClass());
        output.mkdirs();
        for (MemberMetadata fieldData : metadata.getTransformedFields()) {
            File fieldOut = new File(output, fieldData.getTransformerMemberName() + ".tmd.txt");
            ReportBuilder builder = ReportBuilder.create("Tansformer Metadata Format 1.0,\nthe following details are for a field named " + fieldData.getTransformerMemberName() + ".");
            String fieldModOld = Modifier.toString(fieldData.getOldModifier()).replaceAll(" ", ", ");
            String fieldModNew = Modifier.toString(fieldData.getNewModifier()).replaceAll(" ", ", ");
            FieldNode trFieldNode = transformer.fields.stream().filter(t -> t.name.equals(fieldData.getTransformerMemberName())).findFirst().get();
            String transformMethod = "reflecting field (in-transformer usage)";
            if (!fieldModOld.equals(fieldModNew)) {
                transformMethod = "access transformer (changes field access)";
            }
            if (fieldData.isNew()) {
                transformMethod = "appending field (new field)";
            }
            ReportCategory basicInfo = builder.newCategory("Basic information");
            builder.newNode(basicInfo, "Details").addAll("Field name", fieldData.getTransformerMemberName(), "In-transformer modifiers", Modifier.toString(trFieldNode.access).replaceAll(" ", ", "), "Transform method", transformMethod);
            ReportNode nd = builder.newNode(basicInfo, "Target information").addAll("Target name", fieldData.getName(), "Target type", fieldData.getType(), "Target name (mapped)", fieldData.getMappedName(), "Target type (mapped)", fieldData.getMappedType(), "Target modifiers", fieldModOld);
            if (!fieldModOld.equals(fieldModNew)) {
                nd.add("New target modifiers", fieldModNew);
            }
            StringBuilder strBuilder = new StringBuilder();
            builder.build(strBuilder);
            Files.writeString(fieldOut.toPath(), (CharSequence)strBuilder.toString(), new OpenOption[0]);
        }
        log.debug("Dumped transformer metadata.");
    }

    protected void dumpTransformerMethodInfo(TransformerMetadata metadata, File output, ClassNode transformer, ClassNode targetClass) throws IOException {
        if (output.exists()) {
            return;
        }
        log.debug("Dumping transformer method metadata... Transformer: " + metadata.getTransfomerClass());
        output.mkdirs();
        for (MemberMetadata methodData : metadata.getTransformedMethods()) {
            File methodOutput = new File(output, methodData.getTransformerMemberName() + ".tmd.txt");
            ReportBuilder builder = ReportBuilder.create("Tansformer Metadata Format 1.0,\nthe following details are for a method named " + methodData.getTransformerMemberName() + ".");
            String mthModOld = Modifier.toString(methodData.getOldModifier()).replaceAll(" ", ", ");
            String mthModNew = Modifier.toString(methodData.getNewModifier()).replaceAll(" ", ", ");
            Optional<MethodNode> nodeOpt = transformer.methods.stream().filter(t -> t.name.equals(methodData.getTransformerMemberName()) && t.desc.equals(methodData.toTransformerDescriptor())).findFirst();
            MethodNode trMthNode = nodeOpt.get();
            String transformMethod = "unrecognized";
            if (methodData.isNew()) {
                transformMethod = "appending method (new method)";
            } else if (Transformer.AnnotationInfo.isAnnotationPresent(InjectAt.class, trMthNode)) {
                transformMethod = "injecting method (modifies methods)";
            } else if (Transformer.AnnotationInfo.isAnnotationPresent(Reflect.class, trMthNode) || Modifier.isAbstract(trMthNode.access) && !Modifier.isInterface(transformer.access)) {
                transformMethod = "reflecting method (in-transformer usage)";
            } else if (mthModOld.equals(mthModNew)) {
                transformMethod = "access transformer (changes method access)";
            }
            ReportCategory basicInfo = builder.newCategory("Basic information");
            ReportNode details = builder.newNode(basicInfo, "Details").addAll("Method name", methodData.getTransformerMemberName(), "In-transformer modifiers", Modifier.toString(trMthNode.access).replaceAll(" ", ", "), "Transform method", transformMethod, "Transformer return type", methodData.getType());
            Transformer.FluidMethodInfo mInfo = Transformer.FluidMethodInfo.create(trMthNode);
            if (Transformer.AnnotationInfo.isAnnotationPresent(InjectAt.class, trMthNode)) {
                ReportNode target = builder.newNode(basicInfo, "Inject target metadata");
                Transformer.AnnotationInfo info = Transformer.AnnotationInfo.getAnnotation(InjectAt.class, trMthNode);
                target.add("Inject location", info.values.get("location"));
                if (info.values.containsKey("targetCall")) {
                    target.add("Target call", info.values.get("targetCall"));
                }
                if (info.values.containsKey("targetOwner")) {
                    target.add("Target owner", info.values.get("targetOwner"));
                }
                if (info.values.containsKey("offset")) {
                    target.add("Inject offset", info.values.get("offset"));
                }
            }
            details.add("Parameter count", Integer.valueOf(mInfo.types.length));
            if (mInfo.types.length != 0) {
                ReportNode params = builder.newNode(basicInfo, "Transformer parameters");
                int offset = Modifier.isStatic(trMthNode.access) ? 0 : 1;
                for (int i = 0; i < mInfo.types.length; ++i) {
                    String type = mInfo.types[i];
                    Object name = "var" + i;
                    if (trMthNode.localVariables != null && trMthNode.localVariables.size() > offset + i) {
                        name = ((LocalVariableNode)trMthNode.localVariables.get((int)(offset + i))).name;
                    }
                    for (Transformer.AnnotationInfo anno : Transformer.FluidMethodInfo.getParameterAnnotations(trMthNode, i)) {
                        if (!anno.name.equals("org.asf.cyan.fluid.api.transforming.LocalVariable")) continue;
                        name = (String)name + " (local variable reference)";
                    }
                    params.add((String)name, type);
                }
            }
            if (trMthNode.localVariables != null && trMthNode.localVariables.size() != 0) {
                details.add("Local variable count", Integer.valueOf(trMthNode.localVariables.size()));
                ReportNode vars = builder.newNode(basicInfo, "Transformer local variables");
                int index = 0;
                int offset = Modifier.isStatic(trMthNode.access) ? 0 : 1;
                for (LocalVariableNode var : trMthNode.localVariables) {
                    if (offset + mInfo.types.length <= index) {
                        String type = Fluid.parseDescriptor(var.desc);
                        vars.add(var.name, "type: " + type + ", index: " + var.index);
                    }
                    ++index;
                }
            }
            if (trMthNode.instructions != null && !Modifier.isAbstract(trMthNode.access)) {
                details.add("Instruction count", Integer.valueOf(trMthNode.instructions.size()));
            }
            ReportNode nd = builder.newNode(basicInfo, "Target information").addAll("Target name", methodData.getName(), "Target type", methodData.getType(), "Target name (mapped)", methodData.getMappedName(), "Target type (mapped)", methodData.getMappedType(), "Target descriptor", methodData.toDescriptor(), "Target descriptor (mapped)", methodData.toMappedDescriptor(), "Target modifiers", mthModOld);
            if (!mthModOld.equals(mthModNew)) {
                nd.add("New target modifiers", mthModNew);
            }
            StringBuilder strBuilder = new StringBuilder();
            builder.build(strBuilder);
            Files.writeString(methodOutput.toPath(), (CharSequence)strBuilder.toString(), new OpenOption[0]);
        }
        log.debug("Dumped transformer metadata.");
    }

    protected String buildSummary(TransformerMetadata metadata) {
        StringBuilder summary = new StringBuilder();
        String simpleName = metadata.getTransfomerClass();
        if (simpleName.contains(".")) {
            simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        ReportBuilder builder = ReportBuilder.create("Tansformer Metadata Format 1.0,\nthe following details are for the " + simpleName + " transformer.");
        ReportCategory basicInfo = builder.newCategory("Basic information");
        builder.newNode(basicInfo, "Details").addAll("Simple name", simpleName, "Fully qualified name", metadata.getTransfomerClass(), "Target class", metadata.getTargetClass(), "Mapped target class", metadata.getMappedTargetClass(), "Field count", metadata.getTransformedFields().length, "Method count", metadata.getTransformedMethods().length);
        ReportCategory trInfo = builder.newCategory("Transformer information");
        ArrayList<String> methods = new ArrayList<String>();
        int longestMethType = 0;
        for (MemberMetadata method : metadata.getTransformedMethods()) {
            if (method.getType().length() <= longestMethType) continue;
            longestMethType = method.getType().length();
        }
        for (MemberMetadata method : metadata.getTransformedMethods()) {
            StringBuilder methodBuilder = new StringBuilder();
            methodBuilder.append(method.getType().substring(0, 1).toUpperCase());
            methodBuilder.append(method.getType().substring(1));
            for (int i = method.getType().length(); i < longestMethType; ++i) {
                methodBuilder.append(" ");
            }
            methodBuilder.append("  ");
            methodBuilder.append(method.getTransformerMemberName());
            methodBuilder.append("(");
            boolean first = true;
            for (String type : method.getTypes()) {
                if (!first) {
                    methodBuilder.append(", ");
                }
                methodBuilder.append(type);
                first = false;
            }
            methodBuilder.append(")");
            methods.add(methodBuilder.toString());
            methodBuilder = new StringBuilder();
            methodBuilder.append(method.getMappedName());
            if (!method.getName().equals(method.getMappedName())) {
                methodBuilder.append(" (aka ");
                methodBuilder.append(method.getName());
                methodBuilder.append(")");
            }
            methods.add(methodBuilder.toString());
        }
        builder.newNode(trInfo, "Method transformers").addAll(methods.toArray());
        ArrayList<String> fields = new ArrayList<String>();
        int longestFieldType = 0;
        for (MemberMetadata field : metadata.getTransformedFields()) {
            if (field.getType().length() <= longestFieldType) continue;
            longestFieldType = field.getType().length();
        }
        for (MemberMetadata field : metadata.getTransformedFields()) {
            StringBuilder fieldBuilder = new StringBuilder();
            fieldBuilder.append(field.getType().substring(0, 1).toUpperCase());
            fieldBuilder.append(field.getType().substring(1));
            for (int i = field.getType().length(); i < longestFieldType; ++i) {
                fieldBuilder.append(" ");
            }
            fieldBuilder.append("  ");
            fieldBuilder.append(field.getTransformerMemberName());
            fields.add(fieldBuilder.toString());
            fieldBuilder = new StringBuilder();
            fieldBuilder.append(field.getMappedName());
            if (!field.getName().equals(field.getMappedName())) {
                fieldBuilder.append(" (aka ");
                fieldBuilder.append(field.getName());
                fieldBuilder.append(")");
            }
            fields.add(fieldBuilder.toString());
        }
        builder.newNode(trInfo, "Field transformers").addAll(fields.toArray());
        builder.build(summary);
        return summary.toString();
    }

    protected static void setImplementation(TransformerMetadata implementation) {
        log.debug("Assigning FLUID Transformer Metadata Implementation... Using the " + implementation.getImplementationName() + " Implementation...");
        selectedImplementation = implementation;
    }

    protected MemberMetadata constructMetadata() {
        return new MemberMetadata();
    }

    protected MemberMetadata assignMetadataValues(MemberMetadata data, MemberType memberType, String owner, String transformerMemberName, String name, String desc, String type, String[] params, int oldModifier, int newModifier, boolean isNew) {
        data.assign(memberType, transformerMemberName, owner, name, desc, type, params, oldModifier, newModifier, isNew);
        return data;
    }
}

