/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.modules.eventbus.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventListener;
import org.asf.edge.modules.eventbus.EventObject;
import org.asf.edge.modules.eventbus.EventPath;
import org.asf.edge.modules.eventbus.IEventReceiver;

public class EventBusImpl
extends EventBus {
    private EventBus parent;
    private HashMap<String, ArrayList<Consumer<?>>> listeners = new HashMap();
    private Logger eventLog = LogManager.getLogger((String)"EVENTBUS");
    private ArrayList<IEventReceiver> boundReceivers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllEventsFromReceiver(IEventReceiver receiver) {
        if (this.boundReceivers.contains(receiver)) {
            return;
        }
        this.boundReceivers.add(receiver);
        this.eventLog.info("Registering all events in " + receiver.getClass().getTypeName() + "...");
        for (Method meth : receiver.getClass().getMethods()) {
            ArrayList<Consumer<?>> events;
            Class<?> eventType;
            if (!meth.isAnnotationPresent(EventListener.class) || !Modifier.isPublic(meth.getModifiers()) || Modifier.isAbstract(meth.getModifiers()) || meth.getParameterCount() != 1 || !EventObject.class.isAssignableFrom(meth.getParameterTypes()[0]) || !(eventType = meth.getParameterTypes()[0]).isAnnotationPresent(EventPath.class)) continue;
            EventPath info = eventType.getAnnotation(EventPath.class);
            meth.setAccessible(true);
            String path = info.value();
            if (!this.listeners.containsKey(path)) {
                HashMap<String, ArrayList<Consumer<?>>> hashMap = this.listeners;
                synchronized (hashMap) {
                    if (!this.listeners.containsKey(path)) {
                        this.listeners.put(path, new ArrayList());
                    }
                }
            }
            ArrayList<Consumer<?>> arrayList = events = this.listeners.get(path);
            synchronized (arrayList) {
                events.add(t -> {
                    try {
                        meth.invoke((Object)receiver, t);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventObject> void addEventHandler(Class<T> eventClass, Consumer<T> eventHandler) {
        ArrayList<Consumer<?>> events;
        EventPath info = eventClass.getAnnotation(EventPath.class);
        String path = info.value();
        if (!this.listeners.containsKey(path)) {
            HashMap<String, ArrayList<Consumer<?>>> hashMap = this.listeners;
            synchronized (hashMap) {
                if (!this.listeners.containsKey(path)) {
                    this.listeners.put(path, new ArrayList());
                }
            }
        }
        ArrayList<Consumer<?>> arrayList = events = this.listeners.get(path);
        synchronized (arrayList) {
            events.add(eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventObject> void removeEventHandler(Class<T> eventClass, Consumer<T> eventHandler) {
        ArrayList<Consumer<?>> events;
        EventPath info = eventClass.getAnnotation(EventPath.class);
        String path = info.value();
        if (!this.listeners.containsKey(path)) {
            return;
        }
        ArrayList<Consumer<?>> arrayList = events = this.listeners.get(path);
        synchronized (arrayList) {
            events.remove(eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatchEvent(EventObject event) {
        Consumer[] events;
        if (this.parent != null) {
            this.parent.dispatchEvent(event);
        }
        if (!this.listeners.containsKey(event.eventPath())) return;
        Consumer[] consumerArray = events = this.listeners.get(event.eventPath());
        synchronized (events) {
            Consumer[] evs = (Consumer[])events.toArray(Consumer[]::new);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (Consumer ev : evs) {
                ev.accept(event);
            }
            return;
        }
    }

    @Override
    public EventBus createBus() {
        EventBusImpl ev = new EventBusImpl();
        ev.parent = this;
        return ev;
    }
}

