/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.commondata.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.commondata.impl.db.DatabaseCommonDataManager;
import org.asf.edge.common.services.commondata.impl.db.DatabaseRequest;
import org.postgresql.util.PGobject;

public class PostgresDatabaseCommonDataManager
extends DatabaseCommonDataManager {
    private String url;
    private Properties props;
    private Logger logger = LogManager.getLogger((String)"CommonDataManager");

    @Override
    public void initService() {
    }

    @Override
    public void loadManager() {
        File configFile = new File("commondata.json");
        JsonObject commonDataManagerConfig = new JsonObject();
        if (configFile.exists()) {
            try {
                commonDataManagerConfig = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException e) {
                this.logger.error("Failed to load common data manager configuration!", e);
                return;
            }
        }
        JsonObject databaseManagerConfig = new JsonObject();
        if (!commonDataManagerConfig.has("postgreSQL")) {
            databaseManagerConfig.addProperty("url", "jdbc:postgresql://localhost/edge");
            JsonObject props = new JsonObject();
            props.addProperty("user", "edge");
            props.addProperty("password", "edgesodserver");
            databaseManagerConfig.add("properties", (JsonElement)props);
            commonDataManagerConfig.add("postgreSQL", (JsonElement)databaseManagerConfig);
            try {
                Files.writeString(configFile.toPath(), (CharSequence)new Gson().newBuilder().setPrettyPrinting().create().toJson((JsonElement)commonDataManagerConfig), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.error("Failed to write the common data manager configuration!", (Throwable)e);
                return;
            }
        } else {
            databaseManagerConfig = commonDataManagerConfig.get("postgreSQL").getAsJsonObject();
        }
        this.url = databaseManagerConfig.get("url").getAsString();
        JsonObject properties = databaseManagerConfig.get("properties").getAsJsonObject();
        this.props = new Properties();
        for (String key : properties.keySet()) {
            this.props.setProperty(key, properties.get(key).getAsString());
        }
        try {
            Class.forName("org.postgresql.Driver");
            DriverManager.getConnection(this.url, this.props).close();
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.error("Failed to connect to database!", (Throwable)e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupContainer(String rootNodeName) {
        try (Connection conn = DriverManager.getConnection(this.url, this.props);){
            Statement statement = conn.createStatement();
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS CDC2_" + rootNodeName + " (DATAKEY varchar(64), PARENT varchar(64), PARENTCONTAINER varchar(256), DATA JSONB)");
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to prepare data container '" + rootNodeName + "'", (Throwable)e);
        }
    }

    @Override
    public DatabaseRequest createRequest() throws SQLException {
        final Connection conn = DriverManager.getConnection(this.url, this.props);
        return new DatabaseRequest(){

            @Override
            public void setDataObject(int i, String obj, PreparedStatement st) throws SQLException {
                PGobject o = new PGobject();
                o.setType("jsonb");
                o.setValue(obj);
                st.setObject(i, o);
            }

            @Override
            public PreparedStatement createPreparedStatement(String query) throws SQLException {
                return conn.prepareStatement(query);
            }

            @Override
            public void finish() throws SQLException {
                conn.close();
            }
        };
    }
}

