/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.events.accounts.AccountManagerLoadEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.impl.BasicAccountObject;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public abstract class BasicAccountManager
extends AccountManager {
    protected Logger logger = LogManager.getLogger((String)"AccountManager");
    private static SecureRandom rnd = new SecureRandom();
    private HashMap<String, AccountCache> cache = new HashMap();
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepInMemory(AccountObject acc, boolean addIfNeeded) {
        HashMap<String, AccountCache> hashMap = this.cache;
        synchronized (hashMap) {
            if (this.cache.containsKey(acc.getAccountID())) {
                this.cache.get((Object)acc.getAccountID()).lastUpdate = System.currentTimeMillis();
            } else if (addIfNeeded) {
                AccountCache c = new AccountCache();
                c.lastUpdate = System.currentTimeMillis();
                c.account = acc;
                this.cache.put(acc.getAccountID(), c);
                try {
                    AccountDataContainer cont = acc.getAccountData().getChildContainer("accountdata");
                    if (!cont.entryExists("server_id") || !cont.getEntry("server_id").getAsString().equals(CommonInit.getServerID())) {
                        cont.setEntry("server_id", (JsonElement)new JsonPrimitive(CommonInit.getServerID()));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected abstract void managerLoaded();

    protected abstract boolean isLoginNameInUse(String var1);

    protected abstract boolean isVikingNameInUse(String var1);

    protected abstract AccountObject getAccountByID(String var1, boolean var2);

    protected abstract byte[] getPasswordCheckData(String var1);

    public abstract BasicAccountObject registerGuest(String var1, String var2);

    public abstract BasicAccountObject registerAccount(String var1, String var2, String var3, byte[] var4);

    @Override
    public boolean isUsernameTaken(String username) {
        if (this.isLoginNameInUse(username)) {
            return true;
        }
        return this.isVikingNameInUse(username);
    }

    @Override
    public AccountObject getAccount(String id) {
        while (true) {
            try {
                if (this.cache.containsKey(id)) {
                    return this.cache.get((Object)id).account;
                }
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                continue;
            }
            break;
        }
        return this.getAccountByID(id, false);
    }

    @Override
    public AccountObject getGuestAccount(String guestID) {
        return this.getAccountByID(guestID, true);
    }

    @Override
    public void loadManager() {
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                AccountCache[] accountCacheArray = this.cache;
                // MONITORENTER : this.cache
                AccountCache[] cached = (AccountCache[])this.cache.values().toArray(AccountCache[]::new);
                // MONITOREXIT : accountCacheArray
                for (AccountCache obj : cached) {
                    if (System.currentTimeMillis() - obj.lastUpdate <= 180000L) continue;
                    this.cache.remove(obj.account.getAccountID());
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        this.managerLoaded();
        EventBus.getInstance().dispatchEvent((EventObject)new AccountManagerLoadEvent(this));
    }

    @Override
    public boolean isValidUsername(String username) {
        return !username.replace(" ", "").equals("") && username.length() >= 2 && username.length() <= 100 && username.matches("^[A-Za-z].*$") && username.matches("^[A-Za-z0-9@._# ]+$");
    }

    @Override
    public boolean isValidPassword(String password) {
        return password.replaceAll("[^A-Za-z0-9]", "").length() >= 6;
    }

    @Override
    public boolean verifyPassword(String id, String password) {
        byte[] passwordCheckData = this.getPasswordCheckData(id);
        if (passwordCheckData == null) {
            return false;
        }
        byte[] salt = Arrays.copyOfRange(passwordCheckData, 0, 32);
        byte[] hash = Arrays.copyOfRange(passwordCheckData, 32, 48);
        byte[] current = BasicAccountManager.getHash(salt, password.toCharArray());
        for (int i = 0; i < hash.length; ++i) {
            if (hash[i] == current[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TokenParseResult verifyToken(String token) {
        this.keyInit();
        try {
            String verifyD = token.split("\\.")[0] + "." + token.split("\\.")[1];
            String sig = token.split("\\.")[2];
            if (!SessionToken.verify(verifyD.getBytes("UTF-8"), Base64.getUrlDecoder().decode(sig), this.publicKey)) {
                return TokenParseResult.INVALID_DATA;
            }
            return TokenParseResult.SUCCESS;
        }
        catch (Exception e) {
            return TokenParseResult.INVALID_DATA;
        }
    }

    @Override
    public byte[] signToken(String token) {
        this.keyInit();
        try {
            return SessionToken.sign(token.getBytes("UTF-8"), this.privateKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AccountObject registerGuestAccount(String guestID) {
        if (this.getGuestAccount(guestID) != null) {
            return null;
        }
        String id = UUID.randomUUID().toString();
        while (this.accountExists(id)) {
            id = UUID.randomUUID().toString();
        }
        BasicAccountObject obj = this.registerGuest(id, guestID);
        if (obj == null) {
            return null;
        }
        try {
            AccountDataContainer settings = ((AccountObject)obj).getAccountData().getChildContainer("accountdata");
            settings.setEntry("lastlogintime", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            settings.setEntry("registrationtimestamp", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            settings.setEntry("isguestaccount", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            settings.setEntry("ismultiplayerenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            settings.setEntry("ischatenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            settings.setEntry("isstrictchatfilterenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to update account settings of ID '" + id + "'", (Throwable)e);
            return null;
        }
        return obj;
    }

    @Override
    public AccountObject registerAccount(String username, String email, char[] password) {
        int i;
        if (!this.isValidUsername(username)) {
            return null;
        }
        if (this.isUsernameTaken(username)) {
            return null;
        }
        if (!this.isValidPassword(new String(password))) {
            return null;
        }
        if (this.getAccountIDByEmail(email) != null) {
            return null;
        }
        String id = UUID.randomUUID().toString();
        while (this.accountExists(id)) {
            id = UUID.randomUUID().toString();
        }
        byte[] salt = BasicAccountManager.salt();
        byte[] hash = BasicAccountManager.getHash(salt, password);
        byte[] cred = new byte[48];
        for (i = 0; i < 32; ++i) {
            cred[i] = salt[i];
        }
        for (i = 32; i < 48; ++i) {
            cred[i] = hash[i - 32];
        }
        BasicAccountObject obj = this.registerAccount(id, email, username, cred);
        if (obj == null) {
            return null;
        }
        try {
            AccountDataContainer settings = ((AccountObject)obj).getAccountData().getChildContainer("accountdata");
            settings.setEntry("lastlogintime", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            settings.setEntry("registrationtimestamp", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            settings.setEntry("isguestaccount", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            settings.setEntry("ismultiplayerenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            settings.setEntry("ischatenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            settings.setEntry("isstrictchatfilterenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to update account settings of ID '" + id + "'", (Throwable)e);
            return null;
        }
        return obj;
    }

    public byte[] createCredBytesWithPassword(char[] password) {
        int i;
        byte[] salt = BasicAccountManager.salt();
        byte[] hash = BasicAccountManager.getHash(salt, password);
        byte[] cred = new byte[48];
        for (i = 0; i < 32; ++i) {
            cred[i] = salt[i];
        }
        for (i = 32; i < 48; ++i) {
            cred[i] = hash[i - 32];
        }
        return cred;
    }

    private static byte[] salt() {
        byte[] salt = new byte[32];
        rnd.nextBytes(salt);
        return salt;
    }

    private static byte[] getHash(byte[] salt, char[] password) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 128);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            return factory.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return null;
        }
    }

    private void keyInit() {
        if (this.publicKey == null || this.privateKey == null) {
            try {
                File publicKey = new File("publickey.pem");
                File privateKey = new File("privatekey.pem");
                if (!publicKey.exists() || !privateKey.exists()) {
                    KeyPair pair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
                    Files.writeString(publicKey.toPath(), (CharSequence)SessionToken.pemEncode(pair.getPublic().getEncoded(), "PUBLIC"), new OpenOption[0]);
                    Files.writeString(privateKey.toPath(), (CharSequence)SessionToken.pemEncode(pair.getPrivate().getEncoded(), "PRIVATE"), new OpenOption[0]);
                }
                KeyFactory fac = KeyFactory.getInstance("RSA");
                this.privateKey = fac.generatePrivate(new PKCS8EncodedKeySpec(SessionToken.pemDecode(Files.readString(privateKey.toPath()))));
                this.publicKey = fac.generatePublic(new X509EncodedKeySpec(SessionToken.pemDecode(Files.readString(publicKey.toPath()))));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String[] getOnlinePlayerIDs() {
        while (true) {
            try {
                return (String[])this.cache.keySet().toArray(String[]::new);
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                continue;
            }
            break;
        }
    }

    public boolean isOnline(String accountID) {
        while (true) {
            try {
                return this.cache.containsKey(accountID);
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                continue;
            }
            break;
        }
    }

    private class AccountCache {
        public long lastUpdate;
        public AccountObject account;

        private AccountCache() {
        }
    }
}

