/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.entities.items;

public class ItemSaleInfo {
    private String name;
    private long startTime;
    private long endTime;
    private float modifier;
    private int[] categories;
    private int[] itemIds;
    private boolean memberOnly;

    public ItemSaleInfo(String name, long startTime, long endTime, float modifier, int[] categories, int[] itemIds, boolean memberOnly) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.modifier = modifier;
        this.categories = categories;
        this.itemIds = itemIds;
        this.memberOnly = memberOnly;
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public float getSaleModifier() {
        return this.modifier;
    }

    public int[] getCategories() {
        if (this.categories == null) {
            return new int[0];
        }
        return this.categories;
    }

    public int[] getItemIDs() {
        if (this.itemIds == null) {
            return new int[0];
        }
        return this.itemIds;
    }

    public boolean isMemberOnly() {
        return this.memberOnly;
    }

    public boolean isActive() {
        return System.currentTimeMillis() >= this.startTime && System.currentTimeMillis() < this.endTime;
    }

    public boolean isUpcoming() {
        return System.currentTimeMillis() < this.startTime && System.currentTimeMillis() < this.endTime;
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() >= this.endTime;
    }
}

