/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.contentserver.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.stream.Stream;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;
import org.asf.edge.common.util.TripleDesUtil;
import org.asf.edge.common.xmls.items.edgespecific.ItemRegistryManifest;
import org.asf.edge.contentserver.xmls.AssetVersionManifestData;
import org.asf.edge.contentserver.xmls.LoadScreenData;
import org.asf.edge.contentserver.xmls.ProductConfigData;

public class EdgeContentServerDumper {
    private static String[] tdEncryptedFiles = new String[]{"DWADragonsMain.xml"};
    private static String[] retainFiles = new String[0];
    private static boolean dryRun = false;
    private static ArrayList<String> assetsToDownload = new ArrayList();
    private static String versionSecretFile = "\n#\n# This file defines the secret used to encrypt the manifest sent to the client\n# Its version-specific likely, for %ver% its %secret%\n#\n\nxmlsecret=%secret%";

    public static void main(String[] args) throws IOException {
        QuestionListData[] questions;
        File serverDown;
        if (args.length < 7) {
            System.err.println("Missing arguments: \"<server>\" \"<version>\" \"<platform>\" \"<key>\" \"<output>\" \"<new-server-url>\" <overwrite true/false> [<dry run true/false>] [\"<file name to retain>\" ...]");
            System.err.println("Example arguments: \"http://media.jumpstart.com/\" \"3.31.0\" \"WIN\" \"C92EC1AA-54CD-4D0C-A8D5-403FCCF1C0BD\" \"asset-archive\" \"https://example.com/sod-archive/\" false false");
            System.err.println("");
            System.err.println("The server url can be found in the client's resources.assets, the url before 'DWADragonsMain_SodStaging' is where the DWADragonsMain.xml file is pulled from.");
            System.err.println("The UUID after 'DWADragonsMain_SodStaging' is the secret used to decrypt the xmls.");
            System.err.println("");
            System.err.println("Make sure to remove 'DWADragonsUnity' from the server URL as else asset resolution will fail!");
            System.exit(1);
        }
        if (!args[0].endsWith("/")) {
            args[0] = args[0] + "/";
        }
        if (!args[5].endsWith("/")) {
            args[5] = args[5] + "/";
        }
        if (args.length >= 8) {
            dryRun = args[7].equalsIgnoreCase("true");
        }
        retainFiles = new String[args.length - 8];
        for (int i = 8; i < args.length; ++i) {
            EdgeContentServerDumper.retainFiles[i - 8] = args[i];
        }
        if (!dryRun) {
            System.out.println("Creating output...");
        }
        File output = new File(args[4], "DWADragonsUnity/" + args[2] + "/" + args[1]);
        if (!dryRun) {
            output.mkdirs();
        }
        if (!dryRun) {
            System.out.println("Saving to " + output.getPath() + "!");
        } else {
            System.out.println("Output is " + output.getPath() + "!");
        }
        if (!dryRun) {
            System.out.println("Saving key...");
            Files.writeString(new File(output, "versionxmlsecret.conf").toPath(), (CharSequence)versionSecretFile.replace("%secret%", args[3]).replace("%plat%", args[2]).replace("%ver%", args[1]), new OpenOption[0]);
        }
        if (!(serverDown = new File(args[4], "ServerDown.xml")).exists()) {
            if (!dryRun) {
                String url = args[0] + "ServerDown.xml";
                File outputFile = serverDown;
                outputFile.getParentFile().mkdirs();
                System.out.println("Downloading: " + url + " -> " + outputFile.getPath());
                InputStream strm = new URL(url).openStream();
                String[] fO = new FileOutputStream(outputFile);
                strm.transferTo((OutputStream)fO);
                fO.close();
            } else {
                assetsToDownload.add("ServerDown.xml");
            }
        }
        if (!dryRun) {
            System.out.println("Downloading manifests...");
        } else {
            System.out.println("Verifying manifests...");
        }
        String manifest = EdgeContentServerDumper.downloadString(args[0], args[1], args[2], args[3], "DWADragonsMain.xml", "");
        System.out.println("Loading manifest...");
        String[] urlsToSwap = new String[]{"https://media.jumpstart.com/", "https://media.schoolofdragons.com/", "http://media.jumpstart.com/", "http://media.schoolofdragons.com/", args[5]};
        String xml = manifest;
        for (String u2 : urlsToSwap) {
            if (!xml.contains(u2)) continue;
            xml = xml.replace(u2, args[0]);
        }
        XmlMapper mapper = new XmlMapper();
        ProductConfigData conf = (ProductConfigData)mapper.readValue(xml, ProductConfigData.class);
        System.out.println("Modifying manifest...");
        xml = manifest;
        for (String u2 : urlsToSwap = new String[]{"https://media.jumpstart.com/", "https://media.schoolofdragons.com/", "http://media.jumpstart.com/", "http://media.schoolofdragons.com/", args[0]}) {
            if (!xml.contains(u2)) continue;
            xml = xml.replace(u2, args[5]);
        }
        if (!dryRun && !new File(output, "DWADragonsMain.xml").exists()) {
            Files.writeString(new File(output, "DWADragonsMain.xml").toPath(), (CharSequence)xml, new OpenOption[0]);
        }
        if (conf.manifests != null && conf.manifests.length != 0) {
            if (!dryRun) {
                System.out.println("Downloading main assets...");
            } else {
                System.out.println("Verifying main assets...");
            }
            EdgeContentServerDumper.downloadFileEachQuality(args[0], args[1], args[2], args[3], output, "dwadragonsmain", "", "?v=00000000000000000000000000000000", args[6].equalsIgnoreCase("true"));
            for (String man : conf.manifests) {
                EdgeContentServerDumper.downloadFileEachQuality(args[0], args[1], args[2], args[3], output, man, "", "?v=00000000000000000000000000000000", args[6].equalsIgnoreCase("true"));
            }
        }
        URL dataUrl = new URL(conf.dataURL[0].replace("{Version}", args[1]));
        String path = dataUrl.getPath().substring(dataUrl.getPath().indexOf("DWADragonsUnity/" + args[2] + "/" + args[1]) + ("DWADragonsUnity/" + args[2] + "/" + args[1]).length() + 1);
        EdgeContentServerDumper.downloadAssetsForEachQuality(args[0], args[1], args[2], args[3], output, mapper, path + "/AssetVersionsDO.xml", conf, new File(args[4]), args[5], args[6].equalsIgnoreCase("true"));
        if (!dryRun) {
            System.out.println("Downloading questiondata assets...");
        } else {
            System.out.println("Verifying questiondata assets...");
        }
        InputStream strm = EdgeContentServerDumper.class.getClassLoader().getResourceAsStream("questiondata.xml");
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        for (QuestionListData lst : questions = (QuestionListData[])mapper.reader().readValue(data, QuestionListData[].class)) {
            if (lst.imageURL != null) {
                EdgeContentServerDumper.downloadAsset(lst.imageURL, args[0], new File(args[4]), args[1], args[2], path);
            }
            for (QuestionListData.QuestionBlock q : lst.questions) {
                if (q.imageURL != null) {
                    EdgeContentServerDumper.downloadAsset(q.imageURL, args[0], new File(args[4]), args[1], args[2], path);
                }
                for (QuestionListData.QuestionBlock.AnswerBlock a : q.answers) {
                    if (a.imageURL == null) continue;
                    EdgeContentServerDumper.downloadAsset(a.imageURL, args[0], new File(args[4]), args[1], args[2], path);
                }
            }
        }
        if (!dryRun) {
            System.out.println("Downloading item assets...");
        } else {
            System.out.println("Verifying item assets...");
        }
        strm = ItemManagerImpl.class.getClassLoader().getResourceAsStream("itemdata/itemdefs.xml");
        data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        ItemRegistryManifest reg = (ItemRegistryManifest)mapper.reader().readValue(data, ItemRegistryManifest.class);
        for (ObjectNode def : reg.itemDefs) {
            String asset;
            if (!def.has("an") || (asset = def.get("an").asText()) == null) continue;
            EdgeContentServerDumper.downloadAsset(asset, args[0], new File(args[4]), args[1], args[2], path);
        }
        if (!dryRun) {
            System.out.println("Finished!");
        } else {
            System.out.println();
            System.out.println(assetsToDownload.size() + " files to download:");
            for (String file : assetsToDownload) {
                if (file.startsWith("/")) {
                    file = file.substring(1);
                }
                System.out.println(" - " + file);
            }
        }
    }

    private static void downloadAsset(String asset, String server, File outputRoot, String version, String platform, String path) throws IOException {
        if (((String)asset).startsWith("https://media.jumpstart.com/")) {
            asset = server + ((String)asset).substring("https://media.jumpstart.com/".length());
        } else if (((String)asset).startsWith("http://media.jumpstart.com/")) {
            asset = server + ((String)asset).substring("http://media.jumpstart.com/".length());
        } else if (((String)asset).startsWith("https://media.schoolofdragons.com/")) {
            asset = server + ((String)asset).substring("https://media.schoolofdragons.com/".length());
        } else if (((String)asset).startsWith("http://media.schoolofdragons.com/")) {
            asset = server + ((String)asset).substring("http://media.schoolofdragons.com/".length());
        }
        if (((String)asset).startsWith(server)) {
            FileOutputStream fO;
            InputStream strmI;
            URL asU = new URL((String)asset);
            String path2 = ((String)asset).substring(server.length());
            File dest = new File(outputRoot, path2);
            File outputFile = new File(outputRoot, path2 + ".tmp");
            if (dryRun) {
                System.out.println("Will download: " + (String)asset + " -> " + dest.getPath());
                if (((String)asset).startsWith("https://media.jumpstart.com/")) {
                    assetsToDownload.add(((String)asset).substring("https://media.jumpstart.com/".length()));
                } else if (((String)asset).startsWith("http://media.jumpstart.com/")) {
                    assetsToDownload.add(((String)asset).substring("http://media.jumpstart.com/".length()));
                } else if (((String)asset).startsWith("https://media.schoolofdragons.com/")) {
                    assetsToDownload.add(((String)asset).substring("https://media.schoolofdragons.com/".length()));
                } else if (((String)asset).startsWith("http://media.schoolofdragons.com/")) {
                    assetsToDownload.add(((String)asset).substring("http://media.schoolofdragons.com/".length()));
                } else if (((String)asset).startsWith(server)) {
                    assetsToDownload.add(((String)asset).substring(server.length()));
                }
            } else {
                System.out.println("Downloading: " + (String)asset + " -> " + dest.getPath());
                try {
                    outputFile.getParentFile().mkdirs();
                    strmI = asU.openStream();
                    fO = new FileOutputStream(outputFile);
                    strmI.transferTo(fO);
                    fO.close();
                    if (dest.exists()) {
                        dest.delete();
                    }
                    outputFile.renameTo(dest);
                }
                catch (IOException e) {
                    System.err.println("Failure! " + (String)asset + " was not downloaded!");
                }
            }
            outputFile = new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + ("/" + path).replace("/Mid/", "/Low/") + "/" + path2 + ".tmp");
            dest = new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + ("/" + path).replace("/Mid/", "/Low/") + "/" + path2);
            if (dryRun) {
                System.out.println("Will download: " + (String)asset + " -> " + dest.getPath());
                assetsToDownload.add("DWADragonsUnity/" + platform + "/" + version + ("/" + path).replace("/Mid/", "/Low/") + "/" + path2);
            } else {
                System.out.println("Downloading: " + (String)asset + " -> " + dest.getPath());
                try {
                    outputFile.getParentFile().mkdirs();
                    strmI = asU.openStream();
                    fO = new FileOutputStream(outputFile);
                    strmI.transferTo(fO);
                    fO.close();
                    if (dest.exists()) {
                        dest.delete();
                    }
                    outputFile.renameTo(dest);
                }
                catch (IOException e) {
                    System.err.println("Failure! " + (String)asset + " was not downloaded!");
                }
            }
            outputFile = new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + "/" + path + "/" + path2 + ".tmp");
            dest = new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + "/" + path + "/" + path2);
            if (dryRun) {
                System.out.println("Will download: " + (String)asset + " -> " + dest.getPath());
                assetsToDownload.add("DWADragonsUnity/" + platform + "/" + version + "/" + path + "/" + path2);
            } else {
                System.out.println("Downloading: " + (String)asset + " -> " + new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + "/" + path + "/" + path2).getPath());
                try {
                    outputFile.getParentFile().mkdirs();
                    strmI = asU.openStream();
                    fO = new FileOutputStream(outputFile);
                    strmI.transferTo(fO);
                    fO.close();
                    if (dest.exists()) {
                        dest.delete();
                    }
                    outputFile.renameTo(dest);
                }
                catch (IOException e) {
                    System.err.println("Failure! " + (String)asset + " was not downloaded!");
                }
            }
            outputFile = new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + ("/" + path).replace("/Mid/", "/High/") + "/" + path2 + ".tmp");
            dest = new File(outputRoot, "DWADragonsUnity/" + platform + "/" + version + ("/" + path).replace("/Mid/", "/High/") + "/" + path2);
            if (dryRun) {
                System.out.println("Will download: " + (String)asset + " -> " + dest.getPath());
                assetsToDownload.add("DWADragonsUnity/" + platform + "/" + version + ("/" + path).replace("/Mid/", "/High/") + "/" + path2);
            } else {
                System.out.println("Downloading: " + (String)asset + " -> " + dest.getPath());
                try {
                    outputFile.getParentFile().mkdirs();
                    strmI = asU.openStream();
                    fO = new FileOutputStream(outputFile);
                    strmI.transferTo(fO);
                    fO.close();
                    if (dest.exists()) {
                        dest.delete();
                    }
                    outputFile.renameTo(dest);
                }
                catch (IOException e) {
                    System.err.println("Failure! " + (String)asset + " was not downloaded!");
                }
            }
        }
    }

    private static void downloadAssetsForEachQuality(String server, String version, String platform, String key, File output, XmlMapper mapper, String manifest, ProductConfigData conf, File outputRoot, String newServerURL, boolean overwrite) throws IOException {
        EdgeContentServerDumper.downloadAssets(server, version, platform, key, output, mapper, manifest, "Mid", conf, outputRoot, newServerURL, overwrite);
        EdgeContentServerDumper.downloadAssets(server, version, platform, key, output, mapper, manifest, "Low", conf, outputRoot, newServerURL, overwrite);
        EdgeContentServerDumper.downloadAssets(server, version, platform, key, output, mapper, manifest, "High", conf, outputRoot, newServerURL, overwrite);
    }

    /*
     * WARNING - void declaration
     */
    private static void downloadAssets(String server, String version, String platform, String key, File output, XmlMapper mapper, String manifest, String level, ProductConfigData conf, File outputRoot, String newServerURL, boolean overwrite) throws IOException {
        File manFile;
        String manData;
        if (manifest.startsWith("/")) {
            manifest = manifest.substring(1);
        }
        try {
            System.out.println("Downloading asset list file... Downloading " + manifest.replace("/Mid/", "/" + level + "/"));
            String assetListManTxt = EdgeContentServerDumper.downloadString(server, version, platform, key, manifest.replace("/Mid/", "/" + level + "/"), "?v=00000000000000000000000000000000");
            System.out.println("Parsing asset list... Reading file " + manifest.replace("/Mid/", "/" + level + "/") + "...");
            manData = assetListManTxt;
            manFile = new File(output, manifest.replace("/Mid/", "/" + level + "/"));
        }
        catch (IOException e) {
            System.out.println("Downloading asset list file... Downloading " + manifest);
            String assetListManTxt = EdgeContentServerDumper.downloadString(server, version, platform, key, manifest, "?v=00000000000000000000000000000000");
            System.out.println("Parsing asset list... Reading file " + manifest + "...");
            manData = assetListManTxt;
            manFile = new File(output, manifest);
        }
        AssetVersionManifestData assetData = (AssetVersionManifestData)mapper.readValue(manData, AssetVersionManifestData.class);
        if (assetData.assets == null && assetData.legacyData != null) {
            void var18_22;
            HashMap<String, AssetVersionManifestData.AssetVersionBlock> assets = new HashMap<String, AssetVersionManifestData.AssetVersionBlock>();
            AssetVersionManifestData.AssetBlockLegacy[] assetBlockLegacyArray = assetData.legacyData;
            int n = assetBlockLegacyArray.length;
            boolean bl = false;
            while (var18_22 < n) {
                AssetVersionManifestData.AssetBlockLegacy legacyBlock = assetBlockLegacyArray[var18_22];
                AssetVersionManifestData.AssetVersionBlock block = null;
                if (assets.containsKey(legacyBlock.assetName)) {
                    block = (AssetVersionManifestData.AssetVersionBlock)assets.get(legacyBlock.assetName);
                } else {
                    block = new AssetVersionManifestData.AssetVersionBlock();
                    block.name = legacyBlock.assetName;
                    block.variants = new AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock[0];
                    assets.put(block.name, block);
                }
                AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock var = new AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock();
                var.locale = null;
                var.version = legacyBlock.version;
                var.size = legacyBlock.size;
                ArrayList<AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock> lst = new ArrayList<AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock>(Arrays.asList(block.variants));
                lst.add(var);
                block.variants = (AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock[])lst.toArray(AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock[]::new);
                ++var18_22;
            }
            assetData.assets = (AssetVersionManifestData.AssetVersionBlock[])assets.values().toArray(AssetVersionManifestData.AssetVersionBlock[]::new);
        }
        AssetVersionManifestData oldData = null;
        if (manFile.exists()) {
            oldData = (AssetVersionManifestData)mapper.readValue(Files.readString(manFile.toPath()), AssetVersionManifestData.class);
            if (oldData.assets == null && oldData.legacyData != null) {
                HashMap<String, AssetVersionManifestData.AssetVersionBlock> assets = new HashMap<String, AssetVersionManifestData.AssetVersionBlock>();
                for (AssetVersionManifestData.AssetBlockLegacy legacyBlock : oldData.legacyData) {
                    AssetVersionManifestData.AssetVersionBlock block = null;
                    if (assets.containsKey(legacyBlock.assetName)) {
                        block = (AssetVersionManifestData.AssetVersionBlock)assets.get(legacyBlock.assetName);
                    } else {
                        block = new AssetVersionManifestData.AssetVersionBlock();
                        block.name = legacyBlock.assetName;
                        block.variants = new AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock[0];
                        assets.put(block.name, block);
                    }
                    AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock var = new AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock();
                    var.locale = null;
                    var.version = legacyBlock.version;
                    var.size = legacyBlock.size;
                    ArrayList<AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock> lst = new ArrayList<AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock>(Arrays.asList(block.variants));
                    lst.add(var);
                    block.variants = (AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock[])lst.toArray(AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock[]::new);
                }
                oldData.assets = (AssetVersionManifestData.AssetVersionBlock[])assets.values().toArray(AssetVersionManifestData.AssetVersionBlock[]::new);
            }
        } else if (!dryRun) {
            Files.writeString(manFile.toPath(), (CharSequence)manData, new OpenOption[0]);
        }
        ArrayList<Object> failed = new ArrayList<Object>();
        for (AssetVersionManifestData.AssetVersionBlock asset : assetData.assets) {
            for (AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock variant : asset.variants) {
                Object url = asset.name;
                url = asset.name;
                AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock old = null;
                if (oldData != null) {
                    block16: for (AssetVersionManifestData.AssetVersionBlock a2 : assetData.assets) {
                        if (!a2.name.equalsIgnoreCase(asset.name)) continue;
                        for (AssetVersionManifestData.AssetVersionBlock.AssetVariantBlock v2 : asset.variants) {
                            if ((v2.locale != null || variant.locale != null) && (v2.locale == null || variant.locale == null || !v2.locale.equalsIgnoreCase(variant.locale))) continue;
                            old = v2;
                            break block16;
                        }
                        break;
                    }
                }
                if (((String)url).startsWith("RS_CONTENT/")) {
                    url = conf.contentDataURL[0].replace("/Mid/", "/" + level + "/").replace("{Version}", version) + ((String)url).substring("RS_CONTENT".length());
                } else if (((String)url).startsWith("RS_DATA/")) {
                    url = conf.dataURL[0].replace("/Mid/", "/" + level + "/").replace("{Version}", version) + ((String)url).substring("RS_DATA".length());
                } else if (((String)url).startsWith("RS_SCENE/")) {
                    url = conf.sceneURL[0].replace("/Mid/", "/" + level + "/").replace("{Version}", version) + ((String)url).substring("RS_SCENE".length());
                } else if (((String)url).startsWith("RS_SHARED/")) {
                    url = conf.sharedDataURL[0].replace("/Mid/", "/" + level + "/").replace("{Version}", version) + ((String)url).substring("RS_SHARED".length());
                } else if (((String)url).startsWith("RS_SOUND/")) {
                    url = conf.soundURL[0].replace("/Mid/", "/" + level + "/").replace("{Version}", version) + ((String)url).substring("RS_SOUND".length());
                } else if (((String)url).startsWith("RS_MOVIES/")) {
                    url = conf.moviesURL[0].replace("/Mid/", "/" + level + "/").replace("{Version}", version) + ((String)url).substring("RS_MOVIES".length());
                } else {
                    throw new IOException("Unable to translate path: " + (String)url);
                }
                URL u = new URL((String)url);
                Object path = u.getPath().substring(u.getPath().indexOf("DWADragonsUnity/" + platform + "/" + version) + ("DWADragonsUnity/" + platform + "/" + version).length() + 1);
                if (variant.locale != null) {
                    if (assetData.legacyData == null) {
                        File f = new File((String)path);
                        if (f.getName().contains(".")) {
                            oPth = path;
                            String ext = f.getName().substring(f.getName().lastIndexOf("."));
                            String fn = ((String)path).substring(0, ((String)path).lastIndexOf("."));
                            path = fn + "." + variant.locale + ext;
                            url = ((String)url).replace(oPth, (CharSequence)path);
                            u = new URL((String)url);
                        } else {
                            oPth = path;
                            path = (String)path + "." + variant.locale;
                            url = ((String)url).replace(oPth, (CharSequence)path);
                            u = new URL((String)url);
                        }
                    } else {
                        path = ((String)path).replace("/en-US/", "/" + variant.locale + "/");
                    }
                }
                String nm = new File(asset.name).getName();
                try {
                    if (nm.equals("DailyBonusAndPromoDO.xml")) {
                        strm = new URL((String)url).openStream();
                        xml = new String(strm.readAllBytes(), "UTF-8");
                        strm.close();
                        for (String line : xml.replace("\r", "").split("\n")) {
                            String pth;
                            URL dataUrl;
                            if (line.contains("<BkgIconRes>")) {
                                promoUrl = line.substring(line.indexOf("<BkgIconRes>") + "<BkgIconRes>".length());
                                promoUrl = ((String)promoUrl).substring(0, ((String)promoUrl).indexOf("</BkgIconRes>"));
                                if (((String)(promoUrl = EdgeContentServerDumper.decodeXML((String)promoUrl))).startsWith("RS_DATA/Content/")) {
                                    promoUrl = server + "/" + ((String)promoUrl).substring("RS_DATA/".length());
                                }
                                if (!((String)promoUrl).startsWith("http")) continue;
                                dataUrl = new URL(conf.dataURL[0].replace("{Version}", version));
                                pth = dataUrl.getPath().substring(dataUrl.getPath().indexOf("DWADragonsUnity/" + platform + "/" + version) + ("DWADragonsUnity/" + platform + "/" + version).length() + 1);
                                EdgeContentServerDumper.downloadAsset((String)promoUrl, server, outputRoot, version, platform, pth);
                                continue;
                            }
                            if (line.contains("<IconRes>")) {
                                promoUrl = line.substring(line.indexOf("<IconRes>") + "<IconRes>".length());
                                promoUrl = ((String)promoUrl).substring(0, ((String)promoUrl).indexOf("</IconRes>"));
                                if (((String)(promoUrl = EdgeContentServerDumper.decodeXML((String)promoUrl))).startsWith("RS_DATA/Content/")) {
                                    promoUrl = server + "/" + ((String)promoUrl).substring("RS_DATA/".length());
                                }
                                if (!((String)promoUrl).startsWith("http")) continue;
                                dataUrl = new URL(conf.dataURL[0].replace("{Version}", version));
                                pth = dataUrl.getPath().substring(dataUrl.getPath().indexOf("DWADragonsUnity/" + platform + "/" + version) + ("DWADragonsUnity/" + platform + "/" + version).length() + 1);
                                EdgeContentServerDumper.downloadAsset((String)promoUrl, server, outputRoot, version, platform, pth);
                                continue;
                            }
                            if (!line.contains("<ImageRes>")) continue;
                            promoUrl = line.substring(line.indexOf("<ImageRes>") + "<ImageRes>".length());
                            promoUrl = ((String)promoUrl).substring(0, ((String)promoUrl).indexOf("</ImageRes>"));
                            if (((String)(promoUrl = EdgeContentServerDumper.decodeXML((String)promoUrl))).startsWith("RS_DATA/Content/")) {
                                promoUrl = server + "/" + ((String)promoUrl).substring("RS_DATA/".length());
                            }
                            if (!((String)promoUrl).startsWith("http")) continue;
                            dataUrl = new URL(conf.dataURL[0].replace("{Version}", version));
                            pth = dataUrl.getPath().substring(dataUrl.getPath().indexOf("DWADragonsUnity/" + platform + "/" + version) + ("DWADragonsUnity/" + platform + "/" + version).length() + 1);
                            EdgeContentServerDumper.downloadAsset((String)promoUrl, server, outputRoot, version, platform, pth);
                        }
                    } else if (nm.equals("LoadScreenDataDO.xml")) {
                        strm = new URL((String)url).openStream();
                        xml = new String(strm.readAllBytes(), "UTF-8");
                        strm.close();
                        LoadScreenData screenData = (LoadScreenData)mapper.readValue(xml, LoadScreenData.class);
                        for (LoadScreenData.LoadScreenBlock block : screenData.loadScreens) {
                            try {
                                URL screenU = new URL(block.name);
                                String path2 = screenU.getPath();
                                dest = new File(outputRoot, path2);
                                if (dest.exists()) continue;
                                outputFile = new File(outputRoot, path2 + ".tmp");
                                if (dryRun) {
                                    System.out.println("Will download: " + screenU + " -> " + dest.getPath());
                                    assetsToDownload.add(path2);
                                    continue;
                                }
                                System.out.println("Downloading: " + screenU + " -> " + dest.getPath());
                                outputFile.getParentFile().mkdirs();
                                strmI = screenU.openStream();
                                fO = new FileOutputStream(outputFile);
                                strmI.transferTo(fO);
                                fO.close();
                                if (dest.exists()) {
                                    dest.delete();
                                }
                                outputFile.renameTo(dest);
                            }
                            catch (IOException e) {
                                System.err.println("Failure! " + block.name + " was not downloaded!");
                                failed.add(block.name);
                            }
                        }
                    } else if (nm.equals("LoginContentDO.xml")) {
                        strm = new URL((String)url).openStream();
                        xml = new String(strm.readAllBytes(), "UTF-8");
                        strm.close();
                        for (String line : xml.replace("\r", "").split("\n")) {
                            if (!line.contains("<URL>")) continue;
                            promoUrl = line.substring(line.indexOf("<URL>") + "<URL>".length());
                            promoUrl = ((String)promoUrl).substring(0, ((String)promoUrl).indexOf("</URL>"));
                            promoUrl = EdgeContentServerDumper.decodeXML((String)promoUrl);
                            try {
                                URL promoU = new URL((String)promoUrl);
                                String path2 = promoU.getPath();
                                dest = new File(outputRoot, path2);
                                if (dest.exists()) continue;
                                outputFile = new File(outputRoot, path2 + ".tmp");
                                if (dryRun) {
                                    System.out.println("Will download: " + (String)promoUrl + " -> " + dest.getPath());
                                    assetsToDownload.add(path2);
                                    continue;
                                }
                                System.out.println("Downloading: " + (String)promoUrl + " -> " + dest.getPath());
                                outputFile.getParentFile().mkdirs();
                                strmI = new URL((String)promoUrl).openStream();
                                fO = new FileOutputStream(outputFile);
                                strmI.transferTo(fO);
                                fO.close();
                                if (dest.exists()) {
                                    dest.delete();
                                }
                                outputFile.renameTo(dest);
                            }
                            catch (IOException e) {
                                System.err.println("Failure! " + (String)promoUrl + " was not downloaded!");
                                failed.add(promoUrl);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Failure! " + (String)url + " was not processed!");
                    failed.add(url);
                }
                if (!((String)url).endsWith(".xml")) {
                    url = (String)url + "?v=" + variant.version;
                }
                File outputFile = new File(output, (String)path);
                if (!overwrite && outputFile.exists() && old != null && old.version != variant.version || outputFile.exists() && Stream.of(retainFiles).anyMatch(t -> t.equalsIgnoreCase(outputFile.getName()))) {
                    System.out.println("Skipped: " + (String)url);
                    continue;
                }
                if (dryRun) {
                    assetsToDownload.add(new URL((String)url).getPath());
                    System.out.println("Will download: " + (String)url + " -> " + outputFile.getPath());
                    continue;
                }
                outputFile.getParentFile().mkdirs();
                System.out.println("Downloading: " + (String)url + " -> " + outputFile.getPath());
                try {
                    InputStream strm = new URL((String)url).openStream();
                    Object pathF = path;
                    if (Stream.of(tdEncryptedFiles).anyMatch(arg_0 -> EdgeContentServerDumper.lambda$downloadAssets$5((String)pathF, arg_0))) {
                        byte[] keyHash;
                        try {
                            MessageDigest digest = MessageDigest.getInstance("MD5");
                            keyHash = digest.digest(key.getBytes("UTF-8"));
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new RuntimeException(e);
                        }
                        byte[] data = Base64.getDecoder().decode(strm.readAllBytes());
                        strm.close();
                        strm = new ByteArrayInputStream(TripleDesUtil.decrypt((byte[])data, (byte[])keyHash));
                    }
                    FileOutputStream fO = new FileOutputStream(outputFile);
                    strm.transferTo(fO);
                    fO.close();
                    if (((String)path).endsWith(".xml")) {
                        String[] urlsToSwap = new String[]{"https://media.jumpstart.com/", "https://media.schoolofdragons.com/", "http://media.jumpstart.com/", "http://media.schoolofdragons.com/", server};
                        String xml = Files.readString(outputFile.toPath());
                        for (String u2 : urlsToSwap) {
                            if (!xml.contains(u2)) continue;
                            xml = xml.replace(u2, newServerURL);
                        }
                        Files.writeString(outputFile.toPath(), (CharSequence)xml, new OpenOption[0]);
                    }
                    strm.close();
                }
                catch (IOException e) {
                    System.err.println("Failure! " + (String)url + " was not downloaded!");
                    failed.add(url);
                }
            }
        }
        if (failed.size() != 0) {
            System.err.println("");
            System.err.println("");
            System.err.println("There were failed downloads!");
            for (String string : failed) {
                System.err.println(" - " + string);
            }
            System.err.println("");
            System.err.println("");
        }
        if (!dryRun) {
            if (manFile.exists()) {
                manFile.delete();
            }
            Files.writeString(manFile.toPath(), (CharSequence)manData, new OpenOption[0]);
        }
    }

    private static void downloadFileEachQuality(String server, String version, String platform, String key, File output, String file, String outputSuffix, String query, boolean overwrite) throws MalformedURLException, IOException {
        EdgeContentServerDumper.downloadFile(server, version, platform, key, output, "Low/" + file, outputSuffix, query, overwrite);
        EdgeContentServerDumper.downloadFile(server, version, platform, key, output, "Mid/" + file, outputSuffix, query, overwrite);
        EdgeContentServerDumper.downloadFile(server, version, platform, key, output, "High/" + file, outputSuffix, query, overwrite);
    }

    private static String downloadString(String server, String version, String platform, String key, String file, String query) throws MalformedURLException, IOException {
        String url = server + "DWADragonsUnity/" + platform + "/" + version + "/" + file + query;
        System.out.println("Downloading: " + url);
        if (dryRun) {
            assetsToDownload.add("DWADragonsUnity/" + platform + "/" + version + "/" + file);
        }
        String fileF = file;
        InputStream strm = new URL(url).openStream();
        if (Stream.of(tdEncryptedFiles).anyMatch(t -> t.equals(fileF))) {
            String man = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            if (man.matches("^([A-Za-z0-9+\\/]{4})*([A-Za-z0-9+\\/]{3}=|[A-Za-z0-9+\\/]{2}==)?$")) {
                byte[] keyHash;
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    keyHash = digest.digest(key.getBytes("UTF-8"));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                byte[] data = Base64.getDecoder().decode(man);
                strm = new ByteArrayInputStream(TripleDesUtil.decrypt((byte[])data, (byte[])keyHash));
            } else {
                strm = new ByteArrayInputStream(man.getBytes("UTF-8"));
            }
        }
        byte[] data = strm.readAllBytes();
        strm.close();
        return new String(data, "UTF-8");
    }

    private static void downloadFile(String server, String version, String platform, String key, File output, String file, String outputSuffix, String query, boolean overwrite) throws MalformedURLException, IOException {
        String url = server + "DWADragonsUnity/" + platform + "/" + version + "/" + file + query;
        File outputFile = new File(output, file + outputSuffix);
        if (!overwrite && outputFile.exists()) {
            System.out.println("Skipped: " + url);
            return;
        }
        if (dryRun) {
            System.out.println("Will download: " + url + " -> " + outputFile.getPath());
            assetsToDownload.add("DWADragonsUnity/" + platform + "/" + version + "/" + file);
            return;
        }
        outputFile.getParentFile().mkdirs();
        System.out.println("Downloading: " + url + " -> " + outputFile.getPath());
        String fileF = file;
        InputStream strm = new URL(url).openStream();
        if (Stream.of(tdEncryptedFiles).anyMatch(t -> t.equals(fileF))) {
            String man = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            if (man.matches("^([A-Za-z0-9+\\/]{4})*([A-Za-z0-9+\\/]{3}=|[A-Za-z0-9+\\/]{2}==)?$")) {
                byte[] keyHash;
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    keyHash = digest.digest(key.getBytes("UTF-8"));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                byte[] data = Base64.getDecoder().decode(man);
                strm = new ByteArrayInputStream(TripleDesUtil.decrypt((byte[])data, (byte[])keyHash));
            } else {
                strm = new ByteArrayInputStream(man.getBytes("UTF-8"));
                new File(output, file + ".edgeunencrypted").createNewFile();
            }
        }
        FileOutputStream fO = new FileOutputStream(outputFile);
        strm.transferTo(fO);
        fO.close();
        strm.close();
    }

    private static String decodeXML(String content) {
        Object newContent = "";
        Object buffer = "";
        for (char ch : content.toCharArray()) {
            if (((String)buffer).isEmpty()) {
                if (ch == '&') {
                    buffer = (String)buffer + ch;
                    continue;
                }
                newContent = (String)newContent + ch;
                continue;
            }
            if (((String)buffer + ch).startsWith("&#x")) {
                if (ch != ';') {
                    buffer = (String)buffer + ch;
                    continue;
                }
                buffer = ((String)buffer).substring(3);
                try {
                    int i = Integer.parseInt((String)buffer, 16);
                    if (i > 65535 || i < 0) {
                        throw new NumberFormatException();
                    }
                    newContent = (String)newContent + (char)i;
                }
                catch (NumberFormatException e) {
                    newContent = (String)newContent + "&#x" + (String)buffer + ch;
                }
                buffer = "";
                continue;
            }
            if (!((String)buffer + ch).equals("&#")) {
                newContent = (String)newContent + (String)buffer;
                buffer = "";
                continue;
            }
            buffer = (String)buffer + ch;
        }
        newContent = ((String)newContent).replace("&amp;", "&");
        newContent = ((String)newContent).replace("&lt;", "<");
        newContent = ((String)newContent).replace("&gt;", ">");
        newContent = ((String)newContent).replace("&quot;", "\"");
        newContent = ((String)newContent).replace("&apos;", ";");
        if (!((String)buffer).isEmpty()) {
            newContent = (String)newContent + (String)buffer;
        }
        return newContent;
    }

    private static /* synthetic */ boolean lambda$downloadAssets$5(String pathF, String t) {
        return t.equals(pathF);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
    public static class QuestionListData {
        @JsonProperty(value="ID")
        public int id;
        public String imageURL;
        @JsonProperty(value="Qs")
        @JacksonXmlElementWrapper(useWrapping=false)
        public QuestionBlock[] questions = new QuestionBlock[0];

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
        public static class QuestionBlock {
            @JsonProperty(value="ID")
            public int id;
            @JsonProperty(value="Img")
            public String imageURL;
            @JacksonXmlElementWrapper(useWrapping=false)
            public AnswerBlock[] answers = new AnswerBlock[0];

            @JsonIgnoreProperties(ignoreUnknown=true)
            @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
            public static class AnswerBlock {
                @JsonProperty(value="ID")
                public int id;
                @JsonProperty(value="Img")
                public String imageURL;
            }
        }
    }
}

