/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.objects;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.asf.connective.headers.HeaderCollection;
import org.asf.connective.objects.HttpObject;

public class HttpRequest
extends HttpObject {
    private InputStream body;
    private String httpVersion;
    private long bodyContentLength = -1L;
    private String requestMethod;
    private String requestResource;
    private String requestPath;
    private String requestQuery;
    private LinkedHashMap<String, String> queryParameters = new LinkedHashMap();
    private String bodyStr;

    public HttpRequest(InputStream body, long bodyContentLength, HeaderCollection headers, String httpVersion, String requestMethod, String requestResource) throws IllegalArgumentException {
        this.body = body;
        this.bodyContentLength = bodyContentLength;
        this.headers = headers;
        this.httpVersion = httpVersion;
        this.requestResource = requestResource;
        this.requestMethod = requestMethod.toUpperCase();
        this.requestPath = "";
        this.requestQuery = "";
        try {
            this.requestPath = requestResource;
            if (this.requestPath.contains("?")) {
                this.requestQuery = this.requestPath.substring(this.requestPath.indexOf("?") + 1);
                this.requestPath = this.requestPath.substring(0, this.requestPath.indexOf("?"));
            }
            this.requestPath = URLDecoder.decode(this.requestPath, "UTF-8");
            while (this.requestPath.startsWith("/")) {
                this.requestPath = this.requestPath.substring(1);
            }
            while (this.requestPath.endsWith("/")) {
                this.requestPath = this.requestPath.substring(0, this.requestPath.length() - 1);
            }
            while (this.requestPath.contains("//")) {
                this.requestPath = this.requestPath.replace("//", "/");
            }
            if (this.requestPath.contains("\\")) {
                this.requestPath = this.requestPath.replace("\\", "/");
            }
            if (!this.requestPath.startsWith("/")) {
                this.requestPath = "/" + this.requestPath;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed request");
        }
        if (this.requestPath.startsWith("..") || this.requestPath.endsWith("..") || this.requestPath.contains("/..") || this.requestPath.contains("../")) {
            throw new IllegalArgumentException("Invalid resource requested, forbidden path");
        }
        Object key = "";
        Object value = "";
        boolean isKey = true;
        for (int i = 0; i < this.requestQuery.length(); ++i) {
            char ch = this.requestQuery.charAt(i);
            if (ch == '&') {
                if (isKey && !((String)key).isEmpty()) {
                    this.queryParameters.put((String)key, "");
                    key = "";
                    continue;
                }
                if (isKey || ((String)key).isEmpty()) continue;
                try {
                    this.queryParameters.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
                }
                catch (Exception e) {
                    this.queryParameters.put((String)key, (String)value);
                }
                isKey = true;
                key = "";
                value = "";
                continue;
            }
            if (ch == '=') {
                isKey = !isKey;
                continue;
            }
            if (isKey) {
                key = (String)key + ch;
                continue;
            }
            value = (String)value + ch;
        }
        if (!((String)key).isEmpty() || !((String)value).isEmpty()) {
            try {
                this.queryParameters.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
            }
            catch (Exception e) {
                this.queryParameters.put((String)key, (String)value);
            }
        }
    }

    public boolean hasRequestBody() {
        return this.body != null;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getRequestQuery() {
        return this.requestQuery;
    }

    public void transferRequestBody(OutputStream output) throws IOException {
        if (this.body == null) {
            return;
        }
        if (this.bodyContentLength > -1L) {
            long length = this.bodyContentLength;
            int tr = 0;
            for (long i = 0L; i < length; i += (long)tr) {
                tr = 1000;
                if (length - i < (long)tr) {
                    tr = this.body.available();
                    if (tr == 0) {
                        output.write(this.body.read());
                        ++i;
                    }
                    tr = this.body.available();
                }
                output.write(this.body.readNBytes(tr));
            }
        } else {
            this.body.transferTo(output);
        }
    }

    public Map<String, String> getRequestQueryParameters() {
        return this.queryParameters;
    }

    public String getRawRequestResource() {
        return this.requestResource;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public long getBodyLength() {
        return this.bodyContentLength;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public InputStream getBodyStream() {
        if (this.bodyStr != null) {
            throw new IllegalStateException("This method cannot be used if getRequestBodyAsString() is called");
        }
        return this.body;
    }

    public String getRequestBodyAsString() throws IOException {
        if (this.bodyStr != null) {
            return this.bodyStr;
        }
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        this.transferRequestBody(strm);
        this.bodyStr = new String(strm.toByteArray(), "UTF-8");
        return this.bodyStr;
    }

    public String getRequestBodyAsString(String encoding) throws IOException {
        if (this.bodyStr != null) {
            return this.bodyStr;
        }
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        this.transferRequestBody(strm);
        this.bodyStr = new String(strm.toByteArray(), encoding);
        return this.bodyStr;
    }

    public String getRequestBodyAsString(Charset encoding) throws IOException {
        if (this.bodyStr != null) {
            return this.bodyStr;
        }
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        this.transferRequestBody(strm);
        this.bodyStr = new String(strm.toByteArray(), encoding);
        return this.bodyStr;
    }

    public String toString() {
        return this.requestMethod + " " + this.requestResource;
    }
}

