/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.commondata.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.commondata.impl.db.DatabaseCommonDataManager;
import org.asf.edge.common.services.commondata.impl.db.DatabaseRequest;
import org.asf.edge.common.services.config.ConfigProviderService;

public class DefaultDatabaseCommonDataManager
extends DatabaseCommonDataManager {
    private String url;
    private Properties props;
    private Logger logger = LogManager.getLogger((String)"CommonDataManager");
    private Connection conn;

    @Override
    public void initService() {
    }

    @Override
    public void loadManager() {
        JsonObject commonDataManagerConfig;
        try {
            commonDataManagerConfig = ConfigProviderService.getInstance().loadConfig("server", "commondata");
        }
        catch (IOException e) {
            this.logger.error("Failed to load common data manager configuration!", (Throwable)e);
            return;
        }
        if (commonDataManagerConfig == null) {
            commonDataManagerConfig = new JsonObject();
        }
        JsonObject databaseManagerConfig = new JsonObject();
        if (!commonDataManagerConfig.has("databaseManager")) {
            databaseManagerConfig.addProperty("url", "jdbc:mysql://localhost/edge");
            JsonObject props = new JsonObject();
            props.addProperty("user", "edge");
            props.addProperty("password", "edgesodserver");
            databaseManagerConfig.add("properties", (JsonElement)props);
            commonDataManagerConfig.add("databaseManager", (JsonElement)databaseManagerConfig);
            try {
                ConfigProviderService.getInstance().saveConfig("server", "commondata", commonDataManagerConfig);
            }
            catch (IOException e) {
                this.logger.error("Failed to write the common data manager configuration!", (Throwable)e);
                return;
            }
        } else {
            databaseManagerConfig = commonDataManagerConfig.get("databaseManager").getAsJsonObject();
        }
        this.url = databaseManagerConfig.get("url").getAsString();
        JsonObject properties = databaseManagerConfig.get("properties").getAsJsonObject();
        this.props = new Properties();
        for (String key : properties.keySet()) {
            this.props.setProperty(key, properties.get(key).getAsString());
        }
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            Class.forName("org.asf.edge.common.jdbc.LoggingProxyDriver");
            Class.forName("org.asf.edge.common.jdbc.LockingDriver");
            Connection conn = DriverManager.getConnection(this.url, this.props);
            if (this.url.startsWith("jdbc:sqlite:")) {
                this.conn = conn;
            } else {
                conn.close();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.error("Failed to connect to database!", (Throwable)e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupContainer(String rootNodeName) {
        try {
            boolean nonSingle;
            Connection conn = this.conn;
            boolean bl = nonSingle = conn == null;
            if (nonSingle) {
                conn = DriverManager.getConnection(this.url, this.props);
            }
            try {
                Statement statement = conn.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS CDC2_" + rootNodeName + " (DATAKEY varchar(64), PARENT varchar(64), PARENTCONTAINER varchar(256), DATA LONGTEXT)");
                statement.close();
            }
            finally {
                if (nonSingle) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to prepare data container '" + rootNodeName + "'", (Throwable)e);
        }
    }

    @Override
    public DatabaseRequest createRequest() throws SQLException {
        boolean nonSingle;
        Connection conn = this.conn;
        boolean bl = nonSingle = conn == null;
        if (nonSingle) {
            conn = DriverManager.getConnection(this.url, this.props);
        }
        final Connection connF = conn;
        return new DatabaseRequest(){

            @Override
            public PreparedStatement createPreparedStatement(String query) throws SQLException {
                return connF.prepareStatement(query);
            }

            @Override
            public void finish() throws SQLException {
                if (nonSingle) {
                    connF.close();
                }
            }
        };
    }
}

