/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.http.apihandlerutils.functions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FunctionResult {
    private String statusMessage;
    private int statusCode;
    private boolean hasResponseBody;
    private String mediaType;
    private InputStream responseBody;
    private long contentLength = -1L;

    public FunctionResult(int statusCode, String statusMessage) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public FunctionResult(int statusCode, String statusMessage, String mediaType, InputStream responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.mediaType = mediaType;
        this.responseBody = responseBody;
    }

    public FunctionResult(int statusCode, String statusMessage, InputStream responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.responseBody = responseBody;
    }

    public FunctionResult(int statusCode, String statusMessage, String mediaType, long contentLength, InputStream responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.mediaType = mediaType;
        this.responseBody = responseBody;
        this.contentLength = contentLength;
    }

    public FunctionResult(int statusCode, String statusMessage, long contentLength, InputStream responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.responseBody = responseBody;
        this.contentLength = contentLength;
    }

    public FunctionResult(int statusCode, String statusMessage, String mediaType, byte[] responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.mediaType = mediaType;
        this.responseBody = new ByteArrayInputStream(responseBody);
        this.contentLength = responseBody.length;
    }

    public FunctionResult(int statusCode, String statusMessage, byte[] responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.responseBody = new ByteArrayInputStream(responseBody);
        this.contentLength = responseBody.length;
    }

    public FunctionResult(int statusCode, String statusMessage, String mediaType, String responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        this.mediaType = mediaType;
        try {
            this.responseBody = new ByteArrayInputStream(responseBody.getBytes("UTF-8"));
            this.contentLength = responseBody.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public FunctionResult(int statusCode, String statusMessage, String responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasResponseBody = true;
        try {
            this.responseBody = new ByteArrayInputStream(responseBody.getBytes("UTF-8"));
            this.contentLength = responseBody.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean hasResponseBody() {
        return this.hasResponseBody;
    }

    public String getResponseMediaType() {
        return this.mediaType;
    }

    public InputStream getResponseBodyStream() {
        return this.responseBody;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

