/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.entities.messages.defaultmessages.WsGenericMessage;
import org.asf.edge.common.events.updates.ServerUpdateCompletionEvent;
import org.asf.edge.common.events.updates.ServerUpdateEvent;
import org.asf.edge.common.events.updates.UpdateCancelEvent;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class CommonUpdater {
    private static Logger logger;
    private static String currentVersion;
    private static boolean cancelUpdate;
    private static boolean updating;
    private static String nextVersion;
    private static String serverURL;
    private static int updateTimeRemaining;
    private static File updaterJar;

    public static String getCurrentVersion() {
        return currentVersion;
    }

    public static void init(String serverName, String defaultChannel, String currentVersion, File updaterJar) throws IOException {
        CommonUpdater.currentVersion = currentVersion;
        CommonUpdater.updaterJar = updaterJar;
        logger = LogManager.getLogger((String)"Updater");
        serverURL = "https://projectedge.net/updates/" + serverName;
        String updateChannel = defaultChannel;
        boolean disableUpdater = true;
        if (!new File("updater.conf").exists()) {
            Files.writeString(Path.of("updater.conf", new String[0]), (CharSequence)("# Updater URL\nurl=https://projectedge.net/updates/" + serverName + "\n\n# Update channel, valid values are lts, stable, unstable and dev\n# channel=" + defaultChannel + "\n\n# Runtime automatic updater, true to enable updating while the server runs, false otherwise\nruntime-auto-update=true\n\n# Update timer length\nruntime-update-timer-length=120\n\n# Disables the updater\ndisable=true\n"), new OpenOption[0]);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : Files.readAllLines(Path.of("updater.conf", new String[0]))) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            String key = line;
            String value = "";
            if (key.contains("=")) {
                value = key.substring(key.indexOf("=") + 1);
                key = key.substring(0, key.indexOf("="));
            }
            properties.put(key, value);
        }
        updateChannel = properties.getOrDefault("channel", updateChannel);
        disableUpdater = Boolean.parseBoolean(properties.getOrDefault("disable", "true"));
        serverURL = properties.getOrDefault("url", serverURL);
        if (Boolean.parseBoolean(properties.getOrDefault("runtime-auto-update", "false")) && System.getProperty("debugMode") == null) {
            int mins = Integer.parseInt(properties.getOrDefault("runtime-update-timer-length", "120"));
            String channel = updateChannel;
            Thread updater = new Thread(() -> {
                do {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!CommonUpdater.shouldUpdate(channel));
                CommonUpdater.runUpdater(mins);
            }, "Automatic update thread");
            updater.setDaemon(true);
            updater.start();
        }
        if (!disableUpdater && System.getProperty("debugMode") == null && CommonUpdater.shouldUpdate(updateChannel)) {
            EventBus.getInstance().dispatchEvent((EventObject)new ServerUpdateEvent(nextVersion, -1));
            EventBus.getInstance().dispatchEvent((EventObject)new ServerUpdateCompletionEvent(nextVersion));
            System.exit(0);
        }
    }

    public static boolean cancelUpdate() {
        if (updating) {
            cancelUpdate = true;
            nextVersion = null;
            updateTimeRemaining = -1;
            EventBus.getInstance().dispatchEvent((EventObject)new UpdateCancelEvent());
            AccountManager.getInstance().runForAllAccounts(t -> {
                if (t.isOnline()) {
                    WsGenericMessage msg = new WsGenericMessage();
                    msg.rawObject.typeID = 3;
                    msg.rawObject.messageContentNonMembers = msg.rawObject.messageContentMembers = "The server update has been cancelled by an administrator.";
                    try {
                        WsMessageService.getInstance().getMessengerFor((AccountObject)t).sendSessionMessage(msg);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return true;
            });
            logger.info("Update cancelled.");
            return true;
        }
        return false;
    }

    public static boolean runUpdater(int mins) {
        if (!cancelUpdate) {
            updating = true;
            EventBus.getInstance().dispatchEvent((EventObject)new ServerUpdateEvent(nextVersion, mins));
            int minutes = mins;
            Thread th = new Thread(() -> {
                int remaining;
                updateTimeRemaining = remaining = minutes;
                while (!cancelUpdate) {
                    if (remaining <= 0 || AccountManager.getInstance().getOnlinePlayerIDs().length == 0) {
                        CommonUpdater.updateShutdown();
                        cancelUpdate = false;
                        return;
                    }
                    for (int i = 0; i < 60 && !cancelUpdate; ++i) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    updateTimeRemaining = --remaining;
                }
                cancelUpdate = false;
                updating = false;
            });
            th.setName("Update Thread");
            th.start();
            return true;
        }
        return false;
    }

    public static void updateShutdown() {
        if (!updating) {
            EventBus.getInstance().dispatchEvent((EventObject)new ServerUpdateEvent(nextVersion, -1));
        }
        logger.info("Restarting server...");
        AccountManager.getInstance().runForAllAccounts(t -> {
            if (t.isOnline()) {
                WsGenericMessage msg = new WsGenericMessage();
                msg.rawObject.typeID = 3;
                msg.rawObject.messageContentNonMembers = msg.rawObject.messageContentMembers = "Edge servers are restarting! They will be offline for a few seconds and may cause errors now!";
                try {
                    WsMessageService.getInstance().getMessengerFor((AccountObject)t).sendSessionMessage(msg);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        });
        EventBus.getInstance().dispatchEvent((EventObject)new ServerUpdateCompletionEvent(nextVersion));
        if (!new File("update.list").exists()) {
            System.exit(237);
        } else {
            System.exit(0);
        }
    }

    private static boolean shouldUpdate(String channel) {
        logger.info("Checking for updates...");
        try {
            InputStream updateLog = new URL(serverURL + (serverURL.endsWith("/") ? "" : "/") + channel + "/update.info").openStream();
            String update = new String(updateLog.readAllBytes(), "UTF-8").trim();
            updateLog.close();
            if (!currentVersion.equals(update)) {
                logger.info("Update available, new version: " + update);
                logger.info("Preparing to update Edge...");
                InputStream strm = new URL(serverURL + (serverURL.endsWith("/") ? "" : "/") + channel + "/" + update + "/update.list").openStream();
                String fileList = new String(strm.readAllBytes(), "UTF-8").trim();
                strm.close();
                Object downloadList = "";
                for (String file : fileList.split("\n")) {
                    if (file.isEmpty()) continue;
                    downloadList = (String)downloadList + file + "=" + serverURL + (serverURL.endsWith("/") ? "" : "/") + channel + "/" + update + "/" + file + "\n";
                }
                Files.writeString(Path.of("update.list", new String[0]), (CharSequence)downloadList, new OpenOption[0]);
                if (!new File("updater.jar").exists()) {
                    Files.copy(updaterJar.toPath(), Path.of("updater.jar", new String[0]), new CopyOption[0]);
                }
                nextVersion = update;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void warnPlayerIfUpdating(AccountObject account) {
        if (updating && updateTimeRemaining != -1) {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", Locale.US);
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            Object message = switch (updateTimeRemaining) {
                case 1, 3, 5, 10 -> "The Edge servers are presently being updated! They will be temporarily offline for a few seconds and may cause errors! Restart is imminent!";
                case 0 -> "Edge servers are restarting! They will be offline for a few seconds and may cause errors now!";
                default -> "The Edge servers are gonna be updated! They will be temporarily offline and may cause errors soon! They are scheduled to go down at " + fmt.format(new Date(System.currentTimeMillis() + (long)(updateTimeRemaining * 60 * 1000))) + " UTC";
            };
            if (message != null) {
                WsGenericMessage msg = new WsGenericMessage();
                msg.rawObject.typeID = 3;
                msg.rawObject.messageContentMembers = message;
                msg.rawObject.messageContentNonMembers = msg.rawObject.messageContentMembers;
                try {
                    WsMessageService.getInstance().getMessengerFor(account).sendSessionMessage(msg);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        currentVersion = null;
        cancelUpdate = false;
        updating = false;
        nextVersion = null;
        serverURL = null;
        updateTimeRemaining = -1;
    }
}

