/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.Transformer;
import org.asf.cyan.fluid.api.ClassLoadHook;
import org.asf.cyan.fluid.api.transforming.TargetClass;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.sources.IClassSourceProvider;
import org.asf.cyan.fluid.remapping.Mapping;
import org.objectweb.asm.tree.ClassNode;

public class Transformers {
    private static boolean inited;
    private static FluidClassPool pool;
    private static Logger log;
    private static ArrayList<ClassLoadHook> hooks;
    private static HashMap<String, String> transformerOwners;
    private static HashMap<String, ArrayList<ClassNode>> transformers;

    public static void initialize() {
        if (inited) {
            throw new IllegalStateException("Cannot re-initialize FLUID!");
        }
        for (ClassLoadHook hook : Fluid.getHooks()) {
            String target = Fluid.mapClass(hook.targetPath());
            hook.build();
            hook.intialize(target.replaceAll("\\.", "/"));
            hooks.add(hook);
        }
        int index = 0;
        for (String transformer : Fluid.getTransformers()) {
            ClassNode transformerNode;
            try {
                transformerNode = Fluid.getTransformerPool().getClassNode(transformer);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            String target = null;
            for (Transformer.AnnotationInfo anno : Transformer.AnnotationInfo.create(transformerNode)) {
                if (!anno.is(TargetClass.class)) continue;
                target = (String)anno.get("target");
            }
            if (target != null) {
                target = Fluid.mapClass(target);
                ArrayList<ClassNode> trs = transformers.getOrDefault(target.replaceAll("\\.", "/"), new ArrayList());
                trs.add(transformerNode);
                transformers.put(target.replaceAll("\\.", "/"), trs);
                transformerOwners.put(transformerNode.name, Fluid.getTransformerOwners()[index]);
            }
            ++index;
        }
        pool = FluidClassPool.create();
        for (URL u : Fluid.getTransformerPool().getURLSources()) {
            if (Stream.of(pool.getURLSources()).anyMatch(t -> t.toString().equals(u.toString()))) continue;
            pool.addSource(u);
        }
        inited = true;
        for (Runnable hook : Fluid.getPostInitHooks()) {
            hook.run();
        }
    }

    public static void addClassSource(URL source) {
        pool.addSource(source);
    }

    public static void addClassSource(IClassSourceProvider<?> provider) {
        pool.addSource(provider);
    }

    public static boolean isInitialized() {
        return inited;
    }

    public static byte[] applyTransformers(String className, byte[] classfileBuffer, ClassLoader loader) {
        if (!inited) {
            throw new IllegalStateException("Transformer utility is not initialized");
        }
        return Transformers.applyTransformers(className, classfileBuffer, loader, pool, hooks, transformers, transformerOwners);
    }

    public static byte[] applyTransformers(String className, byte[] classfileBuffer, ClassLoader loader, FluidClassPool pool, List<ClassLoadHook> hooks, Map<String, ArrayList<ClassNode>> transformers, Map<String, String> transformerOwners) {
        String classNameF = className.replaceAll("\\.", "/");
        boolean match = false;
        boolean transformerMatch = false;
        if (hooks.stream().anyMatch(t -> {
            String target = t.getTarget();
            if (target.equals("@ANY")) {
                return true;
            }
            return target.equals(classNameF);
        })) {
            match = true;
        }
        if (transformers.keySet().stream().anyMatch(t -> t.equals(classNameF))) {
            transformerMatch = true;
        }
        if (!match && !transformerMatch) {
            try {
                pool.rewriteClass(classNameF, classfileBuffer);
            }
            catch (ClassNotFoundException e) {
                pool.readClass(classNameF, classfileBuffer);
            }
            return null;
        }
        byte[] bytecode = null;
        if (match) {
            Mapping<?>[] cls;
            try {
                cls = pool.rewriteClass(classNameF, classfileBuffer);
            }
            catch (ClassNotFoundException e) {
                cls = pool.readClass(classNameF, classfileBuffer);
            }
            Mapping<?>[] cc = cls;
            hooks.stream().filter(t -> {
                String target = t.getTarget();
                if (target.equals("@ANY")) {
                    return true;
                }
                return target.equals(classNameF);
            }).forEach(hook -> {
                try {
                    if (!hook.isSilent()) {
                        log.debug("Applying hook " + hook.getClass().getTypeName() + " to class " + classNameF);
                    }
                    hook.apply((ClassNode)cc, pool, loader, classfileBuffer);
                }
                catch (ClassNotFoundException e) {
                    log.error("FLUID hook apply failed, hook type: " + hook.getClass().getTypeName(), (Throwable)e);
                }
            });
            bytecode = pool.getByteCode(cc.name);
        }
        if (transformerMatch) {
            String clName = classNameF.replaceAll("/", ".");
            for (Mapping<?> map : Fluid.getMappings()) {
                boolean found = false;
                for (Mapping<?> mp : map.mappings) {
                    if (!mp.obfuscated.equals(clName)) continue;
                    clName = mp.name;
                    found = true;
                    break;
                }
                if (found) break;
            }
            ClassNode cls = null;
            if (bytecode != null) {
                try {
                    cls = pool.rewriteClass(classNameF, bytecode);
                }
                catch (ClassNotFoundException e) {
                    cls = pool.readClass(classNameF, bytecode);
                }
            } else {
                try {
                    cls = pool.rewriteClass(classNameF, classfileBuffer);
                }
                catch (ClassNotFoundException e) {
                    cls = pool.readClass(classNameF, classfileBuffer);
                }
            }
            Transformer.transform(cls, transformerOwners, transformers, clName, classNameF, pool, Fluid.getTransformerPool(), loader);
            bytecode = pool.getByteCode(cls.name);
        } else if (bytecode != null) {
            try {
                pool.rewriteClass(classNameF, bytecode);
            }
            catch (ClassNotFoundException e) {
                pool.readClass(classNameF, bytecode);
            }
        } else {
            try {
                pool.rewriteClass(classNameF, classfileBuffer);
            }
            catch (ClassNotFoundException e) {
                pool.readClass(classNameF, classfileBuffer);
            }
        }
        return bytecode;
    }

    static {
        log = LogManager.getLogger((String)"Fluid");
        hooks = new ArrayList();
        transformerOwners = new HashMap();
        transformers = new HashMap();
    }
}

