/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ContentSource;
import org.asf.connective.DefaultContentSource;
import org.asf.connective.IServerAdapterDefinition;
import org.asf.connective.NetworkedConnectiveHttpServer;
import org.asf.connective.headers.HeaderCollection;
import org.asf.connective.impl.http_1_1.Http_1_1_Adapter;
import org.asf.connective.impl.https_1_1.Https_1_1_Adapter;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.processors.HttpRequestProcessor;

public abstract class ConnectiveHttpServer {
    public static final String CONNECTIVE_VERSION = "1.0.0.A13";
    private ContentSource contentSource = new DefaultContentSource();
    private Logger logger = LogManager.getLogger((String)"connective-http");
    private HeaderCollection defaultHeaders = new HeaderCollection();
    protected ArrayList<HttpRequestProcessor> reqProcessors = new ArrayList();
    protected ArrayList<HttpPushProcessor> pushProcessors = new ArrayList();
    private static ArrayList<IServerAdapterDefinition> adapters = new ArrayList<Https_1_1_Adapter>(List.of(new Http_1_1_Adapter(), new Https_1_1_Adapter()));
    private BiFunction<HttpResponse, HttpRequest, String> errorGenerator = new BiFunction<HttpResponse, HttpRequest, String>(){
        protected String htmlCache = null;

        @Override
        public String apply(HttpResponse response, HttpRequest request) {
            block2: {
                try {
                    InputStream strm = this.getClass().getResource("/error.template.html").openStream();
                    this.htmlCache = new String(strm.readAllBytes());
                }
                catch (Exception ex) {
                    if (this.htmlCache != null) break block2;
                    return "FATAL ERROR GENERATING PAGE: " + ex.getClass().getTypeName() + ": " + ex.getMessage();
                }
            }
            String str = this.htmlCache;
            str = str.replace("%path%", request.getRequestPath());
            str = str.replace("%server-name%", ConnectiveHttpServer.this.getServerName());
            str = str.replace("%server-version%", ConnectiveHttpServer.this.getServerVersion());
            str = str.replace("%error-status%", Integer.toString(response.getResponseCode()));
            str = str.replace("%error-message%", response.getResponseMessage());
            return str;
        }
    };

    public HttpRequestProcessor[] getRequestProcessors() {
        return (HttpRequestProcessor[])this.reqProcessors.toArray(HttpRequestProcessor[]::new);
    }

    public HttpPushProcessor[] getPushProcessors() {
        return (HttpPushProcessor[])this.pushProcessors.toArray(HttpPushProcessor[]::new);
    }

    public ContentSource getContentSource() {
        return this.contentSource;
    }

    public void setContentSource(ContentSource newSource) {
        newSource.parent = this.contentSource;
        this.contentSource = newSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAdapter(IServerAdapterDefinition adapter) {
        ArrayList<IServerAdapterDefinition> arrayList = adapters;
        synchronized (arrayList) {
            adapters.add(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServerAdapterDefinition findAdapter(String adapterName) {
        IServerAdapterDefinition[] iServerAdapterDefinitionArray = adapters;
        synchronized (adapters) {
            IServerAdapterDefinition[] adapterLst = (IServerAdapterDefinition[])adapters.toArray(IServerAdapterDefinition[]::new);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (IServerAdapterDefinition adapter : adapterLst) {
                if (adapter == null || !adapter.getName().equalsIgnoreCase(adapterName)) continue;
                return adapter;
            }
            return null;
        }
    }

    public static ConnectiveHttpServer create(String adapterName) throws IllegalArgumentException {
        return ConnectiveHttpServer.create(adapterName, Map.of());
    }

    public static ConnectiveHttpServer create(String adapterName, Map<String, String> configuration) throws IllegalArgumentException {
        IServerAdapterDefinition adapter = ConnectiveHttpServer.findAdapter(adapterName);
        if (adapter == null) {
            return null;
        }
        return adapter.createServer(configuration);
    }

    public static NetworkedConnectiveHttpServer createNetworked(String adapterName) throws IllegalArgumentException {
        return ConnectiveHttpServer.createNetworked(adapterName, Map.of());
    }

    public static NetworkedConnectiveHttpServer createNetworked(String adapterName, Map<String, String> configuration) throws IllegalArgumentException {
        IServerAdapterDefinition adapter = ConnectiveHttpServer.findAdapter(adapterName);
        if (adapter == null) {
            return null;
        }
        ConnectiveHttpServer srv = adapter.createServer(configuration);
        if (srv instanceof NetworkedConnectiveHttpServer) {
            return (NetworkedConnectiveHttpServer)srv;
        }
        return null;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public abstract String getServerName();

    public abstract String getServerVersion();

    public abstract void setServerName(String var1);

    public abstract void start() throws IOException;

    public abstract void stop() throws IOException;

    public abstract void stopForced() throws IOException;

    public abstract boolean isRunning();

    public HeaderCollection getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void waitForExit() {
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void registerProcessor(HttpPushProcessor processor) {
        if (!this.pushProcessors.stream().anyMatch(t -> t.getClass().getTypeName().equals(processor.getClass().getTypeName()) && t.supportsChildPaths() == processor.supportsChildPaths() && t.supportsNonPush() == processor.supportsNonPush() && t.path() == processor.path())) {
            this.pushProcessors.add(processor);
        }
    }

    public void registerProcessor(HttpRequestProcessor processor) {
        if (processor instanceof HttpPushProcessor) {
            this.registerProcessor((HttpPushProcessor)processor);
            return;
        }
        if (!this.reqProcessors.stream().anyMatch(t -> t.getClass().getTypeName().equals(processor.getClass().getTypeName()) && t.supportsChildPaths() == processor.supportsChildPaths() && t.path() == processor.path())) {
            this.reqProcessors.add(processor);
        }
    }

    public BiFunction<HttpResponse, HttpRequest, String> getErrorPageGenerator() {
        return this.errorGenerator;
    }

    public void setErrorPageGenerator(BiFunction<HttpResponse, HttpRequest, String> errorGenerator) {
        this.errorGenerator = errorGenerator;
    }

    public abstract String getProtocolName();
}

