/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.textfilter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.stream.Stream;
import org.asf.edge.common.services.textfilter.FilterMode;
import org.asf.edge.common.services.textfilter.FilterSeverity;
import org.asf.edge.common.services.textfilter.PhraseFilterSet;

public class PhraseFilter {
    private PhraseFilterSet set;
    private String phrase;
    private String reason;
    private String[] variants;
    private FilterSeverity severity;
    private FilterMode[] modes;

    public PhraseFilter(PhraseFilterSet set, FilterMode[] modes, String phrase, String[] variants, String reason, FilterSeverity severity) {
        this.set = set;
        this.phrase = phrase;
        this.variants = variants;
        this.reason = reason;
        this.severity = severity;
        this.modes = modes;
    }

    public FilterMode[] getModes() {
        return (FilterMode[])this.modes.clone();
    }

    public void addMode(FilterMode mode) {
        if (this.hasMode(mode)) {
            return;
        }
        FilterMode[] modesU = new FilterMode[this.modes.length];
        for (int i = 0; i < this.modes.length; ++i) {
            modesU[i] = this.modes[i];
        }
        modesU[this.modes.length] = mode;
        this.modes = modesU;
    }

    public boolean hasMode(FilterMode mode) {
        return Stream.of(this.modes).anyMatch(m -> m == mode);
    }

    public void addVariant(String variant) {
        String[] variantsU = new String[this.variants.length];
        for (int i = 0; i < this.variants.length; ++i) {
            variantsU[i] = this.variants[i];
        }
        variantsU[this.variants.length] = variant;
        this.variants = variantsU;
    }

    public FilterSeverity getSeverity() {
        return this.severity;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public String[] getVariants() {
        return (String[])this.variants.clone();
    }

    public String getReason() {
        return this.reason;
    }

    @JsonIgnore
    public PhraseFilterSet getSet() {
        return this.set;
    }

    public String[] getAllPhrases() {
        String[] v = this.getVariants();
        this.variants = new String[v.length + 1];
        for (int i = 0; i < v.length; ++i) {
            this.variants[i] = v[i];
        }
        this.variants[v.length] = this.getPhrase();
        return v;
    }
}

