/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.asf.edge.common.services.accounts.impl.DatabaseAccountManager;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseRequest;
import org.asf.edge.common.services.config.ConfigProviderService;

public class DefaultDatabaseAccountManager
extends DatabaseAccountManager {
    private String url;
    private Properties props;
    private Connection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void managerLoaded() {
        JsonObject accountManagerConfig;
        try {
            accountManagerConfig = ConfigProviderService.getInstance().loadConfig("server", "accountmanager");
        }
        catch (IOException e) {
            this.logger.error("Failed to load account manager configuration!", (Throwable)e);
            return;
        }
        if (accountManagerConfig == null) {
            accountManagerConfig = new JsonObject();
        }
        JsonObject databaseManagerConfig = new JsonObject();
        if (!accountManagerConfig.has("databaseManager")) {
            databaseManagerConfig.addProperty("url", "jdbc:mysql://localhost/edge");
            JsonObject props = new JsonObject();
            props.addProperty("user", "edge");
            props.addProperty("password", "edgesodserver");
            databaseManagerConfig.add("properties", (JsonElement)props);
            accountManagerConfig.add("databaseManager", (JsonElement)databaseManagerConfig);
            try {
                ConfigProviderService.getInstance().saveConfig("server", "accountmanager", accountManagerConfig);
            }
            catch (IOException e) {
                this.logger.error("Failed to write the account manager configuration!", (Throwable)e);
                return;
            }
        } else {
            databaseManagerConfig = accountManagerConfig.get("databaseManager").getAsJsonObject();
        }
        this.url = databaseManagerConfig.get("url").getAsString();
        JsonObject properties = databaseManagerConfig.get("properties").getAsJsonObject();
        this.props = new Properties();
        for (String key : properties.keySet()) {
            this.props.setProperty(key, properties.get(key).getAsString());
        }
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            Class.forName("org.mariadb.jdbc.Driver");
            Class.forName("org.asf.edge.common.jdbc.LoggingProxyDriver");
            Class.forName("org.asf.edge.common.jdbc.LockingDriver");
            Connection conn = DriverManager.getConnection(this.url, this.props);
            if (this.url.startsWith("jdbc:sqlite:")) {
                this.conn = conn;
            }
            try {
                Statement statement = conn.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS EMAILMAP_V2 (EMAIL TEXT, ID CHAR(36))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS USERMAP_V2 (USERNAME TEXT, ID CHAR(36), CREDS BINARY(48))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS SAVEUSERNAMEMAP_V2 (USERNAME TEXT, ID CHAR(36))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS SAVEMAP_V2 (ACCID CHAR(36), SAVES LONGTEXT)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS ACCOUNTWIDEPLAYERDATA_V2 (ACCID CHAR(36), DATAKEY varchar(64), PARENT varchar(64), PARENTCONTAINER varchar(256), DATA LONGTEXT)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS SAVESPECIFICPLAYERDATA_V2 (SVID CHAR(36), DATAKEY varchar(64), PARENT varchar(64), PARENTCONTAINER varchar(256), DATA LONGTEXT)");
                statement.close();
            }
            finally {
                if (!this.url.startsWith("jdbc:sqlite:")) {
                    conn.close();
                }
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.error("Failed to connect to database!", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public DatabaseRequest createRequest() throws SQLException {
        boolean nonSingle = false;
        Connection conn = this.conn;
        if (conn == null) {
            nonSingle = true;
            conn = DriverManager.getConnection(this.url, this.props);
        }
        final Connection connF = conn;
        final boolean nonSingleF = nonSingle;
        return new DatabaseRequest(){

            @Override
            public PreparedStatement prepareStatement(String query) throws SQLException {
                return connF.prepareStatement(query);
            }

            @Override
            public void close() throws SQLException {
                if (nonSingleF) {
                    connF.close();
                }
            }
        };
    }
}

