/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.IEventReceiver;

public class ServiceManager {
    private static HashMap<String, AbstractService> services = new HashMap();
    private static HashMap<String, ArrayList<RegistrationInfo>> serviceImplementations = new HashMap();
    private static Logger logger = LogManager.getLogger((String)"ServiceManager");

    public static <T extends AbstractService> void registerServiceImplementation(Class<T> service, T impl) {
        ServiceManager.registerServiceImplementation(service, impl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractService> void registerServiceImplementation(Class<T> service, T impl, int priority) {
        HashMap<String, ArrayList<RegistrationInfo>> hashMap = serviceImplementations;
        synchronized (hashMap) {
            if (!serviceImplementations.containsKey(service.getTypeName())) {
                serviceImplementations.put(service.getTypeName(), new ArrayList());
            }
            RegistrationInfo inf = new RegistrationInfo();
            inf.implementation = impl;
            inf.priority = priority;
            serviceImplementations.get(service.getTypeName()).add(inf);
            logger.debug("Service implementation " + impl.getClass().getTypeName() + " registered for service " + service.getTypeName() + " with priority " + priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractService> T getService(Class<T> service) {
        T i;
        if (services.containsKey(service.getTypeName())) {
            return (T)services.get(service.getTypeName());
        }
        HashMap<String, AbstractService> hashMap = services;
        synchronized (hashMap) {
            if (services.containsKey(service.getTypeName())) {
                return (T)services.get(service.getTypeName());
            }
            HashMap<String, ArrayList<RegistrationInfo>> hashMap2 = serviceImplementations;
            synchronized (hashMap2) {
                i = ServiceManager.selectServiceImplementationInternal(service);
            }
        }
        if (!((AbstractService)i).inited) {
            ((AbstractService)i).initService();
        }
        ((AbstractService)i).inited = true;
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractService> T selectServiceImplementation(Class<T> service) {
        T i;
        HashMap<String, AbstractService> hashMap = services;
        synchronized (hashMap) {
            HashMap<String, ArrayList<RegistrationInfo>> hashMap2 = serviceImplementations;
            synchronized (hashMap2) {
                i = ServiceManager.selectServiceImplementationInternal(service);
            }
        }
        if (!((AbstractService)i).inited) {
            ((AbstractService)i).initService();
        }
        ((AbstractService)i).inited = true;
        return i;
    }

    private static <T extends AbstractService> T selectServiceImplementationInternal(Class<T> service) {
        if (!serviceImplementations.containsKey(service.getTypeName())) {
            throw new IllegalArgumentException("No service implementations for " + service.getTypeName());
        }
        RegistrationInfo[] i = (RegistrationInfo[])serviceImplementations.get(service.getTypeName()).stream().sorted((t1, t2) -> -Integer.compare(t1.priority, t2.priority)).toArray(RegistrationInfo[]::new);
        if (i.length >= 1) {
            EventBus.getInstance().addAllEventsFromReceiver((IEventReceiver)i[0].implementation);
            services.put(service.getTypeName(), i[0].implementation);
            logger.debug("Service implementation selected for " + service.getTypeName() + ": " + i[0].implementation.getClass().getTypeName());
            return (T)i[0].implementation;
        }
        throw new IllegalArgumentException("No service implementations for " + service.getTypeName());
    }

    private static class RegistrationInfo {
        public int priority;
        public AbstractService implementation;

        private RegistrationInfo() {
        }
    }
}

