/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.cyan.fluid.FluidAgent;
import org.asf.cyan.fluid.Transformer;
import org.asf.cyan.fluid.api.ClassLoadHook;
import org.asf.cyan.fluid.api.FluidTransformer;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.deobfuscation.DeobfuscationTarget;
import org.asf.cyan.fluid.deobfuscation.DeobfuscationTargetMap;
import org.asf.cyan.fluid.remapping.FluidClassRemapper;
import org.asf.cyan.fluid.remapping.FluidMemberRemapper;
import org.asf.cyan.fluid.remapping.MAPTYPE;
import org.asf.cyan.fluid.remapping.Mapping;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class Fluid {
    private static File dumpDir = new File(".");
    protected static Logger log = LogManager.getLogger((String)"Fluid");
    static Map<Character, String> descriptors = Map.of(Character.valueOf('V'), "void", Character.valueOf('Z'), "boolean", Character.valueOf('I'), "int", Character.valueOf('J'), "long", Character.valueOf('D'), "double", Character.valueOf('F'), "float", Character.valueOf('S'), "short", Character.valueOf('C'), "char", Character.valueOf('B'), "byte");
    private static ArrayList<Runnable> postInitHooks = new ArrayList();
    private static ArrayList<String> addedTransformerLocations = new ArrayList();
    private static FluidClassPool transformerPool = FluidClassPool.createEmpty();
    private static ArrayList<Mapping<?>> loadedMappings = new ArrayList();
    private static HashMap<String, String> loadedTransformers = new HashMap();
    private static ArrayList<ClassLoadHook> loadedHooks = new ArrayList();
    private static boolean closed = false;
    private static boolean beforeLoad = true;
    private static boolean warn = true;
    private static HashMap<String, String> extraAgents = new HashMap();

    public static void setDumpDir(File dir) {
        dumpDir = dir;
    }

    public static String getVersion() {
        URL info = Fluid.class.getResource("/fluid.info");
        StringBuilder builder = new StringBuilder();
        try {
            Scanner sc = new Scanner(info.openStream());
            while (sc.hasNext()) {
                builder.append(sc.nextLine());
            }
            sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    public static String getDescriptor(String type) {
        Object prefix = "";
        while (type.contains("[]")) {
            prefix = (String)prefix + "[";
            type = type.substring(0, type.lastIndexOf("["));
        }
        int i = 0;
        for (String desc : descriptors.values()) {
            if (desc.equals(type)) {
                return (String)prefix + ((Character[])descriptors.keySet().toArray(Character[]::new))[i].toString();
            }
            ++i;
        }
        if (type == "") {
            return "";
        }
        return (String)prefix + "L" + type.replaceAll("\\.", "/") + ";";
    }

    public static String getDescriptors(String[] types) {
        StringBuilder b = new StringBuilder();
        for (String type : types) {
            b.append(Fluid.getDescriptor(type));
        }
        return b.toString();
    }

    public static String parseDescriptor(String descriptor) {
        return Fluid.parseDescriptorIntern(descriptor, 0, descriptor.length())[0].toString();
    }

    public static void registerPostInitHook(Runnable runnable) {
        postInitHooks.add(runnable);
    }

    public static String[] parseMultipleDescriptors(String descriptor) {
        ArrayList<String> argumentTypes = new ArrayList<String>();
        int l = descriptor.length();
        for (int i = 0; i < l; ++i) {
            Object[] info = Fluid.parseDescriptorIntern(descriptor, i, l);
            i = (Integer)info[1];
            argumentTypes.add(info[0].toString());
        }
        return (String[])argumentTypes.toArray(String[]::new);
    }

    private static Object[] parseDescriptorIntern(String descriptor, int start, int l) {
        StringBuilder out = new StringBuilder();
        boolean parseName = false;
        int arrays = 0;
        int i = start;
        for (i = start; i < l; ++i) {
            char ch = descriptor.charAt(i);
            if (ch == 'L' && !parseName) {
                parseName = true;
                continue;
            }
            if (!parseName && ch == '[') {
                ++arrays;
                continue;
            }
            if (!parseName) {
                out.append(descriptors.get(Character.valueOf(ch)));
                if (arrays != 0) {
                    for (int i2 = 0; i2 < arrays; ++i2) {
                        out.append("[]");
                    }
                    arrays = 0;
                }
                descriptor = out.toString();
                break;
            }
            if (ch == '/') {
                out.append('.');
                continue;
            }
            if (ch != ';') {
                out.append(ch);
                continue;
            }
            if (arrays != 0) {
                for (int i2 = 0; i2 < arrays; ++i2) {
                    out.append("[]");
                }
                arrays = 0;
            }
            descriptor = out.toString();
            break;
        }
        out = null;
        return new Object[]{descriptor, i};
    }

    static FluidClassPool getTransformerPool() {
        return transformerPool;
    }

    public static Mapping<?>[] getMappings() {
        return (Mapping[])loadedMappings.toArray(Mapping[]::new);
    }

    static String[] getTransformers() {
        return (String[])loadedTransformers.keySet().toArray(String[]::new);
    }

    static String[] getTransformerOwners() {
        return (String[])loadedTransformers.values().toArray(String[]::new);
    }

    static ClassLoadHook[] getHooks() {
        return (ClassLoadHook[])loadedHooks.toArray(ClassLoadHook[]::new);
    }

    public static void closeFluidLoader() {
        if (closed) {
            throw new IllegalStateException("Cannot close FLUID more than once!");
        }
        closed = true;
    }

    public static void openFluidLoader() {
        if (!beforeLoad) {
            throw new IllegalStateException("Cannot re-open FLUID!");
        }
        beforeLoad = false;
    }

    public static void registerTransformer(String transformer, URL source) throws IllegalStateException, ClassNotFoundException {
        String owner = CallTrace.traceCall().getTypeName();
        if (owner.contains(".")) {
            owner = owner.substring(owner.lastIndexOf(".") + 1);
        }
        if (owner.contains("$")) {
            owner = owner.substring(0, owner.lastIndexOf("$"));
        }
        Fluid.registerTransformer(transformer, owner, source);
    }

    public static void registerTransformer(String transformer, String owner, URL source) throws IllegalStateException, ClassNotFoundException {
        if (!closed && !beforeLoad) {
            String simpleName = transformer.replaceAll("/", ".");
            if (simpleName.contains(".")) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
            }
            if (!addedTransformerLocations.contains(source.toString())) {
                transformerPool.addSource(source);
                addedTransformerLocations.add(source.toString());
            }
            ClassNode transformerNode = transformerPool.getClassNode(transformer);
            log.info("Loading transformer " + simpleName + "...");
            if (transformerNode.visibleAnnotations == null || !transformerNode.visibleAnnotations.stream().anyMatch(t -> Fluid.parseDescriptor(t.desc).equals(FluidTransformer.class.getTypeName()))) {
                throw new IllegalArgumentException("Transformer does not have the @FluidTransformer annotation, class: " + transformer.replaceAll("/", "."));
            }
        } else {
            throw new IllegalStateException("Cannot register transformers after FLUID has been closed or before it has been opened!");
        }
        loadedTransformers.put(transformer.replaceAll("/", "."), owner);
    }

    public static void registerHook(ClassLoadHook hook) throws IllegalStateException {
        if (closed || beforeLoad) {
            throw new IllegalStateException("Cannot register hooks after FLUID has been closed or before it has been opened!");
        }
        log.info("Loading class hook " + hook.getClass().getSimpleName() + ", target class: " + hook.targetPath());
        loadedHooks.add(hook);
    }

    public static void loadMappings(Mapping<?> mappings) throws IllegalStateException {
        if (closed || beforeLoad) {
            throw new IllegalStateException("Cannot add mappings after FLUID has been closed or before it has been opened!");
        }
        loadedMappings.add(mappings);
    }

    public static String mapClass(String input) {
        Mapping<?> map;
        String suffix = "";
        if (input.contains("[]")) {
            suffix = input.substring(input.indexOf("[]"));
            input = input.substring(0, input.indexOf("[]"));
        }
        if ((map = Fluid.mapClassToMapping(input, t -> true)) != null) {
            return map.obfuscated + suffix;
        }
        return input + suffix;
    }

    static Mapping<?> mapClassToMapping(String input, Function<Mapping<?>, Boolean> fn) {
        for (Mapping<?> mappings : loadedMappings) {
            Mapping<?> map = mappings.mapClassToMapping(input, fn, false);
            if (map == null) continue;
            return map;
        }
        return null;
    }

    public static String mapMethod(String classPath, String methodName, String ... methodParameters) {
        return Fluid.mapMethod(classPath, methodName, false, methodParameters);
    }

    public static String mapMethod(String classPath, String methodName, boolean getPath, String ... methodParameters) {
        String mName = methodName;
        Mapping<?> map = Fluid.mapClassToMapping(classPath, t -> Stream.of(t.mappings).anyMatch(t2 -> t2.mappingType == MAPTYPE.METHOD && t2.name.equals(mName) && Arrays.equals(t2.argumentTypes, methodParameters)));
        if (map != null) {
            classPath = map.obfuscated;
            methodName = Stream.of(map.mappings).filter((Predicate<Mapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$mapMethod$10(java.lang.String java.lang.String[] org.asf.cyan.fluid.remapping.Mapping ), (Lorg/asf/cyan/fluid/remapping/Mapping;)Z)((String)mName, (String[])methodParameters)).findFirst().get().obfuscated;
        }
        if (getPath) {
            return classPath + "." + methodName;
        }
        return methodName;
    }

    public static String mapProperty(String classPath, String propertyName) {
        String pName = propertyName;
        Mapping<?> map = Fluid.mapClassToMapping(classPath, t -> Stream.of(t.mappings).anyMatch(t2 -> t2.mappingType == MAPTYPE.PROPERTY && t2.name.equals(pName)));
        if (map != null) {
            propertyName = Stream.of(map.mappings).filter((Predicate<Mapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$mapProperty$13(java.lang.String org.asf.cyan.fluid.remapping.Mapping ), (Lorg/asf/cyan/fluid/remapping/Mapping;)Z)((String)pName)).findFirst().get().obfuscated;
        }
        return propertyName;
    }

    public static void noAgentWarn() {
        warn = false;
    }

    public static void loadAgent() {
        if (System.getProperty("jdk.attach.allowAttachSelf") == null || !System.getProperty("jdk.attach.allowAttachSelf").equals("true")) {
            throw new RuntimeException("Cannot load the FLUID agent without jvm argument -Djdk.attach.allowAttachSelf=true");
        }
        log.debug("Loading FLUID agent... Searching for its jar...");
        if (!closed && warn) {
            log.warn("Fluid agent is loading, but the FLUID API was not closed, this is unrecommended and unsafe, you can use Fluid.noAgentlog.warn() to ignore this message");
        }
        try {
            log.debug("Initialize FLUID API...");
            FluidAgent.initialize();
            log.debug("Attaching to vm with PID " + Long.toString(ProcessHandle.current().pid()) + " (self)...");
            VirtualMachine vm = VirtualMachine.attach(Long.toString(ProcessHandle.current().pid()));
            log.debug("Finding jar path...");
            String path = new File(FluidAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalPath();
            log.debug("Path: " + path);
            if (System.getProperty("cyanAgentJar") != null && !path.endsWith(".jar")) {
                path = System.getProperty("cyanAgentJar");
                log.debug("OVERRIDE FROM COMMAND LINE, New path: " + path);
            }
            log.debug("Loading agent...");
            vm.loadAgent(path);
            log.debug("Detaching from VM...");
            vm.detach();
            log.debug("Done.");
        }
        catch (AgentInitializationException | AgentLoadException | AttachNotSupportedException | IOException | URISyntaxException e) {
            log.error("Failed to load agent", (Throwable)e);
        }
    }

    public static FluidMemberRemapper createMemberRemapper(DeobfuscationTargetMap mp) {
        return new FluidMemberRemapper(mp);
    }

    public static FluidClassRemapper createClassRemapper(DeobfuscationTargetMap mp) {
        return new FluidClassRemapper(mp);
    }

    public static DeobfuscationTargetMap createTargetMap(ClassNode[] classes, FluidClassPool pool, Mapping<?> ... mappings) {
        DeobfuscationTargetMap mp = new DeobfuscationTargetMap();
        int threads = Integer.getInteger("fluid.mapping.threads.count", Runtime.getRuntime().availableProcessors());
        ArrayList<MapDat[]> batches = new ArrayList<MapDat[]>();
        log.info("FLUID uses a multi-threaded mapping system, " + threads + " threads are being used.");
        int done = 0;
        MapDat[] currentBatch = new MapDat[threads];
        for (ClassNode cls : classes) {
            for (Mapping<?> root : mappings) {
                for (Mapping<?> clsMapping : root.mappings) {
                    if (clsMapping.mappingType != MAPTYPE.CLASS || !clsMapping.obfuscated.equals(cls.name.replace("/", "."))) continue;
                    currentBatch[done++] = new MapDat(cls, root, clsMapping);
                    if (done != threads) continue;
                    batches.add(currentBatch);
                    currentBatch = new MapDat[threads];
                    done = 0;
                }
            }
        }
        if (done != threads) {
            batches.add(currentBatch);
        }
        done = 0;
        int i = 0;
        for (MapDat[] batch : batches) {
            boolean running;
            int thc = 1;
            Thread[] threadInstances = new Thread[threads];
            for (MapDat dat : batch) {
                Thread th;
                if (dat == null) continue;
                int n = thc++;
                threadInstances[thc - 2] = th = new Thread(() -> {
                    Mapping<?> root = dat.root;
                    Mapping<?> clsMapping = dat.clsMapping;
                    ClassNode cls = dat.cls;
                    DeobfuscationTarget target = new DeobfuscationTarget();
                    target.jvmName = clsMapping.name.replaceAll("\\.", "/");
                    target.outputName = clsMapping.name;
                    block4: for (MethodNode method : cls.methods) {
                        Object str = "";
                        String desc = method.desc;
                        Object[] types = Fluid.parseMultipleDescriptors(desc.substring(1).substring(0, desc.substring(1).lastIndexOf(")")));
                        for (int index = 0; index < types.length; ++index) {
                            Mapping<?> mp2;
                            String type = types[index];
                            String tSuffix = "";
                            if (type.contains("[]")) {
                                tSuffix = type.substring(type.indexOf("["));
                                type = type.substring(0, type.indexOf("["));
                            }
                            if ((mp2 = root.mapClassToMapping(type, t -> true, true)) != null) {
                                types[index] = mp2.name + tSuffix;
                            }
                            str = ((String)str).equals("") ? type + tSuffix : (String)str + ", " + type + tSuffix;
                        }
                        for (Mapping<?> methodMap : clsMapping.mappings) {
                            if (!methodMap.mappingType.equals((Object)MAPTYPE.METHOD) || !methodMap.obfuscated.equals(method.name) || !Arrays.equals(types, methodMap.argumentTypes)) continue;
                            target.methods.put(methodMap.obfuscated + " " + method.desc, methodMap.name);
                            continue block4;
                        }
                    }
                    block7: for (FieldNode field : cls.fields) {
                        for (Mapping<?> fieldMap : clsMapping.mappings) {
                            if (!fieldMap.mappingType.equals((Object)MAPTYPE.PROPERTY) || !fieldMap.obfuscated.equals(field.name)) continue;
                            target.fields.put(fieldMap.obfuscated + " " + field.desc, fieldMap.name);
                            continue block7;
                        }
                    }
                    if (cls.superName != null && !cls.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) {
                        try {
                            Fluid.mapSuperAndInterfaces(root, mp, target, pool.getClassNode(cls.superName), pool);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    for (String inter : cls.interfaces) {
                        try {
                            Fluid.mapSuperAndInterfaces(root, mp, target, pool.getClassNode(inter), pool);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    mp.put(clsMapping.obfuscated.replaceAll("\\.", "/"), target);
                }, "FLUID Mapper Thread #" + n);
                th.setDaemon(true);
                th.start();
            }
            block5: do {
                running = false;
                for (Thread th : threadInstances) {
                    if (th == null || !th.isAlive()) continue;
                    running = true;
                    continue block5;
                }
            } while (running);
            if (i % 100 == 0) {
                log.info("Mapped " + i + "/" + classes.length + " classes.");
            }
            if (i + threads <= classes.length) {
                i += threads;
                continue;
            }
            i = classes.length;
        }
        log.info("Mapped " + classes.length + "/" + classes.length + " classes.");
        return mp;
    }

    public static DeobfuscationTargetMap deobfuscate(FluidClassPool pool) {
        return Fluid.deobfuscate(pool, (Mapping[])loadedMappings.toArray(Mapping[]::new));
    }

    public static DeobfuscationTargetMap deobfuscate(FluidClassPool pool, Mapping<?> ... mappings) {
        ArrayList<ClassNode> nodes = new ArrayList<ClassNode>();
        for (Mapping<?> root : mappings) {
            for (Mapping<?> clsMapping : root.mappings) {
                if (clsMapping.mappingType != MAPTYPE.CLASS) continue;
                try {
                    nodes.add(pool.getClassNode(clsMapping.obfuscated));
                }
                catch (ClassNotFoundException e) {
                    log.warn("Could not load " + clsMapping.obfuscated + ", the class could not be found.");
                }
            }
        }
        ClassNode[] classes = (ClassNode[])nodes.toArray(ClassNode[]::new);
        DeobfuscationTargetMap mp = Fluid.createTargetMap(classes, pool, mappings);
        Fluid.deobfuscate(classes, pool, mappings);
        return mp;
    }

    public static void deobfuscate(ClassNode cls, FluidClassPool pool) {
        Fluid.deobfuscate(cls, pool, (Mapping[])loadedMappings.toArray(Mapping[]::new));
    }

    public static void deobfuscate(ClassNode[] classes, FluidClassPool pool) {
        Fluid.deobfuscate(classes, pool, (Mapping[])loadedMappings.toArray(Mapping[]::new));
    }

    public static void deobfuscate(ClassNode cls, FluidClassPool pool, Mapping<?> ... mappings) {
        try {
            Optional<Mapping> clsMapping = null;
            Mapping root = Stream.of(mappings).filter(t -> Stream.of(t.mappings).anyMatch(t2 -> t2.mappingType.equals((Object)MAPTYPE.CLASS) && t2.obfuscated.equals(cls.name.replaceAll("/", ".")))).findFirst().get();
            clsMapping = Stream.of(root.mappings).filter(t2 -> t2.mappingType.equals((Object)MAPTYPE.CLASS) && t2.obfuscated.equals(cls.name.replaceAll("/", "."))).findFirst();
            if (clsMapping.isEmpty()) {
                return;
            }
            Fluid.deobfuscate(root, clsMapping.get(), cls, pool);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deobfuscate(ClassNode[] classes, FluidClassPool pool, Mapping<?> ... mappings) {
        int length = 0;
        for (ClassNode cls : classes) {
            Optional<Mapping> root = Stream.of(mappings).filter(t -> Stream.of(t.mappings).anyMatch(t2 -> t2.mappingType.equals((Object)MAPTYPE.CLASS) && t2.obfuscated.equals(cls.name.replaceAll("/", ".")))).findFirst();
            if (root.isEmpty()) continue;
            ++length;
        }
        int i = 0;
        for (ClassNode cls : classes) {
            try {
                Optional<Mapping> clsMapping = null;
                Optional<Mapping> root = Stream.of(mappings).filter(t -> Stream.of(t.mappings).anyMatch(t2 -> t2.mappingType.equals((Object)MAPTYPE.CLASS) && t2.obfuscated.equals(cls.name.replaceAll("/", ".")))).findFirst();
                if (root.isEmpty() || (clsMapping = Stream.of(root.get().mappings).filter(t2 -> t2.mappingType.equals((Object)MAPTYPE.CLASS) && t2.obfuscated.equals(cls.name.replaceAll("/", "."))).findFirst()).isEmpty()) continue;
                Fluid.deobfuscate(root.get(), clsMapping.get(), cls, pool);
                if (i % 100 == 0) {
                    log.info("Deobfuscated " + i + "/" + length + " classes.");
                }
            }
            catch (Exception e) {
                log.error("Failed to deobfuscate " + cls.name.replaceAll("/", "."), (Throwable)e);
            }
            ++i;
        }
        log.info("Deobfuscated " + length + "/" + length + " classes.");
    }

    static void mapSuperAndInterfaces(Mapping<?> root, DeobfuscationTargetMap mp, DeobfuscationTarget target, ClassNode cls, FluidClassPool pool) {
        for (Mapping<?> clsMapping : root.mappings) {
            if (!clsMapping.obfuscated.equals(cls.name.replaceAll("/", "."))) continue;
            block5: for (MethodNode method : cls.methods) {
                if (Modifier.isPrivate(method.access)) continue;
                Object str = "";
                String desc = method.desc;
                Object[] types = Fluid.parseMultipleDescriptors(desc.substring(1).substring(0, desc.substring(1).lastIndexOf(")")));
                for (int index = 0; index < types.length; ++index) {
                    Mapping<?> mp2;
                    String type = types[index];
                    String tSuffix = "";
                    if (type.contains("[]")) {
                        tSuffix = type.substring(type.indexOf("["));
                        type = type.substring(0, type.indexOf("["));
                    }
                    if ((mp2 = root.mapClassToMapping(type, t -> true, true)) != null) {
                        types[index] = mp2.name + tSuffix;
                    }
                    str = ((String)str).equals("") ? type + tSuffix : (String)str + ", " + type + tSuffix;
                }
                for (Mapping<?> methodMap : clsMapping.mappings) {
                    if (!methodMap.mappingType.equals((Object)MAPTYPE.METHOD) || Modifier.isPrivate(method.access) || !methodMap.obfuscated.equals(method.name) || !Arrays.equals(types, methodMap.argumentTypes)) continue;
                    if (target.methods.containsKey(methodMap.obfuscated + " " + method.desc) && !root.allowSupertypeFinalOverride()) continue block5;
                    target.methods.put(methodMap.obfuscated + " " + method.desc, methodMap.name);
                    continue block5;
                }
            }
            block8: for (FieldNode field : cls.fields) {
                if (Modifier.isPrivate(field.access)) continue;
                for (Mapping<?> fieldMap : clsMapping.mappings) {
                    if (!fieldMap.mappingType.equals((Object)MAPTYPE.PROPERTY) || Modifier.isPrivate(field.access) || !fieldMap.obfuscated.equals(field.name)) continue;
                    if (target.fields.containsKey(fieldMap.obfuscated + " " + field.desc) && !root.allowSupertypeFinalOverride()) continue block8;
                    target.fields.put(fieldMap.obfuscated + " " + field.desc, fieldMap.name);
                    continue block8;
                }
            }
            if (cls.superName != null && !cls.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) {
                try {
                    Fluid.mapSuperAndInterfaces(root, mp, target, pool.getClassNode(cls.superName), pool);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            for (String inter : cls.interfaces) {
                try {
                    Fluid.mapSuperAndInterfaces(root, mp, target, pool.getClassNode(inter), pool);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            break;
        }
    }

    public static void deobfuscate(Mapping<?> root, Mapping<?> clsMapping, ClassNode cls, FluidClassPool pool) {
        log.trace("DEOBFUSCATE class: " + cls.name.replaceAll("/", "."));
        block0: for (MethodNode method : cls.methods) {
            Object str = "";
            String desc = method.desc;
            Object[] types = Fluid.parseMultipleDescriptors(desc.substring(1).substring(0, desc.substring(1).lastIndexOf(")")));
            for (int index = 0; index < types.length; ++index) {
                Mapping<?> mp2;
                String type = types[index];
                String tSuffix = "";
                if (type.contains("[]")) {
                    tSuffix = type.substring(type.indexOf("["));
                    type = type.substring(0, type.indexOf("["));
                }
                if ((mp2 = root.mapClassToMapping(type, t -> true, true)) != null) {
                    types[index] = mp2.name + tSuffix;
                }
                str = ((String)str).equals("") ? type + tSuffix : (String)str + ", " + type + tSuffix;
            }
            for (Mapping<?> methodMap : clsMapping.mappings) {
                if (!methodMap.mappingType.equals((Object)MAPTYPE.METHOD) || !methodMap.obfuscated.equals(method.name) || !Arrays.equals(types, methodMap.argumentTypes)) continue;
                log.trace("DEOBFUSCATE method " + methodMap.obfuscated + " (" + (String)str + ") into " + methodMap.name);
                method.name = methodMap.name;
                continue block0;
            }
        }
        block3: for (FieldNode field : cls.fields) {
            for (Mapping<?> fieldMap : clsMapping.mappings) {
                if (!fieldMap.mappingType.equals((Object)MAPTYPE.PROPERTY) || !fieldMap.obfuscated.equals(field.name)) continue;
                log.trace("DEOBFUSCATE field " + fieldMap.obfuscated + " into " + fieldMap.name);
                field.name = fieldMap.name;
                continue block3;
            }
        }
        cls.name = clsMapping.name.replaceAll("\\.", "/");
        log.trace("DEOBFUSCATED " + clsMapping.name + ", remapping required for name change");
    }

    public static ClassNode remapClass(FluidClassRemapper remapper, FluidClassPool pool, ClassNode cls) {
        log.trace("REMAP " + cls.name + ", caller: " + CallTrace.traceCallName());
        ClassWriter writer = new ClassWriter(0);
        ClassRemapper clremapper = new ClassRemapper((ClassVisitor)writer, (Remapper)remapper);
        cls.accept((ClassVisitor)clremapper);
        try {
            pool.detachClass(cls.name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        cls = pool.readClass(cls.name, writer.toByteArray());
        return cls;
    }

    public static ClassNode remapClassMembers(FluidMemberRemapper remapper, FluidClassPool pool, ClassNode cls) {
        log.trace("REMAP " + cls.name + ", caller: " + CallTrace.traceCallName());
        for (MethodNode meth : cls.methods) {
            MethodNode newNode = new MethodNode();
            newNode.desc = meth.desc;
            newNode.name = meth.name;
            newNode.exceptions = meth.exceptions;
            newNode.parameters = meth.parameters;
            newNode.access = meth.access;
            FluidMemberRemapper.FluidMemberVisitor methremapper = new FluidMemberRemapper.FluidMemberVisitor((MethodVisitor)newNode, remapper);
            meth.accept((MethodVisitor)methremapper);
            meth.instructions = newNode.instructions;
            meth.tryCatchBlocks = newNode.tryCatchBlocks;
            meth.exceptions = newNode.exceptions;
            meth.parameters = newNode.parameters;
            meth.localVariables = newNode.localVariables;
        }
        return cls;
    }

    public static void remapClasses(FluidMemberRemapper memberRemapper, FluidClassRemapper classRemapper, FluidClassPool pool, ClassNode[] classesArray) {
        int i = 0;
        log.info("Remapping class members...");
        for (ClassNode cls : classesArray) {
            Fluid.remapClassMembers(memberRemapper, pool, cls);
            if (i % 100 == 0) {
                log.info("Remapped " + i + "/" + classesArray.length + " classes.");
            }
            ++i;
        }
        log.info("Remapped " + classesArray.length + "/" + classesArray.length + " classes.");
        i = 0;
        log.info("Remapping class references...");
        for (ClassNode cls : classesArray) {
            Fluid.remapClass(classRemapper, pool, cls);
            if (i % 100 == 0) {
                log.info("Remapped " + i + "/" + classesArray.length + " classes.");
            }
            ++i;
        }
        log.info("Remapped " + classesArray.length + "/" + classesArray.length + " classes.");
    }

    static Runnable[] getPostInitHooks() {
        return (Runnable[])postInitHooks.toArray(Runnable[]::new);
    }

    public static void addAgent(String agentClass, String agentEntry) {
        if (closed) {
            throw new IllegalStateException("Cannot register transformers after FLUID has been closed or before it has been opened!");
        }
        extraAgents.put(agentClass, agentEntry);
    }

    public static HashMap<String, String> getAgents() {
        return (HashMap)extraAgents.clone();
    }

    public static File getDumpDir() {
        return dumpDir;
    }

    public static void registerAllTransformersFrom(FluidClassPool pool) {
        if (closed || beforeLoad) {
            throw new IllegalStateException("Cannot register transformers after FLUID has been closed or before it has been opened!");
        }
        for (ClassNode node : pool.getLoadedClasses()) {
            if (!Transformer.AnnotationInfo.isAnnotationPresent(FluidTransformer.class, node)) continue;
            String owner = CallTrace.traceCallName(1);
            String simpleName = node.name.replaceAll("/", ".");
            if (simpleName.contains(".")) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
            }
            log.info("Loading transformer " + simpleName + "...");
            transformerPool.readClass(node.name.replaceAll("/", "."), pool.getByteCode(node.name));
            loadedTransformers.put(node.name.replaceAll("/", "."), owner);
        }
    }

    private static /* synthetic */ boolean lambda$mapProperty$13(String pName, Mapping t2) {
        return t2.mappingType == MAPTYPE.PROPERTY && t2.name.equals(pName);
    }

    private static /* synthetic */ boolean lambda$mapMethod$10(String mName, String[] methodParameters, Mapping t2) {
        return t2.mappingType == MAPTYPE.METHOD && t2.name.equals(mName) && Arrays.equals(t2.argumentTypes, methodParameters);
    }

    protected static class CallTrace {
        private static ClassLoader traceLoader = ClassLoader.getPlatformClassLoader();

        protected CallTrace() {
        }

        public static void setCallTraceClassLoader(ClassLoader loader) {
            traceLoader = loader;
        }

        public static Class<?> traceCall() {
            return CallTrace.traceCall(0);
        }

        public static Class<?> traceCall(int minimumDepth) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            int depth = 0;
            for (StackTraceElement element : stack) {
                block8: {
                    if (depth < minimumDepth + 2) {
                        ++depth;
                        continue;
                    }
                    try {
                        Class<?> cls;
                        if (element.getClassName().equals(Thread.class.getTypeName()) || element.getClassName().equals(CallTrace.class.getTypeName())) break block8;
                        try {
                            cls = traceLoader.loadClass(element.getClassName());
                        }
                        catch (ClassNotFoundException e) {
                            try {
                                cls = Class.forName(element.getClassName());
                            }
                            catch (ClassNotFoundException e2) {
                                continue;
                            }
                        }
                        return cls;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++depth;
            }
            return null;
        }

        public static String traceCallName() {
            return CallTrace.traceCall(1).getSimpleName();
        }

        public static String traceCallName(int minimumDepth) {
            return CallTrace.traceCall(minimumDepth + 1).getSimpleName();
        }
    }

    private static class MapDat {
        public ClassNode cls;
        public Mapping<?> root;
        public Mapping<?> clsMapping;

        public MapDat(ClassNode cls, Mapping<?> root, Mapping<?> clsMapping) {
            this.cls = cls;
            this.root = root;
            this.clsMapping = clsMapping;
        }
    }
}

