/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.ContentSource;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.achievements.impl.AchievementManagerImpl;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.common.services.messages.impl.WsMessageServiceImpl;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.commonapi.config.CommonApiServerConfig;
import org.asf.edge.commonapi.events.server.CommonApiServerSetupEvent;
import org.asf.edge.commonapi.events.server.CommonApiServerStartupEvent;
import org.asf.edge.commonapi.http.CaseInsensitiveContentSource;
import org.asf.edge.commonapi.http.handlers.api.accounts.AuthenticationWebServiceV1Processor;
import org.asf.edge.commonapi.http.handlers.api.accounts.AuthenticationWebServiceV3Processor;
import org.asf.edge.commonapi.http.handlers.api.accounts.MembershipWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.api.accounts.ProfileWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.api.accounts.RegistrationWebServiceV3Processor;
import org.asf.edge.commonapi.http.handlers.api.accounts.RegistrationWebServiceV4Processor;
import org.asf.edge.commonapi.http.handlers.api.accounts.SubscriptionWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.api.avatars.AvatarWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.api.core.ConfigurationWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.api.messaging.ChatWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.api.messaging.MessagingWebServiceProcessor;
import org.asf.edge.commonapi.http.handlers.internal.AccountManagerAPI;
import org.asf.edge.commonapi.http.handlers.internal.CommonDataManagerAPI;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeCommonApiServer
implements IBaseServer {
    public static final String COMMON_API_VERSION = "1.0.0.A2";
    private Logger logger;
    private CommonApiServerConfig config;
    private ConnectiveHttpServer server;
    private ConnectiveHttpServer internalServer;
    private long lastRestartTime;
    private long lastShutdownTime;

    public String getVersion() {
        return COMMON_API_VERSION;
    }

    static void printSplash() {
        System.out.println("-------------------------------------------------------------");
        System.out.println("                                                             ");
        System.out.println("    EDGE - Fan-made server software for School of Dragons    ");
        System.out.println("             Common API Server Version: 1.0.0.A2             ");
        System.out.println("                                                             ");
        System.out.println("-------------------------------------------------------------");
        System.out.println("");
        System.out.println("This server implements the following endpoints:");
        System.out.println(" - common.api.jumpstart.com");
        System.out.println(" - user.api.jumpstart.com");
        System.out.println("");
    }

    public EdgeCommonApiServer(CommonApiServerConfig config) {
        this.config = config;
        this.logger = LogManager.getLogger((String)"COMMONAPI");
    }

    public ConnectiveHttpServer getServer() {
        return this.server;
    }

    public ConnectiveHttpServer getInternalServer() {
        return this.internalServer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CommonApiServerConfig getConfiguration() {
        return this.config;
    }

    public void setupServer() throws IOException {
        HashMap<String, String> props;
        if (this.config.server == null) {
            if (this.config.https) {
                props = new HashMap<String, String>();
                props.put("address", this.config.listenAddress);
                props.put("port", Integer.toString(this.config.listenPort));
                props.put("keystore", this.config.tlsKeystore);
                props.put("keystore-password", this.config.tlsKeystorePassword);
                this.config.server = ConnectiveHttpServer.createNetworked((String)"HTTPS/1.1", props);
                this.logger.info("Edge common api HTTPS server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
            } else {
                props = new HashMap();
                props.put("address", this.config.listenAddress);
                props.put("port", Integer.toString(this.config.listenPort));
                this.config.server = ConnectiveHttpServer.createNetworked((String)"HTTP/1.1", props);
                this.logger.info("Edge common api HTTP server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
            }
        }
        if (this.config.internalServer == null) {
            if (this.config.httpsInternal) {
                props = new HashMap();
                props.put("address", this.config.internalListenAddress);
                props.put("port", Integer.toString(this.config.internalListenPort));
                props.put("keystore", this.config.tlsKeystoreInternal);
                props.put("keystore-password", this.config.tlsKeystorePasswordInternal);
                this.config.internalServer = ConnectiveHttpServer.createNetworked((String)"HTTPS/1.1", props);
                this.logger.info("Edge common api internal HTTPS server created with listen address " + this.config.internalListenAddress + " and port " + this.config.internalListenPort);
            } else {
                props = new HashMap();
                props.put("address", this.config.internalListenAddress);
                props.put("port", Integer.toString(this.config.internalListenPort));
                this.config.internalServer = ConnectiveHttpServer.createNetworked((String)"HTTP/1.1", props);
                this.logger.info("Edge common api internal HTTP server created with listen address " + this.config.internalListenAddress + " and port " + this.config.internalListenPort);
            }
        }
        this.server = this.config.server;
        this.internalServer = this.config.internalServer;
        this.logger.debug("Adding case-insensitive content sources...");
        this.server.setContentSource((ContentSource)new CaseInsensitiveContentSource());
        this.internalServer.setContentSource((ContentSource)new CaseInsensitiveContentSource());
        this.logger.debug("Dispatching event...");
        EventBus.getInstance().dispatchEvent((EventObject)new CommonApiServerSetupEvent(this.config, this));
        this.logger.debug("Configuring api server request handlers...");
        this.server.registerProcessor((HttpPushProcessor)new ChatWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new MessagingWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new MembershipWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new ConfigurationWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new AuthenticationWebServiceV1Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new AuthenticationWebServiceV3Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new AvatarWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new SubscriptionWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new RegistrationWebServiceV3Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new RegistrationWebServiceV4Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new ProfileWebServiceProcessor(this));
        this.logger.debug("Configuring internal server request handlers...");
        this.internalServer.registerProcessor((HttpPushProcessor)new AccountManagerAPI(this));
        this.internalServer.registerProcessor((HttpPushProcessor)new CommonDataManagerAPI(this));
        this.logger.info("Setting up achievement manager...");
        ServiceManager.registerServiceImplementation(AchievementManager.class, (AbstractService)new AchievementManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(AchievementManager.class);
        this.logger.info("Setting up item manager...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        this.logger.info("Setting up message service...");
        ServiceManager.registerServiceImplementation(WsMessageService.class, (AbstractService)new WsMessageServiceImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(WsMessageService.class);
        this.logger.info("Loading text filter...");
        TextFilterService.getInstance();
        this.logger.info("Starting shutdown and restart watchdog...");
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("EDGECOMMON");
        try {
            if (!cont.entryExists("shutdown")) {
                this.lastShutdownTime = System.currentTimeMillis();
                cont.setEntry("shutdown", (JsonElement)new JsonPrimitive((Number)this.lastShutdownTime));
            } else {
                this.lastShutdownTime = cont.getEntry("shutdown").getAsLong();
            }
            if (!cont.entryExists("restart")) {
                this.lastRestartTime = System.currentTimeMillis();
                cont.setEntry("restart", (JsonElement)new JsonPrimitive((Number)this.lastRestartTime));
            } else {
                this.lastRestartTime = cont.getEntry("restart").getAsLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    long shutdown = cont.getEntry("shutdown").getAsLong();
                    if (shutdown > this.lastShutdownTime && this.isRunning()) {
                        this.stopServer();
                        break;
                    }
                    long restart = cont.getEntry("restart").getAsLong();
                    if (restart > this.lastRestartTime && this.isRunning()) {
                        CommonInit.restartPending = true;
                        this.stopServer();
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    public void startServer() throws IOException {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (this.server.isRunning()) {
            throw new IllegalArgumentException("Server is already running");
        }
        this.logger.info("Starting the Common API server...");
        this.server.start();
        this.logger.info("Common API server started successfully!");
        this.logger.info("Starting the Common API internal server...");
        this.internalServer.start();
        EventBus.getInstance().dispatchEvent((EventObject)new CommonApiServerStartupEvent(this.config, this));
        this.logger.info("Common API internal server started successfully!");
    }

    public void stopServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Shutting down the Common API server...");
        try {
            this.server.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Common API server stopped successfully!");
        this.logger.info("Shutting down the Common API internal server...");
        try {
            this.internalServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Common API internal server stopped successfully!");
    }

    public void killServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Forcefully shutting down the Common API server!");
        try {
            this.server.stopForced();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Common API server stopped successfully!");
        this.logger.info("Forcefully shutting down the Common API internal server!");
        try {
            this.internalServer.stopForced();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Common API internal server stopped successfully!");
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isRunning();
    }

    public void waitForExit() {
        this.server.waitForExit();
        this.internalServer.waitForExit();
    }
}

