/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.util.SimpleBinaryMessageClient;
import org.asf.edge.commonapi.EdgeCommonApiServer;

public class CommonDataManagerAPI
extends EdgeWebService<EdgeCommonApiServer> {
    private CommonDataManager manager;

    public CommonDataManagerAPI(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new CommonDataManagerAPI((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/commondatamanager";
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setupContainer(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        this.manager.getContainer(payload.get("node").getAsString());
        resp.addProperty("success", Boolean.valueOf(true));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("key")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            JsonElement val = data.unsafeAccessor().get(payload.get("key").getAsString());
            resp.addProperty("success", Boolean.valueOf(val != null));
            if (val != null) {
                resp.add("entryValue", val);
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("node") && payload.has("key") && payload.has("value"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            data.unsafeAccessor().set(payload.get("key").getAsString(), payload.get("value"));
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void createDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("node") && payload.has("key") && payload.has("parent") && payload.has("value"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            data.unsafeAccessor().create(payload.get("key").getAsString(), payload.get("parent").getAsString(), payload.get("value"));
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void dataEntryExists(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("key")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            resp.addProperty("result", Boolean.valueOf(data.unsafeAccessor().exists(payload.get("key").getAsString())));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void deleteDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("key")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            data.unsafeAccessor().delete(payload.get("key").getAsString());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult deleteContainer(FunctionInfo func) throws IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            data.unsafeAccessor().deleteContainer(payload.get("root").getAsString());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult getChildContainers(FunctionInfo func) throws IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("key")) {
            return this.response(400, "Bad request");
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            String[] containers = data.unsafeAccessor().getChildContainers(payload.get("key").getAsString());
            JsonArray arr = new JsonArray();
            for (String cont : containers) {
                arr.add(cont);
            }
            resp.addProperty("success", Boolean.valueOf(true));
            resp.add("result", (JsonElement)arr);
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult getEntryKeys(FunctionInfo func) throws IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("key")) {
            return this.response(400, "Bad request");
        }
        CommonDataContainer data = this.manager.getContainer(payload.get("node").getAsString());
        JsonObject resp = new JsonObject();
        if (data != null) {
            String[] keys = data.unsafeAccessor().getEntryKeys(payload.get("key").getAsString());
            JsonArray arr = new JsonArray();
            for (String cont : keys) {
                arr.add(cont);
            }
            resp.addProperty("success", Boolean.valueOf(true));
            resp.add("result", (JsonElement)arr);
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult runForChildren(FunctionInfo func) throws IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/CDATAMANAGER/RUNFORCHILDREN")) {
            return this.response(400, "Bad request");
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/CDATAMANAGER/RUNFORCHILDREN");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                try {
                    this.manager.getContainer(payload.get("node").getAsString()).unsafeAccessor().runForChildren(t -> {
                        boolean res = true;
                        client.container = null;
                        try {
                            client.send(t.getBytes("UTF-8"));
                        }
                        catch (IOException e) {
                            return false;
                        }
                        while (client.container == null && client.isConnected()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (client.container == null) {
                            return false;
                        }
                        res = ((FuncResult)client.container).continueRun;
                        return res;
                    }, payload.get("root").getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult runFor(FunctionInfo func) throws IOException {
        if (this.manager == null) {
            this.manager = CommonDataManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/CDATAMANAGER/RUNFOR")) {
            return this.response(400, "Bad request");
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("node") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/CDATAMANAGER/RUNFOR");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                try {
                    this.manager.getContainer(payload.get("node").getAsString()).unsafeAccessor().runFor((name, data) -> {
                        boolean res = true;
                        client.container = null;
                        try {
                            ByteArrayOutputStream resD = new ByteArrayOutputStream();
                            byte[] b = name.getBytes("UTF-8");
                            resD.write(ByteBuffer.allocate(4).putInt(b.length).array());
                            resD.write(b);
                            b = data.toString().getBytes("UTF-8");
                            resD.write(ByteBuffer.allocate(4).putInt(b.length).array());
                            resD.write(b);
                            client.send(resD.toByteArray());
                        }
                        catch (IOException e) {
                            return false;
                        }
                        while (client.container == null && client.isConnected()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (client.container == null) {
                            return false;
                        }
                        res = ((FuncResult)client.container).continueRun;
                        return res;
                    }, payload.get("root").getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    private class FuncResult {
        public boolean continueRun;

        private FuncResult() {
        }
    }
}

