/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.accounts;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.xmls.auth.CommonLoginInfo;
import org.asf.edge.commonapi.xmls.auth.LoginStatusType;
import org.asf.edge.commonapi.xmls.auth.ParentLoginResponseData;
import org.asf.edge.commonapi.xmls.auth.RegistrationResultData;
import org.asf.edge.commonapi.xmls.registration.ParentRegistrationData;

public class RegistrationWebServiceV3Processor
extends EdgeWebService<EdgeCommonApiServer> {
    private static AccountManager manager;
    public static final int COST_DELETE_PROFILE = 50;

    public RegistrationWebServiceV3Processor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new RegistrationWebServiceV3Processor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/v3/RegistrationWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void deleteProfile(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userID");
        AccountSaveContainer save = account.getSave(userID);
        if (save == null) {
            this.setResponseContent("text/xml", req.generateXmlValue("DeleteProfileStatus", (Object)"PROFILE_NOT_FOUND"));
            return;
        }
        AccountDataContainer currencyAccWide = account.getAccountData().getChildContainer("currency");
        int current = 0;
        if (currencyAccWide.entryExists("gems")) {
            current = currencyAccWide.getEntry("gems").getAsInt();
        }
        if (current < 50) {
            this.setResponseContent("text/xml", req.generateXmlValue("DeleteProfileStatus", (Object)"IN_SUFFICIENT_VCASH_FUNDS"));
            return;
        }
        currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(current -= 50)));
        save.deleteSave();
        this.setResponseContent("text/xml", req.generateXmlValue("DeleteProfileStatus", (Object)"SUCCESS"));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void registerParent(LegacyFunctionInfo func) throws IOException {
        AccountObject acc;
        RegistrationResultData resp;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String registrationData = req.getEncryptedValue("parentRegistrationData");
        ParentRegistrationData registration = (ParentRegistrationData)req.parseXmlValue(registrationData, ParentRegistrationData.class);
        if (registration.userPolicy == null || !registration.userPolicy.termsAndConditions || !registration.userPolicy.privacyPolicy) {
            RegistrationResultData resp2 = new RegistrationResultData();
            resp2.status = LoginStatusType.UserPolicyNotAccepted;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp2)));
            return;
        }
        if (registration.childList == null || registration.childList.length < 1) {
            RegistrationResultData resp3 = new RegistrationResultData();
            resp3.status = LoginStatusType.NoChildData;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp3)));
            return;
        }
        if (!manager.isValidUsername(registration.childList[0].childName)) {
            RegistrationResultData resp4 = new RegistrationResultData();
            resp4.status = LoginStatusType.InvalidUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp4)));
            return;
        }
        if (TextFilterService.getInstance().isFiltered(registration.childList[0].childName, true)) {
            RegistrationResultData resp5 = new RegistrationResultData();
            resp5.status = LoginStatusType.InvalidUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp5)));
            return;
        }
        if (!manager.isValidPassword(registration.password)) {
            RegistrationResultData resp6 = new RegistrationResultData();
            resp6.status = LoginStatusType.InvalidPassword;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp6)));
            return;
        }
        String guestID = null;
        if (registration.childList.length >= 2) {
            if (!registration.childList[1].isGuest) {
                RegistrationResultData resp7 = new RegistrationResultData();
                resp7.status = LoginStatusType.InvalidGuestChildUserName;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp7)));
                return;
            }
            registration.childList[1].guestUserName = req.decryptString(registration.childList[1].guestUserName);
            guestID = registration.childList[1].guestUserName;
            if (guestID.length() != 72 || !guestID.matches("^[A-Za-z0-9\\-]+")) {
                RegistrationResultData resp8 = new RegistrationResultData();
                resp8.status = LoginStatusType.InvalidGuestChildUserName;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp8)));
                return;
            }
            if (manager.getGuestAccount(guestID) == null) {
                RegistrationResultData resp9 = new RegistrationResultData();
                resp9.status = LoginStatusType.GuestAccountNotFound;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp9)));
                return;
            }
        }
        if (!registration.email.toLowerCase().matches("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])")) {
            RegistrationResultData resp10 = new RegistrationResultData();
            resp10.status = LoginStatusType.InvalidEmail;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp10)));
            return;
        }
        if (manager.getAccountIDByEmail(registration.email) != null) {
            RegistrationResultData resp11 = new RegistrationResultData();
            resp11.status = LoginStatusType.DuplicateEmail;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp11)));
            return;
        }
        if (guestID != null) {
            AccountObject guestAcc = manager.getGuestAccount(guestID);
            boolean nameFound = false;
            for (String id : guestAcc.getSaveIDs()) {
                if (!guestAcc.getSave(id).getUsername().equalsIgnoreCase(registration.childList[0].childName)) continue;
                nameFound = true;
                break;
            }
            if (!nameFound && manager.isUsernameTaken(registration.childList[0].childName)) {
                resp = new RegistrationResultData();
                resp.status = LoginStatusType.DuplicateUserName;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
                return;
            }
        } else if (manager.isUsernameTaken(registration.childList[0].childName)) {
            RegistrationResultData resp12 = new RegistrationResultData();
            resp12.status = LoginStatusType.DuplicateUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp12)));
            return;
        }
        if (guestID != null) {
            AccountObject guestAcc = manager.getGuestAccount(guestID);
            if (guestAcc == null) {
                resp = new RegistrationResultData();
                resp.status = LoginStatusType.GuestAccountNotFound;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
                return;
            }
            if (!guestAcc.migrateToNormalAccountFromGuest(registration.childList[0].childName, registration.email, registration.password.toCharArray())) {
                resp = new RegistrationResultData();
                resp.status = LoginStatusType.GuestAccountNotFound;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
                return;
            }
            AccountDataContainer cont = guestAcc.getAccountData().getChildContainer("accountdata");
            cont.setEntry("sendupdates", (JsonElement)new JsonPrimitive(Boolean.valueOf(registration.emailNotification == 1)));
            cont.setEntry("isunderage", (JsonElement)new JsonPrimitive(Boolean.valueOf(registration.childList[0].age < 13)));
            if (registration.childList[0].age < 13) {
                guestAcc.setChatEnabled(false);
                guestAcc.setStrictChatFilterEnabled(true);
            }
            acc = guestAcc;
        } else {
            acc = manager.registerAccount(registration.childList[0].childName, registration.email, registration.password.toCharArray());
            if (acc == null) {
                RegistrationResultData resp13 = new RegistrationResultData();
                resp13.status = LoginStatusType.InvalidUserName;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp13)));
                return;
            }
            AccountDataContainer cont = acc.getAccountData().getChildContainer("accountdata");
            cont.setEntry("sendupdates", (JsonElement)new JsonPrimitive(Boolean.valueOf(registration.emailNotification == 1)));
            cont.setEntry("isunderage", (JsonElement)new JsonPrimitive(Boolean.valueOf(registration.childList[0].age < 13)));
            if (registration.childList[0].age < 13) {
                acc.setChatEnabled(false);
                acc.setStrictChatFilterEnabled(true);
            }
        }
        RegistrationResultData resp14 = new RegistrationResultData();
        resp14.status = LoginStatusType.Success;
        resp14.userID = acc.getAccountID();
        AccountDataContainer currencyAccWide = acc.getAccountData().getChildContainer("currency");
        int current = 0;
        if (currencyAccWide.entryExists("gems")) {
            current = currencyAccWide.getEntry("gems").getAsInt();
        }
        currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(current + 75)));
        SessionToken tkn = new SessionToken();
        acc.updateLastLoginTime();
        tkn.accountID = acc.getAccountID();
        tkn.lastLoginTime = acc.getLastLoginTime();
        tkn.capabilities = new String[]{"api"};
        ParentLoginResponseData l = new ParentLoginResponseData();
        l.status = LoginStatusType.Success;
        l.username = acc.getUsername();
        l.apiToken = this.getUtilities().encodeToken(tkn.toTokenString());
        l.email = acc.getAccountEmail();
        l.sendActivationReminder = false;
        l.childList = (CommonLoginInfo[])Stream.of(acc.getSaveIDs()).map(t -> acc.getSave(t)).map(t -> {
            CommonLoginInfo ch = new CommonLoginInfo();
            ch.userID = t.getSaveID();
            ch.username = t.getUsername();
            return ch;
        }).toArray(CommonLoginInfo[]::new);
        resp14.apiToken = tkn.toTokenString();
        resp14.parentLoginInfo = req.generateXmlValue("ParentLoginInfo", (Object)resp14);
        this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp14)));
    }
}

