/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.accounts;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.xmls.auth.LoginStatusType;
import org.asf.edge.commonapi.xmls.auth.UserInfoData;

public class AuthenticationWebServiceV1Processor
extends EdgeWebService<EdgeCommonApiServer> {
    private static AccountManager manager;

    public AuthenticationWebServiceV1Processor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new AuthenticationWebServiceV1Processor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/AuthenticationWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @SodRequest
    @SodTokenSecured
    @Function(value="DeleteAccountNotification")
    public FunctionResult deleteAccount(EdgeWebService.ServiceRequestInfo req, AccountObject account) throws IOException {
        account.deleteAccount();
        return this.ok("text/xml", req.generateXmlValue("MembershipUserStatus", (Object)LoginStatusType.Success));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void isValidApiToken_V2(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        switch (res) {
            case SUCCESS: {
                this.setResponseContent("text/xml", req.generateXmlValue("ApiTokenStatus", (Object)1));
                break;
            }
            case INVALID_DATA: {
                this.setResponseContent("text/xml", req.generateXmlValue("ApiTokenStatus", (Object)3));
                break;
            }
            case LOGGED_IN_ELSEWHERE: {
                this.setResponseContent("text/xml", req.generateXmlValue("ApiTokenStatus", (Object)4));
                break;
            }
            case TOKEN_EXPIRED: {
                this.setResponseContent("text/xml", req.generateXmlValue("ApiTokenStatus", (Object)2));
                break;
            }
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void loginChild(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("parentApiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String saveID = req.getEncryptedValue("childUserID");
        AccountSaveContainer save = account.getSave(saveID);
        if (save == null) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        tkn = new SessionToken();
        tkn.accountID = account.getAccountID();
        tkn.saveID = saveID;
        tkn.lastLoginTime = account.getLastLoginTime();
        tkn.capabilities = new String[]{"api", "gp"};
        ((EdgeCommonApiServer)this.getServerInstance()).getLogger().info("Viking selected for account " + account.getAccountID() + ": selected viking '" + save.getUsername() + "' (ID " + save.getSaveID() + ")");
        save.getAccount().ping(true);
        this.setResponseContent("text/xml", req.generateEncryptedResponse(this.getUtilities().encodeToken(tkn.toTokenString())));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserInfoByApiToken(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        SessionToken tkn = new SessionToken();
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        TokenParseResult res = tkn.parseToken(apiToken);
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountObject account = manager.getAccount(tkn.accountID);
        if (account == null) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (tkn.saveID != null) {
            AccountSaveContainer save = account.getSave(tkn.saveID);
            if (save == null) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            UserInfoData info = new UserInfoData();
            info.userID = save.getSaveID();
            info.parentUserID = account.getAccountID();
            info.username = save.getUsername();
            info.chatEnabled = account.isChatEnabled();
            info.multiplayerEnabled = account.isMultiplayerEnabled();
            info.registrationDate = fmt.format(new Date(account.getRegistrationTimestamp()));
            info.creationDate = fmt.format(new Date(save.getCreationTime()));
            this.setResponseContent("text/xml", req.generateXmlValue("UserInfo", (Object)info));
        } else {
            UserInfoData info = new UserInfoData();
            info.userID = account.getAccountID();
            info.parentUserID = account.getAccountID();
            info.username = account.getUsername();
            info.chatEnabled = account.isChatEnabled();
            info.multiplayerEnabled = account.isMultiplayerEnabled();
            info.registrationDate = fmt.format(new Date(account.getRegistrationTimestamp()));
            info.creationDate = fmt.format(new Date(account.getRegistrationTimestamp()));
            this.setResponseContent("text/xml", req.generateXmlValue("UserInfo", (Object)info));
        }
    }
}

