/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.objects;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.asf.connective.objects.HttpObject;

public class HttpResponse
extends HttpObject {
    @Deprecated
    public InputStream body;
    private long contentLength = -1L;
    private String httpVersion;
    private int statusCode = 200;
    private String statusMessage = "OK";

    public HttpResponse(String httpVersion) throws IllegalArgumentException {
        this.httpVersion = httpVersion;
    }

    public HttpResponse redirect(String destination) {
        return this.redirect(destination, 302, "Found");
    }

    public HttpResponse redirect(String destination, int status, String message) {
        this.setResponseStatus(status, message);
        this.addHeader("Location", destination);
        return this;
    }

    public HttpResponse setResponseStatus(int status, String message) {
        this.statusCode = status;
        this.statusMessage = message;
        return this;
    }

    public HttpResponse setContent(String type, String body) {
        if (type != null) {
            this.addHeader("Content-Type", type, false);
        } else if (this.headers.hasHeader("Content-Type")) {
            this.headers.removeHeader("Content-Type");
        }
        if (body != null) {
            try {
                this.contentLength = body.getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.contentLength = 0L;
        }
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (body == null) {
            this.body = null;
            return this;
        }
        try {
            this.body = new ByteArrayInputStream(body.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpResponse setContent(String type, byte[] body) {
        if (type != null) {
            this.addHeader("Content-Type", type, false);
        } else if (this.headers.hasHeader("Content-Type")) {
            this.headers.removeHeader("Content-Type");
        }
        this.contentLength = body != null ? (long)body.length : 0L;
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = new ByteArrayInputStream(body);
        return this;
    }

    public HttpResponse setContent(byte[] body) {
        if (!this.headers.hasHeader("Content-Type")) {
            this.addHeader("Content-Type", "application/octet-stream", false);
        }
        this.contentLength = body != null ? (long)body.length : 0L;
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = new ByteArrayInputStream(body);
        return this;
    }

    public HttpResponse setContent(String type, InputStream body, long length) {
        if (type != null) {
            this.addHeader("Content-Type", type, false);
        } else if (this.headers.hasHeader("Content-Type")) {
            this.headers.removeHeader("Content-Type");
        }
        this.contentLength = length;
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = body;
        return this;
    }

    public HttpResponse setContent(InputStream body, long length) {
        if (!this.headers.hasHeader("Content-Type")) {
            this.addHeader("Content-Type", "application/octet-stream", false);
        }
        this.contentLength = length;
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = body;
        return this;
    }

    public HttpResponse setContent(String type, InputStream body) {
        if (type != null) {
            this.addHeader("Content-Type", type, false);
        } else if (this.headers.hasHeader("Content-Type")) {
            this.headers.removeHeader("Content-Type");
        }
        this.contentLength = -1L;
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = body;
        return this;
    }

    public HttpResponse setContent(InputStream body) {
        if (!this.headers.hasHeader("Content-Type")) {
            this.addHeader("Content-Type", "application/octet-stream", false);
        }
        this.contentLength = -1L;
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = body;
        return this;
    }

    public HttpResponse setLastModified(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.headers.addHeader("Last-Modified", dateFormat.format(date));
        return this;
    }

    public boolean isSuccessResponseCode() {
        return this.statusCode >= 100 && this.statusCode < 400;
    }

    public int getResponseCode() {
        return this.statusCode;
    }

    public String getResponseMessage() {
        return this.statusMessage;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public boolean hasResponseBody() {
        return this.body != null;
    }

    @Override
    public InputStream getBodyStream() {
        return this.body;
    }

    public long getBodyLength() {
        return this.contentLength;
    }

    public String toString() {
        return this.statusCode + " " + this.statusMessage;
    }
}

