/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.impl.http_1_1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.asf.connective.NetworkedConnectiveHttpServer;
import org.asf.connective.impl.http_1_1.RemoteClientHttp_1_1;
import org.asf.connective.objects.HttpResponse;

public class ConnectiveHttpServer_1_1
extends NetworkedConnectiveHttpServer {
    protected String serverName = "ASF Connective";
    protected String serverVersion = "1.0.0.A13";
    protected InetAddress address;
    protected int port = 8080;
    protected boolean connected = false;
    protected ServerSocket socket = null;
    protected ArrayList<RemoteClientHttp_1_1> clients = new ArrayList();
    protected Thread serverThread;

    public ConnectiveHttpServer_1_1() {
        try {
            this.address = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void setListenAddress(InetAddress address) {
        this.address = address;
    }

    @Override
    public void setListenPort(int port) {
        this.port = port;
    }

    @Override
    public InetAddress getListenAddress() {
        return this.address;
    }

    @Override
    public int getListenPort() {
        return this.port;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void setServerName(String name) {
        this.serverName = name;
    }

    protected OutputStream getClientOutput(Socket client) throws IOException {
        return client.getOutputStream();
    }

    protected InputStream getClientInput(Socket client) throws IOException {
        return client.getInputStream();
    }

    protected void acceptConnection(Socket client) {
    }

    protected ServerSocket getServerSocket(int port, InetAddress ip) throws IOException {
        return new ServerSocket(port, 0, ip);
    }

    @Override
    public void start() throws IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Server already running!");
        }
        this.getLogger().debug("Starting server on " + this.address.getHostAddress() + ", port " + this.port + "...");
        this.connected = true;
        this.socket = this.getServerSocket(this.port, this.address);
        this.serverThread = new Thread(() -> {
            while (this.connected) {
                try {
                    Socket client = this.socket.accept();
                    this.acceptConnection(client);
                    InputStream in = this.getClientInput(client);
                    OutputStream out = this.getClientOutput(client);
                    RemoteClientHttp_1_1 cl = new RemoteClientHttp_1_1(client, this, in, out, req -> new HttpResponse("HTTP/1.1"));
                    try {
                        ArrayList<RemoteClientHttp_1_1> arrayList = this.clients;
                        synchronized (arrayList) {
                            this.clients.add(cl);
                        }
                        cl.beginReceive();
                    }
                    catch (IOException ex) {
                        if (!this.connected) break;
                        this.getLogger().error("Failed to handle messages from [[" + cl.getRemoteAddress() + "]:" + cl.getRemotePort() + "]", (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    if (!this.connected) break;
                    this.getLogger().error("Failed to handle client during handhsake", (Throwable)ex);
                }
            }
        }, "Connective server thread");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
        this.getLogger().debug("Server online, waiting for requests...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        if (!this.connected) {
            return;
        }
        this.getLogger().debug("Stopping server...");
        this.connected = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLogger().debug("Waiting for clients to disconnect...");
        while (true) {
            int c;
            ArrayList<RemoteClientHttp_1_1> arrayList = this.clients;
            synchronized (arrayList) {
                c = this.clients.size();
            }
            if (c == 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = null;
        this.getLogger().debug("HTTP server closed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopForced() throws IOException {
        if (!this.connected) {
            return;
        }
        this.getLogger().debug("Stopping server...");
        this.connected = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLogger().debug("Disconnecting clients...");
        RemoteClientHttp_1_1[] remoteClientHttp_1_1Array = this.clients;
        synchronized (this.clients) {
            RemoteClientHttp_1_1[] clientLst = (RemoteClientHttp_1_1[])this.clients.toArray(RemoteClientHttp_1_1[]::new);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            for (RemoteClientHttp_1_1 client : clientLst) {
                try {
                    client.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.clients.clear();
            this.socket = null;
            this.getLogger().debug("HTTP server closed!");
            return;
        }
    }

    @Override
    public boolean isRunning() {
        return this.connected;
    }

    @Override
    public String getProtocolName() {
        return "HTTP/1.1";
    }
}

