/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.http.cookies;

import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.edge.common.http.cookies.Cookie;
import org.asf.edge.common.http.cookies.CookieContext;
import org.asf.edge.common.http.cookies.StringCookie;

public class CookieManager {
    protected static CookieManager implementation = new CookieManager();

    protected CookieContext getCookiesImpl(HttpRequest request, HttpResponse response) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap outputCookies = new HashMap();
        if (request.hasHeader("Cookie")) {
            String[] cookieString;
            for (String cookie2 : cookieString = request.getHeaderValue("Cookie").split("; ")) {
                if (cookie2.isEmpty()) continue;
                String name2 = cookie2.substring(0, cookie2.indexOf("="));
                String value = cookie2.substring(cookie2.indexOf("=") + 1);
                name2 = name2.replace("%3B", ";");
                name2 = name2.replace("%3D", "=");
                name2 = name2.replace("%25", "%");
                value = value.replace("%3B", ";");
                value = value.replace("%3D", "=");
                value = value.replace("%25", "%");
                cookies.put(name2, value);
            }
        }
        return CookieManager.getCookies(name -> (String)cookies.get(name), () -> (String[])cookies.keySet().toArray(String[]::new), cookie -> {
            cookies.put(cookie.getName(), cookie.getValue());
            if (outputCookies.containsKey(cookie.getName())) {
                String[] cookieHeaders;
                String[] stringArray = cookieHeaders = response.getHeaderValues("Set-Cookie");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String headerValue;
                    String headerValStr = headerValue = stringArray[i];
                    String name = headerValue;
                    String value = "";
                    if (name.contains("=")) {
                        value = name.substring(name.indexOf("=") + 1);
                        name = name.substring(0, name.indexOf("="));
                    }
                    if (value.contains("; ")) {
                        value = value.substring(0, value.indexOf("; "));
                    }
                    name = name.replace("%", "%25");
                    name = name.replace(";", "%3B");
                    name = name.replace("=", "%3D");
                    value = value.replace("%", "%25");
                    value = value.replace(";", "%3B");
                    value = value.replace("=", "%3D");
                    if (!name.equals(cookie.getName())) continue;
                    response.getHeader("Set-Cookie").removeValue(headerValStr);
                    response.getHeader("Set-Cookie").addValue(cookie.getCookieString());
                    return;
                }
                response.addHeader("Set-Cookie", cookie.getCookieString(), true);
            } else {
                response.addHeader("Set-Cookie", cookie.getCookieString(), true);
            }
        });
    }

    protected CookieContext getCookiesImpl(Function<String, String> cookieProvider, Supplier<String[]> allCookies, Consumer<Cookie> cookieOutput) {
        CookieContext collection = new CookieContext();
        collection.assign(cookieOutput);
        for (String cookie : allCookies.get()) {
            collection.assign(cookie, new StringCookie(cookieProvider.apply(cookie)));
        }
        return collection;
    }

    public static CookieContext getCookies(HttpRequest request, HttpResponse response) {
        return implementation.getCookiesImpl(request, response);
    }

    public static CookieContext getCookies(Function<String, String> cookieProvider, Supplier<String[]> allCookies, Consumer<Cookie> cookieOutput) {
        return implementation.getCookiesImpl(cookieProvider, allCookies, cookieOutput);
    }
}

