/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.asf.cyan.fluid.FluidClassTracker;

public class DynamicClassLoader
extends URLClassLoader {
    private boolean secured = false;
    public static final int OPTION_ALLOW_DEFINE = 2;
    public static final int OPTION_DENY_SELF_LOAD = 4;
    public static final int OPTION_DENY_ADD_RUNTIME = 8;
    public static final int OPTION_PREVENT_AUTOSECURE = 16;
    public static final int OPTION_ENABLE_TRANSFORMER_ENGINE = 32;
    private int options = 0;
    private boolean transforming = false;
    private boolean noSecureOnAdd = false;
    private boolean allowSelfToLoad = true;
    private boolean allowSelfToDefine = false;
    private boolean denyAdding = false;
    private ArrayList<BiFunction<byte[], String, byte[]>> transformers = new ArrayList();
    private static HashMap<String, String> rewrittenResources = new HashMap();
    private ArrayList<Function<String, Boolean>> classRestrictions = new ArrayList();
    public static ArrayList<LoadedClassProvider> loadedClassProviders;

    public void secure() {
        if (this.secured) {
            throw new IllegalStateException("Classloader already secured!");
        }
        this.apply();
        this.secured = true;
    }

    private boolean hasOption(int opt) {
        return (opt & this.options) == opt;
    }

    public void apply() {
        if (this.secured) {
            throw new IllegalStateException("Classloader has been secured! Applying options denied!");
        }
        if (this.hasOption(4)) {
            this.allowSelfToLoad = false;
        }
        if (this.hasOption(2)) {
            this.allowSelfToDefine = true;
        }
        if (this.hasOption(8)) {
            this.denyAdding = true;
        }
        if (this.hasOption(32)) {
            this.transforming = true;
        }
    }

    public void setOptions(int options) {
        if (this.secured) {
            throw new IllegalStateException("Classloader has been secured!");
        }
        this.options |= options;
        if (this.hasOption(16)) {
            this.noSecureOnAdd = true;
        }
    }

    public DynamicClassLoader() {
        super(new URL[0], (ClassLoader)null);
    }

    public DynamicClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
    }

    public DynamicClassLoader(String name) {
        super(name, new URL[0], null);
    }

    public DynamicClassLoader(String name, URL[] urls) {
        super(name, urls, null);
    }

    public DynamicClassLoader(String name, ClassLoader parent) {
        super(name, new URL[0], parent);
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DynamicClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DynamicClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public DynamicClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public DynamicClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(name, urls, parent, factory);
    }

    public void addUrl(URL url) {
        if (this.secured && this.denyAdding) {
            throw new RuntimeException("Classloader has been secured, dynamic loading denied.");
        }
        super.addURL(url);
        if (!this.secured && !this.noSecureOnAdd) {
            this.secure();
        }
    }

    public void addUrls(URL[] urls) {
        if (this.secured && this.denyAdding) {
            throw new RuntimeException("Classloader has been secured, dynamic loading denied.");
        }
        for (URL url : urls) {
            super.addURL(url);
        }
        if (!this.secured && !this.noSecureOnAdd) {
            this.secure();
        }
    }

    public void addUrls(Iterable<URL> urls) {
        if (this.secured && this.denyAdding) {
            throw new RuntimeException("Classloader has been secured, dynamic loading denied.");
        }
        for (URL url : urls) {
            super.addURL(url);
        }
        if (!this.secured && !this.noSecureOnAdd) {
            this.secure();
        }
    }

    public void addTransfomer(BiFunction<byte[], String, byte[]> transformer) {
        if (this.secured) {
            throw new RuntimeException("Classloader has been secured.");
        }
        this.transformers.add(transformer);
    }

    public Class<?> getLoadedClass(String name) {
        return FluidClassTracker.loadedClasses.get(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (LoadedClassProvider prov : loadedClassProviders) {
            Class<?> cls = prov.provide(name);
            if (cls == null) continue;
            return cls;
        }
        Class<?> _class = null;
        try {
            if (FluidClassTracker.loadedClasses.containsKey(name)) {
                return FluidClassTracker.loadedClasses.get(name);
            }
            _class = super.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            ClassLoader l = this.getParent();
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == this) {
                l = ClassLoader.getSystemClassLoader();
            }
            _class = Class.forName(name, true, l);
        }
        if (!FluidClassTracker.loadedClasses.containsKey(name)) {
            FluidClassTracker.loadedClasses.put(name, _class);
        }
        return _class;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (LoadedClassProvider prov : loadedClassProviders) {
            Class<?> cls = prov.provide(name);
            if (cls == null) continue;
            return cls;
        }
        if (FluidClassTracker.loadedClasses.containsKey(name)) {
            return FluidClassTracker.loadedClasses.get(name);
        }
        return super.loadClass(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (LoadedClassProvider prov : loadedClassProviders) {
            Class<?> cls = prov.provide(name);
            if (cls == null) continue;
            return cls;
        }
        if (FluidClassTracker.loadedClasses.containsKey(name)) {
            return FluidClassTracker.loadedClasses.get(name);
        }
        Class<?> cl = null;
        try {
            cl = this.doLoadClass(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            ClassLoader l = this.getParent();
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == this) {
                l = ClassLoader.getSystemClassLoader();
            }
            cl = l.loadClass(name);
        }
        if (!FluidClassTracker.loadedClasses.containsKey(name)) {
            FluidClassTracker.loadedClasses.put(name, cl);
        }
        return cl;
    }

    public void addLoadRestriction(Function<String, Boolean> restriction) {
        if (this.secured) {
            throw new IllegalStateException("Classloader has been secured! Cannot add restrictions!");
        }
        this.classRestrictions.add(restriction);
    }

    Class<?> doLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.allowSelfToLoad || this.classRestrictions.stream().anyMatch(t -> (Boolean)t.apply(name))) {
            if (this.getParent() == null) {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            return this.getParent().loadClass(name);
        }
        if (!this.allowSelfToDefine) {
            return super.loadClass(name, resolve);
        }
        String path = name.replaceAll("\\.", "/") + ".class";
        for (URL u : this.getURLs()) {
            try {
                if (!u.toString().endsWith(".class")) {
                    if (u.toString().endsWith(".jar") || u.toString().endsWith(".zip")) {
                        try {
                            u = new URL("jar:" + u.toString() + "!/" + path);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    } else {
                        try {
                            u = new URL(u + "/" + path);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                } else if (!u.toString().endsWith("/" + path)) continue;
                if (name.startsWith("java.")) {
                    return ClassLoader.getSystemClassLoader().loadClass(name);
                }
                BufferedInputStream strm = new BufferedInputStream(u.openStream());
                byte[] data = strm.readAllBytes();
                if (this.transforming) {
                    for (BiFunction<byte[], String, byte[]> transformer : this.transformers) {
                        data = transformer.apply(data, name);
                    }
                }
                strm.close();
                Class<?> cls = this.defineClass(name, ByteBuffer.wrap(data), new CodeSource(u, (Certificate[])null));
                if (resolve) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Cannot find class " + name);
    }

    private URL getResourceURL(String name) throws MalformedURLException {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        Class<?> caller = null;
        int index = 2;
        while (index < elements.length) {
            try {
                caller = this.loadClass(elements[index++].getClassName());
                while (caller.getTypeName().equals(Class.class.getTypeName()) || caller.getTypeName().equals(DynamicClassLoader.class.getTypeName())) {
                    caller = this.loadClass(elements[index++].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ClassLoader cl = caller.getClassLoader();
            if (cl == this) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == this) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                URL cSource = caller.getProtectionDomain().getCodeSource().getLocation();
                Object prefix = cSource.toString();
                if (rewrittenResources.containsKey(caller.getTypeName() + ".source")) {
                    cSource = new File(rewrittenResources.get(caller.getTypeName() + ".source")).toURI().toURL();
                    prefix = cSource.toString();
                }
                if (cSource.getProtocol().equals("jar")) {
                    prefix = ((String)prefix).substring(0, ((String)prefix).lastIndexOf("!"));
                    prefix = (String)prefix + "!/";
                } else if (cSource.toString().endsWith("jar")) {
                    prefix = "jar:" + (String)prefix + "!/";
                } else if (!((String)prefix).endsWith("/")) {
                    prefix = (String)prefix + "/";
                }
                prefix = (String)prefix + name;
                return new URL((String)prefix);
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        try {
            URL resource = this.getResourceURL(name);
            if (resource == null) {
                return null;
            }
            try {
                resource.openStream().close();
            }
            catch (IOException ex) {
                return null;
            }
            return resource;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL resource = this.getResourceURL(name);
            if (resource == null) {
                return null;
            }
            return resource.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void addDefaultCp() {
        for (String entry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            try {
                this.addUrl(new File(entry).toURI().toURL());
            }
            catch (MalformedURLException e) {
                try {
                    this.addUrl(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean knowsLoadedClassProvider(String name) {
        for (LoadedClassProvider prov : loadedClassProviders) {
            if (!prov.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void registerLoadedClassProvider(LoadedClassProvider loadedClassProvider) {
        if (!DynamicClassLoader.knowsLoadedClassProvider(loadedClassProvider.name())) {
            loadedClassProviders.add(loadedClassProvider);
        }
    }

    static {
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            String value = v.toString();
            if (key.startsWith("cyancore.resourceloader.rewriteresource.")) {
                rewrittenResources.put(key.substring("cyancore.resourceloader.rewriteresource.".length()), value);
            }
        }));
        loadedClassProviders = new ArrayList();
    }

    public static interface LoadedClassProvider {
        public String name();

        public Class<?> provide(String var1);
    }
}

