/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.util.TripleDesUtil;

public class LegacyProxyMain {
    private static String encryptedManifest;

    public static void main(String[] args) throws IOException {
        String man;
        Object enc;
        CommonInit.initAll();
        Logger log = LogManager.getLogger((String)"Proxy");
        log.info("Setting up proxy...");
        log.info("Loading configuration...");
        JsonObject config = JsonParser.parseString((String)Files.readString(Path.of("proxy.json", new String[0]))).getAsJsonObject();
        log.info("Downloading application manifest...");
        Object url = config.get("mediaServer").getAsString();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "DWADragonsUnity/" + config.get("platform").getAsString() + "/" + config.get("version").getAsString() + "/DWADragonsMain.xml";
        URL u = new URL((String)url);
        if (!config.get("secret").getAsString().equals("unset")) {
            byte[] key;
            strm = u.openStream();
            enc = Base64.getDecoder().decode(strm.readAllBytes());
            strm.close();
            log.info("Computing key...");
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                key = digest.digest(config.get("secret").getAsString().getBytes("ASCII"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            log.info("Decrypting manifest...");
            byte[] dec = TripleDesUtil.decrypt((byte[])enc, (byte[])key);
            man = new String(dec, "ASCII");
        } else {
            strm = u.openStream();
            man = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
        }
        log.info("Modifying manifest...");
        JsonObject replace = config.get("manifestReplace").getAsJsonObject();
        enc = replace.keySet().iterator();
        while (enc.hasNext()) {
            String replaceKey = (String)enc.next();
            man = man.replace(replaceKey, replace.get(replaceKey).getAsString().replace("%local%", config.get("host").getAsString() + ":" + config.get("port").getAsString()));
        }
        if (!config.get("secret").getAsString().equals("unset")) {
            byte[] key;
            log.info("Computing key...");
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                key = digest.digest(config.get("secret").getAsString().getBytes("ASCII"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            log.info("Re-encrypting manifest...");
            encryptedManifest = Base64.getEncoder().encodeToString(TripleDesUtil.encrypt((byte[])man.getBytes("ASCII"), (byte[])key));
        } else {
            encryptedManifest = man;
        }
        log.info("Setting up http server...");
        ConnectiveHttpServer srv = ConnectiveHttpServer.create((String)"HTTP/1.1", Map.of("address", config.get("host").getAsString(), "port", config.get("port").getAsString()));
        srv.registerProcessor((HttpPushProcessor)new ManifestRequestProcessor("/DWADragonsUnity/" + config.get("platform").getAsString() + "/" + config.get("version").getAsString() + "/DWADragonsMain.xml"));
        srv.registerProcessor((HttpPushProcessor)new ProxyProcessor());
        log.info("Starting proxy server on " + config.get("host").getAsString() + ":" + config.get("port").getAsString() + "...");
        srv.start();
        log.info("Proxy is running!");
        log.info("Modified manifest published to http://" + config.get("host").getAsString() + ":" + config.get("port").getAsString() + "/DWADragonsUnity/" + config.get("platform").getAsString() + "/" + config.get("version").getAsString() + "/DWADragonsMain.xml");
        srv.waitForExit();
    }

    private static class ManifestRequestProcessor
    extends HttpPushProcessor {
        private String path;

        public ManifestRequestProcessor(String path) {
            this.path = path;
        }

        public void process(String path, String method, RemoteClient client, String contentType) throws IOException {
            this.setResponseContent("text/xml", encryptedManifest);
        }

        public HttpPushProcessor createNewInstance() {
            return new ManifestRequestProcessor(this.path);
        }

        public String path() {
            return this.path;
        }

        public boolean supportsNonPush() {
            return true;
        }
    }

    private static class ProxyProcessor
    extends HttpPushProcessor {
        private ProxyProcessor() {
        }

        public HttpPushProcessor createNewInstance() {
            return new ProxyProcessor();
        }

        public String path() {
            return "/";
        }

        public boolean supportsNonPush() {
            return true;
        }

        public boolean supportsChildPaths() {
            return true;
        }

        public void process(String path, String method, RemoteClient client, String contentType) throws IOException {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.split("/").length < 2) {
                this.setResponseStatus(400, "Bad Request");
                return;
            }
            String protocol = path;
            String server = protocol.substring(protocol.indexOf("/") + 1);
            protocol = protocol.substring(0, protocol.indexOf("/"));
            path = server.substring(server.indexOf("/"));
            server = server.substring(0, server.indexOf("/"));
            String url = protocol + "://" + server + path;
            if (!this.getRequest().getRequestQuery().isEmpty()) {
                url = url + "?" + this.getRequest().getRequestQuery();
            }
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setRequestMethod(method);
                conn.setDoInput(true);
                for (String name : this.getHeaders().getHeaderNames()) {
                    if (name.equalsIgnoreCase("Host")) continue;
                    for (String value : this.getHeaders().getHeaderValues(name)) {
                        conn.addRequestProperty(name, value);
                    }
                }
                if (this.getRequest().hasRequestBody()) {
                    conn.setDoOutput(true);
                    this.getRequest().transferRequestBody(conn.getOutputStream());
                }
                int responseCode = conn.getResponseCode();
                String responseMessage = conn.getResponseMessage();
                this.setResponseStatus(responseCode, responseMessage);
                for (String name : conn.getHeaderFields().keySet()) {
                    if (name == null || name.equalsIgnoreCase("transfer-encoding")) continue;
                    JsonArray hValues = new JsonArray();
                    boolean first = true;
                    for (String value : conn.getHeaderFields().get(name)) {
                        hValues.add(value);
                        if (first) {
                            first = false;
                            this.setResponseHeader(name, value, false);
                            continue;
                        }
                        this.setResponseHeader(name, value, true);
                    }
                }
                InputStream body = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
                this.setResponseContent(body);
            }
            catch (IOException e) {
                JsonObject respInfo = new JsonObject();
                respInfo.addProperty("status", (Number)500);
                respInfo.addProperty("statusMessage", "[Proxy] Failed to proxy to " + url);
                respInfo.add("headers", (JsonElement)new JsonObject());
                respInfo.addProperty("responseBody", "");
                this.setResponseStatus(404, "Not found");
                LogManager.getLogger((String)"Proxy").error("Failed to proxy to " + url, (Throwable)e);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
        private static class ServerList {
            @JsonProperty(value="MMOServerInfo")
            @JacksonXmlElementWrapper(useWrapping=false)
            public ObjectNode[] servers;

            private ServerList() {
            }
        }
    }
}

