/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;

public class ItemCsvGenerator {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        ServiceManager.registerServiceImplementation(ItemManager.class, new ItemManagerImpl(), -10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        XmlMapper mapper = new XmlMapper();
        mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        mapper.configure(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL, true);
        System.out.println("Generating detailed item list...");
        Object csv = "Item ID,Item Name,Item Description,Asset Name,Icon Name,Normal cost (non-sale),Selling Factor,Uses,Attributes,Categories,Item relations,Availability,Rank ID,Creative Points,Inventory Max,Lock State,Stackable (unused in client),Allow Stacking (unused in client),Geometry,Textures,Reward type ID,Points\n";
        int i = 0;
        FileOutputStream fO = new FileOutputStream("detaileditemlist.csv");
        fO.write(((String)csv).getBytes("UTF-8"));
        csv = "";
        Object lastProg = "";
        for (ObjectNode def : (ObjectNode[])Stream.of(ItemManager.getInstance().getAllItemDefinitions()).map(t -> t.getRawObject()).toArray(ObjectNode[]::new)) {
            void var18_30;
            void var17_23;
            csv = "\n\"" + def.get("id").asInt() + "\",";
            csv = def.has("itn") && !def.get("itn").asText().isEmpty() ? (String)csv + "\"\"\"" + def.get("itn").asText().replace("\"", "\"\"") + "\"\"\"," : (String)csv + ",";
            csv = def.has("d") && !def.get("d").asText().isEmpty() ? (String)csv + "\"" + def.get("d").asText().replace("\"", "\"\"") + "\"," : (String)csv + ",";
            csv = def.has("an") ? (String)csv + "\"" + def.get("an").asText().replace("\"", "\"\"") + "\"," : (String)csv + ",";
            csv = def.has("icn") ? (String)csv + "\"" + def.get("icn").asText().replace("\"", "\"\"") + "\"," : (String)csv + ",";
            int costGems = 0;
            int costCoins = 0;
            if (def.has("ct")) {
                costCoins = def.get("ct").asInt();
            }
            if (def.has("ct2")) {
                costGems = def.get("ct2").asInt();
            }
            csv = costGems > 0 ? (String)csv + "\"" + costGems + " gems\"," : (costCoins > 0 ? (String)csv + "\"" + costCoins + " coins\"," : (String)csv + "free or not in store,");
            csv = def.has("sf") ? (String)csv + def.get("sf").asInt() + "," : (String)csv + ",";
            csv = def.has("u") ? (String)csv + def.get("u").asInt() + "," : (String)csv + ",";
            Attribute[] attrs = ItemCsvGenerator.getAttributes(def);
            Object str = "";
            for (Attribute attribute : attrs) {
                str = ((String)str).isEmpty() ? attribute.key + " = " + attribute.value : (String)str + "\n" + attribute.key + " = " + attribute.value;
            }
            csv = !((String)str).isEmpty() ? (String)csv + "\"" + ((String)str).replace("\"", "\"\"") + "\"," : (String)csv + ",";
            Category[] cats = ItemCsvGenerator.getCategories(def);
            str = "";
            Category[] categoryArray = cats;
            int n = categoryArray.length;
            boolean bl = false;
            while (var17_23 < n) {
                Category category = categoryArray[var17_23];
                str = ((String)str).isEmpty() ? category.categoryName + " (ID: " + category.id + ", icon: " + category.iconName + ")" : (String)str + "\n" + category.categoryName + " (ID: " + category.id + ", icon: " + category.iconName + ")";
                ++var17_23;
            }
            csv = !((String)str).isEmpty() ? (String)csv + "\"" + ((String)str).replace("\"", "\"\"") + "\"," : (String)csv + ",";
            Relation[] relations = ItemCsvGenerator.getRelations(def);
            str = "";
            Relation[] relationArray = relations;
            int n2 = relationArray.length;
            boolean bl2 = false;
            while (var18_30 < n2) {
                Relation rel = relationArray[var18_30];
                str = ((String)str).isEmpty() ? rel.type + ": " + (rel.quantity == 0 ? 1 : rel.quantity) + "x ID " + rel.itemID + " (weight: " + rel.weight + ")" : (String)str + "\n" + rel.type + ": " + (rel.quantity == 0 ? 1 : rel.quantity) + "x ID " + rel.itemID + " (weight: " + rel.weight + ")";
                ++var18_30;
            }
            csv = !((String)str).isEmpty() ? (String)csv + "\"" + ((String)str).replace("\"", "\"\"") + "\"," : (String)csv + ",";
            Availability[] avs = ItemCsvGenerator.getAvailability(def);
            str = "";
            for (Availability av : avs) {
                str = ((String)str).isEmpty() ? av.startDate + " - " + av.endDate : (String)str + "\n" + av.startDate + " - " + av.endDate;
            }
            csv = !((String)str).isEmpty() ? (String)csv + "\"" + ((String)str).replace("\"", "\"\"") + "\"," : (String)csv + ",";
            csv = def.has("rid") ? (String)csv + def.get("rid").asInt() + "," : (String)csv + ",";
            csv = def.has("cp") ? (String)csv + def.get("cp").asInt() + "," : (String)csv + "\"\",";
            csv = def.has("im") ? (String)csv + def.get("im").asInt() + "," : (String)csv + ",";
            csv = def.has("l") ? (String)csv + (def.get("l").asBoolean() ? "Locked" : "Not locked") + "," : (String)csv + ",";
            csv = def.has("s") ? (String)csv + (def.get("s").asBoolean() ? "Stackable" : "Not stackable") + "," : (String)csv + ",";
            csv = def.has("as") ? (String)csv + (def.get("as").asBoolean() ? "Allows stacking" : "Denies stacking") + "," : (String)csv + ",";
            csv = def.has("g") && !def.get("g").asText().isEmpty() ? (String)csv + "\"" + def.get("g").asText().replace("\"", "\"\"") + "\"," : (String)csv + ",";
            Texture[] textureArray = ItemCsvGenerator.getTextures(def);
            str = "";
            for (Texture t2 : textureArray) {
                str = ((String)str).isEmpty() ? t2.typeName + " (asset: " + t2.assetName + ", x offset: " + t2.offsetX + ", y offset: " + t2.offsetY + ")" : (String)str + "\n" + t2.typeName + " (asset: " + t2.assetName + ", x offset: " + t2.offsetX + ", y offset: " + t2.offsetY + ")";
            }
            csv = !((String)str).isEmpty() ? (String)csv + "\"" + ((String)str).replace("\"", "\"\"") + "\"," : (String)csv + ",";
            csv = def.has("rtid") ? (String)csv + def.get("rtid").asInt() + "," : (String)csv + ",";
            if (def.has("p")) {
                csv = (String)csv + def.get("p").asInt();
            }
            fO.write(((String)csv).getBytes("UTF-8"));
            csv = "";
            String string = (int)(100.0f / (float)ItemManager.getInstance().getAllItemDefinitions().length * (float)(++i)) + "%";
            if (((String)lastProg).equals(string)) continue;
            lastProg = string;
            System.out.println("Progress: " + string);
        }
        fO.close();
        System.out.println("Generating simplified item list...");
        csv = "Item ID,Item Name,Item Description\n";
        for (ObjectNode def : (ObjectNode[])Stream.of(ItemManager.getInstance().getAllItemDefinitions()).map(t -> t.getRawObject()).toArray(ObjectNode[]::new)) {
            csv = (String)csv + "\n\"" + def.get("id").asInt() + "\",";
            csv = def.has("itn") && !def.get("itn").asText().isEmpty() ? (String)csv + "\"\"\"" + def.get("itn").asText().replace("\"", "\"\"") + "\"\"\"," : (String)csv + ",";
            csv = def.has("d") && !def.get("d").asText().isEmpty() ? (String)csv + "\"" + def.get("d").asText().replace("\"", "\"\"") + "\"," : (String)csv + ",";
        }
        Files.writeString(Path.of("itemlist.csv", new String[0]), (CharSequence)csv, new OpenOption[0]);
    }

    private static Texture[] getTextures(ObjectNode raw) {
        if (!raw.has("t")) {
            return new Texture[0];
        }
        ArrayList<Texture> nodes = new ArrayList<Texture>();
        JsonNode node = raw.get("t");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("n")) continue;
                Texture t = new Texture();
                t.assetName = n.get("n").asText();
                t.typeName = n.get("t").asText();
                t.offsetX = n.get("x").asText();
                t.offsetY = n.get("y").asText();
                nodes.add(t);
            }
        } else if (node.has("n")) {
            Texture t = new Texture();
            t.assetName = node.get("n").asText();
            t.typeName = node.get("t").asText();
            t.offsetX = node.get("x").asText();
            t.offsetY = node.get("y").asText();
            nodes.add(t);
        }
        return (Texture[])nodes.toArray(Texture[]::new);
    }

    private static Availability[] getAvailability(ObjectNode raw) {
        if (!raw.has("av")) {
            return new Availability[0];
        }
        ArrayList<Availability> nodes = new ArrayList<Availability>();
        JsonNode node = raw.get("av");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("sdate")) continue;
                Availability a = new Availability();
                a.startDate = n.get("sdate").asText();
                a.endDate = n.get("edate").asText();
                nodes.add(a);
            }
        } else if (node.has("sdate")) {
            Availability a = new Availability();
            a.startDate = node.get("sdate").asText();
            a.endDate = node.get("edate").asText();
            nodes.add(a);
        }
        return (Availability[])nodes.toArray(Availability[]::new);
    }

    private static Relation[] getRelations(ObjectNode raw) {
        if (!raw.has("r")) {
            return new Relation[0];
        }
        ArrayList<Relation> nodes = new ArrayList<Relation>();
        JsonNode node = raw.get("r");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("t")) continue;
                Relation r = new Relation();
                r.type = n.get("t").asText();
                r.itemID = n.get("id").asInt();
                r.weight = n.get("wt").asInt();
                r.quantity = n.get("q").asInt();
                nodes.add(r);
            }
        } else if (node.has("t")) {
            Relation r = new Relation();
            r.type = node.get("t").asText();
            r.itemID = node.get("id").asInt();
            r.weight = node.get("wt").asInt();
            r.quantity = node.get("q").asInt();
            nodes.add(r);
        }
        return (Relation[])nodes.toArray(Relation[]::new);
    }

    private static Category[] getCategories(ObjectNode raw) {
        if (!raw.has("c")) {
            return new Category[0];
        }
        ArrayList<Category> cats = new ArrayList<Category>();
        JsonNode node = raw.get("c");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("cid") || !n.has("cn") || !n.has("i")) continue;
                Category c = new Category();
                c.id = n.get("cid").asInt();
                c.categoryName = n.get("cn").asText();
                c.iconName = n.get("i").asText();
                cats.add(c);
            }
        } else if (node.has("cid") && node.has("cn") && node.has("i")) {
            Category c = new Category();
            c.id = node.get("cid").asInt();
            c.categoryName = node.get("cn").asText();
            c.iconName = node.get("i").asText();
            cats.add(c);
        }
        return (Category[])cats.toArray(Category[]::new);
    }

    private static Attribute[] getAttributes(ObjectNode raw) {
        if (!raw.has("at")) {
            return new Attribute[0];
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        JsonNode node = raw.get("at");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("k") || !n.has("v")) continue;
                Attribute attr = new Attribute();
                attr.key = n.get("k").asText();
                attr.value = n.get("v");
                attrs.add(attr);
            }
        } else if (node.has("k") && node.has("v")) {
            Attribute attr = new Attribute();
            attr.key = node.get("k").asText();
            attr.value = node.get("v");
            attrs.add(attr);
        }
        return (Attribute[])attrs.toArray(Attribute[]::new);
    }

    public static class Attribute {
        public String key;
        public JsonNode value;
    }

    public static class Category {
        public int id;
        public String categoryName;
        public String iconName;
    }

    public static class Relation {
        public String type;
        public int itemID;
        public int weight;
        public int quantity;
    }

    public static class Availability {
        public String startDate;
        public String endDate;
    }

    public static class Texture {
        public String assetName;
        public String typeName;
        public String offsetX;
        public String offsetY;
    }
}

