/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.items.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.entities.items.ItemCategoryInfo;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.ItemSaleInfo;
import org.asf.edge.common.entities.items.ItemStoreInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.events.items.ItemManagerLoadEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.PlayerInventoryImpl;
import org.asf.edge.common.services.items.impl.RandomSaleConfig;
import org.asf.edge.common.services.items.impl.RandomSaleInterval;
import org.asf.edge.common.util.RandomSelectorUtil;
import org.asf.edge.common.xmls.items.ItemStoreDefinitionData;
import org.asf.edge.common.xmls.items.edgespecific.ItemRegistryManifest;
import org.asf.edge.modules.IEdgeModule;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class ItemManagerImpl
extends ItemManager {
    private Logger logger;
    private HashMap<Integer, ItemInfo> itemDefs = new HashMap();
    private HashMap<Integer, ItemStoreInfo> storeDefs = new HashMap();
    private ArrayList<ItemSaleInfo> currentRandomSales = new ArrayList();
    private ArrayList<ItemSaleInfo> upcomingRandomSales = new ArrayList();
    private ArrayList<ItemSaleInfo> sales = new ArrayList();
    private RandomSaleConfig randomSaleConfig;
    private long lastReloadTime;
    public ItemRegistryManifest.DefaultItemBlock[] defaultItems;
    private Random rnd = new Random();

    @Override
    public void initService() {
        CommonDataContainer cont2;
        this.logger = LogManager.getLogger((String)"ItemManager");
        try {
            cont2 = CommonDataManager.getInstance().getContainer("ITEMMANAGER");
            try {
                if (!cont2.entryExists("lastreload")) {
                    this.lastReloadTime = System.currentTimeMillis();
                    cont2.setEntry("lastreload", (JsonElement)new JsonPrimitive((Number)this.lastReloadTime));
                } else {
                    this.lastReloadTime = cont2.getEntry("lastreload").getAsLong();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AsyncTaskManager.runAsync(() -> {
                while (true) {
                    try {
                        long reload = cont2.getEntry("lastreload").getAsLong();
                        if (reload > this.lastReloadTime) {
                            this.lastReloadTime = reload;
                            this.loadData();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            });
        }
        catch (IllegalArgumentException cont2) {
            // empty catch block
        }
        this.loadData();
        this.logger.info("Updating sales...");
        try {
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            for (ItemInfo itm : this.getAllItemDefinitions()) {
                ItemCategoryInfo[] cats;
                for (ItemCategoryInfo cat : cats = itm.getCategories()) {
                    if (categoryIds.contains(cat.getCategoryID())) continue;
                    categoryIds.add(cat.getCategoryID());
                }
            }
            CommonDataContainer cont3 = CommonDataManager.getInstance().getContainer("ITEMSALES");
            ArrayList<ItemSaleInfo> currentRandomSales = new ArrayList<ItemSaleInfo>();
            ArrayList<ItemSaleInfo> upcomingRandomSales = new ArrayList<ItemSaleInfo>();
            ObjectMapper mapper = new ObjectMapper();
            Iterator iterator = categoryIds.iterator();
            while (iterator.hasNext()) {
                int cat = (Integer)iterator.next();
                if (!cont3.entryExists("current-" + cat)) continue;
                SaleInfoBlock b = (SaleInfoBlock)mapper.readValue(cont3.getEntry("current-" + cat).toString(), SaleInfoBlock.class);
                currentRandomSales.add(new ItemSaleInfo(b.name, b.startTime, b.endTime, b.saleModifier, b.categories, b.itemIDs, b.memberOnly));
                b = (SaleInfoBlock)mapper.readValue(cont3.getEntry("next-" + cat).toString(), SaleInfoBlock.class);
                upcomingRandomSales.add(new ItemSaleInfo(b.name, b.startTime, b.endTime, b.saleModifier, b.categories, b.itemIDs, b.memberOnly));
            }
            this.currentRandomSales = currentRandomSales;
            this.upcomingRandomSales = upcomingRandomSales;
        }
        catch (IOException e) {
            this.logger.error("Failed to load current random sales", (Throwable)e);
        }
        try {
            cont2 = CommonDataManager.getInstance().getContainer("ITEMSALES");
            CommonDataContainer contPopularItems = CommonDataManager.getInstance().getContainer("POPULARITEMS");
            AsyncTaskManager.runAsync(() -> {
                while (true) {
                    Calendar cal = Calendar.getInstance();
                    Calendar calNext = Calendar.getInstance();
                    boolean requiresUpdate = false;
                    try {
                        int val = -1;
                        if (!cont2.entryExists("lastupdate")) {
                            requiresUpdate = true;
                        } else {
                            val = cont2.getEntry("lastupdate").getAsInt();
                        }
                        switch (this.randomSaleConfig.refreshInterval) {
                            case DAILY: {
                                if (cal.get(7) == val) break;
                                requiresUpdate = true;
                                cont2.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)cal.get(7)));
                                cal.set(11, 0);
                                calNext.set(11, 0);
                                calNext.add(7, 1);
                                break;
                            }
                            case MONTHLY: {
                                if (cal.get(2) == val) break;
                                requiresUpdate = true;
                                cont2.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)cal.get(2)));
                                cal.set(5, 0);
                                calNext.set(5, 0);
                                calNext.add(2, 1);
                                break;
                            }
                            case WEEKLY: {
                                if (cal.get(3) == val) break;
                                requiresUpdate = true;
                                cont2.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)cal.get(3)));
                                cal.set(7, 0);
                                calNext.set(7, 0);
                                calNext.add(3, 1);
                                break;
                            }
                            case YEARLY: {
                                if (cal.get(1) == val) break;
                                requiresUpdate = true;
                                cont2.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)cal.get(1)));
                                cal.set(2, 0);
                                calNext.set(2, 0);
                                calNext.add(1, 1);
                            }
                        }
                        if (requiresUpdate) {
                            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
                            for (ItemInfo itm : this.getAllItemDefinitions()) {
                                ItemCategoryInfo[] cats;
                                for (ItemCategoryInfo cat : cats = itm.getCategories()) {
                                    if (categoryIds.contains(cat.getCategoryID())) continue;
                                    categoryIds.add(cat.getCategoryID());
                                }
                            }
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            calNext.set(11, 0);
                            calNext.set(12, 0);
                            calNext.set(13, 0);
                            Date saleStart = cal.getTime();
                            cal.add(5, this.randomSaleConfig.expiryLength);
                            Date saleEnd = cal.getTime();
                            Date saleStartNext = calNext.getTime();
                            calNext.add(5, this.randomSaleConfig.expiryLength);
                            Date saleEndNext = calNext.getTime();
                            Map<Integer, ItemSaleInfo> salesNext = this.generateSales(saleStartNext, saleEndNext, cont2, contPopularItems, categoryIds);
                            Map<Integer, ItemSaleInfo> salesCurrent = null;
                            ObjectMapper mapper = new ObjectMapper();
                            for (int cat : categoryIds) {
                                if (!salesNext.containsKey(cat)) continue;
                                if (!cont2.entryExists("current-" + cat)) {
                                    if (salesCurrent == null) {
                                        salesCurrent = this.generateSales(saleStart, saleEnd, cont2, contPopularItems, categoryIds);
                                    }
                                    cont2.setEntry("next-" + cat, JsonParser.parseString((String)mapper.writeValueAsString((Object)salesNext.get(cat))));
                                    cont2.setEntry("current-" + cat, JsonParser.parseString((String)mapper.writeValueAsString((Object)salesCurrent.get(cat))));
                                    continue;
                                }
                                cont2.setEntry("current-" + cat, cont2.getEntry("next-" + cat));
                                cont2.setEntry("next-" + cat, JsonParser.parseString((String)mapper.writeValueAsString((Object)salesNext.get(cat))));
                            }
                            ArrayList<ItemSaleInfo> currentRandomSales = new ArrayList<ItemSaleInfo>();
                            ArrayList<ItemSaleInfo> upcomingRandomSales = new ArrayList<ItemSaleInfo>();
                            for (int cat : categoryIds) {
                                JsonElement ent = cont2.getEntry("current-" + cat);
                                if (ent == null) continue;
                                SaleInfoBlock b = (SaleInfoBlock)mapper.readValue(ent.toString(), SaleInfoBlock.class);
                                currentRandomSales.add(new ItemSaleInfo(b.name, b.startTime, b.endTime, b.saleModifier, b.categories, b.itemIDs, b.memberOnly));
                                b = (SaleInfoBlock)mapper.readValue(cont2.getEntry("next-" + cat).toString(), SaleInfoBlock.class);
                                upcomingRandomSales.add(new ItemSaleInfo(b.name, b.startTime, b.endTime, b.saleModifier, b.categories, b.itemIDs, b.memberOnly));
                            }
                            this.currentRandomSales = currentRandomSales;
                            this.upcomingRandomSales = upcomingRandomSales;
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to update sales", (Throwable)e);
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Map<Integer, ItemSaleInfo> generateSales(Date saleStart, Date saleEnd, CommonDataContainer cont, CommonDataContainer contPopularItems, ArrayList<Integer> categoryIds) throws IOException {
        HashMap<Integer, JsonObject> popularItemsData = new HashMap<Integer, JsonObject>();
        HashMap<Integer, ItemSaleInfo> sales = new HashMap<Integer, ItemSaleInfo>();
        for (int category : categoryIds) {
            HashMap<Integer, Integer> itemWeights = new HashMap<Integer, Integer>();
            for (ItemStoreInfo store : this.getAllStores()) {
                JsonObject popularItems = new JsonObject();
                if (popularItemsData.containsKey(store.getID())) {
                    popularItems = (JsonObject)popularItemsData.get(store.getID());
                } else {
                    if (contPopularItems.entryExists("last-" + store.getID())) {
                        popularItems = contPopularItems.getEntry("last-" + store.getID()).getAsJsonObject();
                    }
                    popularItemsData.put(store.getID(), popularItems);
                }
                for (ItemInfo itm : store.getItems()) {
                    int weight;
                    if (!Stream.of(itm.getCategories()).anyMatch(t -> t.getCategoryID() == category)) continue;
                    int popularity = 0;
                    if (popularItems.has(Integer.toString(itm.getID()))) {
                        popularity = popularItems.get(Integer.toString(itm.getID())).getAsInt();
                    }
                    if ((weight = 50 - popularity / 50) <= 0) {
                        weight = 1;
                    }
                    itemWeights.put(itm.getID(), weight);
                }
            }
            if (itemWeights.size() <= 0) continue;
            int amount = itemWeights.size() / this.randomSaleConfig.saleCountFactor;
            if (amount < 1) {
                amount = 1;
            } else if (amount > this.randomSaleConfig.maximumSalesPerCategory) {
                amount = this.randomSaleConfig.maximumSalesPerCategory;
            }
            ArrayList<Integer> itemIDs = new ArrayList<Integer>();
            for (int i = 0; i < amount; ++i) {
                int id = (Integer)RandomSelectorUtil.selectWeighted(itemWeights);
                while (itemIDs.contains(id)) {
                    id = (Integer)RandomSelectorUtil.selectWeighted(itemWeights);
                }
                itemIDs.add(id);
            }
            float modifier = this.rnd.nextFloat(this.randomSaleConfig.randomMinimalModifier, this.randomSaleConfig.randomMaximalModifier);
            DecimalFormatSymbols format = DecimalFormatSymbols.getInstance();
            format.setDecimalSeparator('.');
            modifier = Float.parseFloat(new DecimalFormat("0.000", format).format(modifier));
            int[] itemIdArr = new int[itemIDs.size()];
            for (int i = 0; i < itemIdArr.length; ++i) {
                itemIdArr[i] = (Integer)itemIDs.get(i);
            }
            ItemSaleInfo sale = new ItemSaleInfo("Random sale " + category, saleStart.getTime(), saleEnd.getTime(), modifier, new int[0], itemIdArr, false);
            sales.put(category, sale);
        }
        return sales;
    }

    private void loadData() {
        ItemRegistryManifest.DefaultItemBlock[] defaultItems;
        XmlMapper mapper;
        String data;
        InputStream strm;
        HashMap<Integer, ItemInfo> itemDefs = new HashMap<Integer, ItemInfo>();
        HashMap<Integer, ItemStoreInfo> storeDefs = new HashMap<Integer, ItemStoreInfo>();
        ArrayList<ItemSaleInfo> sales = new ArrayList<ItemSaleInfo>();
        this.logger.info("Loading item store data...");
        try {
            ItemStoreDefinitionData[] stores;
            strm = this.getClass().getClassLoader().getResourceAsStream("itemdata/itemstores.xml");
            data = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            data = data.replace("http://media.jumpstart.com/", "RS_DATA/");
            data = data.replace("https://media.jumpstart.com/", "RS_DATA/");
            data = data.replace("http://media.schoolofdragons.com/", "RS_DATA/");
            data = data.replace("https://media.schoolofdragons.com/", "RS_DATA/");
            mapper = new XmlMapper();
            for (ItemStoreDefinitionData itemStoreDefinitionData : stores = (ItemStoreDefinitionData[])mapper.reader().readValue(data, ItemStoreDefinitionData[].class)) {
                this.logger.debug("Loading store: " + itemStoreDefinitionData.storeID + " (" + itemStoreDefinitionData.storeName + ")");
                ItemInfo[] items = new ItemInfo[itemStoreDefinitionData.items.length];
                for (int i = 0; i < items.length; ++i) {
                    items[i] = new ItemInfo(itemStoreDefinitionData.items[i].get("id").asInt(), itemStoreDefinitionData.items[i].get("itn").asText(), itemStoreDefinitionData.items[i].get("d").asText(), itemStoreDefinitionData.items[i]);
                    itemDefs.put(items[i].getID(), items[i]);
                    this.logger.debug("Registered item: " + items[i].getID() + ": " + items[i].getName());
                }
                storeDefs.put(itemStoreDefinitionData.storeID, new ItemStoreInfo(itemStoreDefinitionData.storeID, itemStoreDefinitionData.storeName, itemStoreDefinitionData.storeDescription, items));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.info("Loading item defs...");
        try {
            strm = this.getClass().getClassLoader().getResourceAsStream("itemdata/itemdefs.xml");
            data = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            data = data.replace("http://media.jumpstart.com/", "RS_DATA/");
            data = data.replace("https://media.jumpstart.com/", "RS_DATA/");
            data = data.replace("http://media.schoolofdragons.com/", "RS_DATA/");
            data = data.replace("https://media.schoolofdragons.com/", "RS_DATA/");
            mapper = new XmlMapper();
            ItemRegistryManifest reg = (ItemRegistryManifest)mapper.reader().readValue(data, ItemRegistryManifest.class);
            defaultItems = reg.defaultItems.defaultItems;
            for (ItemStoreDefinitionData itemStoreDefinitionData : reg.itemDefs) {
                ItemInfo itm = new ItemInfo(itemStoreDefinitionData.get("id").asInt(), itemStoreDefinitionData.get("itn").asText(), itemStoreDefinitionData.get("d").asText(), (ObjectNode)itemStoreDefinitionData);
                itemDefs.put(itm.getID(), itm);
                this.logger.debug("Registered item: " + itm.getID() + ": " + itm.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.info("Loading item transformers...");
        this.loadTransformers(this.getClass(), itemDefs);
        for (IEdgeModule module : ModuleManager.getLoadedModules()) {
            this.loadTransformers(module.getClass(), itemDefs);
        }
        File transformersItems = new File("itemtransformers");
        if (transformersItems.exists()) {
            for (File transformer : transformersItems.listFiles(t -> t.getName().endsWith(".xml") || t.isDirectory())) {
                this.loadItemTransformer(transformer, itemDefs);
            }
        }
        this.logger.info("Loading shop transformers...");
        this.loadTransformersShops(this.getClass(), storeDefs, itemDefs);
        for (IEdgeModule module : ModuleManager.getLoadedModules()) {
            this.loadTransformersShops(module.getClass(), storeDefs, itemDefs);
        }
        File transformersShops = new File("shoptransformers");
        if (transformersShops.exists()) {
            for (File transformer : transformersShops.listFiles(t -> t.getName().endsWith(".json") || t.isDirectory())) {
                this.loadShopTransformer(transformer, storeDefs, itemDefs);
            }
        }
        this.logger.info("Loading item sales...");
        try {
            File saleConfig = new File("salesettings.json");
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            if (!saleConfig.exists()) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 12);
                cal.set(12, 0);
                cal.set(13, 0);
                Date start = cal.getTime();
                cal = Calendar.getInstance();
                cal.set(11, 12);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.add(2, 1);
                Date end = cal.getTime();
                Files.writeString(saleConfig.toPath(), (CharSequence)("{\n    \"randomSales\": {\n        \"enabled\": true,\n        \n        \"__COMMENT1__\": \"The following settings control the interval and expiry for sales\",\n        \"__COMMENT2__\": \"The interval can be either daily, weekly, monthly or yearly, however make sure the expiry isnt too high else things can get weird\",\n        \n        \"saleTimeDays\": 20,\n        \"refreshInterval\": \"monthly\",\n        \n        \"__COMMENT3__\": \"The modifiers below control how much the random sales discount\",\n        \"randomMinimalModifier\": 0.1,\n        \"randomMaximalModifier\": 0.3,\n        \n        \"__COMMENT4__\": \"The sale count factor is used to determine how many items should be on sale per category\",\n        \"saleCountFactor\": 10,\n        \n        \"__COMMENT5__\": \"The following maximum value is used to limit the amount of sales per category\",\n        \"maximumSalesPerCategory\": 12\n    },\n    \n    \"sales\": [\n        {\n            \"name\": \"Example sale, eggs and hatch tickets at 95% discount\",\n            \n            \"__COMMENT6__\": \"Sale duration\",\n            \"start\": \"" + fmt.format(start) + "\",\n            \"end\": \"" + fmt.format(end) + "\",\n            \n            \"modifier\": 0.95,\n            \n            \"__COMMENT7__\": \"Adds dragon egg categories to sales, you can find category IDs in item definitions\",\n            \"categories\": [\n                456,\n                \n                545,\n                546,\n                547,\n                548,\n                549,\n                550,\n                551\n            ],\n            \n            \"__COMMENT8__\": \"Adds the instant hatch ticket to the sale\",\n            \"itemIDs\": [\n                18601\n            ],\n            \n            \"memberOnly\": false\n        }\n    ]\n}\n"), new OpenOption[0]);
            }
            JsonObject saleConf = JsonParser.parseString((String)Files.readString(saleConfig.toPath())).getAsJsonObject();
            RandomSaleConfig config = new RandomSaleConfig();
            JsonObject randomSales = saleConf.get("randomSales").getAsJsonObject();
            config.enabled = randomSales.get("enabled").getAsBoolean();
            config.expiryLength = randomSales.get("saleTimeDays").getAsInt();
            String string = randomSales.get("refreshInterval").getAsString();
            if (string.equalsIgnoreCase("monthly")) {
                config.refreshInterval = RandomSaleInterval.MONTHLY;
            } else if (string.equalsIgnoreCase("yearly")) {
                config.refreshInterval = RandomSaleInterval.YEARLY;
            } else if (string.equalsIgnoreCase("weekly")) {
                config.refreshInterval = RandomSaleInterval.WEEKLY;
            } else if (string.equalsIgnoreCase("daily")) {
                config.refreshInterval = RandomSaleInterval.DAILY;
            } else {
                throw new IOException("Invalid refreshInterval value: " + string);
            }
            config.randomMinimalModifier = randomSales.get("randomMinimalModifier").getAsFloat();
            config.randomMaximalModifier = randomSales.get("randomMaximalModifier").getAsFloat();
            config.saleCountFactor = randomSales.get("saleCountFactor").getAsInt();
            config.maximumSalesPerCategory = randomSales.get("maximumSalesPerCategory").getAsInt();
            int saleID = Integer.MIN_VALUE;
            for (JsonElement objE : saleConf.get("sales").getAsJsonArray()) {
                if (saleID == 0) {
                    throw new IOException("Too many sales registered, hit the upper limit for user sales");
                }
                ++saleID;
                JsonObject sale = objE.getAsJsonObject();
                int[] categories = new int[sale.get("categories").getAsJsonArray().size()];
                int[] itemIds = new int[sale.get("itemIDs").getAsJsonArray().size()];
                int in = 0;
                for (JsonElement ele : sale.get("categories").getAsJsonArray()) {
                    categories[in++] = ele.getAsInt();
                }
                in = 0;
                for (JsonElement ele : sale.get("itemIDs").getAsJsonArray()) {
                    itemIds[in++] = ele.getAsInt();
                }
                Date start = fmt.parse(sale.get("start").getAsString());
                Date end = fmt.parse(sale.get("end").getAsString());
                ItemSaleInfo i = new ItemSaleInfo(sale.get("name").getAsString(), start.getTime(), end.getTime(), sale.get("modifier").getAsFloat(), categories, itemIds, sale.get("memberOnly").getAsBoolean());
                sales.add(i);
                this.logger.debug("Registered sale: " + i.getName());
            }
            this.randomSaleConfig = config;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
        this.defaultItems = defaultItems;
        this.itemDefs = itemDefs;
        this.storeDefs = storeDefs;
        this.sales = sales;
        this.logger.info("Dispatching load event...");
        EventBus.getInstance().dispatchEvent((EventObject)new ItemManagerLoadEvent(this));
    }

    private void loadItemTransformer(File transformer, HashMap<Integer, ItemInfo> itemDefs) {
        block10: {
            if (transformer.isFile()) {
                this.logger.debug("Loading transformer: '" + transformer.getPath() + "'...");
                try {
                    FileInputStream strm = new FileInputStream(transformer);
                    XmlMapper mapper = new XmlMapper();
                    ObjectNode def = (ObjectNode)mapper.reader().readValue(new String(((InputStream)strm).readAllBytes(), "UTF-8"), ObjectNode.class);
                    ((InputStream)strm).close();
                    if (!itemDefs.containsKey(def.get("id").asInt())) {
                        ItemInfo itm = new ItemInfo(def.get("id").asInt(), def.get("itn").asText(), def.get("d").asText(), def);
                        if (!itemDefs.containsKey(itm.getID())) {
                            itemDefs.put(itm.getID(), itm);
                            this.logger.debug("Registered item: " + itm.getID() + ": " + itm.getName());
                        }
                        break block10;
                    }
                    ItemInfo itm = itemDefs.get(def.get("id").asInt());
                    if (itm == null) {
                        throw new IllegalArgumentException("Item definition not found: " + def.get("id").asInt());
                    }
                    ObjectNode obj = itm.getRawObject();
                    Iterator names = def.fieldNames();
                    while (names.hasNext()) {
                        String key = (String)names.next();
                        if (obj.has(key)) {
                            obj.remove(key);
                        }
                        obj.set(key, def.get(key));
                    }
                    itm.reloadDef();
                    this.logger.debug("Updated item: " + itm.getID() + ": " + itm.getName());
                }
                catch (Exception e) {
                    this.logger.error("Transformer failed to load: " + transformer.getPath(), (Throwable)e);
                }
            } else {
                this.logger.debug("Loading transformers from " + transformer.getPath() + "...");
                for (File tr : transformer.listFiles(t -> t.getName().endsWith(".xml") || t.isDirectory())) {
                    this.loadItemTransformer(tr, itemDefs);
                }
            }
        }
    }

    private void loadTransformers(Class<?> cls, HashMap<Integer, ItemInfo> itemDefs) {
        URL source = cls.getProtectionDomain().getCodeSource().getLocation();
        Object baseURL = "";
        String fileName = "";
        try {
            File sourceFile = new File(source.toURI());
            fileName = sourceFile.getName();
            baseURL = sourceFile.isDirectory() ? source + (source.toString().endsWith("/") ? "" : "/") : "jar:" + source + "!/";
        }
        catch (Exception e) {
            return;
        }
        try {
            this.logger.debug("Loading transformers from " + fileName + "...");
            InputStream strm = new URL((String)baseURL + "itemtransformers/index.json").openStream();
            JsonArray index = JsonParser.parseString((String)new String(strm.readAllBytes(), "UTF-8")).getAsJsonArray();
            strm.close();
            for (JsonElement ele : index) {
                this.logger.debug("Loading transformer: 'itemtransformers/" + ele.getAsString() + ".xml'...");
                try {
                    ItemInfo itm;
                    strm = new URL((String)baseURL + "itemtransformers/" + ele.getAsString() + ".xml").openStream();
                    XmlMapper mapper = new XmlMapper();
                    ObjectNode def = (ObjectNode)mapper.reader().readValue(new String(strm.readAllBytes(), "UTF-8"), ObjectNode.class);
                    strm.close();
                    if (!itemDefs.containsKey(def.get("id").asInt())) {
                        itm = new ItemInfo(def.get("id").asInt(), def.get("itn").asText(), def.get("d").asText(), def);
                        if (itemDefs.containsKey(itm.getID())) continue;
                        itemDefs.put(itm.getID(), itm);
                        this.logger.debug("Registered item: " + itm.getID() + ": " + itm.getName());
                        continue;
                    }
                    itm = itemDefs.get(def.get("id").asInt());
                    if (itm == null) {
                        throw new IllegalArgumentException("Item definition not found: " + def.get("id").asInt());
                    }
                    ObjectNode obj = itm.getRawObject();
                    Iterator names = def.fieldNames();
                    while (names.hasNext()) {
                        String key = (String)names.next();
                        if (obj.has(key)) {
                            obj.remove(key);
                        }
                        obj.set(key, def.get(key));
                    }
                    itm.reloadDef();
                    this.logger.debug("Updated item: " + itm.getID() + ": " + itm.getName());
                }
                catch (Exception e) {
                    this.logger.error("Transformer failed to load: " + ele.getAsString() + " (" + fileName + ")", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private void loadShopTransformer(File transformer, HashMap<Integer, ItemStoreInfo> storeDefs, HashMap<Integer, ItemInfo> itemDefs) {
        if (transformer.isFile()) {
            this.logger.debug("Loading transformer: '" + transformer.getPath() + "'...");
            try {
                FileInputStream strm = new FileInputStream(transformer);
                JsonObject tr = JsonParser.parseString((String)new String(((InputStream)strm).readAllBytes(), "UTF-8")).getAsJsonObject();
                ((InputStream)strm).close();
                this.loadShopTransformer(tr, storeDefs, itemDefs);
            }
            catch (Exception e) {
                this.logger.error("Transformer failed to load: " + transformer.getPath(), (Throwable)e);
            }
        } else {
            this.logger.debug("Loading transformers from " + transformer.getPath() + "...");
            for (File tr : transformer.listFiles(t -> t.getName().endsWith(".json") || t.isDirectory())) {
                this.loadShopTransformer(tr, storeDefs, itemDefs);
            }
        }
    }

    private void loadTransformersShops(Class<?> cls, HashMap<Integer, ItemStoreInfo> storeDefs, HashMap<Integer, ItemInfo> itemDefs) {
        URL source = cls.getProtectionDomain().getCodeSource().getLocation();
        Object baseURL = "";
        String fileName = "";
        try {
            File sourceFile = new File(source.toURI());
            fileName = sourceFile.getName();
            baseURL = sourceFile.isDirectory() ? source + (source.toString().endsWith("/") ? "" : "/") : "jar:" + source + "!/";
        }
        catch (Exception e) {
            return;
        }
        try {
            this.logger.debug("Loading transformers from " + fileName + "...");
            InputStream strm = new URL((String)baseURL + "shoptransformers/index.json").openStream();
            JsonArray index = JsonParser.parseString((String)new String(strm.readAllBytes(), "UTF-8")).getAsJsonArray();
            strm.close();
            for (JsonElement ele : index) {
                this.logger.debug("Loading transformer: 'shoptransformers/" + ele.getAsString() + ".json'...");
                try {
                    strm = new URL((String)baseURL + "shoptransformers/" + ele.getAsString() + ".json").openStream();
                    JsonObject transformer = JsonParser.parseString((String)new String(strm.readAllBytes(), "UTF-8")).getAsJsonObject();
                    strm.close();
                    this.loadShopTransformer(transformer, storeDefs, itemDefs);
                }
                catch (Exception e) {
                    this.logger.error("Transformer failed to load: " + ele.getAsString() + " (" + fileName + ")", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private void loadShopTransformer(JsonObject transformer, HashMap<Integer, ItemStoreInfo> storeDefs, HashMap<Integer, ItemInfo> itemDefs) {
        if (!transformer.has("mode")) {
            throw new IllegalArgumentException("No 'mode' field present in transformer!");
        }
        if (!(transformer.get("mode").getAsString().equals("merge") || transformer.get("mode").getAsString().equals("define") || transformer.get("mode").getAsString().equals("replace"))) {
            throw new IllegalArgumentException("Invalid transformation mode, expected either 'merge', 'define' or 'replace'");
        }
        if (!transformer.has("id")) {
            throw new IllegalArgumentException("No 'id' field present in transformer!");
        }
        String mode = transformer.get("mode").getAsString();
        ItemStoreInfo shop = storeDefs.get(transformer.get("id").getAsInt());
        if (shop == null && mode.equals("merge")) {
            throw new IllegalArgumentException("Store '" + transformer.get("id").getAsInt() + "' was not found");
        }
        if (shop != null && mode.equals("define")) {
            throw new IllegalArgumentException("Store '" + transformer.get("id").getAsInt() + "' already exists");
        }
        String descr = "";
        String name = "";
        if (shop != null) {
            descr = shop.getDescription();
        }
        if (shop != null) {
            name = shop.getName();
        }
        if (transformer.has("name")) {
            name = transformer.get("name").getAsString();
        }
        if (transformer.has("description")) {
            descr = transformer.get("description").getAsString();
        }
        HashMap<String, ItemInfo> items = new HashMap<String, ItemInfo>();
        if (shop != null && !mode.equals("replace")) {
            for (ItemInfo itm : shop.getItems()) {
                items.put(Integer.toString(itm.getID()), itm);
            }
        }
        if (transformer.has("items")) {
            JsonObject obj = transformer.get("items").getAsJsonObject();
            for (String id : obj.keySet()) {
                ItemInfo def;
                if (items.containsKey(id)) {
                    def = (ItemInfo)items.get(id);
                } else {
                    int defID = Integer.parseInt(id);
                    def = itemDefs.get(defID);
                    if (def == null) {
                        throw new IllegalArgumentException("Item definition '" + id + "' does not exists");
                    }
                }
                JsonObject trans = obj.get(id).getAsJsonObject();
                if (!trans.has("mode")) {
                    throw new IllegalArgumentException("No 'mode' field present in transformer item! Item ID: " + id);
                }
                if (!(trans.get("mode").getAsString().equals("update") || trans.get("mode").getAsString().equals("define") || trans.get("mode").getAsString().equals("remove"))) {
                    throw new IllegalArgumentException("Invalid transformation mode in transformer item, expected either 'update', 'define' or 'remove'");
                }
                String md = trans.get("mode").getAsString();
                if (md.equals("define") && items.containsKey(id)) {
                    throw new IllegalArgumentException("Unable to define item that already exists in shop item list! Item ID: " + id);
                }
                if (md.equals("remove") && !items.containsKey(id)) {
                    throw new IllegalArgumentException("Unable to remove item that does not exists in shop item list! Item ID: " + id);
                }
                if (!md.equals("remove")) {
                    if (!trans.has("cost")) {
                        throw new IllegalArgumentException("No 'cost' field present in transformer item! Item ID: " + id);
                    }
                    if (!trans.has("currency")) {
                        throw new IllegalArgumentException("No 'currency' field present in transformer item! Item ID: " + id);
                    }
                    if (!trans.get("currency").getAsString().equals("gems") && !trans.get("currency").getAsString().equals("coins")) {
                        throw new IllegalArgumentException("Invalid currency type in transformer item, expected either 'gems' or 'coins'");
                    }
                }
                ObjectNode newNode = def.getRawObject().deepCopy();
                newNode.set("ct", (JsonNode)new IntNode(-1));
                newNode.set("ct2", (JsonNode)new IntNode(0));
                if (trans.get("currency").getAsString().equals("coins")) {
                    newNode.set("ct", (JsonNode)new IntNode(trans.get("cost").getAsInt()));
                } else {
                    newNode.set("ct2", (JsonNode)new IntNode(trans.get("cost").getAsInt()));
                }
                ItemInfo newDef = new ItemInfo(def.getID(), def.getDescription(), def.getDescription(), newNode);
                items.put(id, newDef);
            }
        }
        storeDefs.put(shop.getID(), new ItemStoreInfo(shop.getID(), name, descr, (ItemInfo[])items.values().toArray(ItemInfo[]::new)));
    }

    @Override
    public int[] getStoreIds() {
        int[] ids = new int[this.storeDefs.size()];
        Integer[] idI = (Integer[])this.storeDefs.keySet().toArray(Integer[]::new);
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = idI[i];
        }
        return ids;
    }

    @Override
    public ItemStoreInfo[] getAllStores() {
        return (ItemStoreInfo[])this.storeDefs.values().toArray(ItemStoreInfo[]::new);
    }

    @Override
    public ItemStoreInfo getStore(int id) {
        return this.storeDefs.get(id);
    }

    @Override
    public int[] getItemDefinitionIds() {
        int[] ids = new int[this.itemDefs.size()];
        Integer[] idI = (Integer[])this.itemDefs.keySet().toArray(Integer[]::new);
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = idI[i];
        }
        return ids;
    }

    @Override
    public ItemInfo[] getAllItemDefinitions() {
        return (ItemInfo[])this.itemDefs.values().toArray(ItemInfo[]::new);
    }

    @Override
    public ItemInfo getItemDefinition(int id) {
        return this.itemDefs.get(id);
    }

    @Override
    public PlayerInventory getCommonInventory(AccountDataContainer data) {
        return new PlayerInventoryImpl(data, data.getAccount(), this);
    }

    @Override
    public void registerItemDefinition(ItemInfo item) {
        if (!this.itemDefs.containsKey(item.getID())) {
            this.itemDefs.put(item.getID(), item);
            this.logger.debug("Registered item: " + item.getID() + ": " + item.getName());
        }
    }

    @Override
    public void updateItemDefinition(int id, ObjectNode rawData) {
        ItemInfo itm = this.getItemDefinition(id);
        if (itm == null) {
            throw new IllegalArgumentException("Item definition not found: " + id);
        }
        ObjectNode obj = itm.getRawObject();
        Iterator names = rawData.fieldNames();
        while (names.hasNext()) {
            String key = (String)names.next();
            if (obj.has(key)) {
                obj.remove(key);
            }
            obj.set(key, rawData.get(key));
        }
        itm.reloadDef();
        this.logger.debug("Updated item: " + itm.getID() + ": " + itm.getName());
    }

    @Override
    public void reload() {
        this.lastReloadTime = System.currentTimeMillis();
        try {
            CommonDataManager.getInstance().getContainer("ITEMMANAGER").setEntry("lastreload", (JsonElement)new JsonPrimitive((Number)this.lastReloadTime));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Reloading item manager...");
        this.loadData();
    }

    @Override
    public void registerSale(ItemSaleInfo sale) {
        this.sales.add(sale);
        this.logger.debug("Registered sale: " + sale.getName());
    }

    @Override
    public void unregisterSale(ItemSaleInfo sale) {
        this.sales.remove(sale);
        this.logger.debug("Removed sale: " + sale.getName());
    }

    @Override
    public ItemSaleInfo[] getSales() {
        ArrayList<ItemSaleInfo> sales = new ArrayList<ItemSaleInfo>(this.sales);
        sales.addAll(this.currentRandomSales);
        sales.addAll(this.upcomingRandomSales);
        return (ItemSaleInfo[])sales.toArray(ItemSaleInfo[]::new);
    }

    @Override
    public ItemSaleInfo[] getActiveSales() {
        ArrayList<ItemSaleInfo> sales = new ArrayList<ItemSaleInfo>(this.sales);
        sales.addAll(this.currentRandomSales);
        return (ItemSaleInfo[])sales.stream().filter(t -> t.isActive()).toArray(ItemSaleInfo[]::new);
    }

    @Override
    public ItemSaleInfo[] getUpcomingSales() {
        ArrayList<ItemSaleInfo> sales = new ArrayList<ItemSaleInfo>(this.sales);
        sales.addAll(this.upcomingRandomSales);
        return (ItemSaleInfo[])sales.stream().filter(t -> t.isUpcoming()).toArray(ItemSaleInfo[]::new);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SaleInfoBlock {
        public String name;
        public long startTime;
        public long endTime;
        public float saleModifier;
        public int[] categories;
        public int[] itemIDs;
        public boolean memberOnly;

        private SaleInfoBlock() {
        }
    }
}

